/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.annotation.TargetApi;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.os.BuildCompat;
import android.support.v7.widget.TooltipCompatHandler;
import android.view.View;

public class TooltipCompat {
    private static final ViewCompatImpl IMPL = BuildCompat.isAtLeastO() ? new Api26ViewCompatImpl() : new BaseViewCompatImpl();

    public static void setTooltipText(@NonNull View view, @Nullable CharSequence tooltipText) {
        IMPL.setTooltipText(view, tooltipText);
    }

    private TooltipCompat() {
    }

    @TargetApi(value=26)
    private static class Api26ViewCompatImpl
    implements ViewCompatImpl {
        private Api26ViewCompatImpl() {
        }

        @Override
        public void setTooltipText(@NonNull View view, @Nullable CharSequence tooltipText) {
            view.setTooltipText(tooltipText);
        }
    }

    private static class BaseViewCompatImpl
    implements ViewCompatImpl {
        private BaseViewCompatImpl() {
        }

        @Override
        public void setTooltipText(@NonNull View view, @Nullable CharSequence tooltipText) {
            TooltipCompatHandler.setTooltipText(view, tooltipText);
        }
    }

    private static interface ViewCompatImpl {
        public void setTooltipText(@NonNull View var1, @Nullable CharSequence var2);
    }
}

