/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver;

import android.support.constraint.solver.ArrayRow;
import java.util.Arrays;

public class SolverVariable {
    private static final boolean INTERNAL_DEBUG = false;
    public static final int STRENGTH_NONE = 0;
    public static final int STRENGTH_LOW = 1;
    public static final int STRENGTH_MEDIUM = 2;
    public static final int STRENGTH_HIGH = 3;
    public static final int STRENGTH_HIGHEST = 4;
    public static final int STRENGTH_EQUALITY = 5;
    public static final int STRENGTH_FIXED = 6;
    public static final int STRENGTH_BARRIER = 7;
    private static int uniqueSlackId = 1;
    private static int uniqueErrorId = 1;
    private static int uniqueUnrestrictedId = 1;
    private static int uniqueConstantId = 1;
    private static int uniqueId = 1;
    private String mName;
    public int id = -1;
    int definitionId = -1;
    public int strength = 0;
    public float computedValue;
    static final int MAX_STRENGTH = 7;
    float[] strengthVector = new float[7];
    Type mType;
    ArrayRow[] mClientEquations = new ArrayRow[8];
    int mClientEquationsCount = 0;
    public int usageInRowCount = 0;

    static void increaseErrorId() {
        ++uniqueErrorId;
    }

    private static String getUniqueName(Type type, String prefix) {
        if (prefix != null) {
            return prefix + uniqueErrorId;
        }
        switch (type) {
            case UNRESTRICTED: {
                return "U" + ++uniqueUnrestrictedId;
            }
            case CONSTANT: {
                return "C" + ++uniqueConstantId;
            }
            case SLACK: {
                return "S" + ++uniqueSlackId;
            }
            case ERROR: {
                return "e" + ++uniqueErrorId;
            }
            case UNKNOWN: {
                return "V" + ++uniqueId;
            }
        }
        throw new AssertionError((Object)type.name());
    }

    public SolverVariable(String name, Type type) {
        this.mName = name;
        this.mType = type;
    }

    public SolverVariable(Type type, String prefix) {
        this.mType = type;
    }

    void clearStrengths() {
        for (int i = 0; i < 7; ++i) {
            this.strengthVector[i] = 0.0f;
        }
    }

    String strengthsToString() {
        String representation = this + "[";
        boolean negative = false;
        boolean empty = true;
        for (int j = 0; j < this.strengthVector.length; ++j) {
            representation = representation + this.strengthVector[j];
            if (this.strengthVector[j] > 0.0f) {
                negative = false;
            } else if (this.strengthVector[j] < 0.0f) {
                negative = true;
            }
            if (this.strengthVector[j] != 0.0f) {
                empty = false;
            }
            representation = j < this.strengthVector.length - 1 ? representation + ", " : representation + "] ";
        }
        if (negative) {
            representation = representation + " (-)";
        }
        if (empty) {
            representation = representation + " (*)";
        }
        return representation;
    }

    void addClientEquation(ArrayRow equation) {
        for (int i = 0; i < this.mClientEquationsCount; ++i) {
            if (this.mClientEquations[i] != equation) continue;
            return;
        }
        if (this.mClientEquationsCount >= this.mClientEquations.length) {
            this.mClientEquations = Arrays.copyOf(this.mClientEquations, this.mClientEquations.length * 2);
        }
        this.mClientEquations[this.mClientEquationsCount] = equation;
        ++this.mClientEquationsCount;
    }

    void removeClientEquation(ArrayRow equation) {
        for (int i = 0; i < this.mClientEquationsCount; ++i) {
            if (this.mClientEquations[i] != equation) continue;
            for (int j = 0; j < this.mClientEquationsCount - i - 1; ++j) {
                this.mClientEquations[i + j] = this.mClientEquations[i + j + 1];
            }
            --this.mClientEquationsCount;
            return;
        }
    }

    public void reset() {
        this.mName = null;
        this.mType = Type.UNKNOWN;
        this.strength = 0;
        this.id = -1;
        this.definitionId = -1;
        this.computedValue = 0.0f;
        this.mClientEquationsCount = 0;
        this.usageInRowCount = 0;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public void setType(Type type, String prefix) {
        this.mType = type;
    }

    public String toString() {
        String result = "";
        result = result + this.mName;
        return result;
    }

    public static enum Type {
        UNRESTRICTED,
        CONSTANT,
        SLACK,
        ERROR,
        UNKNOWN;

    }
}

