/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver.widgets;

import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import android.support.constraint.solver.widgets.Guideline;
import android.support.constraint.solver.widgets.HelperWidget;
import android.support.constraint.solver.widgets.analyzer.BasicMeasure;

public class VirtualLayout
extends HelperWidget {
    private int mPaddingTop = 0;
    private int mPaddingBottom = 0;
    private int mPaddingLeft = 0;
    private int mPaddingRight = 0;
    private boolean mNeedsCallFromSolver = false;
    private int mMeasuredWidth = 0;
    private int mMeasuredHeight = 0;
    protected BasicMeasure.Measure mMeasure = new BasicMeasure.Measure();

    public void setPadding(int value) {
        this.mPaddingLeft = value;
        this.mPaddingTop = value;
        this.mPaddingRight = value;
        this.mPaddingBottom = value;
    }

    public void setPaddingLeft(int value) {
        this.mPaddingLeft = value;
    }

    public void setPaddingTop(int value) {
        this.mPaddingTop = value;
    }

    public void setPaddingRight(int value) {
        this.mPaddingRight = value;
    }

    public void setPaddingBottom(int value) {
        this.mPaddingBottom = value;
    }

    public int getPaddingTop() {
        return this.mPaddingTop;
    }

    public int getPaddingBottom() {
        return this.mPaddingBottom;
    }

    public int getPaddingLeft() {
        return this.mPaddingLeft;
    }

    public int getPaddingRight() {
        return this.mPaddingRight;
    }

    protected void needsCallbackFromSolver(boolean value) {
        this.mNeedsCallFromSolver = value;
    }

    public boolean needSolverPass() {
        return this.mNeedsCallFromSolver;
    }

    public void measure(int widthMode, int widthSize, int heightMode, int heightSize) {
    }

    @Override
    public void updateConstraints(ConstraintWidgetContainer container) {
        this.captureWidgets();
    }

    public void captureWidgets() {
        for (int i = 0; i < this.mWidgetsCount; ++i) {
            ConstraintWidget widget = this.mWidgets[i];
            widget.setInVirtualLayout(true);
        }
    }

    public int getMeasuredWidth() {
        return this.mMeasuredWidth;
    }

    public int getMeasuredHeight() {
        return this.mMeasuredHeight;
    }

    public void setMeasure(int width, int height) {
        this.mMeasuredWidth = width;
        this.mMeasuredHeight = height;
    }

    protected boolean measureChildren() {
        BasicMeasure.Measurer measurer = null;
        if (this.mParent != null) {
            measurer = ((ConstraintWidgetContainer)this.mParent).getMeasurer();
        }
        if (measurer == null) {
            return false;
        }
        for (int i = 0; i < this.mWidgetsCount; ++i) {
            boolean skip;
            ConstraintWidget widget = this.mWidgets[i];
            if (widget instanceof Guideline) continue;
            ConstraintWidget.DimensionBehaviour widthBehavior = widget.getDimensionBehaviour(0);
            ConstraintWidget.DimensionBehaviour heightBehavior = widget.getDimensionBehaviour(1);
            boolean bl = skip = widthBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mMatchConstraintDefaultWidth != 1 && heightBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mMatchConstraintDefaultHeight != 1;
            if (skip) continue;
            if (widthBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                widthBehavior = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            }
            if (heightBehavior == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                heightBehavior = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            }
            this.mMeasure.horizontalBehavior = widthBehavior;
            this.mMeasure.verticalBehavior = heightBehavior;
            this.mMeasure.horizontalDimension = widget.getWidth();
            this.mMeasure.verticalDimension = widget.getHeight();
            measurer.measure(widget, this.mMeasure);
            if (widthBehavior == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                widget.setWrapWidth(this.mMeasure.measuredWidth);
            }
            if (heightBehavior == ConstraintWidget.DimensionBehaviour.WRAP_CONTENT) {
                widget.setWrapHeight(this.mMeasure.measuredHeight);
            }
            widget.setWidth(this.mMeasure.measuredWidth);
            widget.setHeight(this.mMeasure.measuredHeight);
            widget.setBaselineDistance(this.mMeasure.measuredBaseline);
        }
        return true;
    }
}

