/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver.widgets;

import android.support.constraint.solver.Cache;
import android.support.constraint.solver.SolverVariable;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.Guideline;
import android.support.constraint.solver.widgets.ResolutionAnchor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

public class ConstraintAnchor {
    private static final boolean ALLOW_BINARY = false;
    private ResolutionAnchor mResolutionAnchor = new ResolutionAnchor(this);
    public static final int USER_CREATOR = 0;
    public static final int SCOUT_CREATOR = 1;
    public static final int AUTO_CONSTRAINT_CREATOR = 2;
    private static final int UNSET_GONE_MARGIN = -1;
    public final ConstraintWidget mOwner;
    public final Type mType;
    public ConstraintAnchor mTarget;
    public int mMargin = 0;
    int mGoneMargin = -1;
    private Strength mStrength = Strength.NONE;
    private ConnectionType mConnectionType = ConnectionType.RELAXED;
    private int mConnectionCreator = 0;
    SolverVariable mSolverVariable;

    public ResolutionAnchor getResolutionNode() {
        return this.mResolutionAnchor;
    }

    public void copyFrom(ConstraintAnchor source, HashMap<ConstraintWidget, ConstraintWidget> map) {
        if (source.mTarget != null) {
            Type type = source.mTarget.getType();
            ConstraintWidget owner = map.get(source.mTarget.mOwner);
            this.mTarget = owner.getAnchor(type);
        } else {
            this.mTarget = null;
        }
        this.mMargin = source.mMargin;
        this.mGoneMargin = source.mGoneMargin;
        this.mStrength = source.mStrength;
        this.mConnectionType = source.mConnectionType;
        this.mConnectionCreator = source.mConnectionCreator;
    }

    public ConstraintAnchor(ConstraintWidget owner, Type type) {
        this.mOwner = owner;
        this.mType = type;
    }

    public SolverVariable getSolverVariable() {
        return this.mSolverVariable;
    }

    public void resetSolverVariable(Cache cache) {
        if (this.mSolverVariable == null) {
            this.mSolverVariable = new SolverVariable(SolverVariable.Type.UNRESTRICTED, null);
        } else {
            this.mSolverVariable.reset();
        }
    }

    public ConstraintWidget getOwner() {
        return this.mOwner;
    }

    public Type getType() {
        return this.mType;
    }

    public int getMargin() {
        if (this.mOwner.getVisibility() == 8) {
            return 0;
        }
        if (this.mGoneMargin > -1 && this.mTarget != null && this.mTarget.mOwner.getVisibility() == 8) {
            return this.mGoneMargin;
        }
        return this.mMargin;
    }

    public Strength getStrength() {
        return this.mStrength;
    }

    public ConstraintAnchor getTarget() {
        return this.mTarget;
    }

    public ConnectionType getConnectionType() {
        return this.mConnectionType;
    }

    public void setConnectionType(ConnectionType type) {
        this.mConnectionType = type;
    }

    public int getConnectionCreator() {
        return this.mConnectionCreator;
    }

    public void setConnectionCreator(int creator) {
        this.mConnectionCreator = creator;
    }

    public void reset() {
        this.mTarget = null;
        this.mMargin = 0;
        this.mGoneMargin = -1;
        this.mStrength = Strength.STRONG;
        this.mConnectionCreator = 0;
        this.mConnectionType = ConnectionType.RELAXED;
        this.mResolutionAnchor.reset();
    }

    public boolean connect(ConstraintAnchor toAnchor, int margin, Strength strength, int creator) {
        return this.connect(toAnchor, margin, -1, strength, creator, false);
    }

    public boolean connect(ConstraintAnchor toAnchor, int margin, int goneMargin, Strength strength, int creator, boolean forceConnection) {
        if (toAnchor == null) {
            this.mTarget = null;
            this.mMargin = 0;
            this.mGoneMargin = -1;
            this.mStrength = Strength.NONE;
            this.mConnectionCreator = 2;
            return true;
        }
        if (!forceConnection && !this.isValidConnection(toAnchor)) {
            return false;
        }
        this.mTarget = toAnchor;
        this.mMargin = margin > 0 ? margin : 0;
        this.mGoneMargin = goneMargin;
        this.mStrength = strength;
        this.mConnectionCreator = creator;
        return true;
    }

    public boolean connect(ConstraintAnchor toAnchor, int margin, int creator) {
        return this.connect(toAnchor, margin, -1, Strength.STRONG, creator, false);
    }

    public boolean connect(ConstraintAnchor toAnchor, int margin) {
        return this.connect(toAnchor, margin, -1, Strength.STRONG, 0, false);
    }

    public boolean isConnected() {
        return this.mTarget != null;
    }

    public boolean isValidConnection(ConstraintAnchor anchor) {
        if (anchor == null) {
            return false;
        }
        Type target = anchor.getType();
        if (target == this.mType) {
            return this.mType != Type.BASELINE || anchor.getOwner().hasBaseline() && this.getOwner().hasBaseline();
        }
        switch (this.mType) {
            case CENTER: {
                return target != Type.BASELINE && target != Type.CENTER_X && target != Type.CENTER_Y;
            }
            case LEFT: 
            case RIGHT: {
                boolean isCompatible;
                boolean bl = isCompatible = target == Type.LEFT || target == Type.RIGHT;
                if (anchor.getOwner() instanceof Guideline) {
                    isCompatible = isCompatible || target == Type.CENTER_X;
                }
                return isCompatible;
            }
            case TOP: 
            case BOTTOM: {
                boolean isCompatible;
                boolean bl = isCompatible = target == Type.TOP || target == Type.BOTTOM;
                if (anchor.getOwner() instanceof Guideline) {
                    isCompatible = isCompatible || target == Type.CENTER_Y;
                }
                return isCompatible;
            }
            case BASELINE: 
            case CENTER_X: 
            case CENTER_Y: 
            case NONE: {
                return false;
            }
        }
        throw new AssertionError((Object)this.mType.name());
    }

    public boolean isSideAnchor() {
        switch (this.mType) {
            case LEFT: 
            case RIGHT: 
            case TOP: 
            case BOTTOM: {
                return true;
            }
            case CENTER: 
            case BASELINE: 
            case CENTER_X: 
            case CENTER_Y: 
            case NONE: {
                return false;
            }
        }
        throw new AssertionError((Object)this.mType.name());
    }

    public boolean isSimilarDimensionConnection(ConstraintAnchor anchor) {
        Type target = anchor.getType();
        if (target == this.mType) {
            return true;
        }
        switch (this.mType) {
            case CENTER: {
                return target != Type.BASELINE;
            }
            case LEFT: 
            case RIGHT: 
            case CENTER_X: {
                return target == Type.LEFT || target == Type.RIGHT || target == Type.CENTER_X;
            }
            case TOP: 
            case BOTTOM: 
            case BASELINE: 
            case CENTER_Y: {
                return target == Type.TOP || target == Type.BOTTOM || target == Type.CENTER_Y || target == Type.BASELINE;
            }
            case NONE: {
                return false;
            }
        }
        throw new AssertionError((Object)this.mType.name());
    }

    public void setStrength(Strength strength) {
        if (this.isConnected()) {
            this.mStrength = strength;
        }
    }

    public void setMargin(int margin) {
        if (this.isConnected()) {
            this.mMargin = margin;
        }
    }

    public void setGoneMargin(int margin) {
        if (this.isConnected()) {
            this.mGoneMargin = margin;
        }
    }

    public boolean isVerticalAnchor() {
        switch (this.mType) {
            case CENTER: 
            case LEFT: 
            case RIGHT: 
            case CENTER_X: {
                return false;
            }
            case TOP: 
            case BOTTOM: 
            case BASELINE: 
            case CENTER_Y: 
            case NONE: {
                return true;
            }
        }
        throw new AssertionError((Object)this.mType.name());
    }

    public String toString() {
        return this.mOwner.getDebugName() + ":" + this.mType.toString();
    }

    public int getSnapPriorityLevel() {
        switch (this.mType) {
            case LEFT: {
                return 1;
            }
            case RIGHT: {
                return 1;
            }
            case CENTER_X: {
                return 0;
            }
            case TOP: {
                return 0;
            }
            case BOTTOM: {
                return 0;
            }
            case CENTER_Y: {
                return 1;
            }
            case BASELINE: {
                return 2;
            }
            case CENTER: {
                return 3;
            }
            case NONE: {
                return 0;
            }
        }
        throw new AssertionError((Object)this.mType.name());
    }

    public int getPriorityLevel() {
        switch (this.mType) {
            case CENTER_X: {
                return 0;
            }
            case CENTER_Y: {
                return 0;
            }
            case BASELINE: {
                return 1;
            }
            case LEFT: {
                return 2;
            }
            case RIGHT: {
                return 2;
            }
            case TOP: {
                return 2;
            }
            case BOTTOM: {
                return 2;
            }
            case CENTER: {
                return 2;
            }
            case NONE: {
                return 0;
            }
        }
        throw new AssertionError((Object)this.mType.name());
    }

    public boolean isSnapCompatibleWith(ConstraintAnchor anchor) {
        if (this.mType == Type.CENTER) {
            return false;
        }
        if (this.mType == anchor.getType()) {
            return true;
        }
        switch (this.mType) {
            case LEFT: {
                switch (anchor.getType()) {
                    case RIGHT: {
                        return true;
                    }
                    case CENTER_X: {
                        return true;
                    }
                }
                return false;
            }
            case RIGHT: {
                switch (anchor.getType()) {
                    case LEFT: {
                        return true;
                    }
                    case CENTER_X: {
                        return true;
                    }
                }
                return false;
            }
            case CENTER_X: {
                switch (anchor.getType()) {
                    case LEFT: {
                        return true;
                    }
                    case RIGHT: {
                        return true;
                    }
                }
                return false;
            }
            case TOP: {
                switch (anchor.getType()) {
                    case BOTTOM: {
                        return true;
                    }
                    case CENTER_Y: {
                        return true;
                    }
                }
                return false;
            }
            case BOTTOM: {
                switch (anchor.getType()) {
                    case TOP: {
                        return true;
                    }
                    case CENTER_Y: {
                        return true;
                    }
                }
                return false;
            }
            case CENTER_Y: {
                switch (anchor.getType()) {
                    case TOP: {
                        return true;
                    }
                    case BOTTOM: {
                        return true;
                    }
                }
                return false;
            }
            case CENTER: 
            case BASELINE: 
            case NONE: {
                return false;
            }
        }
        throw new AssertionError((Object)this.mType.name());
    }

    public boolean isConnectionAllowed(ConstraintWidget target, ConstraintAnchor anchor) {
        return this.isConnectionAllowed(target);
    }

    public boolean isConnectionAllowed(ConstraintWidget target) {
        HashSet<ConstraintWidget> checked = new HashSet<ConstraintWidget>();
        if (this.isConnectionToMe(target, checked)) {
            return false;
        }
        ConstraintWidget parent = this.getOwner().getParent();
        if (parent == target) {
            return true;
        }
        return target.getParent() == parent;
    }

    private boolean isConnectionToMe(ConstraintWidget target, HashSet<ConstraintWidget> checked) {
        if (checked.contains(target)) {
            return false;
        }
        checked.add(target);
        if (target == this.getOwner()) {
            return true;
        }
        ArrayList<ConstraintAnchor> targetAnchors = target.getAnchors();
        int targetAnchorsSize = targetAnchors.size();
        for (int i = 0; i < targetAnchorsSize; ++i) {
            ConstraintAnchor anchor = targetAnchors.get(i);
            if (!anchor.isSimilarDimensionConnection(this) || !anchor.isConnected() || !this.isConnectionToMe(anchor.getTarget().getOwner(), checked)) continue;
            return true;
        }
        return false;
    }

    public final ConstraintAnchor getOpposite() {
        switch (this.mType) {
            case LEFT: {
                return this.mOwner.mRight;
            }
            case RIGHT: {
                return this.mOwner.mLeft;
            }
            case TOP: {
                return this.mOwner.mBottom;
            }
            case BOTTOM: {
                return this.mOwner.mTop;
            }
            case CENTER: 
            case BASELINE: 
            case CENTER_X: 
            case CENTER_Y: 
            case NONE: {
                return null;
            }
        }
        throw new AssertionError((Object)this.mType.name());
    }

    public static enum ConnectionType {
        RELAXED,
        STRICT;

    }

    public static enum Strength {
        NONE,
        STRONG,
        WEAK;

    }

    public static enum Type {
        NONE,
        LEFT,
        TOP,
        RIGHT,
        BOTTOM,
        BASELINE,
        CENTER,
        CENTER_X,
        CENTER_Y;

    }
}

