/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver.widgets.analyzer;

import android.support.constraint.solver.widgets.Barrier;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.analyzer.Dependency;
import android.support.constraint.solver.widgets.analyzer.DependencyNode;
import android.support.constraint.solver.widgets.analyzer.WidgetRun;

class HelperReferences
extends WidgetRun {
    public HelperReferences(ConstraintWidget widget) {
        super(widget);
    }

    @Override
    void clear() {
        this.runGroup = null;
        this.start.clear();
    }

    @Override
    void reset() {
        this.start.resolved = false;
    }

    @Override
    boolean supportsWrapComputation() {
        return false;
    }

    private void addDependency(DependencyNode node) {
        this.start.dependencies.add(node);
        node.targets.add(this.start);
    }

    @Override
    void apply() {
        if (this.widget instanceof Barrier) {
            this.start.delegateToWidgetRun = true;
            Barrier barrier = (Barrier)this.widget;
            int type = barrier.getBarrierType();
            boolean allowsGoneWidget = barrier.allowsGoneWidget();
            switch (type) {
                case 0: {
                    this.start.type = DependencyNode.Type.LEFT;
                    for (int i = 0; i < barrier.mWidgetsCount; ++i) {
                        ConstraintWidget refwidget = barrier.mWidgets[i];
                        if (!allowsGoneWidget && refwidget.getVisibility() == 8) continue;
                        DependencyNode target = refwidget.horizontalRun.start;
                        target.dependencies.add(this.start);
                        this.start.targets.add(target);
                    }
                    this.addDependency(this.widget.horizontalRun.start);
                    this.addDependency(this.widget.horizontalRun.end);
                    break;
                }
                case 1: {
                    this.start.type = DependencyNode.Type.RIGHT;
                    for (int i = 0; i < barrier.mWidgetsCount; ++i) {
                        ConstraintWidget refwidget = barrier.mWidgets[i];
                        if (!allowsGoneWidget && refwidget.getVisibility() == 8) continue;
                        DependencyNode target = refwidget.horizontalRun.end;
                        target.dependencies.add(this.start);
                        this.start.targets.add(target);
                    }
                    this.addDependency(this.widget.horizontalRun.start);
                    this.addDependency(this.widget.horizontalRun.end);
                    break;
                }
                case 2: {
                    this.start.type = DependencyNode.Type.TOP;
                    for (int i = 0; i < barrier.mWidgetsCount; ++i) {
                        ConstraintWidget refwidget = barrier.mWidgets[i];
                        if (!allowsGoneWidget && refwidget.getVisibility() == 8) continue;
                        DependencyNode target = refwidget.verticalRun.start;
                        target.dependencies.add(this.start);
                        this.start.targets.add(target);
                    }
                    this.addDependency(this.widget.verticalRun.start);
                    this.addDependency(this.widget.verticalRun.end);
                    break;
                }
                case 3: {
                    this.start.type = DependencyNode.Type.BOTTOM;
                    for (int i = 0; i < barrier.mWidgetsCount; ++i) {
                        ConstraintWidget refwidget = barrier.mWidgets[i];
                        if (!allowsGoneWidget && refwidget.getVisibility() == 8) continue;
                        DependencyNode target = refwidget.verticalRun.end;
                        target.dependencies.add(this.start);
                        this.start.targets.add(target);
                    }
                    this.addDependency(this.widget.verticalRun.start);
                    this.addDependency(this.widget.verticalRun.end);
                }
            }
        }
    }

    @Override
    public void update(Dependency dependency) {
        Barrier barrier = (Barrier)this.widget;
        int type = barrier.getBarrierType();
        int min = -1;
        int max = 0;
        for (DependencyNode node : this.start.targets) {
            int value = node.value;
            if (min == -1 || value < min) {
                min = value;
            }
            if (max >= value) continue;
            max = value;
        }
        if (type == 0 || type == 2) {
            this.start.resolve(min + barrier.getMargin());
        } else {
            this.start.resolve(max + barrier.getMargin());
        }
    }

    @Override
    public void applyToWidget() {
        Barrier barrier = (Barrier)this.widget;
        int type = barrier.getBarrierType();
        if (type == 0 || type == 1) {
            this.widget.setDrawX(this.start.value);
        } else {
            this.widget.setDrawY(this.start.value);
        }
    }
}

