/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.solver.widgets;

import android.support.constraint.solver.LinearSystem;
import android.support.constraint.solver.widgets.ConstraintAnchor;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.ConstraintWidgetContainer;
import android.support.constraint.solver.widgets.VirtualLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class Flow
extends VirtualLayout {
    public static final int HORIZONTAL_ALIGN_START = 0;
    public static final int HORIZONTAL_ALIGN_END = 1;
    public static final int HORIZONTAL_ALIGN_CENTER = 2;
    public static final int VERTICAL_ALIGN_TOP = 0;
    public static final int VERTICAL_ALIGN_BOTTOM = 1;
    public static final int VERTICAL_ALIGN_CENTER = 2;
    public static final int VERTICAL_ALIGN_BASELINE = 3;
    public static final int WRAP_NONE = 0;
    public static final int WRAP_CHAIN = 1;
    public static final int WRAP_ALIGNED = 2;
    private int mHorizontalStyle = -1;
    private int mVerticalStyle = -1;
    private int mFirstHorizontalStyle = -1;
    private int mFirstVerticalStyle = -1;
    private int mLastHorizontalStyle = -1;
    private int mLastVerticalStyle = -1;
    private float mHorizontalBias = 0.5f;
    private float mVerticalBias = 0.5f;
    private float mFirstHorizontalBias = 0.5f;
    private float mFirstVerticalBias = 0.5f;
    private float mLastHorizontalBias = 0.5f;
    private float mLastVerticalBias = 0.5f;
    private int mHorizontalGap = 0;
    private int mVerticalGap = 0;
    private int mHorizontalAlign = 2;
    private int mVerticalAlign = 2;
    private int mWrapMode = 0;
    private int mMaxElementsWrap = -1;
    private int mOrientation = 0;
    private ArrayList<WidgetsList> mChainList = new ArrayList();
    private ConstraintWidget[] mAlignedBiggestElementsInRows = null;
    private ConstraintWidget[] mAlignedBiggestElementsInCols = null;
    private int[] mAlignedDimensions = null;

    @Override
    public void copy(ConstraintWidget src, HashMap<ConstraintWidget, ConstraintWidget> map) {
        super.copy(src, map);
        Flow srcFLow = (Flow)src;
        this.mHorizontalStyle = srcFLow.mHorizontalStyle;
        this.mVerticalStyle = srcFLow.mVerticalStyle;
        this.mFirstHorizontalStyle = srcFLow.mFirstHorizontalStyle;
        this.mFirstVerticalStyle = srcFLow.mFirstVerticalStyle;
        this.mLastHorizontalStyle = srcFLow.mLastHorizontalStyle;
        this.mLastVerticalStyle = srcFLow.mLastVerticalStyle;
        this.mHorizontalBias = srcFLow.mHorizontalBias;
        this.mVerticalBias = srcFLow.mVerticalBias;
        this.mFirstHorizontalBias = srcFLow.mFirstHorizontalBias;
        this.mFirstVerticalBias = srcFLow.mFirstVerticalBias;
        this.mLastHorizontalBias = srcFLow.mLastHorizontalBias;
        this.mLastVerticalBias = srcFLow.mLastVerticalBias;
        this.mHorizontalGap = srcFLow.mHorizontalGap;
        this.mVerticalGap = srcFLow.mVerticalGap;
        this.mHorizontalAlign = srcFLow.mHorizontalAlign;
        this.mVerticalAlign = srcFLow.mVerticalAlign;
        this.mWrapMode = srcFLow.mWrapMode;
        this.mMaxElementsWrap = srcFLow.mMaxElementsWrap;
        this.mOrientation = srcFLow.mOrientation;
    }

    public void setOrientation(int value) {
        this.mOrientation = value;
    }

    public void setFirstHorizontalStyle(int value) {
        this.mFirstHorizontalStyle = value;
    }

    public void setFirstVerticalStyle(int value) {
        this.mFirstVerticalStyle = value;
    }

    public void setLastHorizontalStyle(int value) {
        this.mLastHorizontalStyle = value;
    }

    public void setLastVerticalStyle(int value) {
        this.mLastVerticalStyle = value;
    }

    public void setHorizontalStyle(int value) {
        this.mHorizontalStyle = value;
    }

    public void setVerticalStyle(int value) {
        this.mVerticalStyle = value;
    }

    public void setHorizontalBias(float value) {
        this.mHorizontalBias = value;
    }

    public void setVerticalBias(float value) {
        this.mVerticalBias = value;
    }

    public void setFirstHorizontalBias(float value) {
        this.mFirstHorizontalBias = value;
    }

    public void setFirstVerticalBias(float value) {
        this.mFirstVerticalBias = value;
    }

    public void setLastHorizontalBias(float value) {
        this.mLastHorizontalBias = value;
    }

    public void setLastVerticalBias(float value) {
        this.mLastVerticalBias = value;
    }

    public void setHorizontalAlign(int value) {
        this.mHorizontalAlign = value;
    }

    public void setVerticalAlign(int value) {
        this.mVerticalAlign = value;
    }

    public void setWrapMode(int value) {
        this.mWrapMode = value;
    }

    public void setHorizontalGap(int value) {
        this.mHorizontalGap = value;
    }

    public void setVerticalGap(int value) {
        this.mVerticalGap = value;
    }

    public void setMaxElementsWrap(int value) {
        this.mMaxElementsWrap = value;
    }

    private final int getWidgetWidth(ConstraintWidget widget) {
        if (widget == null) {
            return 0;
        }
        if (widget.getHorizontalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mMatchConstraintDefaultWidth == 0) {
            return 0;
        }
        return widget.getWidth();
    }

    private final int getWidgetHeight(ConstraintWidget widget) {
        if (widget == null) {
            return 0;
        }
        if (widget.getVerticalDimensionBehaviour() == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT && widget.mMatchConstraintDefaultHeight == 0) {
            return 0;
        }
        return widget.getHeight();
    }

    @Override
    public void measure(int widthMode, int widthSize, int heightMode, int heightSize) {
        if (this.mWidgetsCount > 0 && !this.measureChildren()) {
            this.setMeasure(0, 0);
            this.needsCallbackFromSolver(false);
            return;
        }
        int width = 0;
        int height = 0;
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int paddingTop = this.getPaddingTop();
        int paddingBottom = this.getPaddingBottom();
        int[] measured = new int[2];
        int max = widthSize - paddingLeft - paddingRight;
        if (this.mOrientation == 1) {
            max = heightSize - paddingTop - paddingBottom;
        }
        if (this.mOrientation == 0) {
            if (this.mHorizontalStyle == -1) {
                this.mHorizontalStyle = 0;
            }
            if (this.mVerticalStyle == -1) {
                this.mVerticalStyle = 0;
            }
        } else {
            if (this.mHorizontalStyle == -1) {
                this.mHorizontalStyle = 0;
            }
            if (this.mVerticalStyle == -1) {
                this.mVerticalStyle = 0;
            }
        }
        switch (this.mWrapMode) {
            case 2: {
                this.measureAligned(this.mWidgets, this.mOrientation, max, measured);
                break;
            }
            case 1: {
                this.measureChainWrap(this.mWidgets, this.mOrientation, max, measured);
                break;
            }
            case 0: {
                this.measureNoWrap(this.mWidgets, this.mOrientation, max, measured);
            }
        }
        width = measured[0] + paddingLeft + paddingRight;
        height = measured[1] + paddingTop + paddingBottom;
        int measuredWidth = 0;
        int measuredHeight = 0;
        if (widthMode == 0x40000000) {
            measuredWidth = widthSize;
        } else if (widthMode == Integer.MIN_VALUE) {
            measuredWidth = Math.min(width, widthSize);
        } else if (widthMode == 0) {
            measuredWidth = width;
        }
        if (heightMode == 0x40000000) {
            measuredHeight = heightSize;
        } else if (heightMode == Integer.MIN_VALUE) {
            measuredHeight = Math.min(height, heightSize);
        } else if (heightMode == 0) {
            measuredHeight = height;
        }
        this.setMeasure(measuredWidth, measuredHeight);
        this.needsCallbackFromSolver(this.mWidgetsCount > 0);
    }

    private void measureChainWrap(ConstraintWidget[] widgets, int orientation, int max, int[] measured) {
        boolean doWrap;
        ConstraintWidget widget;
        int i;
        int count = this.mWidgetsCount;
        if (count == 0) {
            return;
        }
        this.mChainList.clear();
        WidgetsList list = new WidgetsList(orientation, this.mLeft, this.mTop, this.mRight, this.mBottom);
        this.mChainList.add(list);
        if (orientation == 0) {
            int width = this.mHorizontalGap * 2;
            for (i = 0; i < count; ++i) {
                widget = widgets[i];
                int w = this.getWidgetWidth(widget);
                boolean bl = doWrap = width + w + this.mHorizontalGap > max && list.biggest != null;
                if (!doWrap && i > 0 && this.mMaxElementsWrap > 0 && i % this.mMaxElementsWrap == 0) {
                    doWrap = true;
                }
                if (doWrap) {
                    width = this.mHorizontalGap * 2;
                    list = new WidgetsList(orientation, this.mLeft, this.mTop, this.mRight, this.mBottom);
                    list.setStartIndex(i);
                    this.mChainList.add(list);
                }
                width += w + this.mHorizontalGap;
                list.add(widget);
            }
        } else {
            int height = this.mVerticalGap * 2;
            for (i = 0; i < count; ++i) {
                widget = widgets[i];
                int h = this.getWidgetHeight(widget);
                boolean bl = doWrap = height + h + this.mVerticalGap > max && list.biggest != null;
                if (!doWrap && i > 0 && this.mMaxElementsWrap > 0 && i % this.mMaxElementsWrap == 0) {
                    doWrap = true;
                }
                if (doWrap) {
                    height = this.mVerticalGap * 2;
                    list = new WidgetsList(orientation, this.mLeft, this.mTop, this.mRight, this.mBottom);
                    list.setStartIndex(i);
                    this.mChainList.add(list);
                }
                height += h;
                list.add(widget);
            }
        }
        int listCount = this.mChainList.size();
        ConstraintAnchor left = this.mLeft;
        ConstraintAnchor top = this.mTop;
        ConstraintAnchor right = this.mRight;
        ConstraintAnchor bottom = this.mBottom;
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        int maxWidth = 0;
        int maxHeight = 0;
        for (int i2 = 0; i2 < listCount; ++i2) {
            WidgetsList next;
            WidgetsList current = this.mChainList.get(i2);
            if (orientation == 0) {
                if (i2 < listCount - 1) {
                    next = this.mChainList.get(i2 + 1);
                    bottom = ((WidgetsList)next).biggest.mTop;
                    paddingBottom = 0;
                } else {
                    bottom = this.mBottom;
                    paddingBottom = this.getPaddingBottom();
                }
                ConstraintAnchor currentBottom = ((WidgetsList)current).biggest.mBottom;
                current.setup(orientation, left, top, right, bottom, paddingLeft, paddingTop, paddingRight, paddingBottom);
                top = currentBottom;
                paddingTop = 0;
                maxWidth = Math.max(maxWidth, current.getWidth());
                maxHeight += current.getHeight();
                if (i2 <= 0) continue;
                maxHeight += this.mVerticalGap;
                continue;
            }
            if (i2 < listCount - 1) {
                next = this.mChainList.get(i2 + 1);
                right = ((WidgetsList)next).biggest.mLeft;
                paddingRight = 0;
            } else {
                right = this.mRight;
                paddingRight = this.getPaddingRight();
            }
            ConstraintAnchor currentRight = ((WidgetsList)current).biggest.mRight;
            current.setup(orientation, left, top, right, bottom, paddingLeft, paddingTop, paddingRight, paddingBottom);
            left = currentRight;
            paddingLeft = 0;
            maxWidth += current.getWidth();
            maxHeight = Math.max(maxHeight, current.getHeight());
            if (i2 <= 0) continue;
            maxWidth += this.mHorizontalGap;
        }
        measured[0] = maxWidth;
        measured[1] = maxHeight;
    }

    private void measureNoWrap(ConstraintWidget[] widgets, int orientation, int max, int[] measured) {
        boolean width = false;
        boolean height = false;
        int count = this.mWidgetsCount;
        if (count == 0) {
            return;
        }
        WidgetsList list = null;
        if (this.mChainList.size() == 0) {
            list = new WidgetsList(orientation, this.mLeft, this.mTop, this.mRight, this.mBottom);
            this.mChainList.add(list);
        } else {
            list = this.mChainList.get(0);
            list.clear();
            list.setup(orientation, this.mLeft, this.mTop, this.mRight, this.mBottom, this.getPaddingLeft(), this.getPaddingTop(), this.getPaddingRight(), this.getPaddingBottom());
        }
        for (int i = 0; i < count; ++i) {
            ConstraintWidget widget = widgets[i];
            list.add(widget);
        }
        measured[0] = list.getWidth();
        measured[1] = list.getHeight();
    }

    private void measureAligned(ConstraintWidget[] widgets, int orientation, int max, int[] measured) {
        ConstraintWidget widget;
        int i;
        int w;
        boolean done = false;
        int rows = 0;
        int cols = 0;
        if (orientation == 0) {
            cols = this.mMaxElementsWrap;
            if (cols <= 0) {
                w = 0;
                cols = 0;
                for (i = 0; i < this.mWidgetsCount; ++i) {
                    if (i > 0) {
                        w += this.mHorizontalGap;
                    }
                    if ((widget = widgets[i]) == null) continue;
                    if ((w += this.getWidgetWidth(widget)) <= max) {
                        ++cols;
                        continue;
                    }
                    break;
                }
            }
        } else {
            rows = this.mMaxElementsWrap;
            if (rows <= 0) {
                int h = 0;
                rows = 0;
                for (i = 0; i < this.mWidgetsCount; ++i) {
                    if (i > 0) {
                        h += this.mVerticalGap;
                    }
                    if ((widget = widgets[i]) == null) continue;
                    if ((h += this.getWidgetHeight(widget)) <= max) {
                        ++rows;
                        continue;
                    }
                    break;
                }
            }
        }
        if (this.mAlignedDimensions == null) {
            this.mAlignedDimensions = new int[2];
        }
        if (rows == 0 && orientation == 1 || cols == 0 && orientation == 0) {
            done = true;
        }
        while (!done) {
            ConstraintWidget widget2;
            if (orientation == 0) {
                rows = (int)Math.ceil((float)this.mWidgetsCount / (float)cols);
            } else {
                cols = (int)Math.ceil((float)this.mWidgetsCount / (float)rows);
            }
            if (this.mAlignedBiggestElementsInCols == null || this.mAlignedBiggestElementsInCols.length < cols) {
                this.mAlignedBiggestElementsInCols = new ConstraintWidget[cols];
            } else {
                Arrays.fill(this.mAlignedBiggestElementsInCols, null);
            }
            if (this.mAlignedBiggestElementsInRows == null || this.mAlignedBiggestElementsInRows.length < rows) {
                this.mAlignedBiggestElementsInRows = new ConstraintWidget[rows];
            } else {
                Arrays.fill(this.mAlignedBiggestElementsInRows, null);
            }
            for (int i2 = 0; i2 < cols; ++i2) {
                for (int j = 0; j < rows; ++j) {
                    int index = j * cols + i2;
                    if (orientation == 1) {
                        index = i2 * rows + j;
                    }
                    if (index >= widgets.length || (widget2 = widgets[index]) == null) continue;
                    int w2 = this.getWidgetWidth(widget2);
                    if (this.mAlignedBiggestElementsInCols[i2] == null || this.mAlignedBiggestElementsInCols[i2].getWidth() < w2) {
                        this.mAlignedBiggestElementsInCols[i2] = widget2;
                    }
                    int h = this.getWidgetHeight(widget2);
                    if (this.mAlignedBiggestElementsInRows[j] != null && this.mAlignedBiggestElementsInRows[j].getHeight() >= h) continue;
                    this.mAlignedBiggestElementsInRows[j] = widget2;
                }
            }
            w = 0;
            for (i = 0; i < cols; ++i) {
                widget = this.mAlignedBiggestElementsInCols[i];
                if (widget == null) continue;
                if (i > 0) {
                    w += this.mHorizontalGap;
                }
                w += this.getWidgetWidth(widget);
            }
            int h = 0;
            for (int j = 0; j < rows; ++j) {
                widget2 = this.mAlignedBiggestElementsInRows[j];
                if (widget2 == null) continue;
                if (j > 0) {
                    h += this.mVerticalGap;
                }
                h += this.getWidgetHeight(widget2);
            }
            measured[0] = w;
            measured[1] = h;
            if (orientation == 0) {
                if (w > max) {
                    if (cols > 1) {
                        --cols;
                        continue;
                    }
                    done = true;
                    continue;
                }
                done = true;
                continue;
            }
            if (h > max) {
                if (rows > 1) {
                    --rows;
                    continue;
                }
                done = true;
                continue;
            }
            done = true;
        }
        this.mAlignedDimensions[0] = cols;
        this.mAlignedDimensions[1] = rows;
    }

    private void createAlignedConstraints(boolean isInRtl) {
        int i;
        if (this.mAlignedDimensions == null || this.mAlignedBiggestElementsInCols == null || this.mAlignedBiggestElementsInRows == null) {
            return;
        }
        for (int i2 = 0; i2 < this.mWidgetsCount; ++i2) {
            ConstraintWidget widget = this.mWidgets[i2];
            widget.resetAnchors();
        }
        int cols = this.mAlignedDimensions[0];
        int rows = this.mAlignedDimensions[1];
        ConstraintWidget previous = null;
        for (i = 0; i < cols; ++i) {
            ConstraintWidget widget;
            int index = i;
            if (isInRtl) {
                index = cols - i - 1;
            }
            if ((widget = this.mAlignedBiggestElementsInCols[index]) == null) continue;
            if (i == 0) {
                widget.connect(widget.mLeft, this.mLeft, this.getPaddingLeft());
                widget.setHorizontalChainStyle(this.mHorizontalStyle);
                widget.setHorizontalBiasPercent(this.mHorizontalBias);
            }
            if (i == cols - 1) {
                widget.connect(widget.mRight, this.mRight, this.getPaddingRight());
            }
            if (i > 0) {
                widget.connect(widget.mLeft, previous.mRight, this.mHorizontalGap);
                previous.connect(previous.mRight, widget.mLeft, 0);
            }
            previous = widget;
        }
        for (int j = 0; j < rows; ++j) {
            ConstraintWidget widget = this.mAlignedBiggestElementsInRows[j];
            if (widget == null) continue;
            if (j == 0) {
                widget.connect(widget.mTop, this.mTop, this.getPaddingTop());
                widget.setVerticalChainStyle(this.mVerticalStyle);
                widget.setVerticalBiasPercent(this.mVerticalBias);
            }
            if (j == rows - 1) {
                widget.connect(widget.mBottom, this.mBottom, this.getPaddingBottom());
            }
            if (j > 0) {
                widget.connect(widget.mTop, previous.mBottom, this.mVerticalGap);
                previous.connect(previous.mBottom, widget.mTop, 0);
            }
            previous = widget;
        }
        for (i = 0; i < cols; ++i) {
            for (int j = 0; j < rows; ++j) {
                ConstraintWidget widget;
                int index = j * cols + i;
                if (this.mOrientation == 1) {
                    index = i * rows + j;
                }
                if (index >= this.mWidgets.length || (widget = this.mWidgets[index]) == null) continue;
                ConstraintWidget biggestInCol = this.mAlignedBiggestElementsInCols[i];
                ConstraintWidget biggestInRow = this.mAlignedBiggestElementsInRows[j];
                if (widget != biggestInCol) {
                    widget.connect(widget.mLeft, biggestInCol.mLeft, 0);
                    widget.connect(widget.mRight, biggestInCol.mRight, 0);
                }
                if (widget == biggestInRow) continue;
                widget.connect(widget.mTop, biggestInRow.mTop, 0);
                widget.connect(widget.mBottom, biggestInRow.mBottom, 0);
            }
        }
    }

    @Override
    public void addToSolver(LinearSystem system) {
        super.addToSolver(system);
        boolean isInRtl = this.getParent() != null ? ((ConstraintWidgetContainer)this.getParent()).isRtl() : false;
        switch (this.mWrapMode) {
            case 1: {
                int count = this.mChainList.size();
                for (int i = 0; i < count; ++i) {
                    WidgetsList list = this.mChainList.get(i);
                    list.createConstraints(isInRtl, i, i == count - 1);
                }
                break;
            }
            case 0: {
                if (this.mChainList.size() <= 0) break;
                WidgetsList list = this.mChainList.get(0);
                list.createConstraints(isInRtl, 0, true);
                break;
            }
            case 2: {
                this.createAlignedConstraints(isInRtl);
            }
        }
        this.needsCallbackFromSolver(false);
    }

    private class WidgetsList {
        private int mOrientation = 0;
        private ConstraintWidget biggest = null;
        int biggestDimension = 0;
        private ConstraintAnchor mLeft;
        private ConstraintAnchor mTop;
        private ConstraintAnchor mRight;
        private ConstraintAnchor mBottom;
        private int mPaddingLeft = 0;
        private int mPaddingTop = 0;
        private int mPaddingRight = 0;
        private int mPaddingBottom = 0;
        private int mWidth = 0;
        private int mHeight = 0;
        private int mStartIndex = 0;
        private int mCount = 0;

        public WidgetsList(int orientation, ConstraintAnchor left, ConstraintAnchor top, ConstraintAnchor right, ConstraintAnchor bottom) {
            this.mOrientation = orientation;
            this.mLeft = left;
            this.mTop = top;
            this.mRight = right;
            this.mBottom = bottom;
            this.mPaddingLeft = Flow.this.getPaddingLeft();
            this.mPaddingTop = Flow.this.getPaddingTop();
            this.mPaddingRight = Flow.this.getPaddingRight();
            this.mPaddingBottom = Flow.this.getPaddingBottom();
        }

        public void setup(int orientation, ConstraintAnchor left, ConstraintAnchor top, ConstraintAnchor right, ConstraintAnchor bottom, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
            this.mOrientation = orientation;
            this.mLeft = left;
            this.mTop = top;
            this.mRight = right;
            this.mBottom = bottom;
            this.mPaddingLeft = paddingLeft;
            this.mPaddingTop = paddingTop;
            this.mPaddingRight = paddingRight;
            this.mPaddingBottom = paddingBottom;
        }

        public void clear() {
            this.biggestDimension = 0;
            this.biggest = null;
            this.mWidth = 0;
            this.mHeight = 0;
            this.mStartIndex = 0;
            this.mCount = 0;
        }

        public void setStartIndex(int value) {
            this.mStartIndex = value;
        }

        public int getWidth() {
            if (this.mOrientation == 0) {
                return this.mWidth - Flow.this.mHorizontalGap;
            }
            return this.mWidth;
        }

        public int getHeight() {
            if (this.mOrientation == 1) {
                return this.mHeight - Flow.this.mVerticalGap;
            }
            return this.mHeight;
        }

        public void add(ConstraintWidget widget) {
            if (this.mOrientation == 0) {
                int width = Flow.this.getWidgetWidth(widget);
                int gap = Flow.this.mHorizontalGap;
                if (widget.getVisibility() == 8) {
                    gap = 0;
                }
                this.mWidth += width + gap;
                int height = Flow.this.getWidgetHeight(widget);
                if (this.biggest == null || this.biggestDimension < height) {
                    this.biggest = widget;
                    this.biggestDimension = height;
                    this.mHeight = height;
                }
            } else {
                int width = Flow.this.getWidgetWidth(widget);
                int height = Flow.this.getWidgetHeight(widget);
                int gap = Flow.this.mVerticalGap;
                if (widget.getVisibility() == 8) {
                    gap = 0;
                }
                this.mHeight += height + gap;
                if (this.biggest == null || this.biggestDimension < width) {
                    this.biggest = widget;
                    this.biggestDimension = width;
                    this.mWidth = width;
                }
            }
            ++this.mCount;
        }

        public void createConstraints(boolean isInRtl, int chainIndex, boolean isLastChain) {
            int count = this.mCount;
            for (int i = 0; i < count; ++i) {
                ConstraintWidget widget = Flow.this.mWidgets[this.mStartIndex + i];
                widget.resetAnchors();
            }
            if (count == 0 || this.biggest == null) {
                return;
            }
            boolean singleChain = isLastChain && chainIndex == 0;
            int firstVisible = -1;
            int lastVisible = -1;
            for (int i = 0; i < count; ++i) {
                ConstraintWidget widget;
                int index = i;
                if (isInRtl) {
                    index = count - 1 - i;
                }
                if ((widget = Flow.this.mWidgets[this.mStartIndex + index]).getVisibility() != 0) continue;
                if (firstVisible == -1) {
                    firstVisible = i;
                }
                lastVisible = i;
            }
            ConstraintWidget previous = null;
            if (this.mOrientation == 0) {
                ConstraintWidget widget;
                int index;
                int i;
                ConstraintWidget verticalWidget = this.biggest;
                verticalWidget.setVerticalChainStyle(Flow.this.mVerticalStyle);
                int padding = this.mPaddingTop;
                if (chainIndex > 0) {
                    padding += Flow.this.mVerticalGap;
                }
                verticalWidget.mTop.connect(this.mTop, padding);
                if (isLastChain) {
                    verticalWidget.mBottom.connect(this.mBottom, this.mPaddingBottom);
                }
                if (chainIndex > 0) {
                    ConstraintAnchor bottom = this.mTop.mOwner.mBottom;
                    bottom.connect(verticalWidget.mTop, 0);
                }
                ConstraintWidget baselineVerticalWidget = verticalWidget;
                if (Flow.this.mVerticalAlign == 3 && !verticalWidget.hasBaseline()) {
                    for (i = 0; i < count; ++i) {
                        index = i;
                        if (isInRtl) {
                            index = count - 1 - i;
                        }
                        if (!(widget = Flow.this.mWidgets[this.mStartIndex + index]).hasBaseline()) continue;
                        baselineVerticalWidget = widget;
                        break;
                    }
                }
                for (i = 0; i < count; ++i) {
                    index = i;
                    if (isInRtl) {
                        index = count - 1 - i;
                    }
                    widget = Flow.this.mWidgets[this.mStartIndex + index];
                    if (i == 0) {
                        widget.connect(widget.mLeft, this.mLeft, this.mPaddingLeft);
                        int style = Flow.this.mHorizontalStyle;
                        float bias = Flow.this.mHorizontalBias;
                        if (this.mStartIndex == 0 && Flow.this.mFirstHorizontalStyle != -1) {
                            style = Flow.this.mFirstHorizontalStyle;
                            bias = Flow.this.mFirstHorizontalBias;
                        } else if (isLastChain && Flow.this.mLastHorizontalStyle != -1) {
                            style = Flow.this.mLastHorizontalStyle;
                            bias = Flow.this.mLastHorizontalBias;
                        }
                        widget.setHorizontalChainStyle(style);
                        widget.setHorizontalBiasPercent(bias);
                    }
                    if (i == count - 1) {
                        widget.connect(widget.mRight, this.mRight, this.mPaddingRight);
                    }
                    if (previous != null) {
                        widget.mLeft.connect(previous.mRight, Flow.this.mHorizontalGap);
                        if (i == firstVisible) {
                            widget.mLeft.setGoneMargin(this.mPaddingLeft);
                        }
                        previous.mRight.connect(widget.mLeft, 0);
                        if (i == lastVisible + 1) {
                            previous.mRight.setGoneMargin(this.mPaddingRight);
                        }
                    }
                    if (widget != verticalWidget) {
                        if (Flow.this.mVerticalAlign == 3 && baselineVerticalWidget.hasBaseline() && widget != baselineVerticalWidget && widget.hasBaseline()) {
                            widget.mBaseline.connect(baselineVerticalWidget.mBaseline, 0);
                        } else {
                            switch (Flow.this.mVerticalAlign) {
                                case 0: {
                                    widget.mTop.connect(verticalWidget.mTop, 0);
                                    break;
                                }
                                case 1: {
                                    widget.mBottom.connect(verticalWidget.mBottom, 0);
                                    break;
                                }
                                default: {
                                    if (singleChain) {
                                        widget.mTop.connect(this.mTop, this.mPaddingTop);
                                        widget.mBottom.connect(this.mBottom, this.mPaddingBottom);
                                        break;
                                    }
                                    widget.mTop.connect(verticalWidget.mTop, 0);
                                    widget.mBottom.connect(verticalWidget.mBottom, 0);
                                }
                            }
                        }
                    }
                    previous = widget;
                }
            } else {
                ConstraintWidget horizontalWidget = this.biggest;
                horizontalWidget.setHorizontalChainStyle(Flow.this.mVerticalStyle);
                int padding = this.mPaddingLeft;
                if (chainIndex > 0) {
                    padding += Flow.this.mHorizontalGap;
                }
                if (isInRtl) {
                    horizontalWidget.mRight.connect(this.mRight, padding);
                    if (isLastChain) {
                        horizontalWidget.mLeft.connect(this.mLeft, this.mPaddingRight);
                    }
                    if (chainIndex > 0) {
                        ConstraintAnchor left = this.mRight.mOwner.mLeft;
                        left.connect(horizontalWidget.mRight, 0);
                    }
                } else {
                    horizontalWidget.mLeft.connect(this.mLeft, padding);
                    if (isLastChain) {
                        horizontalWidget.mRight.connect(this.mRight, this.mPaddingRight);
                    }
                    if (chainIndex > 0) {
                        ConstraintAnchor right = this.mLeft.mOwner.mRight;
                        right.connect(horizontalWidget.mLeft, 0);
                    }
                }
                for (int i = 0; i < count; ++i) {
                    ConstraintWidget widget = Flow.this.mWidgets[this.mStartIndex + i];
                    if (i == 0) {
                        widget.connect(widget.mTop, this.mTop, this.mPaddingTop);
                        int style = Flow.this.mVerticalStyle;
                        float bias = Flow.this.mVerticalBias;
                        if (this.mStartIndex == 0 && Flow.this.mFirstVerticalStyle != -1) {
                            style = Flow.this.mFirstVerticalStyle;
                            bias = Flow.this.mFirstVerticalBias;
                        } else if (isLastChain && Flow.this.mLastVerticalStyle != -1) {
                            style = Flow.this.mLastVerticalStyle;
                            bias = Flow.this.mLastVerticalBias;
                        }
                        widget.setVerticalChainStyle(style);
                        widget.setVerticalBiasPercent(bias);
                    }
                    if (i == count - 1) {
                        widget.connect(widget.mBottom, this.mBottom, this.mPaddingBottom);
                    }
                    if (previous != null) {
                        widget.mTop.connect(previous.mBottom, Flow.this.mVerticalGap);
                        if (i == firstVisible) {
                            widget.mTop.setGoneMargin(this.mPaddingTop);
                        }
                        previous.mBottom.connect(widget.mTop, 0);
                        if (i == lastVisible + 1) {
                            previous.mBottom.setGoneMargin(this.mPaddingBottom);
                        }
                    }
                    if (widget != horizontalWidget) {
                        if (isInRtl) {
                            switch (Flow.this.mHorizontalAlign) {
                                case 0: {
                                    widget.mRight.connect(horizontalWidget.mRight, 0);
                                    break;
                                }
                                case 2: {
                                    widget.mLeft.connect(horizontalWidget.mLeft, 0);
                                    widget.mRight.connect(horizontalWidget.mRight, 0);
                                    break;
                                }
                                case 1: {
                                    widget.mLeft.connect(horizontalWidget.mLeft, 0);
                                }
                            }
                        } else {
                            switch (Flow.this.mHorizontalAlign) {
                                case 0: {
                                    widget.mLeft.connect(horizontalWidget.mLeft, 0);
                                    break;
                                }
                                case 2: {
                                    if (singleChain) {
                                        widget.mLeft.connect(this.mLeft, this.mPaddingLeft);
                                        widget.mRight.connect(this.mRight, this.mPaddingRight);
                                        break;
                                    }
                                    widget.mLeft.connect(horizontalWidget.mLeft, 0);
                                    widget.mRight.connect(horizontalWidget.mRight, 0);
                                    break;
                                }
                                case 1: {
                                    widget.mRight.connect(horizontalWidget.mRight, 0);
                                }
                            }
                        }
                    }
                    previous = widget;
                }
            }
        }
    }
}

