/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.constraint.R;
import android.support.constraint.motion.Debug;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import android.view.View;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;

public class ConstraintAttribute {
    private static final String TAG = "TransitionLayout";
    String mName;
    private AttributeType mType;
    private int mIntegerValue;
    private float mFloatValue;
    private String mStringValue;
    boolean mBooleanValue;
    private int mColorValue;

    public AttributeType getType() {
        return this.mType;
    }

    public void setFloatValue(float value) {
        this.mFloatValue = value;
    }

    public void setColorValue(int value) {
        this.mColorValue = value;
    }

    public void setIntValue(int value) {
        this.mIntegerValue = value;
    }

    public void setStringValue(String value) {
        this.mStringValue = value;
    }

    public int noOfInterpValues() {
        switch (this.mType) {
            case COLOR_TYPE: 
            case COLOR_DRAWABLE_TYPE: {
                return 4;
            }
        }
        return 1;
    }

    public float getValueToInterpolate() {
        switch (this.mType) {
            case INT_TYPE: {
                return this.mIntegerValue;
            }
            case FLOAT_TYPE: {
                return this.mFloatValue;
            }
            case COLOR_TYPE: 
            case COLOR_DRAWABLE_TYPE: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case STRING_TYPE: {
                throw new RuntimeException("Cannot interpolate String");
            }
            case BOOLEAN_TYPE: {
                return this.mBooleanValue ? 0.0f : 1.0f;
            }
            case DIMENSION_TYPE: {
                return this.mFloatValue;
            }
        }
        return Float.NaN;
    }

    public void getValuesToInterpolate(float[] ret) {
        switch (this.mType) {
            case INT_TYPE: {
                ret[0] = this.mIntegerValue;
                break;
            }
            case FLOAT_TYPE: {
                ret[0] = this.mFloatValue;
                break;
            }
            case COLOR_TYPE: 
            case COLOR_DRAWABLE_TYPE: {
                int a = 0xFF & this.mColorValue >> 25;
                int r = 0xFF & this.mColorValue >> 16;
                int g = 0xFF & this.mColorValue >> 8;
                int b = 0xFF & this.mColorValue;
                float f_r = (float)Math.pow((float)r / 255.0f, 2.2);
                float f_g = (float)Math.pow((float)g / 255.0f, 2.2);
                float f_b = (float)Math.pow((float)b / 255.0f, 2.2);
                ret[0] = f_r;
                ret[1] = f_g;
                ret[2] = f_b;
                ret[3] = (float)a / 255.0f;
                break;
            }
            case STRING_TYPE: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case BOOLEAN_TYPE: {
                ret[0] = this.mBooleanValue ? 0.0f : 1.0f;
                break;
            }
            case DIMENSION_TYPE: {
                ret[0] = this.mFloatValue;
            }
        }
    }

    public void setValue(float[] value) {
        switch (this.mType) {
            case INT_TYPE: {
                this.mIntegerValue = (int)value[0];
                break;
            }
            case FLOAT_TYPE: {
                this.mFloatValue = value[0];
                break;
            }
            case COLOR_TYPE: 
            case COLOR_DRAWABLE_TYPE: {
                this.mColorValue = Color.HSVToColor((float[])value);
                break;
            }
            case STRING_TYPE: {
                throw new RuntimeException("Color does not have a single color to interpolate");
            }
            case BOOLEAN_TYPE: {
                this.mBooleanValue = (double)value[0] > 0.5;
                break;
            }
            case DIMENSION_TYPE: {
                this.mFloatValue = value[0];
            }
        }
    }

    public boolean diff(ConstraintAttribute constraintAttribute) {
        if (constraintAttribute == null || this.mType != constraintAttribute.mType) {
            return false;
        }
        switch (this.mType) {
            case INT_TYPE: {
                return this.mIntegerValue == constraintAttribute.mIntegerValue;
            }
            case FLOAT_TYPE: {
                return this.mFloatValue == constraintAttribute.mFloatValue;
            }
            case COLOR_TYPE: 
            case COLOR_DRAWABLE_TYPE: {
                return this.mColorValue == constraintAttribute.mColorValue;
            }
            case STRING_TYPE: {
                return this.mIntegerValue == constraintAttribute.mIntegerValue;
            }
            case BOOLEAN_TYPE: {
                return this.mBooleanValue == constraintAttribute.mBooleanValue;
            }
            case DIMENSION_TYPE: {
                return this.mFloatValue == constraintAttribute.mFloatValue;
            }
        }
        return false;
    }

    public ConstraintAttribute(String name, AttributeType attributeType) {
        this.mName = name;
        this.mType = attributeType;
    }

    public ConstraintAttribute(String name, AttributeType attributeType, Object value) {
        this.mName = name;
        this.mType = attributeType;
        this.setValue(value);
    }

    public ConstraintAttribute(ConstraintAttribute source, Object value) {
        this.mName = source.mName;
        this.mType = source.mType;
        this.setValue(value);
    }

    public void setValue(Object value) {
        switch (this.mType) {
            case INT_TYPE: {
                this.mIntegerValue = (Integer)value;
                break;
            }
            case FLOAT_TYPE: {
                this.mFloatValue = ((Float)value).floatValue();
                break;
            }
            case COLOR_TYPE: 
            case COLOR_DRAWABLE_TYPE: {
                this.mColorValue = (Integer)value;
                break;
            }
            case STRING_TYPE: {
                this.mStringValue = (String)value;
                break;
            }
            case BOOLEAN_TYPE: {
                this.mBooleanValue = (Boolean)value;
                break;
            }
            case DIMENSION_TYPE: {
                this.mFloatValue = ((Float)value).floatValue();
            }
        }
    }

    public static HashMap<String, ConstraintAttribute> extractAttributes(HashMap<String, ConstraintAttribute> base, View view) {
        HashMap<String, ConstraintAttribute> ret = new HashMap<String, ConstraintAttribute>();
        Class<?> viewClass = view.getClass();
        for (String name : base.keySet()) {
            ConstraintAttribute constraintAttribute = base.get(name);
            try {
                Object val;
                if (name.equals("BackgroundColor")) {
                    ColorDrawable viewColor = (ColorDrawable)view.getBackground();
                    val = viewColor.getColor();
                    ret.put(name, new ConstraintAttribute(constraintAttribute, val));
                    continue;
                }
                Method method = viewClass.getMethod("getMap" + name, new Class[0]);
                val = method.invoke((Object)view, new Object[0]);
                ret.put(name, new ConstraintAttribute(constraintAttribute, val));
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public static void setAttributes(View view, HashMap<String, ConstraintAttribute> map) {
        Class<?> viewClass = view.getClass();
        for (String name : map.keySet()) {
            ConstraintAttribute constraintAttribute = map.get(name);
            String methodName = "set" + name;
            try {
                switch (constraintAttribute.mType) {
                    case INT_TYPE: {
                        Method method = viewClass.getMethod(methodName, Integer.TYPE);
                        method.invoke((Object)view, constraintAttribute.mIntegerValue);
                        break;
                    }
                    case FLOAT_TYPE: {
                        Method method = viewClass.getMethod(methodName, Float.TYPE);
                        method.invoke((Object)view, Float.valueOf(constraintAttribute.mFloatValue));
                        break;
                    }
                    case COLOR_DRAWABLE_TYPE: {
                        Method method = viewClass.getMethod(methodName, Drawable.class);
                        ColorDrawable drawable = new ColorDrawable();
                        drawable.setColor(constraintAttribute.mColorValue);
                        method.invoke((Object)view, drawable);
                        break;
                    }
                    case COLOR_TYPE: {
                        Method method = viewClass.getMethod(methodName, Integer.TYPE);
                        method.invoke((Object)view, constraintAttribute.mColorValue);
                        break;
                    }
                    case STRING_TYPE: {
                        Method method = viewClass.getMethod(methodName, CharSequence.class);
                        method.invoke((Object)view, constraintAttribute.mStringValue);
                        break;
                    }
                    case BOOLEAN_TYPE: {
                        Method method = viewClass.getMethod(methodName, Boolean.TYPE);
                        method.invoke((Object)view, constraintAttribute.mBooleanValue);
                        break;
                    }
                    case DIMENSION_TYPE: {
                        Method method = viewClass.getMethod(methodName, Float.TYPE);
                        method.invoke((Object)view, Float.valueOf(constraintAttribute.mFloatValue));
                    }
                }
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private static int clamp(int c) {
        int N = 255;
        c &= ~(c >> 31);
        c -= N;
        c &= c >> 31;
        return c += N;
    }

    public void setInterpolatedValue(View view, float[] value) {
        Class<?> viewClass = view.getClass();
        String methodName = "set" + this.mName;
        try {
            switch (this.mType) {
                case INT_TYPE: {
                    Method method = viewClass.getMethod(methodName, Integer.TYPE);
                    method.invoke((Object)view, (int)value[0]);
                    break;
                }
                case FLOAT_TYPE: {
                    Method method = viewClass.getMethod(methodName, Float.TYPE);
                    method.invoke((Object)view, Float.valueOf(value[0]));
                    break;
                }
                case COLOR_DRAWABLE_TYPE: {
                    Method method = viewClass.getMethod(methodName, Drawable.class);
                    int r = ConstraintAttribute.clamp((int)((float)Math.pow(value[0], 0.45454545454545453) * 255.0f));
                    int g = ConstraintAttribute.clamp((int)((float)Math.pow(value[1], 0.45454545454545453) * 255.0f));
                    int b = ConstraintAttribute.clamp((int)((float)Math.pow(value[2], 0.45454545454545453) * 255.0f));
                    int a = ConstraintAttribute.clamp((int)(value[3] * 255.0f));
                    int color = a << 24 | r << 16 | g << 8 | b;
                    ColorDrawable drawable = new ColorDrawable();
                    drawable.setColor(color);
                    method.invoke((Object)view, drawable);
                    break;
                }
                case COLOR_TYPE: {
                    Method method = viewClass.getMethod(methodName, Integer.TYPE);
                    int r = ConstraintAttribute.clamp((int)((float)Math.pow(value[0], 0.45454545454545453) * 255.0f));
                    int g = ConstraintAttribute.clamp((int)((float)Math.pow(value[1], 0.45454545454545453) * 255.0f));
                    int b = ConstraintAttribute.clamp((int)((float)Math.pow(value[2], 0.45454545454545453) * 255.0f));
                    int a = ConstraintAttribute.clamp((int)(value[3] * 255.0f));
                    int color = a << 24 | r << 16 | g << 8 | b;
                    method.invoke((Object)view, color);
                    break;
                }
                case STRING_TYPE: {
                    throw new RuntimeException("unable to interpolate strings " + this.mName);
                }
                case BOOLEAN_TYPE: {
                    Method method = viewClass.getMethod(methodName, Boolean.TYPE);
                    method.invoke((Object)view, value[0] > 0.5f);
                    break;
                }
                case DIMENSION_TYPE: {
                    Method method = viewClass.getMethod(methodName, Float.TYPE);
                    method.invoke((Object)view, Float.valueOf(value[0]));
                }
            }
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)("no method " + methodName + "on View \"" + Debug.getName(view) + "\""));
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)("cannot access method " + methodName + "on View \"" + Debug.getName(view) + "\""));
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void parse(Context context, XmlPullParser parser, HashMap<String, ConstraintAttribute> custom) {
        AttributeSet attributeSet = Xml.asAttributeSet((XmlPullParser)parser);
        TypedArray a = context.obtainStyledAttributes(attributeSet, R.styleable.CustomAttribute);
        String name = null;
        Object value = null;
        AttributeType type = null;
        int N = a.getIndexCount();
        for (int i = 0; i < N; ++i) {
            int attr = a.getIndex(i);
            if (attr == R.styleable.CustomAttribute_attributeName) {
                name = a.getString(attr);
                if (name == null || name.length() <= 0) continue;
                name = Character.toUpperCase(name.charAt(0)) + name.substring(1);
                continue;
            }
            if (attr == R.styleable.CustomAttribute_customBoolean) {
                value = a.getBoolean(attr, false);
                type = AttributeType.BOOLEAN_TYPE;
                continue;
            }
            if (attr == R.styleable.CustomAttribute_customColorValue) {
                type = AttributeType.COLOR_TYPE;
                value = a.getColor(attr, 0);
                continue;
            }
            if (attr == R.styleable.CustomAttribute_customColorDrawableValue) {
                type = AttributeType.COLOR_DRAWABLE_TYPE;
                value = a.getColor(attr, 0);
                continue;
            }
            if (attr == R.styleable.CustomAttribute_customDimension) {
                type = AttributeType.DIMENSION_TYPE;
                value = Float.valueOf(a.getDimension(attr, 0.0f));
                continue;
            }
            if (attr == R.styleable.CustomAttribute_customFloatValue) {
                type = AttributeType.FLOAT_TYPE;
                value = Float.valueOf(a.getFloat(attr, Float.NaN));
                continue;
            }
            if (attr == R.styleable.CustomAttribute_customIntegerValue) {
                type = AttributeType.INT_TYPE;
                value = a.getInteger(attr, -1);
                continue;
            }
            if (attr != R.styleable.CustomAttribute_customStringValue) continue;
            type = AttributeType.STRING_TYPE;
            value = a.getString(attr);
        }
        if (name != null && value != null) {
            custom.put(name, new ConstraintAttribute(name, type, value));
        }
        a.recycle();
    }

    public static enum AttributeType {
        INT_TYPE,
        FLOAT_TYPE,
        COLOR_TYPE,
        COLOR_DRAWABLE_TYPE,
        STRING_TYPE,
        BOOLEAN_TYPE,
        DIMENSION_TYPE;

    }
}

