/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.support.constraint.ConstraintLayout;
import android.support.constraint.R;
import android.support.constraint.solver.widgets.ConstraintWidget;
import android.support.constraint.solver.widgets.Helper;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import java.lang.reflect.Field;
import java.util.Arrays;

public abstract class ConstraintHelper
extends View {
    protected int[] mIds = new int[32];
    protected int mCount;
    protected Context myContext;
    protected Helper mHelperWidget;
    protected boolean mUseViewMeasure = false;
    private String mReferenceIds;
    private View[] mViews = null;

    public ConstraintHelper(Context context) {
        super(context);
        this.myContext = context;
        this.init(null);
    }

    public ConstraintHelper(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.myContext = context;
        this.init(attrs);
    }

    public ConstraintHelper(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.myContext = context;
        this.init(attrs);
    }

    protected void init(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.ConstraintLayout_Layout);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr != R.styleable.ConstraintLayout_Layout_constraint_referenced_ids) continue;
                this.mReferenceIds = a.getString(attr);
                this.setIds(this.mReferenceIds);
            }
        }
    }

    public int[] getReferencedIds() {
        return Arrays.copyOf(this.mIds, this.mCount);
    }

    public void setReferencedIds(int[] ids) {
        this.mCount = 0;
        for (int i = 0; i < ids.length; ++i) {
            this.setTag(ids[i], null);
        }
    }

    public void setTag(int tag, Object value) {
        if (this.mCount + 1 > this.mIds.length) {
            this.mIds = Arrays.copyOf(this.mIds, this.mIds.length * 2);
        }
        this.mIds[this.mCount] = tag;
        ++this.mCount;
    }

    public void onDraw(Canvas canvas) {
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mUseViewMeasure) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        } else {
            this.setMeasuredDimension(0, 0);
        }
    }

    public void validateParams() {
        if (this.mHelperWidget == null) {
            return;
        }
        ViewGroup.LayoutParams params = this.getLayoutParams();
        if (params instanceof ConstraintLayout.LayoutParams) {
            ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)params;
            layoutParams.widget = (ConstraintWidget)this.mHelperWidget;
        }
    }

    private void addID(String idString) {
        ConstraintLayout constraintLayout;
        Object value;
        if (idString == null) {
            return;
        }
        if (this.myContext == null) {
            return;
        }
        idString = idString.trim();
        int tag = 0;
        try {
            Class<R.id> res = R.id.class;
            Field field = res.getField(idString);
            tag = field.getInt(null);
        }
        catch (Exception res) {
            // empty catch block
        }
        if (tag == 0 && this.isInEditMode() && this.getParent() instanceof ConstraintLayout && (value = (constraintLayout = (ConstraintLayout)this.getParent()).getDesignInformation(0, idString)) != null && value instanceof Integer) {
            tag = (Integer)value;
        }
        if (tag == 0) {
            tag = this.myContext.getResources().getIdentifier(idString, "id", this.myContext.getPackageName());
        }
        if (tag != 0) {
            this.setTag(tag, null);
        } else {
            Log.w((String)"ConstraintHelper", (String)("Could not find id of \"" + idString + "\""));
        }
    }

    private void setIds(String idList) {
        if (idList == null) {
            return;
        }
        int begin = 0;
        while (true) {
            int end;
            if ((end = idList.indexOf(44, begin)) == -1) break;
            this.addID(idList.substring(begin, end));
            begin = end + 1;
        }
        this.addID(idList.substring(begin));
    }

    public void updatePreLayout(ConstraintLayout container) {
        if (this.isInEditMode()) {
            this.setIds(this.mReferenceIds);
        }
        if (this.mHelperWidget == null) {
            return;
        }
        this.mHelperWidget.removeAllIds();
        for (int i = 0; i < this.mCount; ++i) {
            int id2 = this.mIds[i];
            View view = container.getViewById(id2);
            if (view == null) continue;
            this.mHelperWidget.add(container.getViewWidget(view));
        }
    }

    protected View[] getViews(ConstraintLayout layout) {
        if (this.mViews == null || this.mViews.length != this.mCount) {
            this.mViews = new View[this.mCount];
        }
        for (int i = 0; i < this.mCount; ++i) {
            int id2 = this.mIds[i];
            this.mViews[i] = layout.getViewById(id2);
        }
        return this.mViews;
    }

    public void updatePostLayout(ConstraintLayout container) {
    }

    public void updatePostMeasure(ConstraintLayout container) {
    }

    public void updatePostConstraints(ConstraintLayout constainer) {
    }
}

