/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.motion;

import android.content.Context;
import android.support.constraint.motion.MotionLayout;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class Debug {
    public static void logStack(String tag, String msg, int n) {
        StackTraceElement[] st = new Throwable().getStackTrace();
        String s = " ";
        for (int i = 1; i <= n; ++i) {
            StackTraceElement ste = st[i];
            s = s + ".(" + st[i].getFileName() + ":" + st[i].getLineNumber() + ") ";
        }
        Log.v((String)tag, (String)(msg + s));
    }

    public static String getName(View view) {
        try {
            Context context = view.getContext();
            return context.getResources().getResourceEntryName(view.getId());
        }
        catch (Exception ex) {
            return "UNKNOWN";
        }
    }

    public static String getName(Context context, int id2) {
        try {
            return context.getResources().getResourceEntryName(id2);
        }
        catch (Exception ex) {
            return "UNKNOWN";
        }
    }

    public static String getState(MotionLayout layout, int stateId) {
        if (stateId == -1) {
            return "UNDEFINED";
        }
        Context context = layout.getContext();
        return context.getResources().getResourceEntryName(stateId);
    }

    public static String getActionType(MotionEvent event) {
        int type = event.getAction();
        Field[] fields = MotionEvent.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            try {
                if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(Integer.TYPE) || field.getInt(null) != type) continue;
                return field.getName();
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return "---";
    }

    public static String getLocation() {
        StackTraceElement s = new Throwable().getStackTrace()[1];
        return ".(" + s.getFileName() + ":" + s.getLineNumber() + ")";
    }
}

