/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.motion;

import android.content.Context;
import android.support.constraint.ConstraintAttribute;
import android.support.constraint.motion.Key;
import android.support.constraint.motion.KeyAttributes;
import android.support.constraint.motion.KeyCycle;
import android.support.constraint.motion.KeyPosition;
import android.support.constraint.motion.KeyTimeCycle;
import android.support.constraint.motion.KeyTrigger;
import android.support.constraint.motion.MotionController;
import android.util.Log;
import android.util.Xml;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class KeyFrames {
    public static final int UNSET = -1;
    private HashMap<Integer, ArrayList<Key>> mFramesMap = new HashMap();
    static HashMap<String, Constructor<? extends Key>> sKeyMakers = new HashMap();
    private static final String TAG = "KeyFrames";

    private void addKey(Key key) {
        if (!this.mFramesMap.containsKey(key.mTargetId)) {
            this.mFramesMap.put(key.mTargetId, new ArrayList());
        }
        this.mFramesMap.get(key.mTargetId).add(key);
    }

    public KeyFrames(Context context, XmlPullParser parser) {
        String tagName = null;
        try {
            Key key = null;
            int eventType = parser.getEventType();
            while (eventType != 1) {
                switch (eventType) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        tagName = parser.getName();
                        if (sKeyMakers.containsKey(tagName)) {
                            try {
                                key = sKeyMakers.get(tagName).newInstance(new Object[0]);
                                key.load(context, Xml.asAttributeSet((XmlPullParser)parser));
                                this.addKey(key);
                            }
                            catch (Exception e) {
                                Log.e((String)TAG, (String)"unable to create ", (Throwable)e);
                            }
                            break;
                        }
                        if (!tagName.equalsIgnoreCase("CustomAttribute") || key == null || key.mCustomConstraints == null) break;
                        ConstraintAttribute.parse(context, parser, key.mCustomConstraints);
                        break;
                    }
                    case 3: {
                        if (!"KeyFrameSet".equals(parser.getName())) break;
                        return;
                    }
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void addFrames(MotionController motionController) {
        ArrayList<Key> list = this.mFramesMap.get(motionController.mId);
        if (list != null) {
            motionController.addKeys(list);
        }
    }

    static String name(int viewId, Context context) {
        return context.getResources().getResourceEntryName(viewId);
    }

    public Set<Integer> getKeys() {
        return this.mFramesMap.keySet();
    }

    public ArrayList<Key> getKeyFramesForView(int id2) {
        return this.mFramesMap.get(id2);
    }

    static {
        try {
            sKeyMakers.put("KeyAttribute", KeyAttributes.class.getConstructor(new Class[0]));
            sKeyMakers.put("KeyPosition", KeyPosition.class.getConstructor(new Class[0]));
            sKeyMakers.put("KeyCycle", KeyCycle.class.getConstructor(new Class[0]));
            sKeyMakers.put("KeyTimeCycle", KeyTimeCycle.class.getConstructor(new Class[0]));
            sKeyMakers.put("KeyTrigger", KeyTrigger.class.getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)"unable to load", (Throwable)e);
        }
    }
}

