/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.motion;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.constraint.R;
import android.support.constraint.motion.MotionLayout;
import android.support.constraint.motion.MotionScene;
import android.support.v4.widget.NestedScrollView;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import org.xmlpull.v1.XmlPullParser;

class TouchResponse {
    private static final boolean DEBUG = false;
    private int mTouchAnchorSide = 0;
    private int mTouchSide = 0;
    private int mTouchAnchorId = -1;
    private float mTouchAnchorY = 0.5f;
    private float mTouchAnchorX = 0.5f;
    private float mTouchDirectionX = 0.0f;
    private float mTouchDirectionY = 1.0f;
    private boolean mDragStarted = false;
    private float[] mAnchorDpDt = new float[2];
    private float mLastTouchX;
    private float mLastTouchY;
    private final MotionLayout mMotionLayout;
    private static final float[][] TOUCH_SIDES = new float[][]{{0.5f, 0.0f}, {0.0f, 0.5f}, {1.0f, 0.5f}, {0.5f, 1.0f}, {0.5f, 0.5f}};
    private static final float[][] TOUCH_DIRECTION = new float[][]{{0.0f, -1.0f}, {0.0f, 1.0f}, {-1.0f, 0.0f}, {1.0f, 0.0f}};
    private float mMaxVelocity = 4.0f;
    private float mMaxAcceleration = 1.2f;
    private boolean mMoveWhenScrollAtTop = true;
    private float mDragScale = 1.0f;

    TouchResponse(Context context, MotionLayout layout, XmlPullParser parser) {
        this.mMotionLayout = layout;
        this.fillFromAttributeList(context, Xml.asAttributeSet((XmlPullParser)parser));
    }

    private void fillFromAttributeList(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.OnSwipe);
        this.fill(a);
        a.recycle();
    }

    private void fill(TypedArray a) {
        int N = a.getIndexCount();
        for (int i = 0; i < N; ++i) {
            int attr = a.getIndex(i);
            if (attr == R.styleable.OnSwipe_touchAnchorId) {
                this.mTouchAnchorId = a.getResourceId(attr, this.mTouchAnchorId);
                continue;
            }
            if (attr == R.styleable.OnSwipe_touchAnchorSide) {
                this.mTouchAnchorSide = a.getInt(attr, this.mTouchAnchorSide);
                this.mTouchAnchorX = TOUCH_SIDES[this.mTouchAnchorSide][0];
                this.mTouchAnchorY = TOUCH_SIDES[this.mTouchAnchorSide][1];
                continue;
            }
            if (attr == R.styleable.OnSwipe_dragDirection) {
                this.mTouchSide = a.getInt(attr, this.mTouchSide);
                this.mTouchDirectionX = TOUCH_DIRECTION[this.mTouchSide][0];
                this.mTouchDirectionY = TOUCH_DIRECTION[this.mTouchSide][1];
                continue;
            }
            if (attr == R.styleable.OnSwipe_maxVelocity) {
                this.mMaxVelocity = a.getFloat(attr, this.mMaxVelocity);
                continue;
            }
            if (attr == R.styleable.OnSwipe_maxAcceleration) {
                this.mMaxAcceleration = a.getFloat(attr, this.mMaxAcceleration);
                continue;
            }
            if (attr == R.styleable.OnSwipe_moveWhenScrollAtTop) {
                this.mMoveWhenScrollAtTop = a.getBoolean(attr, this.mMoveWhenScrollAtTop);
                continue;
            }
            if (attr != R.styleable.OnSwipe_dragScale) continue;
            this.mDragScale = a.getFloat(attr, this.mDragScale);
        }
    }

    void setUpTouchEvent(float lastTouchX, float lastTouchY) {
        this.mLastTouchX = lastTouchX;
        this.mLastTouchY = lastTouchY;
        this.mDragStarted = false;
    }

    void processTouchEvent(MotionEvent event, VelocityTracker velocityTracker, int currentState, MotionScene motionScene) {
        velocityTracker.addMovement(event);
        switch (event.getAction()) {
            case 0: {
                this.mLastTouchX = event.getRawX();
                this.mLastTouchY = event.getRawY();
                this.mDragStarted = false;
                break;
            }
            case 2: {
                float change;
                float dy = event.getRawY() - this.mLastTouchY;
                float dx = event.getRawX() - this.mLastTouchX;
                float drag = dx * this.mTouchDirectionX + dy * this.mTouchDirectionY;
                if (!(Math.abs(drag) > 10.0f) && !this.mDragStarted) break;
                float pos = this.mMotionLayout.getProgress();
                if (!this.mDragStarted) {
                    this.mDragStarted = true;
                    this.mMotionLayout.setProgress(pos);
                }
                if (this.mTouchAnchorId != -1) {
                    this.mMotionLayout.getAnchorDpDt(this.mTouchAnchorId, pos, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
                } else {
                    float minSize;
                    this.mAnchorDpDt[1] = this.mAnchorDpDt[0] = (minSize = (float)Math.min(this.mMotionLayout.getWidth(), this.mMotionLayout.getHeight()));
                }
                float movmentInDir = this.mTouchDirectionX * this.mAnchorDpDt[0] + this.mTouchDirectionY * this.mAnchorDpDt[1];
                movmentInDir *= this.mDragScale;
                if ((double)Math.abs(movmentInDir) < 0.01) {
                    this.mAnchorDpDt[0] = 0.01f;
                    this.mAnchorDpDt[1] = 0.01f;
                }
                if ((pos = Math.max(Math.min(pos + (change = this.mTouchDirectionX != 0.0f ? dx / this.mAnchorDpDt[0] : dy / this.mAnchorDpDt[1]), 1.0f), 0.0f)) != this.mMotionLayout.getProgress()) {
                    this.mMotionLayout.setProgress(pos);
                }
                this.mLastTouchX = event.getRawX();
                this.mLastTouchY = event.getRawY();
                break;
            }
            case 1: {
                this.mDragStarted = false;
                velocityTracker.computeCurrentVelocity(1000);
                float tvx = velocityTracker.getXVelocity();
                float tvy = velocityTracker.getYVelocity();
                float pos = this.mMotionLayout.getProgress();
                if (this.mTouchAnchorId != -1) {
                    this.mMotionLayout.getAnchorDpDt(this.mTouchAnchorId, pos, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
                } else {
                    float minSize;
                    this.mAnchorDpDt[1] = this.mAnchorDpDt[0] = (minSize = (float)Math.min(this.mMotionLayout.getWidth(), this.mMotionLayout.getHeight()));
                }
                float movmentInDir = this.mTouchDirectionX * this.mAnchorDpDt[0] + this.mTouchDirectionY * this.mAnchorDpDt[1];
                float velocity = this.mTouchDirectionX != 0.0f ? tvx / this.mAnchorDpDt[0] : tvy / this.mAnchorDpDt[1];
                if (!Float.isNaN(velocity)) {
                    pos += velocity / 3.0f;
                }
                if (pos == 0.0f || pos == 1.0f) break;
                this.mMotionLayout.touchAnimateTo((double)pos < 0.5 ? 0.0f : 1.0f, velocity);
            }
        }
    }

    void setDown(float lastTouchX, float lastTouchY) {
        this.mLastTouchX = lastTouchX;
        this.mLastTouchY = lastTouchY;
    }

    void scrollUp(float dx, float dy) {
        this.mDragStarted = false;
        float pos = this.mMotionLayout.getProgress();
        this.mMotionLayout.getAnchorDpDt(this.mTouchAnchorId, pos, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
        float movmentInDir = this.mTouchDirectionX * this.mAnchorDpDt[0] + this.mTouchDirectionY * this.mAnchorDpDt[1];
        float velocity = this.mTouchDirectionX != 0.0f ? dx * this.mTouchDirectionX / this.mAnchorDpDt[0] : dy * this.mTouchDirectionY / this.mAnchorDpDt[1];
        if (!Float.isNaN(velocity)) {
            pos += velocity / 3.0f;
        }
        if (pos != 0.0f && pos != 1.0f) {
            this.mMotionLayout.touchAnimateTo((double)pos < 0.5 ? 0.0f : 1.0f, velocity);
        }
    }

    void scrollMove(float dx, float dy) {
        float change;
        float drag = dx * this.mTouchDirectionX + dy * this.mTouchDirectionY;
        float pos = this.mMotionLayout.getProgress();
        if (!this.mDragStarted) {
            this.mDragStarted = true;
            this.mMotionLayout.setProgress(pos);
        }
        this.mMotionLayout.getAnchorDpDt(this.mTouchAnchorId, pos, this.mTouchAnchorX, this.mTouchAnchorY, this.mAnchorDpDt);
        float movmentInDir = this.mTouchDirectionX * this.mAnchorDpDt[0] + this.mTouchDirectionY * this.mAnchorDpDt[1];
        if ((double)Math.abs(movmentInDir) < 0.01) {
            this.mAnchorDpDt[0] = 0.01f;
            this.mAnchorDpDt[1] = 0.01f;
        }
        if ((pos = Math.max(Math.min(pos + (change = this.mTouchDirectionX != 0.0f ? dx * this.mTouchDirectionX / this.mAnchorDpDt[0] : dy * this.mTouchDirectionY / this.mAnchorDpDt[1]), 1.0f), 0.0f)) != this.mMotionLayout.getProgress()) {
            this.mMotionLayout.setProgress(pos);
        }
    }

    void setupTouch() {
        View view = this.mMotionLayout.findViewById(this.mTouchAnchorId);
        if (view == null) {
            Log.v((String)"MotionLayout", (String)" cannot find view to handle touch");
        }
        if (view instanceof NestedScrollView) {
            NestedScrollView sv = (NestedScrollView)view;
            sv.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View view, MotionEvent motionEvent) {
                    return false;
                }
            });
            sv.setOnScrollChangeListener(new NestedScrollView.OnScrollChangeListener(){

                public void onScrollChange(NestedScrollView v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
                }
            });
        }
    }

    public void setAnchorId(int id2) {
        this.mTouchAnchorId = id2;
    }

    public int getAnchorId() {
        return this.mTouchAnchorId;
    }

    public void setTouchAnchorLocation(float x, float y) {
        this.mTouchAnchorX = x;
        this.mTouchAnchorY = y;
    }

    public void setMaxVelocity(float velocity) {
        this.mMaxVelocity = velocity;
    }

    public void setMaxAcceleration(float acceleration) {
        this.mMaxAcceleration = acceleration;
    }

    float getMaxAcceleration() {
        return this.mMaxAcceleration;
    }

    public float getMaxVelocity() {
        return this.mMaxVelocity;
    }

    boolean getMoveWhenScrollAtTop() {
        return this.mMoveWhenScrollAtTop;
    }

    float dot(float dx, float dy) {
        return dx * this.mTouchDirectionX + dy * this.mTouchDirectionY;
    }

    public String toString() {
        return this.mTouchDirectionX + " , " + this.mTouchDirectionY;
    }
}

