/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.support.constraint.ConstraintLayout;
import android.support.constraint.ConstraintSet;
import android.support.constraint.ConstraintsChangedListener;
import android.support.constraint.R;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.Xml;
import java.io.IOException;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ConstraintLayoutStates {
    public static final String TAG = "ConstraintLayoutStates";
    private static final boolean DEBUG = false;
    private final ConstraintLayout mConstraintLayout;
    ConstraintSet mDefaultConstraintSet;
    int mCurrentStateId = -1;
    int mCurrentConstraintNumber = -1;
    private SparseArray<State> mStateList = new SparseArray();
    private SparseArray<ConstraintSet> mConstraintSetMap = new SparseArray();
    private ConstraintsChangedListener mConstraintsChangedListener = null;

    ConstraintLayoutStates(Context context, ConstraintLayout layout, int resourceID) {
        this.mConstraintLayout = layout;
        this.load(context, resourceID);
    }

    public boolean needsToChange(int id2, float width, float height) {
        State state;
        if (this.mCurrentStateId != id2) {
            return true;
        }
        State state2 = state = id2 == -1 ? (State)this.mStateList.valueAt(0) : (State)this.mStateList.get(this.mCurrentStateId);
        if (this.mCurrentConstraintNumber != -1 && state.mVariants.get(this.mCurrentConstraintNumber).match(width, height)) {
            return false;
        }
        return this.mCurrentConstraintNumber != state.findMatch(width, height);
    }

    public void updateConstraints(int id2, float width, float height) {
        if (this.mCurrentStateId == id2) {
            int cid;
            State state = id2 == -1 ? (State)this.mStateList.valueAt(0) : (State)this.mStateList.get(this.mCurrentStateId);
            if (this.mCurrentConstraintNumber != -1 && state.mVariants.get(this.mCurrentConstraintNumber).match(width, height)) {
                return;
            }
            int match = state.findMatch(width, height);
            if (this.mCurrentConstraintNumber == match) {
                return;
            }
            ConstraintSet constraintSet = match == -1 ? this.mDefaultConstraintSet : state.mVariants.get((int)match).mConstraintSet;
            int n = cid = match == -1 ? state.mConstraintID : state.mVariants.get((int)match).mConstraintID;
            if (constraintSet == null) {
                return;
            }
            this.mCurrentConstraintNumber = match;
            if (this.mConstraintsChangedListener != null) {
                this.mConstraintsChangedListener.preLayoutChange(-1, cid);
            }
            constraintSet.applyTo(this.mConstraintLayout);
            if (this.mConstraintsChangedListener != null) {
                this.mConstraintsChangedListener.postLayoutChange(-1, cid);
            }
        } else {
            int cid;
            this.mCurrentStateId = id2;
            State state = (State)this.mStateList.get(this.mCurrentStateId);
            int match = state.findMatch(width, height);
            ConstraintSet constraintSet = match == -1 ? state.mConstraintSet : state.mVariants.get((int)match).mConstraintSet;
            int n = cid = match == -1 ? state.mConstraintID : state.mVariants.get((int)match).mConstraintID;
            if (constraintSet == null) {
                Log.v((String)TAG, (String)("NO Constraint set found ! id=" + id2 + ", dim =" + width + ", " + height));
                return;
            }
            this.mCurrentConstraintNumber = match;
            if (this.mConstraintsChangedListener != null) {
                this.mConstraintsChangedListener.preLayoutChange(id2, cid);
            }
            constraintSet.applyTo(this.mConstraintLayout);
            if (this.mConstraintsChangedListener != null) {
                this.mConstraintsChangedListener.postLayoutChange(id2, cid);
            }
        }
    }

    public void setOnConstraintsChanged(ConstraintsChangedListener constraintsChangedListener) {
        this.mConstraintsChangedListener = constraintsChangedListener;
    }

    private void load(Context context, int resourceId) {
        Resources res = context.getResources();
        XmlResourceParser parser = res.getXml(resourceId);
        String document = null;
        String tagName = null;
        try {
            State state = null;
            int eventType = parser.getEventType();
            while (eventType != 1) {
                block1 : switch (eventType) {
                    case 0: {
                        document = parser.getName();
                        break;
                    }
                    case 2: {
                        switch (tagName = parser.getName()) {
                            case "layoutDescription": {
                                break;
                            }
                            case "StateSet": {
                                break;
                            }
                            case "State": {
                                state = new State(context, (XmlPullParser)parser);
                                this.mStateList.put(state.mId, (Object)state);
                                break;
                            }
                            case "Variant": {
                                Variant match = new Variant(context, (XmlPullParser)parser);
                                if (state == null) break block1;
                                state.add(match);
                                break;
                            }
                            case "ConstraintSet": {
                                this.parseConstraintSet(context, (XmlPullParser)parser);
                                break;
                            }
                            default: {
                                Log.v((String)TAG, (String)("unknown tag " + tagName));
                                break;
                            }
                        }
                        break;
                    }
                    case 3: {
                        tagName = null;
                        break;
                    }
                }
                eventType = parser.next();
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void parseConstraintSet(Context context, XmlPullParser parser) {
        ConstraintSet set = new ConstraintSet();
        int count = parser.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!"mId".equals(parser.getAttributeName(i))) continue;
            String s = parser.getAttributeValue(i);
            int id2 = -1;
            if (s.contains("/")) {
                String tmp = s.substring(s.indexOf(47) + 1);
                id2 = context.getResources().getIdentifier(tmp, "mId", context.getPackageName());
            }
            if (id2 == -1) {
                if (s != null && s.length() > 1) {
                    id2 = Integer.parseInt(s.substring(1));
                } else {
                    Log.e((String)TAG, (String)"error in parsing mId");
                }
            }
            set.load(context, parser);
            this.mConstraintSetMap.put(id2, (Object)set);
            break;
        }
    }

    static class Variant {
        int mId;
        float mMinWidth = Float.NaN;
        float mMinHeight = Float.NaN;
        float mMaxWidth = Float.NaN;
        float mMaxHeight = Float.NaN;
        int mConstraintID = -1;
        ConstraintSet mConstraintSet;

        public Variant(Context context, XmlPullParser parser) {
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.Variant);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.Variant_constraints) {
                    this.mConstraintID = a.getResourceId(attr, this.mConstraintID);
                    String type = context.getResources().getResourceTypeName(this.mConstraintID);
                    String name = context.getResources().getResourceName(this.mConstraintID);
                    if (!"layout".equals(type)) continue;
                    this.mConstraintSet = new ConstraintSet();
                    this.mConstraintSet.clone(context, this.mConstraintID);
                    continue;
                }
                if (attr == R.styleable.Variant_region_heightLessThan) {
                    this.mMaxHeight = a.getDimension(attr, this.mMaxHeight);
                    continue;
                }
                if (attr == R.styleable.Variant_region_heightMoreThan) {
                    this.mMinHeight = a.getDimension(attr, this.mMinHeight);
                    continue;
                }
                if (attr == R.styleable.Variant_region_widthLessThan) {
                    this.mMaxWidth = a.getDimension(attr, this.mMaxWidth);
                    continue;
                }
                if (attr == R.styleable.Variant_region_widthMoreThan) {
                    this.mMinWidth = a.getDimension(attr, this.mMinWidth);
                    continue;
                }
                Log.v((String)ConstraintLayoutStates.TAG, (String)"Unknown tag");
            }
            a.recycle();
        }

        boolean match(float widthDp, float heightDp) {
            if (!Float.isNaN(this.mMinWidth) && widthDp < this.mMinWidth) {
                return false;
            }
            if (!Float.isNaN(this.mMinHeight) && heightDp < this.mMinHeight) {
                return false;
            }
            if (!Float.isNaN(this.mMaxWidth) && widthDp > this.mMaxWidth) {
                return false;
            }
            return Float.isNaN(this.mMaxHeight) || !(heightDp > this.mMaxHeight);
        }
    }

    static class State {
        int mId;
        ArrayList<Variant> mVariants = new ArrayList();
        int mConstraintID = -1;
        ConstraintSet mConstraintSet;

        public State(Context context, XmlPullParser parser) {
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.State);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.State_android_id) {
                    this.mId = a.getResourceId(attr, this.mId);
                    continue;
                }
                if (attr != R.styleable.State_constraints) continue;
                this.mConstraintID = a.getResourceId(attr, this.mConstraintID);
                String type = context.getResources().getResourceTypeName(this.mConstraintID);
                String name = context.getResources().getResourceName(this.mConstraintID);
                if (!"layout".equals(type)) continue;
                this.mConstraintSet = new ConstraintSet();
                this.mConstraintSet.clone(context, this.mConstraintID);
            }
            a.recycle();
        }

        void add(Variant size) {
            this.mVariants.add(size);
        }

        public int findMatch(float width, float height) {
            for (int i = 0; i < this.mVariants.size(); ++i) {
                if (!this.mVariants.get(i).match(width, height)) continue;
                return i;
            }
            return -1;
        }
    }
}

