/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.motion;

import android.content.Context;
import android.support.constraint.ConstraintSet;
import android.support.constraint.motion.Key;
import android.support.constraint.motion.KeyPositionBase;
import android.support.constraint.motion.MotionController;
import android.support.constraint.motion.MotionLayout;
import android.support.constraint.motion.ProxyInterface;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import java.util.HashMap;

public class DesignTool
implements ProxyInterface {
    private static final boolean DEBUG = false;
    private static final String TAG = "DesignTool";
    private final MotionLayout mMotionLayout;
    static final HashMap<Pair<Integer, Integer>, String> allAttributes = new HashMap();
    static final HashMap<String, String> allMargins = new HashMap();

    public DesignTool(MotionLayout motionLayout) {
        this.mMotionLayout = motionLayout;
    }

    private static int GetPxFromDp(int dpi, String value) {
        if (value == null) {
            return 0;
        }
        int index = value.indexOf(100);
        if (index == -1) {
            return 0;
        }
        String filteredValue = value.substring(0, index);
        int dpValue = (int)((float)(Integer.valueOf(filteredValue) * dpi) / 160.0f);
        return dpValue;
    }

    private static void Connect(int dpi, ConstraintSet set, View view, HashMap<String, String> attributes, int from, int to) {
        String connection = allAttributes.get(Pair.create((Object)from, (Object)to));
        String connectionValue = attributes.get(connection);
        if (connectionValue != null) {
            int marginValue = 0;
            String margin = allMargins.get(connection);
            if (margin != null) {
                marginValue = DesignTool.GetPxFromDp(dpi, attributes.get(margin));
            }
            int id2 = Integer.parseInt(connectionValue);
            set.connect(view.getId(), from, id2, to, marginValue);
        }
    }

    private static void SetBias(ConstraintSet set, View view, HashMap<String, String> attributes, int type) {
        String biasValue;
        String bias = "layout_constraintHorizontal_bias";
        if (type == 1) {
            bias = "layout_constraintVertical_bias";
        }
        if ((biasValue = attributes.get(bias)) != null) {
            if (type == 0) {
                set.setHorizontalBias(view.getId(), Float.parseFloat(biasValue));
            } else if (type == 1) {
                set.setVerticalBias(view.getId(), Float.parseFloat(biasValue));
            }
        }
    }

    private static void SetDimensions(int dpi, ConstraintSet set, View view, HashMap<String, String> attributes, int type) {
        String dimensionValue;
        String dimension = "layout_width";
        if (type == 1) {
            dimension = "layout_height";
        }
        if ((dimensionValue = attributes.get(dimension)) != null) {
            int value = -2;
            if (!dimensionValue.equalsIgnoreCase("wrap_content")) {
                value = DesignTool.GetPxFromDp(dpi, dimensionValue);
            }
            if (type == 0) {
                set.constrainWidth(view.getId(), value);
            } else {
                set.constrainHeight(view.getId(), value);
            }
        }
    }

    private static void SetAbsolutePositions(int dpi, ConstraintSet set, View view, HashMap<String, String> attributes) {
        String absoluteY;
        String absoluteX = attributes.get("layout_editor_absoluteX");
        if (absoluteX != null) {
            set.setEditorAbsoluteX(view.getId(), DesignTool.GetPxFromDp(dpi, absoluteX));
        }
        if ((absoluteY = attributes.get("layout_editor_absoluteY")) != null) {
            set.setEditorAbsoluteY(view.getId(), DesignTool.GetPxFromDp(dpi, absoluteY));
        }
    }

    public int getAnimationPath(Object view, float[] path) {
        if (this.mMotionLayout.mScene == null) {
            return -1;
        }
        int duration = this.mMotionLayout.mScene.getDuration();
        int frames = duration / 16;
        MotionController motionController = this.mMotionLayout.mFrameArrayList.get(view);
        if (motionController == null) {
            return 0;
        }
        motionController.buildPath(path, frames);
        return frames;
    }

    public void getAnimationRectangles(Object view, float[] path) {
        if (this.mMotionLayout.mScene == null) {
            return;
        }
        int duration = this.mMotionLayout.mScene.getDuration();
        int frames = duration / 16;
        MotionController motionController = this.mMotionLayout.mFrameArrayList.get(view);
        if (motionController == null) {
            return;
        }
        motionController.buildRectangles(path, frames);
    }

    public int getAnimationKeyFames(Object view, float[] key) {
        if (this.mMotionLayout.mScene == null) {
            return -1;
        }
        int duration = this.mMotionLayout.mScene.getDuration();
        int frames = duration / 16;
        MotionController motionController = this.mMotionLayout.mFrameArrayList.get(view);
        if (motionController == null) {
            return 0;
        }
        motionController.buildKeyFrames(key, null);
        return frames;
    }

    @Override
    public void setToolPosition(float position) {
        this.mMotionLayout.mIndirectTransition = true;
        this.mMotionLayout.setProgress(position);
        this.mMotionLayout.evaluate(false);
        for (int i = 0; i < this.mMotionLayout.getChildCount(); ++i) {
            View child = this.mMotionLayout.getChildAt(i);
            if (!(child instanceof MotionLayout)) continue;
            ((MotionLayout)child).setProgress(position);
        }
    }

    @Override
    public long getTransitionTimeMs() {
        return this.mMotionLayout.getTransitionTimeMs();
    }

    @Override
    public float getKeyFramePosition(Object view, int type, float x, float y) {
        return this.mMotionLayout.mFrameArrayList.get((View)view).getKeyFrameParameter(type, x, y);
    }

    @Override
    public void setKeyFrame(Object view, int position, String name, Object value) {
        if (this.mMotionLayout.mScene != null) {
            this.mMotionLayout.mScene.setKeyframe((View)view, position, name, value);
            this.mMotionLayout.mTransitionGoalPosition = (float)position / 100.0f;
            this.mMotionLayout.mTransitionLastPosition = 0.0f;
            this.mMotionLayout.rebuildScene();
            this.mMotionLayout.evaluate(true);
        }
    }

    @Override
    public boolean setKeyFramePosition(Object view, int position, int type, float x, float y) {
        if (this.mMotionLayout.mScene != null) {
            MotionController motionController = this.mMotionLayout.mFrameArrayList.get(view);
            position = (int)(this.mMotionLayout.mTransitionPosition * 100.0f);
            position = 30;
            if (motionController != null && this.mMotionLayout.mScene.hasKeyFramePosition((View)view, position)) {
                float fx = motionController.getKeyFrameParameter(2, x, y);
                float fy = motionController.getKeyFrameParameter(5, x, y);
                this.mMotionLayout.mScene.setKeyframe((View)view, position, "motion:percentX", Float.valueOf(fx));
                this.mMotionLayout.mScene.setKeyframe((View)view, position, "motion:percentY", Float.valueOf(fy));
                this.mMotionLayout.rebuildScene();
                this.mMotionLayout.evaluate(true);
                this.mMotionLayout.invalidate();
                return true;
            }
        }
        return false;
    }

    public void setViewDebug(Object view, int debugMode) {
        MotionController motionController = this.mMotionLayout.mFrameArrayList.get(view);
        if (motionController != null) {
            motionController.setDrawPath(debugMode);
            this.mMotionLayout.invalidate();
        }
    }

    @Override
    public int designAccess(int cmd, String type, Object viewObject, float[] in, int inLength, float[] out, int outLength) {
        View view = (View)viewObject;
        MotionController motionController = null;
        if (cmd != 0) {
            if (this.mMotionLayout.mScene == null) {
                return -1;
            }
            if (view != null) {
                motionController = this.mMotionLayout.mFrameArrayList.get(view);
                if (motionController == null) {
                    return -1;
                }
            } else {
                return -1;
            }
        }
        switch (cmd) {
            case 0: {
                return 1;
            }
            case 1: {
                int duration = this.mMotionLayout.mScene.getDuration();
                int frames = duration / 16;
                motionController.buildPath(out, frames);
                return frames;
            }
            case 2: {
                int duration = this.mMotionLayout.mScene.getDuration();
                int frames = duration / 16;
                motionController.buildKeyFrames(out, null);
                return frames;
            }
            case 3: {
                int duration = this.mMotionLayout.mScene.getDuration();
                int frames = duration / 16;
                return motionController.getAttributeValues(type, out, outLength);
            }
        }
        return -1;
    }

    public Object getKeyframe(int type, int target, int position) {
        if (this.mMotionLayout.mScene == null) {
            return null;
        }
        return this.mMotionLayout.mScene.getKeyFrame(this.mMotionLayout.getContext(), type, target, position);
    }

    @Override
    public Object getKeyframeAtLocation(Object viewObject, float x, float y) {
        View view = (View)viewObject;
        MotionController motionController = null;
        if (this.mMotionLayout.mScene == null) {
            return -1;
        }
        if (view != null) {
            motionController = this.mMotionLayout.mFrameArrayList.get(view);
            if (motionController == null) {
                return null;
            }
        } else {
            return null;
        }
        ViewGroup viewGroup = (ViewGroup)view.getParent();
        int layoutWidth = viewGroup.getWidth();
        int layoutHeight = viewGroup.getHeight();
        return motionController.getPositionKeyframe(layoutWidth, layoutHeight, x, y);
    }

    @Override
    public Boolean getPositionKeyframe(Object keyFrame, Object view, float x, float y, String[] attribute, float[] value) {
        if (keyFrame instanceof KeyPositionBase) {
            KeyPositionBase key = (KeyPositionBase)keyFrame;
            MotionController motionController = this.mMotionLayout.mFrameArrayList.get((View)view);
            motionController.positionKeyframe((View)view, key, x, y, attribute, value);
            this.mMotionLayout.rebuildScene();
            this.mMotionLayout.mInTransition = true;
            return true;
        }
        return false;
    }

    public void setKeyframe(Object keyFrame, String tag, Object value) {
        if (keyFrame instanceof Key) {
            Key key = (Key)keyFrame;
            key.setValue(tag, value);
            this.mMotionLayout.rebuildScene();
            this.mMotionLayout.mInTransition = true;
        }
    }

    @Override
    public void setAttributes(int dpi, String constraintSetId, Object opaqueView, Object opaqueAttributes) {
        View view = (View)opaqueView;
        HashMap attributes = (HashMap)opaqueAttributes;
        ConstraintSet set = null;
        Context ctx = this.mMotionLayout.getContext();
        int id2 = ctx.getResources().getIdentifier(constraintSetId, "id", ctx.getPackageName());
        set = this.mMotionLayout.mScene.getConstraintSet(id2);
        if (set == null) {
            return;
        }
        set.clear(view.getId());
        DesignTool.SetDimensions(dpi, set, view, attributes, 0);
        DesignTool.SetDimensions(dpi, set, view, attributes, 1);
        DesignTool.Connect(dpi, set, view, attributes, 6, 6);
        DesignTool.Connect(dpi, set, view, attributes, 6, 7);
        DesignTool.Connect(dpi, set, view, attributes, 7, 7);
        DesignTool.Connect(dpi, set, view, attributes, 7, 6);
        DesignTool.Connect(dpi, set, view, attributes, 1, 1);
        DesignTool.Connect(dpi, set, view, attributes, 1, 2);
        DesignTool.Connect(dpi, set, view, attributes, 2, 2);
        DesignTool.Connect(dpi, set, view, attributes, 2, 1);
        DesignTool.Connect(dpi, set, view, attributes, 3, 3);
        DesignTool.Connect(dpi, set, view, attributes, 3, 4);
        DesignTool.Connect(dpi, set, view, attributes, 4, 3);
        DesignTool.Connect(dpi, set, view, attributes, 4, 4);
        DesignTool.Connect(dpi, set, view, attributes, 5, 5);
        DesignTool.SetBias(set, view, attributes, 0);
        DesignTool.SetBias(set, view, attributes, 1);
        DesignTool.SetAbsolutePositions(dpi, set, view, attributes);
        this.mMotionLayout.mTransitionLastPosition = -1.0f;
        this.mMotionLayout.rebuildScene();
    }

    static {
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)4, (Object)4), "layout_constraintBottom_toBottomOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)4, (Object)3), "layout_constraintBottom_toTopOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)3, (Object)4), "layout_constraintTop_toBottomOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)3, (Object)3), "layout_constraintTop_toTopOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)6, (Object)6), "layout_constraintStart_toStartOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)6, (Object)7), "layout_constraintStart_toEndOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)7, (Object)6), "layout_constraintEnd_toStartOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)7, (Object)7), "layout_constraintEnd_toEndOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)1, (Object)1), "layout_constraintLeft_toLeftOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)1, (Object)2), "layout_constraintLeft_toRightOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)2, (Object)2), "layout_constraintRight_toRightOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)2, (Object)1), "layout_constraintRight_toLeftOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)5, (Object)5), "layout_constraintBaseline_toBaselineOf");
        allMargins.put("layout_constraintBottom_toBottomOf", "layout_marginBottom");
        allMargins.put("layout_constraintBottom_toTopOf", "layout_marginBottom");
        allMargins.put("layout_constraintTop_toBottomOf", "layout_marginTop");
        allMargins.put("layout_constraintTop_toTopOf", "layout_marginTop");
        allMargins.put("layout_constraintStart_toStartOf", "layout_marginStart");
        allMargins.put("layout_constraintStart_toEndOf", "layout_marginStart");
        allMargins.put("layout_constraintEnd_toStartOf", "layout_marginEnd");
        allMargins.put("layout_constraintEnd_toEndOf", "layout_marginEnd");
        allMargins.put("layout_constraintLeft_toLeftOf", "layout_marginLeft");
        allMargins.put("layout_constraintLeft_toRightOf", "layout_marginLeft");
        allMargins.put("layout_constraintRight_toRightOf", "layout_marginRight");
        allMargins.put("layout_constraintRight_toLeftOf", "layout_marginRight");
    }
}

