/*
 * Decompiled with CFR 0.152.
 */
package android.support.constraint.motion;

import android.support.constraint.ConstraintSet;
import android.support.constraint.R;
import android.support.constraint.motion.Key;
import android.support.constraint.motion.KeyPositionBase;
import android.support.constraint.motion.MotionController;
import android.support.constraint.motion.MotionLayout;
import android.support.constraint.motion.MotionScene;
import android.support.constraint.motion.ProxyInterface;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import java.util.HashMap;

public class DesignTool
implements ProxyInterface {
    private static final boolean DEBUG = false;
    private static final String TAG = "DesignTool";
    private final MotionLayout mMotionLayout;
    private MotionScene mSceneCache;
    private String mLastStartState = null;
    private String mLastEndState = null;
    private int mLastStartStateId = -1;
    private int mLastEndStateId = -1;
    static final HashMap<Pair<Integer, Integer>, String> allAttributes = new HashMap();
    static final HashMap<String, String> allMargins = new HashMap();

    public DesignTool(MotionLayout motionLayout) {
        this.mMotionLayout = motionLayout;
    }

    private static int GetPxFromDp(int dpi, String value) {
        if (value == null) {
            return 0;
        }
        int index = value.indexOf(100);
        if (index == -1) {
            return 0;
        }
        String filteredValue = value.substring(0, index);
        int dpValue = (int)((float)(Integer.valueOf(filteredValue) * dpi) / 160.0f);
        return dpValue;
    }

    private static void Connect(int dpi, ConstraintSet set, View view, HashMap<String, String> attributes, int from, int to) {
        String connection = allAttributes.get(Pair.create((Object)from, (Object)to));
        String connectionValue = attributes.get(connection);
        if (connectionValue != null) {
            int marginValue = 0;
            String margin = allMargins.get(connection);
            if (margin != null) {
                marginValue = DesignTool.GetPxFromDp(dpi, attributes.get(margin));
            }
            int id2 = Integer.parseInt(connectionValue);
            set.connect(view.getId(), from, id2, to, marginValue);
        }
    }

    private static void SetBias(ConstraintSet set, View view, HashMap<String, String> attributes, int type) {
        String biasValue;
        String bias = "layout_constraintHorizontal_bias";
        if (type == 1) {
            bias = "layout_constraintVertical_bias";
        }
        if ((biasValue = attributes.get(bias)) != null) {
            if (type == 0) {
                set.setHorizontalBias(view.getId(), Float.parseFloat(biasValue));
            } else if (type == 1) {
                set.setVerticalBias(view.getId(), Float.parseFloat(biasValue));
            }
        }
    }

    private static void SetDimensions(int dpi, ConstraintSet set, View view, HashMap<String, String> attributes, int type) {
        String dimensionValue;
        String dimension = "layout_width";
        if (type == 1) {
            dimension = "layout_height";
        }
        if ((dimensionValue = attributes.get(dimension)) != null) {
            int value = -2;
            if (!dimensionValue.equalsIgnoreCase("wrap_content")) {
                value = DesignTool.GetPxFromDp(dpi, dimensionValue);
            }
            if (type == 0) {
                set.constrainWidth(view.getId(), value);
            } else {
                set.constrainHeight(view.getId(), value);
            }
        }
    }

    private static void SetAbsolutePositions(int dpi, ConstraintSet set, View view, HashMap<String, String> attributes) {
        String absoluteY;
        String absoluteX = attributes.get("layout_editor_absoluteX");
        if (absoluteX != null) {
            set.setEditorAbsoluteX(view.getId(), DesignTool.GetPxFromDp(dpi, absoluteX));
        }
        if ((absoluteY = attributes.get("layout_editor_absoluteY")) != null) {
            set.setEditorAbsoluteY(view.getId(), DesignTool.GetPxFromDp(dpi, absoluteY));
        }
    }

    public int getAnimationPath(Object view, float[] path, int len) {
        if (this.mMotionLayout.mScene == null) {
            return -1;
        }
        MotionController motionController = this.mMotionLayout.mFrameArrayList.get(view);
        if (motionController == null) {
            return 0;
        }
        motionController.buildPath(path, len);
        return len;
    }

    public void getAnimationRectangles(Object view, float[] path) {
        if (this.mMotionLayout.mScene == null) {
            return;
        }
        int duration = this.mMotionLayout.mScene.getDuration();
        int frames = duration / 16;
        MotionController motionController = this.mMotionLayout.mFrameArrayList.get(view);
        if (motionController == null) {
            return;
        }
        motionController.buildRectangles(path, frames);
    }

    public int getAnimationKeyFrames(Object view, float[] key) {
        if (this.mMotionLayout.mScene == null) {
            return -1;
        }
        int duration = this.mMotionLayout.mScene.getDuration();
        int frames = duration / 16;
        MotionController motionController = this.mMotionLayout.mFrameArrayList.get(view);
        if (motionController == null) {
            return 0;
        }
        motionController.buildKeyFrames(key, null);
        return frames;
    }

    @Override
    public void setToolPosition(float position) {
        if (this.mMotionLayout.mScene == null) {
            this.mMotionLayout.mScene = this.mSceneCache;
        }
        this.mMotionLayout.setProgress(position);
        this.mMotionLayout.evaluate(true);
        this.mMotionLayout.requestLayout();
        this.mMotionLayout.invalidate();
    }

    public void setState(String id2) {
        int rscId;
        if (id2 == null) {
            id2 = "motion_base";
        }
        if (this.mLastStartState == id2) {
            return;
        }
        this.mLastStartState = id2;
        this.mLastEndState = null;
        if (id2 == null) {
            // empty if block
        }
        if (this.mMotionLayout.mScene == null) {
            this.mMotionLayout.mScene = this.mSceneCache;
        }
        this.mLastStartStateId = rscId = id2 != null ? this.mMotionLayout.lookUpConstraintId(id2) : R.id.motion_base;
        if (rscId != 0) {
            if (rscId == this.mMotionLayout.getStartState()) {
                this.mMotionLayout.setProgress(0.0f);
            } else if (rscId == this.mMotionLayout.getEndState()) {
                this.mMotionLayout.setProgress(1.0f);
            } else {
                this.mMotionLayout.transitionToState(rscId);
                this.mMotionLayout.setProgress(1.0f);
            }
        }
        this.mMotionLayout.requestLayout();
    }

    public String getStartState() {
        int startid = this.mMotionLayout.getStartState();
        if (this.mLastStartStateId == startid) {
            return this.mLastStartState;
        }
        String last = this.mMotionLayout.getConstraintSetNames(startid);
        if (last != null) {
            this.mLastStartState = last;
            this.mLastStartStateId = startid;
        }
        return this.mMotionLayout.getConstraintSetNames(startid);
    }

    public String getEndState() {
        int endId = this.mMotionLayout.getEndState();
        if (this.mLastEndStateId == endId) {
            return this.mLastEndState;
        }
        String last = this.mMotionLayout.getConstraintSetNames(endId);
        if (last != null) {
            this.mLastEndState = last;
            this.mLastEndStateId = endId;
        }
        return last;
    }

    public float getProgress() {
        return this.mMotionLayout.getProgress();
    }

    public String getState() {
        if (this.mLastStartState != null && this.mLastEndState != null) {
            float epsilon;
            float progress = this.getProgress();
            if (progress <= (epsilon = 0.01f)) {
                return this.mLastStartState;
            }
            if (progress >= 1.0f - epsilon) {
                return this.mLastEndState;
            }
        }
        return this.mLastStartState;
    }

    public boolean isInTransition() {
        return this.mLastStartState != null && this.mLastEndState != null;
    }

    public void setTransition(String start, String end) {
        if (this.mMotionLayout.mScene == null) {
            this.mMotionLayout.mScene = this.mSceneCache;
        }
        int startId = this.mMotionLayout.lookUpConstraintId(start);
        int endId = this.mMotionLayout.lookUpConstraintId(end);
        this.mMotionLayout.setTransition(startId, endId);
        this.mLastStartStateId = startId;
        this.mLastEndStateId = endId;
        this.mLastStartState = start;
        this.mLastEndState = end;
    }

    public void disableAutoTransition(boolean disable) {
        this.mMotionLayout.disableAutoTransition(disable);
    }

    @Override
    public long getTransitionTimeMs() {
        return this.mMotionLayout.getTransitionTimeMs();
    }

    public int getKeyFramePositions(Object view, int[] type, float[] pos) {
        MotionController controller = this.mMotionLayout.mFrameArrayList.get((View)view);
        if (controller == null) {
            return 0;
        }
        return controller.getkeyFramePositions(type, pos);
    }

    public int getKeyFrameInfo(Object view, int type, int[] info) {
        MotionController controller = this.mMotionLayout.mFrameArrayList.get((View)view);
        if (controller == null) {
            return 0;
        }
        return controller.getKeyFrameInfo(type, info);
    }

    @Override
    public float getKeyFramePosition(Object view, int type, float x, float y) {
        return this.mMotionLayout.mFrameArrayList.get((View)view).getKeyFrameParameter(type, x, y);
    }

    @Override
    public void setKeyFrame(Object view, int position, String name, Object value) {
        if (this.mMotionLayout.mScene != null) {
            this.mMotionLayout.mScene.setKeyframe((View)view, position, name, value);
            this.mMotionLayout.mTransitionGoalPosition = (float)position / 100.0f;
            this.mMotionLayout.mTransitionLastPosition = 0.0f;
            this.mMotionLayout.rebuildScene();
            this.mMotionLayout.evaluate(true);
        }
    }

    @Override
    public boolean setKeyFramePosition(Object view, int position, int type, float x, float y) {
        if (this.mMotionLayout.mScene != null) {
            MotionController motionController = this.mMotionLayout.mFrameArrayList.get(view);
            position = (int)(this.mMotionLayout.mTransitionPosition * 100.0f);
            if (motionController != null && this.mMotionLayout.mScene.hasKeyFramePosition((View)view, position)) {
                float fx = motionController.getKeyFrameParameter(2, x, y);
                float fy = motionController.getKeyFrameParameter(5, x, y);
                this.mMotionLayout.mScene.setKeyframe((View)view, position, "motion:percentX", Float.valueOf(fx));
                this.mMotionLayout.mScene.setKeyframe((View)view, position, "motion:percentY", Float.valueOf(fy));
                this.mMotionLayout.rebuildScene();
                this.mMotionLayout.evaluate(true);
                this.mMotionLayout.invalidate();
                return true;
            }
        }
        return false;
    }

    public void setViewDebug(Object view, int debugMode) {
        MotionController motionController = this.mMotionLayout.mFrameArrayList.get(view);
        if (motionController != null) {
            motionController.setDrawPath(debugMode);
            this.mMotionLayout.invalidate();
        }
    }

    @Override
    public int designAccess(int cmd, String type, Object viewObject, float[] in, int inLength, float[] out, int outLength) {
        View view = (View)viewObject;
        MotionController motionController = null;
        if (cmd != 0) {
            if (this.mMotionLayout.mScene == null) {
                return -1;
            }
            if (view != null) {
                motionController = this.mMotionLayout.mFrameArrayList.get(view);
                if (motionController == null) {
                    return -1;
                }
            } else {
                return -1;
            }
        }
        switch (cmd) {
            case 0: {
                return 1;
            }
            case 1: {
                int duration = this.mMotionLayout.mScene.getDuration();
                int frames = duration / 16;
                motionController.buildPath(out, frames);
                return frames;
            }
            case 2: {
                int duration = this.mMotionLayout.mScene.getDuration();
                int frames = duration / 16;
                motionController.buildKeyFrames(out, null);
                return frames;
            }
            case 3: {
                int duration = this.mMotionLayout.mScene.getDuration();
                int frames = duration / 16;
                return motionController.getAttributeValues(type, out, outLength);
            }
        }
        return -1;
    }

    public Object getKeyframe(int type, int target, int position) {
        if (this.mMotionLayout.mScene == null) {
            return null;
        }
        return this.mMotionLayout.mScene.getKeyFrame(this.mMotionLayout.getContext(), type, target, position);
    }

    @Override
    public Object getKeyframeAtLocation(Object viewObject, float x, float y) {
        View view = (View)viewObject;
        MotionController motionController = null;
        if (this.mMotionLayout.mScene == null) {
            return -1;
        }
        if (view != null) {
            motionController = this.mMotionLayout.mFrameArrayList.get(view);
            if (motionController == null) {
                return null;
            }
        } else {
            return null;
        }
        ViewGroup viewGroup = (ViewGroup)view.getParent();
        int layoutWidth = viewGroup.getWidth();
        int layoutHeight = viewGroup.getHeight();
        return motionController.getPositionKeyframe(layoutWidth, layoutHeight, x, y);
    }

    @Override
    public Boolean getPositionKeyframe(Object keyFrame, Object view, float x, float y, String[] attribute, float[] value) {
        if (keyFrame instanceof KeyPositionBase) {
            KeyPositionBase key = (KeyPositionBase)keyFrame;
            MotionController motionController = this.mMotionLayout.mFrameArrayList.get((View)view);
            motionController.positionKeyframe((View)view, key, x, y, attribute, value);
            this.mMotionLayout.rebuildScene();
            this.mMotionLayout.mInTransition = true;
            return true;
        }
        return false;
    }

    public Object getKeyframe(Object view, int type, int position) {
        if (this.mMotionLayout.mScene == null) {
            return null;
        }
        int target = ((View)view).getId();
        return this.mMotionLayout.mScene.getKeyFrame(this.mMotionLayout.getContext(), type, target, position);
    }

    public void setKeyframe(Object keyFrame, String tag, Object value) {
        if (keyFrame instanceof Key) {
            Key key = (Key)keyFrame;
            key.setValue(tag, value);
            this.mMotionLayout.rebuildScene();
            this.mMotionLayout.mInTransition = true;
        }
    }

    @Override
    public void setAttributes(int dpi, String constraintSetId, Object opaqueView, Object opaqueAttributes) {
        View view = (View)opaqueView;
        HashMap attributes = (HashMap)opaqueAttributes;
        int rscId = this.mMotionLayout.lookUpConstraintId(constraintSetId);
        ConstraintSet set = this.mMotionLayout.mScene.getConstraintSet(rscId);
        if (set == null) {
            return;
        }
        set.clear(view.getId());
        DesignTool.SetDimensions(dpi, set, view, attributes, 0);
        DesignTool.SetDimensions(dpi, set, view, attributes, 1);
        DesignTool.Connect(dpi, set, view, attributes, 6, 6);
        DesignTool.Connect(dpi, set, view, attributes, 6, 7);
        DesignTool.Connect(dpi, set, view, attributes, 7, 7);
        DesignTool.Connect(dpi, set, view, attributes, 7, 6);
        DesignTool.Connect(dpi, set, view, attributes, 1, 1);
        DesignTool.Connect(dpi, set, view, attributes, 1, 2);
        DesignTool.Connect(dpi, set, view, attributes, 2, 2);
        DesignTool.Connect(dpi, set, view, attributes, 2, 1);
        DesignTool.Connect(dpi, set, view, attributes, 3, 3);
        DesignTool.Connect(dpi, set, view, attributes, 3, 4);
        DesignTool.Connect(dpi, set, view, attributes, 4, 3);
        DesignTool.Connect(dpi, set, view, attributes, 4, 4);
        DesignTool.Connect(dpi, set, view, attributes, 5, 5);
        DesignTool.SetBias(set, view, attributes, 0);
        DesignTool.SetBias(set, view, attributes, 1);
        DesignTool.SetAbsolutePositions(dpi, set, view, attributes);
        this.mMotionLayout.updateState(rscId, set);
        this.mMotionLayout.requestLayout();
    }

    public void dumpConstraintSet(String set) {
        if (this.mMotionLayout.mScene == null) {
            this.mMotionLayout.mScene = this.mSceneCache;
        }
        int setId = this.mMotionLayout.lookUpConstraintId(set);
        System.out.println(" dumping  " + set + " (" + setId + ")");
        try {
            this.mMotionLayout.mScene.getConstraintSet(setId).dump(this.mMotionLayout.mScene, new int[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static {
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)4, (Object)4), "layout_constraintBottom_toBottomOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)4, (Object)3), "layout_constraintBottom_toTopOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)3, (Object)4), "layout_constraintTop_toBottomOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)3, (Object)3), "layout_constraintTop_toTopOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)6, (Object)6), "layout_constraintStart_toStartOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)6, (Object)7), "layout_constraintStart_toEndOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)7, (Object)6), "layout_constraintEnd_toStartOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)7, (Object)7), "layout_constraintEnd_toEndOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)1, (Object)1), "layout_constraintLeft_toLeftOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)1, (Object)2), "layout_constraintLeft_toRightOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)2, (Object)2), "layout_constraintRight_toRightOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)2, (Object)1), "layout_constraintRight_toLeftOf");
        allAttributes.put((Pair<Integer, Integer>)Pair.create((Object)5, (Object)5), "layout_constraintBaseline_toBaselineOf");
        allMargins.put("layout_constraintBottom_toBottomOf", "layout_marginBottom");
        allMargins.put("layout_constraintBottom_toTopOf", "layout_marginBottom");
        allMargins.put("layout_constraintTop_toBottomOf", "layout_marginTop");
        allMargins.put("layout_constraintTop_toTopOf", "layout_marginTop");
        allMargins.put("layout_constraintStart_toStartOf", "layout_marginStart");
        allMargins.put("layout_constraintStart_toEndOf", "layout_marginStart");
        allMargins.put("layout_constraintEnd_toStartOf", "layout_marginEnd");
        allMargins.put("layout_constraintEnd_toEndOf", "layout_marginEnd");
        allMargins.put("layout_constraintLeft_toLeftOf", "layout_marginLeft");
        allMargins.put("layout_constraintLeft_toRightOf", "layout_marginLeft");
        allMargins.put("layout_constraintRight_toRightOf", "layout_marginRight");
        allMargins.put("layout_constraintRight_toLeftOf", "layout_marginRight");
    }
}

