/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.internal;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.design.internal.FlexContainer;
import android.support.design.internal.FlexItem;
import android.support.design.internal.FlexLine;
import android.support.design.internal.FlexboxHelper;
import android.support.design.internal.R;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class FlexboxLayout
extends ViewGroup
implements FlexContainer {
    private int flexWrap;
    public static final int SHOW_DIVIDER_NONE = 0;
    public static final int SHOW_DIVIDER_BEGINNING = 1;
    public static final int SHOW_DIVIDER_MIDDLE = 2;
    public static final int SHOW_DIVIDER_END = 4;
    @Nullable
    private Drawable dividerDrawableHorizontal;
    @Nullable
    private Drawable dividerDrawableVertical;
    private int showDividerHorizontal;
    private int showDividerVertical;
    private int dividerHorizontalHeight;
    private int dividerVerticalWidth;
    private int[] reorderedIndices;
    private SparseIntArray orderCache;
    private FlexboxHelper flexboxHelper = new FlexboxHelper(this);
    private List<FlexLine> flexLines = new ArrayList<FlexLine>();
    private FlexboxHelper.FlexLinesResult flexLinesResult = new FlexboxHelper.FlexLinesResult();

    public FlexboxLayout(Context context) {
        this(context, null);
    }

    public FlexboxLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public FlexboxLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.orderCache == null) {
            this.orderCache = new SparseIntArray(this.getChildCount());
        }
        if (this.flexboxHelper.isOrderChangedFromLastMeasurement(this.orderCache)) {
            this.reorderedIndices = this.flexboxHelper.createReorderedIndices(this.orderCache);
        }
        this.measureHorizontal(widthMeasureSpec, heightMeasureSpec);
    }

    @Override
    public int getFlexItemCount() {
        return this.getChildCount();
    }

    @Override
    public View getFlexItemAt(int index) {
        return this.getChildAt(index);
    }

    public View getReorderedChildAt(int index) {
        if (index < 0 || index >= this.reorderedIndices.length) {
            return null;
        }
        return this.getChildAt(this.reorderedIndices[index]);
    }

    @Override
    public View getReorderedFlexItemAt(int index) {
        return this.getReorderedChildAt(index);
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.orderCache == null) {
            this.orderCache = new SparseIntArray(this.getChildCount());
        }
        this.reorderedIndices = this.flexboxHelper.createReorderedIndices(child, index, params, this.orderCache);
        super.addView(child, index, params);
    }

    private void measureHorizontal(int widthMeasureSpec, int heightMeasureSpec) {
        this.flexLines.clear();
        this.flexLinesResult.reset();
        this.flexboxHelper.calculateHorizontalFlexLines(this.flexLinesResult, widthMeasureSpec, heightMeasureSpec);
        this.flexLines = this.flexLinesResult.flexLines;
        this.flexboxHelper.determineMainSize(widthMeasureSpec, heightMeasureSpec);
        this.flexboxHelper.determineCrossSize(heightMeasureSpec, this.getPaddingTop() + this.getPaddingBottom());
        this.flexboxHelper.stretchViews();
        this.setMeasuredDimensionForFlex(widthMeasureSpec, heightMeasureSpec, this.flexLinesResult.childState);
    }

    private void setMeasuredDimensionForFlex(int widthMeasureSpec, int heightMeasureSpec, int childState) {
        int heightSizeAndState;
        int widthSizeAndState;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int calculatedMaxHeight = this.getSumOfCrossSize() + this.getPaddingTop() + this.getPaddingBottom();
        int calculatedMaxWidth = this.getLargestMainSize();
        switch (widthMode) {
            case 0x40000000: {
                if (widthSize < calculatedMaxWidth) {
                    childState = View.combineMeasuredStates((int)childState, (int)0x1000000);
                }
                widthSizeAndState = View.resolveSizeAndState((int)widthSize, (int)widthMeasureSpec, (int)childState);
                break;
            }
            case -2147483648: {
                if (widthSize < calculatedMaxWidth) {
                    childState = View.combineMeasuredStates((int)childState, (int)0x1000000);
                } else {
                    widthSize = calculatedMaxWidth;
                }
                widthSizeAndState = View.resolveSizeAndState((int)widthSize, (int)widthMeasureSpec, (int)childState);
                break;
            }
            case 0: {
                widthSizeAndState = View.resolveSizeAndState((int)calculatedMaxWidth, (int)widthMeasureSpec, (int)childState);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown width mode is set: " + widthMode);
            }
        }
        switch (heightMode) {
            case 0x40000000: {
                if (heightSize < calculatedMaxHeight) {
                    childState = View.combineMeasuredStates((int)childState, (int)256);
                }
                heightSizeAndState = View.resolveSizeAndState((int)heightSize, (int)heightMeasureSpec, (int)childState);
                break;
            }
            case -2147483648: {
                if (heightSize < calculatedMaxHeight) {
                    childState = View.combineMeasuredStates((int)childState, (int)256);
                } else {
                    heightSize = calculatedMaxHeight;
                }
                heightSizeAndState = View.resolveSizeAndState((int)heightSize, (int)heightMeasureSpec, (int)childState);
                break;
            }
            case 0: {
                heightSizeAndState = View.resolveSizeAndState((int)calculatedMaxHeight, (int)heightMeasureSpec, (int)childState);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown height mode is set: " + heightMode);
            }
        }
        this.setMeasuredDimension(widthSizeAndState, heightSizeAndState);
    }

    @Override
    public int getLargestMainSize() {
        int largestSize = Integer.MIN_VALUE;
        for (FlexLine flexLine : this.flexLines) {
            largestSize = Math.max(largestSize, flexLine.mainSize);
        }
        return largestSize;
    }

    @Override
    public int getSumOfCrossSize() {
        int sum = 0;
        int size = this.flexLines.size();
        for (int i = 0; i < size; ++i) {
            FlexLine flexLine = this.flexLines.get(i);
            if (this.hasDividerBeforeFlexLine(i)) {
                sum = this.isMainAxisDirectionHorizontal() ? (sum += this.dividerHorizontalHeight) : (sum += this.dividerVerticalWidth);
            }
            if (this.hasEndDividerAfterFlexLine(i)) {
                sum = this.isMainAxisDirectionHorizontal() ? (sum += this.dividerHorizontalHeight) : (sum += this.dividerVerticalWidth);
            }
            sum += flexLine.crossSize;
        }
        return sum;
    }

    @Override
    public boolean isMainAxisDirectionHorizontal() {
        return true;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int layoutDirection = ViewCompat.getLayoutDirection((View)this);
        boolean isRtl = layoutDirection == 1;
        this.layoutHorizontal(isRtl, left, right);
    }

    private void layoutHorizontal(boolean isRtl, int left, int right) {
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int width = right - left;
        int childTop = this.getPaddingTop();
        int size = this.flexLines.size();
        for (int i = 0; i < size; ++i) {
            FlexLine flexLine = this.flexLines.get(i);
            if (this.hasDividerBeforeFlexLine(i)) {
                childTop += this.dividerHorizontalHeight;
            }
            float spaceBetweenItem = 0.0f;
            float childLeft = paddingLeft;
            float childRight = width - paddingRight;
            spaceBetweenItem = Math.max(spaceBetweenItem, 0.0f);
            for (int j = 0; j < flexLine.itemCount; ++j) {
                int index = flexLine.firstIndex + j;
                View child = this.getReorderedChildAt(index);
                if (child == null || child.getVisibility() == 8) continue;
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                childLeft += (float)lp.leftMargin;
                childRight -= (float)lp.rightMargin;
                int beforeDividerLength = 0;
                int endDividerLength = 0;
                if (this.hasDividerBeforeChildAtAlongMainAxis(index, j)) {
                    beforeDividerLength = this.dividerVerticalWidth;
                    childLeft += (float)beforeDividerLength;
                    childRight -= (float)beforeDividerLength;
                }
                if (j == flexLine.itemCount - 1 && (this.showDividerVertical & 4) > 0) {
                    endDividerLength = this.dividerVerticalWidth;
                }
                if (isRtl) {
                    this.flexboxHelper.layoutSingleChildHorizontal(child, Math.round(childRight) - child.getMeasuredWidth(), childTop, Math.round(childRight), childTop + child.getMeasuredHeight());
                } else {
                    this.flexboxHelper.layoutSingleChildHorizontal(child, Math.round(childLeft), childTop, Math.round(childLeft) + child.getMeasuredWidth(), childTop + child.getMeasuredHeight());
                }
                childLeft += (float)child.getMeasuredWidth() + spaceBetweenItem + (float)lp.rightMargin;
                childRight -= (float)child.getMeasuredWidth() + spaceBetweenItem + (float)lp.leftMargin;
                if (isRtl) {
                    flexLine.updatePositionFromView(child, endDividerLength, 0, beforeDividerLength, 0);
                    continue;
                }
                flexLine.updatePositionFromView(child, beforeDividerLength, 0, endDividerLength, 0);
            }
            childTop += flexLine.crossSize;
        }
    }

    protected void onDraw(Canvas canvas) {
        if (this.dividerDrawableVertical == null && this.dividerDrawableHorizontal == null) {
            return;
        }
        if (this.showDividerHorizontal == 0 && this.showDividerVertical == 0) {
            return;
        }
        int layoutDirection = ViewCompat.getLayoutDirection((View)this);
        boolean isRtl = layoutDirection == 1;
        this.drawDividersHorizontal(canvas, isRtl);
    }

    private void drawDividersHorizontal(Canvas canvas, boolean isRtl) {
        int paddingLeft = this.getPaddingLeft();
        int paddingRight = this.getPaddingRight();
        int horizontalDividerLength = Math.max(0, this.getWidth() - paddingRight - paddingLeft);
        int size = this.flexLines.size();
        for (int i = 0; i < size; ++i) {
            int horizontalDividerTop;
            FlexLine flexLine = this.flexLines.get(i);
            for (int j = 0; j < flexLine.itemCount; ++j) {
                int dividerLeft;
                int viewIndex = flexLine.firstIndex + j;
                View view = this.getReorderedChildAt(viewIndex);
                if (view == null || view.getVisibility() == 8) continue;
                LayoutParams lp = (LayoutParams)view.getLayoutParams();
                if (this.hasDividerBeforeChildAtAlongMainAxis(viewIndex, j)) {
                    dividerLeft = isRtl ? view.getRight() + lp.rightMargin : view.getLeft() - lp.leftMargin - this.dividerVerticalWidth;
                    this.drawVerticalDivider(canvas, dividerLeft, flexLine.top, flexLine.crossSize);
                }
                if (j != flexLine.itemCount - 1 || (this.showDividerVertical & 4) <= 0) continue;
                dividerLeft = isRtl ? view.getLeft() - lp.leftMargin - this.dividerVerticalWidth : view.getRight() + lp.rightMargin;
                this.drawVerticalDivider(canvas, dividerLeft, flexLine.top, flexLine.crossSize);
            }
            if (this.hasDividerBeforeFlexLine(i)) {
                horizontalDividerTop = flexLine.top - this.dividerHorizontalHeight;
                this.drawHorizontalDivider(canvas, paddingLeft, horizontalDividerTop, horizontalDividerLength);
            }
            if (!this.hasEndDividerAfterFlexLine(i) || (this.showDividerHorizontal & 4) <= 0) continue;
            horizontalDividerTop = flexLine.bottom;
            this.drawHorizontalDivider(canvas, paddingLeft, horizontalDividerTop, horizontalDividerLength);
        }
    }

    private void drawVerticalDivider(Canvas canvas, int left, int top, int length) {
        if (this.dividerDrawableVertical == null) {
            return;
        }
        this.dividerDrawableVertical.setBounds(left, top, left + this.dividerVerticalWidth, top + length);
        this.dividerDrawableVertical.draw(canvas);
    }

    private void drawHorizontalDivider(Canvas canvas, int left, int top, int length) {
        if (this.dividerDrawableHorizontal == null) {
            return;
        }
        this.dividerDrawableHorizontal.setBounds(left, top, left + length, top + this.dividerHorizontalHeight);
        this.dividerDrawableHorizontal.draw(canvas);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
        if (lp instanceof LayoutParams) {
            return new LayoutParams((LayoutParams)lp);
        }
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)lp);
        }
        return new LayoutParams(lp);
    }

    @Override
    public int getFlexWrap() {
        return this.flexWrap;
    }

    @Override
    public void setFlexWrap(int flexWrap) {
        if (this.flexWrap != flexWrap) {
            this.flexWrap = flexWrap;
            this.requestLayout();
        }
    }

    @Override
    public List<FlexLine> getFlexLines() {
        ArrayList<FlexLine> result = new ArrayList<FlexLine>(this.flexLines.size());
        for (FlexLine flexLine : this.flexLines) {
            if (flexLine.getItemCountNotGone() == 0) continue;
            result.add(flexLine);
        }
        return result;
    }

    @Override
    public int getDecorationLengthMainAxis(View view, int index, int indexInFlexLine) {
        int decorationLength = 0;
        if (this.isMainAxisDirectionHorizontal()) {
            if (this.hasDividerBeforeChildAtAlongMainAxis(index, indexInFlexLine)) {
                decorationLength += this.dividerVerticalWidth;
            }
            if ((this.showDividerVertical & 4) > 0) {
                decorationLength += this.dividerVerticalWidth;
            }
        } else {
            if (this.hasDividerBeforeChildAtAlongMainAxis(index, indexInFlexLine)) {
                decorationLength += this.dividerHorizontalHeight;
            }
            if ((this.showDividerHorizontal & 4) > 0) {
                decorationLength += this.dividerHorizontalHeight;
            }
        }
        return decorationLength;
    }

    @Override
    public int getDecorationLengthCrossAxis(View view) {
        return 0;
    }

    @Override
    public void onNewFlexLineAdded(FlexLine flexLine) {
        if (this.isMainAxisDirectionHorizontal()) {
            if ((this.showDividerVertical & 4) > 0) {
                flexLine.mainSize += this.dividerVerticalWidth;
                flexLine.dividerLengthInMainSize += this.dividerVerticalWidth;
            }
        } else if ((this.showDividerHorizontal & 4) > 0) {
            flexLine.mainSize += this.dividerHorizontalHeight;
            flexLine.dividerLengthInMainSize += this.dividerHorizontalHeight;
        }
    }

    @Override
    public int getChildWidthMeasureSpec(int widthSpec, int padding, int childDimension) {
        return FlexboxLayout.getChildMeasureSpec((int)widthSpec, (int)padding, (int)childDimension);
    }

    @Override
    public int getChildHeightMeasureSpec(int heightSpec, int padding, int childDimension) {
        return FlexboxLayout.getChildMeasureSpec((int)heightSpec, (int)padding, (int)childDimension);
    }

    @Override
    public void onNewFlexItemAdded(View view, int index, int indexInFlexLine, FlexLine flexLine) {
        if (this.hasDividerBeforeChildAtAlongMainAxis(index, indexInFlexLine)) {
            if (this.isMainAxisDirectionHorizontal()) {
                flexLine.mainSize += this.dividerVerticalWidth;
                flexLine.dividerLengthInMainSize += this.dividerVerticalWidth;
            } else {
                flexLine.mainSize += this.dividerHorizontalHeight;
                flexLine.dividerLengthInMainSize += this.dividerHorizontalHeight;
            }
        }
    }

    @Override
    public void setFlexLines(List<FlexLine> flexLines) {
        this.flexLines = flexLines;
    }

    @Override
    public List<FlexLine> getFlexLinesInternal() {
        return this.flexLines;
    }

    @Override
    public void updateViewCache(int position, View view) {
    }

    @Nullable
    public Drawable getDividerDrawableHorizontal() {
        return this.dividerDrawableHorizontal;
    }

    @Nullable
    public Drawable getDividerDrawableVertical() {
        return this.dividerDrawableVertical;
    }

    public void setDividerDrawable(Drawable divider) {
        this.setDividerDrawableHorizontal(divider);
        this.setDividerDrawableVertical(divider);
    }

    public void setDividerDrawableHorizontal(@Nullable Drawable divider) {
        if (divider == this.dividerDrawableHorizontal) {
            return;
        }
        this.dividerDrawableHorizontal = divider;
        this.dividerHorizontalHeight = divider != null ? divider.getIntrinsicHeight() : 0;
        this.setWillNotDrawFlag();
        this.requestLayout();
    }

    public void setDividerDrawableVertical(@Nullable Drawable divider) {
        if (divider == this.dividerDrawableVertical) {
            return;
        }
        this.dividerDrawableVertical = divider;
        this.dividerVerticalWidth = divider != null ? divider.getIntrinsicWidth() : 0;
        this.setWillNotDrawFlag();
        this.requestLayout();
    }

    public void setShowDivider(int dividerMode) {
        this.setShowDividerVertical(dividerMode);
        this.setShowDividerHorizontal(dividerMode);
    }

    public void setShowDividerVertical(int dividerMode) {
        if (dividerMode != this.showDividerVertical) {
            this.showDividerVertical = dividerMode;
            this.requestLayout();
        }
    }

    public void setShowDividerHorizontal(int dividerMode) {
        if (dividerMode != this.showDividerHorizontal) {
            this.showDividerHorizontal = dividerMode;
            this.requestLayout();
        }
    }

    private void setWillNotDrawFlag() {
        if (this.dividerDrawableHorizontal == null && this.dividerDrawableVertical == null) {
            this.setWillNotDraw(true);
        } else {
            this.setWillNotDraw(false);
        }
    }

    private boolean hasDividerBeforeChildAtAlongMainAxis(int index, int indexInFlexLine) {
        if (this.allViewsAreGoneBefore(index, indexInFlexLine)) {
            if (this.isMainAxisDirectionHorizontal()) {
                return (this.showDividerVertical & 1) != 0;
            }
            return (this.showDividerHorizontal & 1) != 0;
        }
        if (this.isMainAxisDirectionHorizontal()) {
            return (this.showDividerVertical & 2) != 0;
        }
        return (this.showDividerHorizontal & 2) != 0;
    }

    private boolean allViewsAreGoneBefore(int index, int indexInFlexLine) {
        for (int i = 1; i <= indexInFlexLine; ++i) {
            View view = this.getReorderedChildAt(index - i);
            if (view == null || view.getVisibility() == 8) continue;
            return false;
        }
        return true;
    }

    private boolean hasDividerBeforeFlexLine(int flexLineIndex) {
        if (flexLineIndex < 0 || flexLineIndex >= this.flexLines.size()) {
            return false;
        }
        if (this.allFlexLinesAreDummyBefore(flexLineIndex)) {
            if (this.isMainAxisDirectionHorizontal()) {
                return (this.showDividerHorizontal & 1) != 0;
            }
            return (this.showDividerVertical & 1) != 0;
        }
        if (this.isMainAxisDirectionHorizontal()) {
            return (this.showDividerHorizontal & 2) != 0;
        }
        return (this.showDividerVertical & 2) != 0;
    }

    private boolean allFlexLinesAreDummyBefore(int flexLineIndex) {
        for (int i = 0; i < flexLineIndex; ++i) {
            if (this.flexLines.get(i).getItemCountNotGone() <= 0) continue;
            return false;
        }
        return true;
    }

    private boolean hasEndDividerAfterFlexLine(int flexLineIndex) {
        if (flexLineIndex < 0 || flexLineIndex >= this.flexLines.size()) {
            return false;
        }
        for (int i = flexLineIndex + 1; i < this.flexLines.size(); ++i) {
            if (this.flexLines.get(i).getItemCountNotGone() <= 0) continue;
            return false;
        }
        if (this.isMainAxisDirectionHorizontal()) {
            return (this.showDividerHorizontal & 4) != 0;
        }
        return (this.showDividerVertical & 4) != 0;
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams
    implements FlexItem {
        private int order = 1;
        private float flexGrow = 0.0f;
        private float flexShrink = 1.0f;
        private float flexBasisPercent = -1.0f;
        private int minWidth;
        private int minHeight;
        private int maxWidth = 0xFFFFFF;
        private int maxHeight = 0xFFFFFF;
        private boolean wrapBefore;
        public static final Parcelable.Creator<LayoutParams> CREATOR = new Parcelable.Creator<LayoutParams>(){

            public LayoutParams createFromParcel(Parcel source) {
                return new LayoutParams(source);
            }

            public LayoutParams[] newArray(int size) {
                return new LayoutParams[size];
            }
        };

        public LayoutParams(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FlexboxLayout_Layout);
            this.order = a.getInt(R.styleable.FlexboxLayout_Layout_layout_order, 1);
            this.flexGrow = a.getFloat(R.styleable.FlexboxLayout_Layout_layout_flexGrow, 0.0f);
            this.flexShrink = a.getFloat(R.styleable.FlexboxLayout_Layout_layout_flexShrink, 1.0f);
            this.flexBasisPercent = a.getFraction(R.styleable.FlexboxLayout_Layout_layout_flexBasisPercent, 1, 1, -1.0f);
            this.minWidth = a.getDimensionPixelSize(R.styleable.FlexboxLayout_Layout_layout_minWidth, 0);
            this.minHeight = a.getDimensionPixelSize(R.styleable.FlexboxLayout_Layout_layout_minHeight, 0);
            this.maxWidth = a.getDimensionPixelSize(R.styleable.FlexboxLayout_Layout_layout_maxWidth, 0xFFFFFF);
            this.maxHeight = a.getDimensionPixelSize(R.styleable.FlexboxLayout_Layout_layout_maxHeight, 0xFFFFFF);
            this.wrapBefore = a.getBoolean(R.styleable.FlexboxLayout_Layout_layout_wrapBefore, false);
            a.recycle();
        }

        public LayoutParams(LayoutParams source) {
            super((ViewGroup.MarginLayoutParams)source);
            this.order = source.order;
            this.flexGrow = source.flexGrow;
            this.flexShrink = source.flexShrink;
            this.flexBasisPercent = source.flexBasisPercent;
            this.minWidth = source.minWidth;
            this.minHeight = source.minHeight;
            this.maxWidth = source.maxWidth;
            this.maxHeight = source.maxHeight;
            this.wrapBefore = source.wrapBefore;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(int width, int height) {
            super(new ViewGroup.LayoutParams(width, height));
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        protected LayoutParams(Parcel in) {
            super(0, 0);
            this.order = in.readInt();
            this.flexGrow = in.readFloat();
            this.flexShrink = in.readFloat();
            this.flexBasisPercent = in.readFloat();
            this.minWidth = in.readInt();
            this.minHeight = in.readInt();
            this.maxWidth = in.readInt();
            this.maxHeight = in.readInt();
            this.wrapBefore = in.readByte() != 0;
            this.bottomMargin = in.readInt();
            this.leftMargin = in.readInt();
            this.rightMargin = in.readInt();
            this.topMargin = in.readInt();
            this.height = in.readInt();
            this.width = in.readInt();
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public void setWidth(int width) {
            this.width = width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public void setHeight(int height) {
            this.height = height;
        }

        @Override
        public int getOrder() {
            return this.order;
        }

        @Override
        public void setOrder(int order) {
            this.order = order;
        }

        @Override
        public float getFlexGrow() {
            return this.flexGrow;
        }

        @Override
        public void setFlexGrow(float flexGrow) {
            this.flexGrow = flexGrow;
        }

        @Override
        public float getFlexShrink() {
            return this.flexShrink;
        }

        @Override
        public void setFlexShrink(float flexShrink) {
            this.flexShrink = flexShrink;
        }

        @Override
        public int getMinWidth() {
            return this.minWidth;
        }

        @Override
        public void setMinWidth(int minWidth) {
            this.minWidth = minWidth;
        }

        @Override
        public int getMinHeight() {
            return this.minHeight;
        }

        @Override
        public void setMinHeight(int minHeight) {
            this.minHeight = minHeight;
        }

        @Override
        public int getMaxWidth() {
            return this.maxWidth;
        }

        @Override
        public void setMaxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
        }

        @Override
        public int getMaxHeight() {
            return this.maxHeight;
        }

        @Override
        public void setMaxHeight(int maxHeight) {
            this.maxHeight = maxHeight;
        }

        @Override
        public boolean isWrapBefore() {
            return this.wrapBefore;
        }

        @Override
        public void setWrapBefore(boolean wrapBefore) {
            this.wrapBefore = wrapBefore;
        }

        @Override
        public float getFlexBasisPercent() {
            return this.flexBasisPercent;
        }

        @Override
        public void setFlexBasisPercent(float flexBasisPercent) {
            this.flexBasisPercent = flexBasisPercent;
        }

        @Override
        public int getMarginLeft() {
            return this.leftMargin;
        }

        @Override
        public int getMarginTop() {
            return this.topMargin;
        }

        @Override
        public int getMarginRight() {
            return this.rightMargin;
        }

        @Override
        public int getMarginBottom() {
            return this.bottomMargin;
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.order);
            dest.writeFloat(this.flexGrow);
            dest.writeFloat(this.flexShrink);
            dest.writeFloat(this.flexBasisPercent);
            dest.writeInt(this.minWidth);
            dest.writeInt(this.minHeight);
            dest.writeInt(this.maxWidth);
            dest.writeInt(this.maxHeight);
            dest.writeByte(this.wrapBefore ? (byte)1 : 0);
            dest.writeInt(this.bottomMargin);
            dest.writeInt(this.leftMargin);
            dest.writeInt(this.rightMargin);
            dest.writeInt(this.topMargin);
            dest.writeInt(this.height);
            dest.writeInt(this.width);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DividerMode {
    }
}

