/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.support.v4.graphics.ColorUtils;

class CircularBorderDrawable
extends Drawable {
    private static final float DRAW_STROKE_WIDTH_MULTIPLE = 1.3333f;
    final Paint paint;
    final Rect rect = new Rect();
    final RectF rectF = new RectF();
    float borderWidth;
    private int topOuterStrokeColor;
    private int topInnerStrokeColor;
    private int bottomOuterStrokeColor;
    private int bottomInnerStrokeColor;
    private ColorStateList borderTint;
    private int currentBorderTintColor;
    private boolean invalidateShader = true;
    private float rotation;

    public CircularBorderDrawable() {
        this.paint = new Paint(1);
        this.paint.setStyle(Paint.Style.STROKE);
    }

    void setGradientColors(int topOuterStrokeColor, int topInnerStrokeColor, int bottomOuterStrokeColor, int bottomInnerStrokeColor) {
        this.topOuterStrokeColor = topOuterStrokeColor;
        this.topInnerStrokeColor = topInnerStrokeColor;
        this.bottomOuterStrokeColor = bottomOuterStrokeColor;
        this.bottomInnerStrokeColor = bottomInnerStrokeColor;
    }

    void setBorderWidth(float width) {
        if (this.borderWidth != width) {
            this.borderWidth = width;
            this.paint.setStrokeWidth(width * 1.3333f);
            this.invalidateShader = true;
            this.invalidateSelf();
        }
    }

    public void draw(Canvas canvas) {
        if (this.invalidateShader) {
            this.paint.setShader(this.createGradientShader());
            this.invalidateShader = false;
        }
        float halfBorderWidth = this.paint.getStrokeWidth() / 2.0f;
        RectF rectF = this.rectF;
        this.copyBounds(this.rect);
        rectF.set(this.rect);
        rectF.left += halfBorderWidth;
        rectF.top += halfBorderWidth;
        rectF.right -= halfBorderWidth;
        rectF.bottom -= halfBorderWidth;
        canvas.save();
        canvas.rotate(this.rotation, rectF.centerX(), rectF.centerY());
        canvas.drawOval(rectF, this.paint);
        canvas.restore();
    }

    public boolean getPadding(Rect padding) {
        int borderWidth = Math.round(this.borderWidth);
        padding.set(borderWidth, borderWidth, borderWidth, borderWidth);
        return true;
    }

    public void setAlpha(int alpha) {
        this.paint.setAlpha(alpha);
        this.invalidateSelf();
    }

    void setBorderTint(ColorStateList tint) {
        if (tint != null) {
            this.currentBorderTintColor = tint.getColorForState(this.getState(), this.currentBorderTintColor);
        }
        this.borderTint = tint;
        this.invalidateShader = true;
        this.invalidateSelf();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    public int getOpacity() {
        return this.borderWidth > 0.0f ? -3 : -2;
    }

    final void setRotation(float rotation) {
        if (rotation != this.rotation) {
            this.rotation = rotation;
            this.invalidateSelf();
        }
    }

    protected void onBoundsChange(Rect bounds) {
        this.invalidateShader = true;
    }

    public boolean isStateful() {
        return this.borderTint != null && this.borderTint.isStateful() || super.isStateful();
    }

    protected boolean onStateChange(int[] state) {
        int newColor;
        if (this.borderTint != null && (newColor = this.borderTint.getColorForState(state, this.currentBorderTintColor)) != this.currentBorderTintColor) {
            this.invalidateShader = true;
            this.currentBorderTintColor = newColor;
        }
        if (this.invalidateShader) {
            this.invalidateSelf();
        }
        return this.invalidateShader;
    }

    private Shader createGradientShader() {
        Rect rect = this.rect;
        this.copyBounds(rect);
        float borderRatio = this.borderWidth / (float)rect.height();
        int[] colors = new int[]{ColorUtils.compositeColors((int)this.topOuterStrokeColor, (int)this.currentBorderTintColor), ColorUtils.compositeColors((int)this.topInnerStrokeColor, (int)this.currentBorderTintColor), ColorUtils.compositeColors((int)ColorUtils.setAlphaComponent((int)this.topInnerStrokeColor, (int)0), (int)this.currentBorderTintColor), ColorUtils.compositeColors((int)ColorUtils.setAlphaComponent((int)this.bottomInnerStrokeColor, (int)0), (int)this.currentBorderTintColor), ColorUtils.compositeColors((int)this.bottomInnerStrokeColor, (int)this.currentBorderTintColor), ColorUtils.compositeColors((int)this.bottomOuterStrokeColor, (int)this.currentBorderTintColor)};
        float[] positions = new float[]{0.0f, borderRatio, 0.5f, 0.5f, 1.0f - borderRatio, 1.0f};
        return new LinearGradient(0.0f, (float)rect.top, 0.0f, (float)rect.bottom, colors, positions, Shader.TileMode.CLAMP);
    }
}

