/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;

class DescendantOffsetUtils {
    private static final ThreadLocal<Matrix> matrix = new ThreadLocal();
    private static final ThreadLocal<RectF> rectF = new ThreadLocal();

    DescendantOffsetUtils() {
    }

    static void offsetDescendantRect(ViewGroup parent, View descendant, Rect rect) {
        Matrix m = matrix.get();
        if (m == null) {
            m = new Matrix();
            matrix.set(m);
        } else {
            m.reset();
        }
        DescendantOffsetUtils.offsetDescendantMatrix((ViewParent)parent, descendant, m);
        RectF rectF = DescendantOffsetUtils.rectF.get();
        if (rectF == null) {
            rectF = new RectF();
            DescendantOffsetUtils.rectF.set(rectF);
        }
        rectF.set(rect);
        m.mapRect(rectF);
        rect.set((int)(rectF.left + 0.5f), (int)(rectF.top + 0.5f), (int)(rectF.right + 0.5f), (int)(rectF.bottom + 0.5f));
    }

    static void getDescendantRect(ViewGroup parent, View descendant, Rect out) {
        out.set(0, 0, descendant.getWidth(), descendant.getHeight());
        DescendantOffsetUtils.offsetDescendantRect(parent, descendant, out);
    }

    private static void offsetDescendantMatrix(ViewParent target, View view, Matrix m) {
        ViewParent parent = view.getParent();
        if (parent instanceof View && parent != target) {
            View vp = (View)parent;
            DescendantOffsetUtils.offsetDescendantMatrix(target, vp, m);
            m.preTranslate((float)(-vp.getScrollX()), (float)(-vp.getScrollY()));
        }
        m.preTranslate((float)view.getLeft(), (float)view.getTop());
        if (!view.getMatrix().isIdentity()) {
            m.preConcat(view.getMatrix());
        }
    }
}

