/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.content.Context;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.MathUtils;
import android.support.design.widget.ViewOffsetBehavior;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.OverScroller;

abstract class HeaderBehavior<V extends View>
extends ViewOffsetBehavior<V> {
    private static final int INVALID_POINTER = -1;
    private Runnable flingRunnable;
    OverScroller scroller;
    private boolean isBeingDragged;
    private int activePointerId = -1;
    private int lastMotionY;
    private int touchSlop = -1;
    private VelocityTracker velocityTracker;

    public HeaderBehavior() {
    }

    public HeaderBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public boolean onInterceptTouchEvent(CoordinatorLayout parent, V child, MotionEvent ev) {
        int action;
        if (this.touchSlop < 0) {
            this.touchSlop = ViewConfiguration.get((Context)parent.getContext()).getScaledTouchSlop();
        }
        if ((action = ev.getAction()) == 2 && this.isBeingDragged) {
            return true;
        }
        switch (ev.getActionMasked()) {
            case 0: {
                this.isBeingDragged = false;
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                if (!this.canDragView(child) || !parent.isPointInChildBounds(child, x, y)) break;
                this.lastMotionY = y;
                this.activePointerId = ev.getPointerId(0);
                this.ensureVelocityTracker();
                break;
            }
            case 2: {
                int y;
                int yDiff;
                int pointerIndex;
                int activePointerId = this.activePointerId;
                if (activePointerId == -1 || (pointerIndex = ev.findPointerIndex(activePointerId)) == -1 || (yDiff = Math.abs((y = (int)ev.getY(pointerIndex)) - this.lastMotionY)) <= this.touchSlop) break;
                this.isBeingDragged = true;
                this.lastMotionY = y;
                break;
            }
            case 1: 
            case 3: {
                this.isBeingDragged = false;
                this.activePointerId = -1;
                if (this.velocityTracker == null) break;
                this.velocityTracker.recycle();
                this.velocityTracker = null;
            }
        }
        if (this.velocityTracker != null) {
            this.velocityTracker.addMovement(ev);
        }
        return this.isBeingDragged;
    }

    public boolean onTouchEvent(CoordinatorLayout parent, V child, MotionEvent ev) {
        if (this.touchSlop < 0) {
            this.touchSlop = ViewConfiguration.get((Context)parent.getContext()).getScaledTouchSlop();
        }
        switch (ev.getActionMasked()) {
            case 0: {
                int x = (int)ev.getX();
                int y = (int)ev.getY();
                if (parent.isPointInChildBounds(child, x, y) && this.canDragView(child)) {
                    this.lastMotionY = y;
                    this.activePointerId = ev.getPointerId(0);
                    this.ensureVelocityTracker();
                    break;
                }
                return false;
            }
            case 2: {
                int activePointerIndex = ev.findPointerIndex(this.activePointerId);
                if (activePointerIndex == -1) {
                    return false;
                }
                int y = (int)ev.getY(activePointerIndex);
                int dy = this.lastMotionY - y;
                if (!this.isBeingDragged && Math.abs(dy) > this.touchSlop) {
                    this.isBeingDragged = true;
                    dy = dy > 0 ? (dy -= this.touchSlop) : (dy += this.touchSlop);
                }
                if (!this.isBeingDragged) break;
                this.lastMotionY = y;
                this.scroll(parent, child, dy, this.getMaxDragOffset(child), 0);
                break;
            }
            case 1: {
                if (this.velocityTracker != null) {
                    this.velocityTracker.addMovement(ev);
                    this.velocityTracker.computeCurrentVelocity(1000);
                    float yvel = this.velocityTracker.getYVelocity(this.activePointerId);
                    this.fling(parent, child, -this.getScrollRangeForDragFling(child), 0, yvel);
                }
            }
            case 3: {
                this.isBeingDragged = false;
                this.activePointerId = -1;
                if (this.velocityTracker == null) break;
                this.velocityTracker.recycle();
                this.velocityTracker = null;
            }
        }
        if (this.velocityTracker != null) {
            this.velocityTracker.addMovement(ev);
        }
        return true;
    }

    int setHeaderTopBottomOffset(CoordinatorLayout parent, V header, int newOffset) {
        return this.setHeaderTopBottomOffset(parent, header, newOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    int setHeaderTopBottomOffset(CoordinatorLayout parent, V header, int newOffset, int minOffset, int maxOffset) {
        int curOffset = this.getTopAndBottomOffset();
        int consumed = 0;
        if (minOffset != 0 && curOffset >= minOffset && curOffset <= maxOffset && curOffset != (newOffset = MathUtils.constrain(newOffset, minOffset, maxOffset))) {
            this.setTopAndBottomOffset(newOffset);
            consumed = curOffset - newOffset;
        }
        return consumed;
    }

    int getTopBottomOffsetForScrollingSibling() {
        return this.getTopAndBottomOffset();
    }

    final int scroll(CoordinatorLayout coordinatorLayout, V header, int dy, int minOffset, int maxOffset) {
        return this.setHeaderTopBottomOffset(coordinatorLayout, header, this.getTopBottomOffsetForScrollingSibling() - dy, minOffset, maxOffset);
    }

    final boolean fling(CoordinatorLayout coordinatorLayout, V layout2, int minOffset, int maxOffset, float velocityY) {
        if (this.flingRunnable != null) {
            layout2.removeCallbacks(this.flingRunnable);
            this.flingRunnable = null;
        }
        if (this.scroller == null) {
            this.scroller = new OverScroller(layout2.getContext());
        }
        this.scroller.fling(0, this.getTopAndBottomOffset(), 0, Math.round(velocityY), 0, 0, minOffset, maxOffset);
        if (this.scroller.computeScrollOffset()) {
            this.flingRunnable = new FlingRunnable(this, coordinatorLayout, layout2);
            ViewCompat.postOnAnimation(layout2, (Runnable)this.flingRunnable);
            return true;
        }
        this.onFlingFinished(coordinatorLayout, layout2);
        return false;
    }

    void onFlingFinished(CoordinatorLayout parent, V layout2) {
    }

    boolean canDragView(V view) {
        return false;
    }

    int getMaxDragOffset(V view) {
        return -view.getHeight();
    }

    int getScrollRangeForDragFling(V view) {
        return view.getHeight();
    }

    private void ensureVelocityTracker() {
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
    }

    private static class FlingRunnable
    implements Runnable {
        private final CoordinatorLayout parent;
        private final V layout;
        final /* synthetic */ HeaderBehavior this$0;

        FlingRunnable(CoordinatorLayout parent, V layout2) {
            this.this$0 = var1_1;
            this.parent = parent;
            this.layout = layout2;
        }

        @Override
        public void run() {
            if (this.layout != null && this.this$0.scroller != null) {
                if (this.this$0.scroller.computeScrollOffset()) {
                    this.this$0.setHeaderTopBottomOffset(this.parent, this.layout, this.this$0.scroller.getCurrY());
                    ViewCompat.postOnAnimation(this.layout, (Runnable)this);
                } else {
                    this.this$0.onFlingFinished(this.parent, this.layout);
                }
            }
        }
    }
}

