/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.StringRes;
import android.support.design.internal.SnackbarContentLayout;
import android.support.design.snackbar.ContentViewCallback;
import android.support.design.widget.BaseTransientBottomBar;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.R;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.TextView;

public final class Snackbar
extends BaseTransientBottomBar<Snackbar> {
    public static final int LENGTH_INDEFINITE = -2;
    public static final int LENGTH_SHORT = -1;
    public static final int LENGTH_LONG = 0;
    @Nullable
    private BaseTransientBottomBar.BaseCallback<Snackbar> callback;

    private Snackbar(ViewGroup parent, View content, ContentViewCallback contentViewCallback) {
        super(parent, content, contentViewCallback);
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public void dismiss() {
        super.dismiss();
    }

    @Override
    public boolean isShown() {
        return super.isShown();
    }

    @NonNull
    public static Snackbar make(@NonNull View view, @NonNull CharSequence text, int duration) {
        ViewGroup parent = Snackbar.findSuitableParent(view);
        if (parent == null) {
            throw new IllegalArgumentException("No suitable parent found from the given view. Please provide a valid view.");
        }
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        SnackbarContentLayout content = (SnackbarContentLayout)inflater.inflate(R.layout.design_layout_snackbar_include, parent, false);
        Snackbar snackbar = new Snackbar(parent, (View)content, (ContentViewCallback)content);
        snackbar.setText(text);
        snackbar.setDuration(duration);
        return snackbar;
    }

    @NonNull
    public static Snackbar make(@NonNull View view, @StringRes int resId, int duration) {
        return Snackbar.make(view, view.getResources().getText(resId), duration);
    }

    private static ViewGroup findSuitableParent(View view) {
        ViewGroup fallback = null;
        do {
            if (view instanceof CoordinatorLayout) {
                return (ViewGroup)view;
            }
            if (view instanceof FrameLayout) {
                if (view.getId() == 0x1020002) {
                    return (ViewGroup)view;
                }
                fallback = (ViewGroup)view;
            }
            if (view == null) continue;
            ViewParent parent = view.getParent();
            View view2 = view = parent instanceof View ? (View)parent : null;
        } while (view != null);
        return fallback;
    }

    @NonNull
    public Snackbar setText(@NonNull CharSequence message) {
        SnackbarContentLayout contentLayout = (SnackbarContentLayout)this.view.getChildAt(0);
        TextView tv = contentLayout.getMessageView();
        tv.setText(message);
        return this;
    }

    @NonNull
    public Snackbar setText(@StringRes int resId) {
        return this.setText(this.getContext().getText(resId));
    }

    @NonNull
    public Snackbar setAction(@StringRes int resId, View.OnClickListener listener) {
        return this.setAction(this.getContext().getText(resId), listener);
    }

    @NonNull
    public Snackbar setAction(CharSequence text, final View.OnClickListener listener) {
        SnackbarContentLayout contentLayout = (SnackbarContentLayout)this.view.getChildAt(0);
        Button tv = contentLayout.getActionView();
        if (TextUtils.isEmpty((CharSequence)text) || listener == null) {
            tv.setVisibility(8);
            tv.setOnClickListener(null);
        } else {
            tv.setVisibility(0);
            tv.setText(text);
            tv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    listener.onClick(view);
                    Snackbar.this.dispatchDismiss(1);
                }
            });
        }
        return this;
    }

    @NonNull
    public Snackbar setActionTextColor(ColorStateList colors) {
        SnackbarContentLayout contentLayout = (SnackbarContentLayout)this.view.getChildAt(0);
        Button tv = contentLayout.getActionView();
        tv.setTextColor(colors);
        return this;
    }

    @NonNull
    public Snackbar setActionTextColor(@ColorInt int color2) {
        SnackbarContentLayout contentLayout = (SnackbarContentLayout)this.view.getChildAt(0);
        Button tv = contentLayout.getActionView();
        tv.setTextColor(color2);
        return this;
    }

    @Deprecated
    @NonNull
    public Snackbar setCallback(Callback callback) {
        if (this.callback != null) {
            this.removeCallback(this.callback);
        }
        if (callback != null) {
            this.addCallback(callback);
        }
        this.callback = callback;
        return this;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class SnackbarLayout
    extends BaseTransientBottomBar.SnackbarBaseLayout {
        public SnackbarLayout(Context context) {
            super(context);
        }

        public SnackbarLayout(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            int childCount = this.getChildCount();
            int availableWidth = this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                if (child.getLayoutParams().width != -1) continue;
                child.measure(View.MeasureSpec.makeMeasureSpec((int)availableWidth, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)child.getMeasuredHeight(), (int)0x40000000));
            }
        }
    }

    public static class Callback
    extends BaseTransientBottomBar.BaseCallback<Snackbar> {
        public static final int DISMISS_EVENT_SWIPE = 0;
        public static final int DISMISS_EVENT_ACTION = 1;
        public static final int DISMISS_EVENT_TIMEOUT = 2;
        public static final int DISMISS_EVENT_MANUAL = 3;
        public static final int DISMISS_EVENT_CONSECUTIVE = 4;

        @Override
        public void onShown(Snackbar sb) {
        }

        @Override
        public void onDismissed(Snackbar transientBottomBar, int event) {
        }
    }
}

