/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.support.annotation.VisibleForTesting;
import android.support.design.animation.AnimationUtils;
import android.support.design.internal.ThemeEnforcement;
import android.support.design.internal.ViewUtils;
import android.support.design.widget.CheckableImageButton;
import android.support.design.widget.CollapsingTextHelper;
import android.support.design.widget.CutoutDrawable;
import android.support.design.widget.DescendantOffsetUtils;
import android.support.design.widget.DrawableUtils;
import android.support.design.widget.IndicatorViewController;
import android.support.design.widget.R;
import android.support.design.widget.TextInputEditText;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.AbsSavedState;
import android.support.v4.view.AccessibilityDelegateCompat;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v4.widget.TextViewCompat;
import android.support.v7.content.res.AppCompatResources;
import android.support.v7.widget.AppCompatDrawableManager;
import android.support.v7.widget.AppCompatTextView;
import android.support.v7.widget.TintTypedArray;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.text.method.PasswordTransformationMethod;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewStructure;
import android.view.accessibility.AccessibilityEvent;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class TextInputLayout
extends LinearLayout {
    private static final int LABEL_SCALE_ANIMATION_DURATION = 167;
    private static final int INVALID_MAX_LENGTH = -1;
    private static final String LOG_TAG = "TextInputLayout";
    private final FrameLayout inputFrame;
    EditText editText;
    private CharSequence originalHint;
    private final IndicatorViewController indicatorViewController = new IndicatorViewController(this);
    boolean counterEnabled;
    private int counterMaxLength;
    private boolean counterOverflowed;
    private TextView counterView;
    private final int counterOverflowTextAppearance;
    private final int counterTextAppearance;
    private boolean hintEnabled;
    private CharSequence hint;
    private GradientDrawable boxBackground;
    private int boxPaddingLeftPx;
    private int boxExpandedPaddingTopPx;
    private int boxCollapsedPaddingTopPx;
    private int boxPaddingRightPx;
    private int boxExpandedPaddingBottomPx;
    private int boxCollapsedPaddingBottomPx;
    private final int boxBottomOffsetPx;
    private final int boxLabelCutoutPaddingPx;
    private int boxBackgroundMode;
    private float boxCornerRadiusTopLeft;
    private float boxCornerRadiusTopRight;
    private float boxCornerRadiusBottomRight;
    private float boxCornerRadiusBottomLeft;
    private int boxStrokeWidthPx;
    private final int boxStrokeWidthDefaultPx;
    private final int boxStrokeWidthFocusedPx;
    @ColorInt
    private int boxStrokeColor;
    @ColorInt
    private int boxBackgroundColor;
    private Drawable editTextOriginalDrawable;
    public static final int BOX_BACKGROUND_NONE = 0;
    public static final int BOX_BACKGROUND_FILLED = 1;
    public static final int BOX_BACKGROUND_OUTLINE = 2;
    private final Rect tmpRect = new Rect();
    private final RectF tmpRectF = new RectF();
    private Typeface typeface;
    private boolean passwordToggleEnabled;
    private Drawable passwordToggleDrawable;
    private CharSequence passwordToggleContentDesc;
    private CheckableImageButton passwordToggleView;
    private boolean passwordToggledVisible;
    private Drawable passwordToggleDummyDrawable;
    private Drawable originalEditTextEndDrawable;
    private ColorStateList passwordToggleTintList;
    private boolean hasPasswordToggleTintList;
    private PorterDuff.Mode passwordToggleTintMode;
    private boolean hasPasswordToggleTintMode;
    private ColorStateList defaultTextColor;
    private ColorStateList focusedTextColor;
    @ColorInt
    private final int defaultStrokeColor;
    @ColorInt
    private final int hoveredStrokeColor;
    @ColorInt
    private int focusedStrokeColor;
    @ColorInt
    private int defaultBoxBackgroundColor;
    @ColorInt
    private final int disabledColor;
    private boolean hintExpanded;
    final CollapsingTextHelper collapsingTextHelper = new CollapsingTextHelper((View)this);
    private boolean hintAnimationEnabled;
    private ValueAnimator animator;
    private boolean hasReconstructedEditTextBackground;
    private boolean inDrawableStateChanged;
    private boolean restoringSavedState;

    public TextInputLayout(Context context) {
        this(context, null);
    }

    public TextInputLayout(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.textInputStyle);
    }

    public TextInputLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setOrientation(1);
        this.setWillNotDraw(false);
        this.setAddStatesFromChildren(true);
        this.inputFrame = new FrameLayout(context);
        this.inputFrame.setAddStatesFromChildren(true);
        this.addView((View)this.inputFrame);
        this.collapsingTextHelper.setTextSizeInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        this.collapsingTextHelper.setPositionInterpolator(AnimationUtils.LINEAR_INTERPOLATOR);
        this.collapsingTextHelper.setCollapsedTextGravity(0x800033);
        TintTypedArray a = ThemeEnforcement.obtainTintedStyledAttributes((Context)context, (AttributeSet)attrs, (int[])R.styleable.TextInputLayout, (int)defStyleAttr, (int)R.style.Widget_Design_TextInputLayout);
        this.hintEnabled = a.getBoolean(R.styleable.TextInputLayout_hintEnabled, true);
        this.setHint(a.getText(R.styleable.TextInputLayout_android_hint));
        this.hintAnimationEnabled = a.getBoolean(R.styleable.TextInputLayout_hintAnimationEnabled, true);
        this.boxPaddingLeftPx = a.getDimensionPixelOffset(R.styleable.TextInputLayout_boxPaddingLeft, 0);
        this.boxCollapsedPaddingTopPx = a.getDimensionPixelOffset(R.styleable.TextInputLayout_boxCollapsedPaddingTop, 0);
        this.boxCollapsedPaddingBottomPx = a.getDimensionPixelOffset(R.styleable.TextInputLayout_boxCollapsedPaddingBottom, 0);
        this.boxExpandedPaddingTopPx = a.getDimensionPixelOffset(R.styleable.TextInputLayout_boxExpandedPaddingTop, 0);
        this.boxPaddingRightPx = a.getDimensionPixelOffset(R.styleable.TextInputLayout_boxPaddingRight, 0);
        this.boxExpandedPaddingBottomPx = a.getDimensionPixelOffset(R.styleable.TextInputLayout_boxExpandedPaddingBottom, 0);
        this.boxBottomOffsetPx = context.getResources().getDimensionPixelOffset(R.dimen.mtrl_textinput_box_bottom_offset);
        this.boxLabelCutoutPaddingPx = context.getResources().getDimensionPixelOffset(R.dimen.mtrl_textinput_box_label_cutout_padding);
        this.boxCornerRadiusTopLeft = a.getDimension(R.styleable.TextInputLayout_boxCornerRadiusTopLeft, 0.0f);
        this.boxCornerRadiusTopRight = a.getDimension(R.styleable.TextInputLayout_boxCornerRadiusTopRight, 0.0f);
        this.boxCornerRadiusBottomRight = a.getDimension(R.styleable.TextInputLayout_boxCornerRadiusBottomRight, 0.0f);
        this.boxCornerRadiusBottomLeft = a.getDimension(R.styleable.TextInputLayout_boxCornerRadiusBottomLeft, 0.0f);
        this.boxBackgroundColor = this.defaultBoxBackgroundColor = a.getColor(R.styleable.TextInputLayout_boxBackgroundColor, 0);
        this.focusedStrokeColor = a.getColor(R.styleable.TextInputLayout_boxStrokeColor, 0);
        this.boxStrokeWidthDefaultPx = context.getResources().getDimensionPixelSize(R.dimen.mtrl_textinput_box_stroke_width_default);
        this.boxStrokeWidthFocusedPx = context.getResources().getDimensionPixelSize(R.dimen.mtrl_textinput_box_stroke_width_focused);
        this.boxStrokeWidthPx = this.boxStrokeWidthDefaultPx;
        int boxBackgroundMode = a.getInt(R.styleable.TextInputLayout_boxBackgroundMode, 0);
        this.setBoxBackgroundMode(boxBackgroundMode);
        if (a.hasValue(R.styleable.TextInputLayout_android_textColorHint)) {
            this.defaultTextColor = this.focusedTextColor = a.getColorStateList(R.styleable.TextInputLayout_android_textColorHint);
        }
        this.defaultStrokeColor = ContextCompat.getColor((Context)context, (int)R.color.mtrl_textinput_default_box_stroke_color);
        this.disabledColor = ContextCompat.getColor((Context)context, (int)R.color.mtrl_textinput_disabled_color);
        this.hoveredStrokeColor = ContextCompat.getColor((Context)context, (int)R.color.mtrl_textinput_hovered_box_stroke_color);
        int hintAppearance = a.getResourceId(R.styleable.TextInputLayout_hintTextAppearance, -1);
        if (hintAppearance != -1) {
            this.setHintTextAppearance(a.getResourceId(R.styleable.TextInputLayout_hintTextAppearance, 0));
        }
        int mErrorTextAppearance = a.getResourceId(R.styleable.TextInputLayout_errorTextAppearance, 0);
        boolean errorEnabled = a.getBoolean(R.styleable.TextInputLayout_errorEnabled, false);
        int mHelperTextTextAppearance = a.getResourceId(R.styleable.TextInputLayout_helperTextTextAppearance, 0);
        boolean helperTextEnabled = a.getBoolean(R.styleable.TextInputLayout_helperTextEnabled, false);
        CharSequence helperText = a.getText(R.styleable.TextInputLayout_helperText);
        boolean counterEnabled = a.getBoolean(R.styleable.TextInputLayout_counterEnabled, false);
        this.setCounterMaxLength(a.getInt(R.styleable.TextInputLayout_counterMaxLength, -1));
        this.counterTextAppearance = a.getResourceId(R.styleable.TextInputLayout_counterTextAppearance, 0);
        this.counterOverflowTextAppearance = a.getResourceId(R.styleable.TextInputLayout_counterOverflowTextAppearance, 0);
        this.passwordToggleEnabled = a.getBoolean(R.styleable.TextInputLayout_passwordToggleEnabled, false);
        this.passwordToggleDrawable = a.getDrawable(R.styleable.TextInputLayout_passwordToggleDrawable);
        this.passwordToggleContentDesc = a.getText(R.styleable.TextInputLayout_passwordToggleContentDescription);
        if (a.hasValue(R.styleable.TextInputLayout_passwordToggleTint)) {
            this.hasPasswordToggleTintList = true;
            this.passwordToggleTintList = a.getColorStateList(R.styleable.TextInputLayout_passwordToggleTint);
        }
        if (a.hasValue(R.styleable.TextInputLayout_passwordToggleTintMode)) {
            this.hasPasswordToggleTintMode = true;
            this.passwordToggleTintMode = ViewUtils.parseTintMode((int)a.getInt(R.styleable.TextInputLayout_passwordToggleTintMode, -1), null);
        }
        a.recycle();
        this.setHelperTextEnabled(helperTextEnabled);
        this.setHelperText(helperText);
        this.setHelperTextTextAppearance(mHelperTextTextAppearance);
        this.setErrorEnabled(errorEnabled);
        this.setErrorTextAppearance(mErrorTextAppearance);
        this.setCounterEnabled(counterEnabled);
        this.applyPasswordToggleTint();
        if (ViewCompat.getImportantForAccessibility((View)this) == 0) {
            ViewCompat.setImportantForAccessibility((View)this, (int)1);
        }
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)new TextInputAccessibilityDelegate());
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (child instanceof EditText) {
            FrameLayout.LayoutParams flp = new FrameLayout.LayoutParams(params);
            flp.gravity = 0x10 | flp.gravity & 0xFFFFFF8F;
            this.inputFrame.addView(child, (ViewGroup.LayoutParams)flp);
            this.inputFrame.setLayoutParams(params);
            this.updateInputLayoutMargins();
            this.setEditText((EditText)child);
        } else {
            super.addView(child, index, params);
        }
    }

    @NonNull
    private Drawable getBoxBackground() {
        if (this.boxBackgroundMode == 1 || this.boxBackgroundMode == 2) {
            return this.boxBackground;
        }
        throw new IllegalStateException();
    }

    public void setBoxBackgroundMode(int boxBackgroundMode) {
        if (boxBackgroundMode == this.boxBackgroundMode) {
            return;
        }
        this.boxBackgroundMode = boxBackgroundMode;
        this.onApplyBoxBackgroundMode();
    }

    private void onApplyBoxBackgroundMode() {
        this.assignBoxBackgroundByMode();
        if (this.boxBackgroundMode != 0) {
            this.updateInputLayoutMargins();
        }
        this.updateTextInputBoxBounds();
        this.applyEditTextBoxPadding();
    }

    private void assignBoxBackgroundByMode() {
        if (this.boxBackgroundMode == 0) {
            this.boxBackground = null;
        } else if (this.boxBackgroundMode == 2 && this.hintEnabled && !(this.boxBackground instanceof CutoutDrawable)) {
            this.boxBackground = new CutoutDrawable();
        } else if (!(this.boxBackground instanceof GradientDrawable)) {
            this.boxBackground = new GradientDrawable();
        }
    }

    private void applyEditTextBoxPadding() {
        if (this.boxBackgroundMode == 0) {
            return;
        }
        if (this.boxBackgroundMode != 0 && this.editText != null) {
            this.editText.setPadding(this.boxPaddingLeftPx, this.boxExpandedPaddingTopPx, this.boxPaddingRightPx, this.boxExpandedPaddingBottomPx);
        }
    }

    public void setBoxPadding(int boxPaddingLeft, int boxCollapsedPaddingTop, int boxExpandedPaddingTop, int boxPaddingRight, int boxCollapsedPaddingBottom, int boxExpandedPaddingBottom) {
        this.boxPaddingLeftPx = boxPaddingLeft;
        this.boxCollapsedPaddingTopPx = boxCollapsedPaddingTop;
        this.boxExpandedPaddingTopPx = boxExpandedPaddingTop;
        this.boxPaddingRightPx = boxPaddingRight;
        this.boxCollapsedPaddingBottomPx = boxCollapsedPaddingBottom;
        this.boxExpandedPaddingBottomPx = boxExpandedPaddingBottom;
        this.applyEditTextBoxPadding();
    }

    public int getBoxPaddingLeft() {
        return this.boxPaddingLeftPx;
    }

    public int getBoxCollapsedPaddingTop() {
        return this.boxCollapsedPaddingTopPx;
    }

    public int getBoxExpandedPaddingTop() {
        return this.boxExpandedPaddingTopPx;
    }

    public int getBoxPaddingRight() {
        return this.boxPaddingRightPx;
    }

    public int getBoxCollapsedPaddingBottom() {
        return this.boxCollapsedPaddingBottomPx;
    }

    public int getBoxExpandedPaddingBottom() {
        return this.boxExpandedPaddingBottomPx;
    }

    public void setBoxStrokeColor(@ColorInt int boxStrokeColor) {
        if (this.focusedStrokeColor != boxStrokeColor) {
            this.focusedStrokeColor = boxStrokeColor;
            this.updateTextInputBoxState();
        }
    }

    public int getBoxStrokeColor() {
        return this.focusedStrokeColor;
    }

    public void setBoxBackgroundColorResource(@ColorRes int boxBackgroundColorId) {
        this.setBoxBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)boxBackgroundColorId));
    }

    public void setBoxBackgroundColor(@ColorInt int boxBackgroundColor) {
        if (this.defaultBoxBackgroundColor != boxBackgroundColor) {
            this.defaultBoxBackgroundColor = boxBackgroundColor;
            this.applyBoxAttributes();
        }
    }

    public int getBoxBackgroundColor() {
        return this.defaultBoxBackgroundColor;
    }

    public void setBoxCornerRadiiResources(@DimenRes int boxCornerRadiusTopLeftId, @DimenRes int boxCornerRadiusTopRightId, @DimenRes int boxCornerRadiusBottomRightId, @DimenRes int boxCornerRadiusBottomLeftId) {
        this.setBoxCornerRadii(this.getContext().getResources().getDimension(boxCornerRadiusTopLeftId), this.getContext().getResources().getDimension(boxCornerRadiusTopRightId), this.getContext().getResources().getDimension(boxCornerRadiusBottomRightId), this.getContext().getResources().getDimension(boxCornerRadiusBottomLeftId));
    }

    public void setBoxCornerRadii(float boxCornerRadiusTopLeft, float boxCornerRadiusTopRight, float boxCornerRadiusBottomLeft, float boxCornerRadiusBottomRight) {
        if (this.boxCornerRadiusTopLeft != boxCornerRadiusTopLeft || this.boxCornerRadiusTopRight != boxCornerRadiusTopRight || this.boxCornerRadiusBottomRight != boxCornerRadiusBottomRight || this.boxCornerRadiusBottomLeft != boxCornerRadiusBottomLeft) {
            this.boxCornerRadiusTopLeft = boxCornerRadiusTopLeft;
            this.boxCornerRadiusTopRight = boxCornerRadiusTopRight;
            this.boxCornerRadiusBottomRight = boxCornerRadiusBottomRight;
            this.boxCornerRadiusBottomLeft = boxCornerRadiusBottomLeft;
            this.applyBoxAttributes();
        }
    }

    public float getBoxCornerRadiusTopLeft() {
        return this.boxCornerRadiusTopLeft;
    }

    public float getBoxCornerRadiusTopRight() {
        return this.boxCornerRadiusTopRight;
    }

    public float getBoxCornerRadiusBottomRight() {
        return this.boxCornerRadiusBottomRight;
    }

    public float getBoxCornerRadiusBottomLeft() {
        return this.boxCornerRadiusBottomLeft;
    }

    private float[] getCornerRadiiAsArray() {
        float[] cornerRadii = new float[]{this.boxCornerRadiusTopLeft, this.boxCornerRadiusTopLeft, this.boxCornerRadiusTopRight, this.boxCornerRadiusTopRight, this.boxCornerRadiusBottomRight, this.boxCornerRadiusBottomRight, this.boxCornerRadiusBottomLeft, this.boxCornerRadiusBottomLeft};
        return cornerRadii;
    }

    public void setTypeface(@Nullable Typeface typeface) {
        if (typeface != this.typeface) {
            this.typeface = typeface;
            this.collapsingTextHelper.setTypefaces(typeface);
            this.indicatorViewController.setTypefaces(typeface);
            if (this.counterView != null) {
                this.counterView.setTypeface(typeface);
            }
        }
    }

    @Nullable
    public Typeface getTypeface() {
        return this.typeface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchProvideAutofillStructure(ViewStructure structure, int flags) {
        if (this.originalHint == null || this.editText == null) {
            super.dispatchProvideAutofillStructure(structure, flags);
            return;
        }
        CharSequence hint = this.editText.getHint();
        this.editText.setHint(this.originalHint);
        try {
            super.dispatchProvideAutofillStructure(structure, flags);
        }
        finally {
            this.editText.setHint(hint);
        }
    }

    private void setEditText(EditText editText) {
        if (this.editText != null) {
            throw new IllegalArgumentException("We already have an EditText, can only have one");
        }
        if (!(editText instanceof TextInputEditText)) {
            Log.i((String)LOG_TAG, (String)"EditText added is not a TextInputEditText. Please switch to using that class instead.");
        }
        this.editText = editText;
        this.onApplyBoxBackgroundMode();
        boolean hasPasswordTransformation = this.hasPasswordTransformation();
        if (!hasPasswordTransformation) {
            this.collapsingTextHelper.setTypefaces(this.editText.getTypeface());
        }
        this.collapsingTextHelper.setExpandedTextSize(this.editText.getTextSize());
        int editTextGravity = this.editText.getGravity();
        this.collapsingTextHelper.setCollapsedTextGravity(0x30 | editTextGravity & 0xFFFFFF8F);
        this.collapsingTextHelper.setExpandedTextGravity(editTextGravity);
        this.editText.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable s) {
                TextInputLayout.this.updateLabelState(!TextInputLayout.this.restoringSavedState);
                if (TextInputLayout.this.counterEnabled) {
                    TextInputLayout.this.updateCounter(s.length());
                }
            }

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }
        });
        if (this.defaultTextColor == null) {
            this.defaultTextColor = this.editText.getHintTextColors();
        }
        if (this.hintEnabled && TextUtils.isEmpty((CharSequence)this.hint)) {
            this.originalHint = this.editText.getHint();
            this.setHint(this.originalHint);
            this.setHint(this.editText.getHint());
            this.editText.setHint(null);
        }
        if (this.counterView != null) {
            this.updateCounter(this.editText.getText().length());
        }
        this.indicatorViewController.adjustIndicatorPadding();
        this.updatePasswordToggleView();
        this.updateLabelState(false, true);
    }

    private void updateInputLayoutMargins() {
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.inputFrame.getLayoutParams();
        int newTopMargin = this.calculateLabelMarginTop();
        if (newTopMargin != lp.topMargin) {
            lp.topMargin = newTopMargin;
            this.inputFrame.requestLayout();
        }
    }

    void updateLabelState(boolean animate) {
        this.updateLabelState(animate, false);
    }

    private void updateLabelState(boolean animate, boolean force) {
        boolean isEnabled = this.isEnabled();
        boolean hasText = this.editText != null && !TextUtils.isEmpty((CharSequence)this.editText.getText());
        boolean hasFocus = this.editText != null && this.editText.hasFocus();
        boolean errorShouldBeShown = this.indicatorViewController.errorShouldBeShown();
        if (this.defaultTextColor != null) {
            this.collapsingTextHelper.setCollapsedTextColor(this.defaultTextColor);
            this.collapsingTextHelper.setExpandedTextColor(this.defaultTextColor);
        }
        if (!isEnabled) {
            this.collapsingTextHelper.setCollapsedTextColor(ColorStateList.valueOf((int)this.disabledColor));
            this.collapsingTextHelper.setExpandedTextColor(ColorStateList.valueOf((int)this.disabledColor));
        } else if (errorShouldBeShown) {
            this.collapsingTextHelper.setCollapsedTextColor(this.indicatorViewController.getErrorViewTextColors());
        } else if (this.counterOverflowed && this.counterView != null) {
            this.collapsingTextHelper.setCollapsedTextColor(this.counterView.getTextColors());
        } else if (hasFocus && this.focusedTextColor != null) {
            this.collapsingTextHelper.setCollapsedTextColor(this.focusedTextColor);
        }
        if (hasText || this.isEnabled() && (hasFocus || errorShouldBeShown)) {
            if (force || this.hintExpanded) {
                this.collapseHint(animate);
            }
        } else if (force || !this.hintExpanded) {
            this.expandHint(animate);
        }
    }

    @Nullable
    public EditText getEditText() {
        return this.editText;
    }

    public void setHint(@Nullable CharSequence hint) {
        if (this.hintEnabled) {
            this.setHintInternal(hint);
            this.sendAccessibilityEvent(2048);
        }
    }

    private void setHintInternal(CharSequence hint) {
        if (!TextUtils.equals((CharSequence)hint, (CharSequence)this.hint)) {
            this.hint = hint;
            this.collapsingTextHelper.setText(hint);
            if (!this.hintExpanded) {
                this.openCutout();
            }
        }
    }

    @Nullable
    public CharSequence getHint() {
        return this.hintEnabled ? this.hint : null;
    }

    public void setHintEnabled(boolean enabled) {
        if (enabled != this.hintEnabled) {
            this.hintEnabled = enabled;
            CharSequence editTextHint = this.editText.getHint();
            if (!this.hintEnabled) {
                if (!TextUtils.isEmpty((CharSequence)this.hint) && TextUtils.isEmpty((CharSequence)editTextHint)) {
                    this.editText.setHint(this.hint);
                }
                this.setHintInternal(null);
            } else if (!TextUtils.isEmpty((CharSequence)editTextHint)) {
                if (TextUtils.isEmpty((CharSequence)this.hint)) {
                    this.setHint(editTextHint);
                }
                this.editText.setHint(null);
            }
            if (this.editText != null) {
                this.updateInputLayoutMargins();
            }
        }
    }

    public boolean isHintEnabled() {
        return this.hintEnabled;
    }

    public void setHintTextAppearance(@StyleRes int resId) {
        this.collapsingTextHelper.setCollapsedTextAppearance(resId);
        this.focusedTextColor = this.collapsingTextHelper.getCollapsedTextColor();
        if (this.editText != null) {
            this.updateLabelState(false);
            this.updateInputLayoutMargins();
        }
    }

    public void setErrorEnabled(boolean enabled) {
        this.indicatorViewController.setErrorEnabled(enabled);
    }

    public void setErrorTextAppearance(@StyleRes int resId) {
        this.indicatorViewController.setErrorTextAppearance(resId);
    }

    public void setHelperTextTextAppearance(@StyleRes int resId) {
        this.indicatorViewController.setHelperTextAppearance(resId);
    }

    public boolean isErrorEnabled() {
        return this.indicatorViewController.isErrorEnabled();
    }

    public void setHelperTextEnabled(boolean enabled) {
        this.indicatorViewController.setHelperTextEnabled(enabled);
    }

    public void setHelperText(@Nullable CharSequence helperText) {
        if (TextUtils.isEmpty((CharSequence)helperText)) {
            if (this.isHelperTextEnabled()) {
                this.setHelperTextEnabled(false);
            }
        } else {
            if (!this.isHelperTextEnabled()) {
                this.setHelperTextEnabled(true);
            }
            this.indicatorViewController.showHelper(helperText);
        }
    }

    public boolean isHelperTextEnabled() {
        return this.indicatorViewController.isHelperTextEnabled();
    }

    public void setError(@Nullable CharSequence errorText) {
        if (!this.indicatorViewController.isErrorEnabled()) {
            if (TextUtils.isEmpty((CharSequence)errorText)) {
                return;
            }
            this.setErrorEnabled(true);
        }
        if (!TextUtils.isEmpty((CharSequence)errorText)) {
            this.indicatorViewController.showError(errorText);
        } else {
            this.indicatorViewController.hideError();
        }
    }

    public void setCounterEnabled(boolean enabled) {
        if (this.counterEnabled != enabled) {
            if (enabled) {
                this.counterView = new AppCompatTextView(this.getContext());
                this.counterView.setId(R.id.textinput_counter);
                if (this.typeface != null) {
                    this.counterView.setTypeface(this.typeface);
                }
                this.counterView.setMaxLines(1);
                this.setTextAppearanceCompatWithErrorFallback(this.counterView, this.counterTextAppearance);
                this.indicatorViewController.addIndicator(this.counterView, 2);
                if (this.editText == null) {
                    this.updateCounter(0);
                } else {
                    this.updateCounter(this.editText.getText().length());
                }
            } else {
                this.indicatorViewController.removeIndicator(this.counterView, 2);
                this.counterView = null;
            }
            this.counterEnabled = enabled;
        }
    }

    public boolean isCounterEnabled() {
        return this.counterEnabled;
    }

    public void setCounterMaxLength(int maxLength) {
        if (this.counterMaxLength != maxLength) {
            this.counterMaxLength = maxLength > 0 ? maxLength : -1;
            if (this.counterEnabled) {
                this.updateCounter(this.editText == null ? 0 : this.editText.getText().length());
            }
        }
    }

    public void setEnabled(boolean enabled) {
        TextInputLayout.recursiveSetEnabled((ViewGroup)this, enabled);
        super.setEnabled(enabled);
    }

    private static void recursiveSetEnabled(ViewGroup vg, boolean enabled) {
        int count = vg.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = vg.getChildAt(i);
            child.setEnabled(enabled);
            if (!(child instanceof ViewGroup)) continue;
            TextInputLayout.recursiveSetEnabled((ViewGroup)child, enabled);
        }
    }

    public int getCounterMaxLength() {
        return this.counterMaxLength;
    }

    void updateCounter(int length) {
        boolean wasCounterOverflowed = this.counterOverflowed;
        if (this.counterMaxLength == -1) {
            this.counterView.setText((CharSequence)String.valueOf(length));
            this.counterOverflowed = false;
        } else {
            boolean bl = this.counterOverflowed = length > this.counterMaxLength;
            if (wasCounterOverflowed != this.counterOverflowed) {
                this.setTextAppearanceCompatWithErrorFallback(this.counterView, this.counterOverflowed ? this.counterOverflowTextAppearance : this.counterTextAppearance);
            }
            this.counterView.setText((CharSequence)this.getContext().getString(R.string.character_counter_pattern, new Object[]{length, this.counterMaxLength}));
        }
        if (this.editText != null && wasCounterOverflowed != this.counterOverflowed) {
            this.updateLabelState(false);
            this.updateEditTextBackground();
        }
    }

    void setTextAppearanceCompatWithErrorFallback(TextView textView, @StyleRes int textAppearance) {
        boolean useDefaultColor = false;
        try {
            TextViewCompat.setTextAppearance((TextView)textView, (int)textAppearance);
            if (Build.VERSION.SDK_INT >= 23 && textView.getTextColors().getDefaultColor() == -65281) {
                useDefaultColor = true;
            }
        }
        catch (Exception e) {
            useDefaultColor = true;
        }
        if (useDefaultColor) {
            TextViewCompat.setTextAppearance((TextView)textView, (int)R.style.TextAppearance_AppCompat_Caption);
            textView.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.design_error));
        }
    }

    private void updateTextInputBoxBounds() {
        if (this.boxBackgroundMode == 0 || this.boxBackground == null || this.editText == null || this.getRight() == 0) {
            return;
        }
        int left = this.editText.getLeft();
        int top = this.calculateBoxBackgroundTop();
        int right = this.editText.getRight();
        int bottom = this.editText.getBottom() + this.boxBottomOffsetPx;
        if (this.boxBackgroundMode == 2) {
            left += this.boxStrokeWidthFocusedPx / 2;
            top -= this.boxStrokeWidthFocusedPx / 2;
            right -= this.boxStrokeWidthFocusedPx / 2;
            bottom += this.boxStrokeWidthFocusedPx / 2;
        }
        this.boxBackground.setBounds(left, top, right, bottom);
        this.applyBoxAttributes();
        this.updateEditTextBackgroundBounds();
    }

    private int calculateBoxBackgroundTop() {
        if (this.editText == null) {
            return 0;
        }
        switch (this.boxBackgroundMode) {
            case 1: {
                return this.editText.getTop();
            }
            case 2: {
                return this.editText.getTop() + this.calculateLabelMarginTop();
            }
        }
        return 0;
    }

    private int calculateLabelMarginTop() {
        if (!this.hintEnabled) {
            return 0;
        }
        switch (this.boxBackgroundMode) {
            case 2: {
                return (int)(this.collapsingTextHelper.getCollapsedTextHeight() / 2.0f);
            }
            case 0: 
            case 1: {
                return (int)this.collapsingTextHelper.getCollapsedTextHeight();
            }
        }
        return 0;
    }

    private int calculateCollapsedTextTopBounds() {
        switch (this.boxBackgroundMode) {
            case 2: {
                return this.getBoxBackground().getBounds().top - this.calculateLabelMarginTop();
            }
            case 1: {
                return this.getBoxBackground().getBounds().top + this.boxCollapsedPaddingTopPx;
            }
        }
        return this.getPaddingTop();
    }

    private void updateEditTextBackgroundBounds() {
        if (this.editText == null) {
            return;
        }
        Drawable editTextBackground = this.editText.getBackground();
        if (editTextBackground == null) {
            return;
        }
        if (android.support.v7.widget.DrawableUtils.canSafelyMutateDrawable((Drawable)editTextBackground)) {
            editTextBackground = editTextBackground.mutate();
        }
        Rect editTextBounds = new Rect();
        DescendantOffsetUtils.getDescendantRect((ViewGroup)this, (View)this.editText, editTextBounds);
        Rect editTextBackgroundBounds = editTextBackground.getBounds();
        if (editTextBackgroundBounds.left != editTextBackgroundBounds.right) {
            Rect editTextBackgroundPadding = new Rect();
            editTextBackground.getPadding(editTextBackgroundPadding);
            int left = editTextBackgroundBounds.left - editTextBackgroundPadding.left;
            int right = editTextBackgroundBounds.right + editTextBackgroundPadding.right * 2;
            editTextBackground.setBounds(left, editTextBackgroundBounds.top, right, this.editText.getBottom());
        }
    }

    private void setBoxAttributes() {
        switch (this.boxBackgroundMode) {
            case 1: {
                this.boxStrokeWidthPx = 0;
                break;
            }
            case 2: {
                if (this.focusedStrokeColor != 0) break;
                this.focusedStrokeColor = this.focusedTextColor.getColorForState(this.getDrawableState(), this.focusedTextColor.getDefaultColor());
                break;
            }
        }
    }

    private void applyBoxAttributes() {
        if (this.boxBackground == null) {
            return;
        }
        this.setBoxAttributes();
        if (this.editText != null && this.boxBackgroundMode == 2) {
            if (this.editText.getBackground() != null) {
                this.editTextOriginalDrawable = this.editText.getBackground();
            }
            ViewCompat.setBackground((View)this.editText, null);
        }
        if (this.editText != null && this.boxBackgroundMode == 1 && this.editTextOriginalDrawable != null) {
            ViewCompat.setBackground((View)this.editText, (Drawable)this.editTextOriginalDrawable);
        }
        if (this.boxStrokeWidthPx > -1 && this.boxStrokeColor != 0) {
            this.boxBackground.setStroke(this.boxStrokeWidthPx, this.boxStrokeColor);
        }
        this.boxBackground.setCornerRadii(this.getCornerRadiiAsArray());
        this.boxBackground.setColor(this.boxBackgroundColor);
        this.invalidate();
    }

    void updateEditTextBackground() {
        if (this.editText == null) {
            return;
        }
        Drawable editTextBackground = this.editText.getBackground();
        if (editTextBackground == null) {
            return;
        }
        this.ensureBackgroundDrawableStateWorkaround();
        if (android.support.v7.widget.DrawableUtils.canSafelyMutateDrawable((Drawable)editTextBackground)) {
            editTextBackground = editTextBackground.mutate();
        }
        if (this.indicatorViewController.errorShouldBeShown()) {
            editTextBackground.setColorFilter((ColorFilter)AppCompatDrawableManager.getPorterDuffColorFilter((int)this.indicatorViewController.getErrorViewCurrentTextColor(), (PorterDuff.Mode)PorterDuff.Mode.SRC_IN));
        } else if (this.counterOverflowed && this.counterView != null) {
            editTextBackground.setColorFilter((ColorFilter)AppCompatDrawableManager.getPorterDuffColorFilter((int)this.counterView.getCurrentTextColor(), (PorterDuff.Mode)PorterDuff.Mode.SRC_IN));
        } else {
            DrawableCompat.clearColorFilter((Drawable)editTextBackground);
            this.editText.refreshDrawableState();
        }
    }

    private void ensureBackgroundDrawableStateWorkaround() {
        int sdk = Build.VERSION.SDK_INT;
        if (sdk != 21 && sdk != 22) {
            return;
        }
        Drawable bg = this.editText.getBackground();
        if (bg == null) {
            return;
        }
        if (!this.hasReconstructedEditTextBackground) {
            Drawable newBg = bg.getConstantState().newDrawable();
            if (bg instanceof DrawableContainer) {
                this.hasReconstructedEditTextBackground = DrawableUtils.setContainerConstantState((DrawableContainer)bg, newBg.getConstantState());
            }
            if (!this.hasReconstructedEditTextBackground) {
                ViewCompat.setBackground((View)this.editText, (Drawable)newBg);
                this.hasReconstructedEditTextBackground = true;
                this.onApplyBoxBackgroundMode();
            }
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        if (this.indicatorViewController.errorShouldBeShown()) {
            ss.error = this.getError();
        }
        ss.isPasswordToggledVisible = this.passwordToggledVisible;
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setError(ss.error);
        if (ss.isPasswordToggledVisible) {
            this.passwordVisibilityToggleRequested(true);
        }
        this.requestLayout();
    }

    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        this.restoringSavedState = true;
        super.dispatchRestoreInstanceState(container);
        this.restoringSavedState = false;
    }

    @Nullable
    public CharSequence getError() {
        return this.indicatorViewController.isErrorEnabled() ? this.indicatorViewController.getErrorText() : null;
    }

    @Nullable
    public CharSequence getHelperText() {
        return this.indicatorViewController.isHelperTextEnabled() ? this.indicatorViewController.getHelperText() : null;
    }

    public boolean isHintAnimationEnabled() {
        return this.hintAnimationEnabled;
    }

    public void setHintAnimationEnabled(boolean enabled) {
        this.hintAnimationEnabled = enabled;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        if (this.hintEnabled) {
            this.collapsingTextHelper.draw(canvas);
        }
        if (this.boxBackground != null) {
            this.boxBackground.draw(canvas);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.updatePasswordToggleView();
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void updatePasswordToggleView() {
        if (this.editText == null) {
            return;
        }
        if (this.shouldShowPasswordIcon()) {
            if (this.passwordToggleView == null) {
                this.passwordToggleView = (CheckableImageButton)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.design_text_input_password_icon, (ViewGroup)this.inputFrame, false);
                this.passwordToggleView.setImageDrawable(this.passwordToggleDrawable);
                this.passwordToggleView.setContentDescription(this.passwordToggleContentDesc);
                this.inputFrame.addView((View)this.passwordToggleView);
                this.passwordToggleView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        TextInputLayout.this.passwordVisibilityToggleRequested(false);
                    }
                });
            }
            if (this.editText != null && ViewCompat.getMinimumHeight((View)this.editText) <= 0) {
                this.editText.setMinimumHeight(ViewCompat.getMinimumHeight((View)this.passwordToggleView));
            }
            this.passwordToggleView.setVisibility(0);
            this.passwordToggleView.setChecked(this.passwordToggledVisible);
            if (this.passwordToggleDummyDrawable == null) {
                this.passwordToggleDummyDrawable = new ColorDrawable();
            }
            this.passwordToggleDummyDrawable.setBounds(0, 0, this.passwordToggleView.getMeasuredWidth(), 1);
            Drawable[] compounds = TextViewCompat.getCompoundDrawablesRelative((TextView)this.editText);
            if (compounds[2] != this.passwordToggleDummyDrawable) {
                this.originalEditTextEndDrawable = compounds[2];
            }
            TextViewCompat.setCompoundDrawablesRelative((TextView)this.editText, (Drawable)compounds[0], (Drawable)compounds[1], (Drawable)this.passwordToggleDummyDrawable, (Drawable)compounds[3]);
            this.passwordToggleView.setPadding(this.editText.getPaddingLeft(), this.editText.getPaddingTop(), this.editText.getPaddingRight(), this.editText.getPaddingBottom());
        } else {
            Drawable[] compounds;
            if (this.passwordToggleView != null && this.passwordToggleView.getVisibility() == 0) {
                this.passwordToggleView.setVisibility(8);
            }
            if (this.passwordToggleDummyDrawable != null && (compounds = TextViewCompat.getCompoundDrawablesRelative((TextView)this.editText))[2] == this.passwordToggleDummyDrawable) {
                TextViewCompat.setCompoundDrawablesRelative((TextView)this.editText, (Drawable)compounds[0], (Drawable)compounds[1], (Drawable)this.originalEditTextEndDrawable, (Drawable)compounds[3]);
                this.passwordToggleDummyDrawable = null;
            }
        }
    }

    public void setPasswordVisibilityToggleDrawable(@DrawableRes int resId) {
        this.setPasswordVisibilityToggleDrawable(resId != 0 ? AppCompatResources.getDrawable((Context)this.getContext(), (int)resId) : null);
    }

    public void setPasswordVisibilityToggleDrawable(@Nullable Drawable icon) {
        this.passwordToggleDrawable = icon;
        if (this.passwordToggleView != null) {
            this.passwordToggleView.setImageDrawable(icon);
        }
    }

    public void setPasswordVisibilityToggleContentDescription(@StringRes int resId) {
        this.setPasswordVisibilityToggleContentDescription(resId != 0 ? this.getResources().getText(resId) : null);
    }

    public void setPasswordVisibilityToggleContentDescription(@Nullable CharSequence description) {
        this.passwordToggleContentDesc = description;
        if (this.passwordToggleView != null) {
            this.passwordToggleView.setContentDescription(description);
        }
    }

    @Nullable
    public Drawable getPasswordVisibilityToggleDrawable() {
        return this.passwordToggleDrawable;
    }

    @Nullable
    public CharSequence getPasswordVisibilityToggleContentDescription() {
        return this.passwordToggleContentDesc;
    }

    public boolean isPasswordVisibilityToggleEnabled() {
        return this.passwordToggleEnabled;
    }

    public void setPasswordVisibilityToggleEnabled(boolean enabled) {
        if (this.passwordToggleEnabled != enabled) {
            this.passwordToggleEnabled = enabled;
            if (!enabled && this.passwordToggledVisible && this.editText != null) {
                this.editText.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
            }
            this.passwordToggledVisible = false;
            this.updatePasswordToggleView();
        }
    }

    public void setPasswordVisibilityToggleTintList(@Nullable ColorStateList tintList) {
        this.passwordToggleTintList = tintList;
        this.hasPasswordToggleTintList = true;
        this.applyPasswordToggleTint();
    }

    public void setPasswordVisibilityToggleTintMode(@Nullable PorterDuff.Mode mode) {
        this.passwordToggleTintMode = mode;
        this.hasPasswordToggleTintMode = true;
        this.applyPasswordToggleTint();
    }

    private void passwordVisibilityToggleRequested(boolean shouldSkipAnimations) {
        if (this.passwordToggleEnabled) {
            int selection = this.editText.getSelectionEnd();
            if (this.hasPasswordTransformation()) {
                this.editText.setTransformationMethod(null);
                this.passwordToggledVisible = true;
            } else {
                this.editText.setTransformationMethod((TransformationMethod)PasswordTransformationMethod.getInstance());
                this.passwordToggledVisible = false;
            }
            this.passwordToggleView.setChecked(this.passwordToggledVisible);
            if (shouldSkipAnimations) {
                this.passwordToggleView.jumpDrawablesToCurrentState();
            }
            this.editText.setSelection(selection);
        }
    }

    private boolean hasPasswordTransformation() {
        return this.editText != null && this.editText.getTransformationMethod() instanceof PasswordTransformationMethod;
    }

    private boolean shouldShowPasswordIcon() {
        return this.passwordToggleEnabled && (this.hasPasswordTransformation() || this.passwordToggledVisible);
    }

    private void applyPasswordToggleTint() {
        if (this.passwordToggleDrawable != null && (this.hasPasswordToggleTintList || this.hasPasswordToggleTintMode)) {
            this.passwordToggleDrawable = DrawableCompat.wrap((Drawable)this.passwordToggleDrawable).mutate();
            if (this.hasPasswordToggleTintList) {
                DrawableCompat.setTintList((Drawable)this.passwordToggleDrawable, (ColorStateList)this.passwordToggleTintList);
            }
            if (this.hasPasswordToggleTintMode) {
                DrawableCompat.setTintMode((Drawable)this.passwordToggleDrawable, (PorterDuff.Mode)this.passwordToggleTintMode);
            }
            if (this.passwordToggleView != null && this.passwordToggleView.getDrawable() != this.passwordToggleDrawable) {
                this.passwordToggleView.setImageDrawable(this.passwordToggleDrawable);
            }
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.boxBackground != null) {
            this.updateTextInputBoxBounds();
        }
        if (this.hintEnabled && this.editText != null) {
            Rect rect = this.tmpRect;
            DescendantOffsetUtils.getDescendantRect((ViewGroup)this, (View)this.editText, rect);
            int l = rect.left + this.editText.getCompoundPaddingLeft();
            int r = rect.right - this.editText.getCompoundPaddingRight();
            int t = this.calculateCollapsedTextTopBounds();
            this.collapsingTextHelper.setExpandedBounds(l, rect.top + this.editText.getCompoundPaddingTop(), r, rect.bottom - this.editText.getCompoundPaddingBottom());
            this.collapsingTextHelper.setCollapsedBounds(l, t, r, bottom - top - this.getPaddingBottom());
            this.collapsingTextHelper.recalculate();
            if (this.cutoutEnabled() && !this.hintExpanded) {
                this.openCutout();
            }
        }
    }

    private void collapseHint(boolean animate) {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.cancel();
        }
        if (animate && this.hintAnimationEnabled) {
            this.animateToExpansionFraction(1.0f);
        } else {
            this.collapsingTextHelper.setExpansionFraction(1.0f);
        }
        this.hintExpanded = false;
        if (this.cutoutEnabled()) {
            this.openCutout();
        }
    }

    private boolean cutoutEnabled() {
        return this.hintEnabled && !TextUtils.isEmpty((CharSequence)this.hint) && this.boxBackground instanceof CutoutDrawable;
    }

    private void openCutout() {
        if (!this.cutoutEnabled()) {
            return;
        }
        RectF cutoutBounds = this.tmpRectF;
        this.collapsingTextHelper.getCollapsedTextActualBounds(cutoutBounds);
        this.applyCutoutPadding(cutoutBounds);
        ((CutoutDrawable)this.boxBackground).setCutout(cutoutBounds);
    }

    private void closeCutout() {
        if (this.cutoutEnabled()) {
            ((CutoutDrawable)this.boxBackground).removeCutout();
        }
    }

    private void applyCutoutPadding(RectF cutoutBounds) {
        cutoutBounds.left -= (float)this.boxLabelCutoutPaddingPx;
        cutoutBounds.top -= (float)this.boxLabelCutoutPaddingPx;
        cutoutBounds.right += (float)this.boxLabelCutoutPaddingPx;
        cutoutBounds.bottom += (float)this.boxLabelCutoutPaddingPx;
    }

    @VisibleForTesting
    boolean cutoutIsOpen() {
        return this.cutoutEnabled() && ((CutoutDrawable)this.boxBackground).hasCutout();
    }

    protected void drawableStateChanged() {
        if (this.inDrawableStateChanged) {
            return;
        }
        this.inDrawableStateChanged = true;
        super.drawableStateChanged();
        int[] state = this.getDrawableState();
        boolean changed = false;
        this.updateLabelState(ViewCompat.isLaidOut((View)this) && this.isEnabled());
        this.updateEditTextBackground();
        this.updateTextInputBoxBounds();
        this.updateTextInputBoxState();
        if (this.collapsingTextHelper != null) {
            changed |= this.collapsingTextHelper.setState(state);
        }
        if (changed) {
            this.invalidate();
        }
        this.inDrawableStateChanged = false;
    }

    void updateTextInputBoxState() {
        boolean isHovered;
        if (this.boxBackground == null || this.boxBackgroundMode == 0) {
            return;
        }
        boolean hasFocus = this.editText != null && this.editText.hasFocus();
        boolean bl = isHovered = this.editText != null && this.editText.isHovered();
        if (this.boxBackgroundMode == 2) {
            this.boxStrokeColor = !this.isEnabled() ? this.disabledColor : (this.indicatorViewController.errorShouldBeShown() ? this.indicatorViewController.getErrorViewCurrentTextColor() : (hasFocus ? this.focusedStrokeColor : (isHovered ? this.hoveredStrokeColor : this.defaultStrokeColor)));
            this.boxStrokeWidthPx = (isHovered || hasFocus) && this.isEnabled() ? this.boxStrokeWidthFocusedPx : this.boxStrokeWidthDefaultPx;
            this.applyBoxAttributes();
        }
    }

    private void expandHint(boolean animate) {
        if (this.animator != null && this.animator.isRunning()) {
            this.animator.cancel();
        }
        if (animate && this.hintAnimationEnabled) {
            this.animateToExpansionFraction(0.0f);
        } else {
            this.collapsingTextHelper.setExpansionFraction(0.0f);
        }
        if (this.cutoutEnabled() && ((CutoutDrawable)this.boxBackground).hasCutout()) {
            this.closeCutout();
        }
        this.hintExpanded = true;
    }

    @VisibleForTesting
    void animateToExpansionFraction(float target) {
        if (this.collapsingTextHelper.getExpansionFraction() == target) {
            return;
        }
        if (this.animator == null) {
            this.animator = new ValueAnimator();
            this.animator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
            this.animator.setDuration(167L);
            this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animator2) {
                    TextInputLayout.this.collapsingTextHelper.setExpansionFraction(((Float)animator2.getAnimatedValue()).floatValue());
                }
            });
        }
        this.animator.setFloatValues(new float[]{this.collapsingTextHelper.getExpansionFraction(), target});
        this.animator.start();
    }

    @VisibleForTesting
    final boolean isHintExpanded() {
        return this.hintExpanded;
    }

    @VisibleForTesting
    final boolean isHelperTextDisplayed() {
        return this.indicatorViewController.helperTextIsDisplayed();
    }

    @VisibleForTesting
    final int getHintCurrentCollapsedTextColor() {
        return this.collapsingTextHelper.getCurrentCollapsedTextColor();
    }

    @VisibleForTesting
    final float getHintCollapsedTextHeight() {
        return this.collapsingTextHelper.getCollapsedTextHeight();
    }

    @VisibleForTesting
    final int getErrorTextCurrentColor() {
        return this.indicatorViewController.getErrorViewCurrentTextColor();
    }

    private class TextInputAccessibilityDelegate
    extends AccessibilityDelegateCompat {
        TextInputAccessibilityDelegate() {
        }

        public void onInitializeAccessibilityEvent(View host, AccessibilityEvent event) {
            super.onInitializeAccessibilityEvent(host, event);
            event.setClassName((CharSequence)TextInputLayout.class.getSimpleName());
        }

        public void onPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
            CharSequence helperText;
            super.onPopulateAccessibilityEvent(host, event);
            CharSequence hint = TextInputLayout.this.collapsingTextHelper.getText();
            if (!TextUtils.isEmpty((CharSequence)hint)) {
                event.getText().add(hint);
            }
            if (!TextUtils.isEmpty((CharSequence)(helperText = TextInputLayout.this.indicatorViewController.getHelperText()))) {
                event.getText().add(helperText);
            }
        }

        public void onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfoCompat info) {
            super.onInitializeAccessibilityNodeInfo(host, info);
            info.setClassName((CharSequence)TextInputLayout.class.getSimpleName());
            CharSequence hint = TextInputLayout.this.collapsingTextHelper.getText();
            if (!TextUtils.isEmpty((CharSequence)hint)) {
                info.setText(hint);
            }
            if (TextInputLayout.this.editText != null) {
                info.setLabelFor((View)TextInputLayout.this.editText);
            }
            if (TextInputLayout.this.indicatorViewController.errorIsDisplayed()) {
                info.setContentInvalid(true);
                info.setError(TextInputLayout.this.indicatorViewController.getErrorText());
            }
        }
    }

    static class SavedState
    extends AbsSavedState {
        CharSequence error;
        boolean isPasswordToggledVisible;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in, null);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        SavedState(Parcel source, ClassLoader loader) {
            super(source, loader);
            this.error = (CharSequence)TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
            this.isPasswordToggledVisible = source.readInt() == 1;
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            TextUtils.writeToParcel((CharSequence)this.error, (Parcel)dest, (int)flags);
            dest.writeInt(this.isPasswordToggledVisible ? 1 : 0);
        }

        public String toString() {
            return "TextInputLayout.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " error=" + this.error + "}";
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface BoxBackgroundMode {
    }
}

