/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StringRes;
import android.support.design.R;
import android.support.design.widget.AnimationUtils;
import android.support.design.widget.ThemeUtils;
import android.support.design.widget.ValueAnimatorCompat;
import android.support.design.widget.ViewUtils;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.ViewPager;
import android.support.v4.widget.TextViewCompat;
import android.support.v7.app.ActionBar;
import android.support.v7.widget.TintManager;
import android.text.Layout;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;

public class TabLayout
extends HorizontalScrollView {
    private static final int DEFAULT_HEIGHT_WITH_TEXT_ICON = 72;
    private static final int DEFAULT_GAP_TEXT_ICON = 8;
    private static final int INVALID_WIDTH = -1;
    private static final int DEFAULT_HEIGHT = 48;
    private static final int TAB_MIN_WIDTH_MARGIN = 56;
    private static final int FIXED_WRAP_GUTTER_MIN = 16;
    private static final int MOTION_NON_ADJACENT_OFFSET = 24;
    private static final int ANIMATION_DURATION = 300;
    public static final int MODE_SCROLLABLE = 0;
    public static final int MODE_FIXED = 1;
    public static final int GRAVITY_FILL = 0;
    public static final int GRAVITY_CENTER = 1;
    private final ArrayList<Tab> mTabs = new ArrayList();
    private Tab mSelectedTab;
    private final SlidingTabStrip mTabStrip;
    private int mTabPaddingStart;
    private int mTabPaddingTop;
    private int mTabPaddingEnd;
    private int mTabPaddingBottom;
    private int mTabTextAppearance;
    private ColorStateList mTabTextColors;
    private float mTabTextSize;
    private float mTabTextMultiLineSize;
    private final int mTabBackgroundResId;
    private int mTabMaxWidth = Integer.MAX_VALUE;
    private final int mRequestedTabMinWidth;
    private final int mRequestedTabMaxWidth;
    private final int mScrollableTabMinWidth;
    private int mContentInsetStart;
    private int mTabGravity;
    private int mMode;
    private OnTabSelectedListener mOnTabSelectedListener;
    private View.OnClickListener mTabClickListener;
    private ValueAnimatorCompat mScrollAnimator;
    private ValueAnimatorCompat mIndicatorAnimator;

    public TabLayout(Context context) {
        this(context, null);
    }

    public TabLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TabLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        ThemeUtils.checkAppCompatTheme(context);
        this.setHorizontalScrollBarEnabled(false);
        this.mTabStrip = new SlidingTabStrip(context);
        this.addView((View)this.mTabStrip, -2, -1);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TabLayout, defStyleAttr, R.style.Widget_Design_TabLayout);
        this.mTabStrip.setSelectedIndicatorHeight(a.getDimensionPixelSize(R.styleable.TabLayout_tabIndicatorHeight, 0));
        this.mTabStrip.setSelectedIndicatorColor(a.getColor(R.styleable.TabLayout_tabIndicatorColor, 0));
        this.mTabPaddingEnd = this.mTabPaddingBottom = a.getDimensionPixelSize(R.styleable.TabLayout_tabPadding, 0);
        this.mTabPaddingTop = this.mTabPaddingBottom;
        this.mTabPaddingStart = this.mTabPaddingBottom;
        this.mTabPaddingStart = a.getDimensionPixelSize(R.styleable.TabLayout_tabPaddingStart, this.mTabPaddingStart);
        this.mTabPaddingTop = a.getDimensionPixelSize(R.styleable.TabLayout_tabPaddingTop, this.mTabPaddingTop);
        this.mTabPaddingEnd = a.getDimensionPixelSize(R.styleable.TabLayout_tabPaddingEnd, this.mTabPaddingEnd);
        this.mTabPaddingBottom = a.getDimensionPixelSize(R.styleable.TabLayout_tabPaddingBottom, this.mTabPaddingBottom);
        this.mTabTextAppearance = a.getResourceId(R.styleable.TabLayout_tabTextAppearance, R.style.TextAppearance_Design_Tab);
        TypedArray ta = context.obtainStyledAttributes(this.mTabTextAppearance, R.styleable.TextAppearance);
        try {
            this.mTabTextSize = ta.getDimensionPixelSize(R.styleable.TextAppearance_android_textSize, 0);
            this.mTabTextColors = ta.getColorStateList(R.styleable.TextAppearance_android_textColor);
        }
        finally {
            ta.recycle();
        }
        if (a.hasValue(R.styleable.TabLayout_tabTextColor)) {
            this.mTabTextColors = a.getColorStateList(R.styleable.TabLayout_tabTextColor);
        }
        if (a.hasValue(R.styleable.TabLayout_tabSelectedTextColor)) {
            int selected = a.getColor(R.styleable.TabLayout_tabSelectedTextColor, 0);
            this.mTabTextColors = TabLayout.createColorStateList(this.mTabTextColors.getDefaultColor(), selected);
        }
        this.mRequestedTabMinWidth = a.getDimensionPixelSize(R.styleable.TabLayout_tabMinWidth, -1);
        this.mRequestedTabMaxWidth = a.getDimensionPixelSize(R.styleable.TabLayout_tabMaxWidth, -1);
        this.mTabBackgroundResId = a.getResourceId(R.styleable.TabLayout_tabBackground, 0);
        this.mContentInsetStart = a.getDimensionPixelSize(R.styleable.TabLayout_tabContentStart, 0);
        this.mMode = a.getInt(R.styleable.TabLayout_tabMode, 1);
        this.mTabGravity = a.getInt(R.styleable.TabLayout_tabGravity, 0);
        a.recycle();
        Resources res = this.getResources();
        this.mTabTextMultiLineSize = res.getDimensionPixelSize(R.dimen.design_tab_text_size_2line);
        this.mScrollableTabMinWidth = res.getDimensionPixelSize(R.dimen.design_tab_scrollable_min_width);
        this.applyModeAndGravity();
    }

    public void setSelectedTabIndicatorColor(@ColorInt int color2) {
        this.mTabStrip.setSelectedIndicatorColor(color2);
    }

    public void setSelectedTabIndicatorHeight(int height) {
        this.mTabStrip.setSelectedIndicatorHeight(height);
    }

    public void setScrollPosition(int position, float positionOffset, boolean updateSelectedText) {
        if (this.mIndicatorAnimator != null && this.mIndicatorAnimator.isRunning()) {
            return;
        }
        if (position < 0 || position >= this.mTabStrip.getChildCount()) {
            return;
        }
        this.mTabStrip.setIndicatorPositionFromTabPosition(position, positionOffset);
        this.scrollTo(this.calculateScrollXForTab(position, positionOffset), 0);
        if (updateSelectedText) {
            this.setSelectedTabView(Math.round((float)position + positionOffset));
        }
    }

    private float getScrollPosition() {
        return this.mTabStrip.getIndicatorPosition();
    }

    public void addTab(@NonNull Tab tab) {
        this.addTab(tab, this.mTabs.isEmpty());
    }

    public void addTab(@NonNull Tab tab, int position) {
        this.addTab(tab, position, this.mTabs.isEmpty());
    }

    public void addTab(@NonNull Tab tab, boolean setSelected) {
        if (tab.mParent != this) {
            throw new IllegalArgumentException("Tab belongs to a different TabLayout.");
        }
        this.addTabView(tab, setSelected);
        this.configureTab(tab, this.mTabs.size());
        if (setSelected) {
            tab.select();
        }
    }

    public void addTab(@NonNull Tab tab, int position, boolean setSelected) {
        if (tab.mParent != this) {
            throw new IllegalArgumentException("Tab belongs to a different TabLayout.");
        }
        this.addTabView(tab, position, setSelected);
        this.configureTab(tab, position);
        if (setSelected) {
            tab.select();
        }
    }

    public void setOnTabSelectedListener(OnTabSelectedListener onTabSelectedListener) {
        this.mOnTabSelectedListener = onTabSelectedListener;
    }

    @NonNull
    public Tab newTab() {
        return new Tab(this);
    }

    public int getTabCount() {
        return this.mTabs.size();
    }

    @Nullable
    public Tab getTabAt(int index) {
        return this.mTabs.get(index);
    }

    public int getSelectedTabPosition() {
        return this.mSelectedTab != null ? this.mSelectedTab.getPosition() : -1;
    }

    public void removeTab(Tab tab) {
        if (tab.mParent != this) {
            throw new IllegalArgumentException("Tab does not belong to this TabLayout.");
        }
        this.removeTabAt(tab.getPosition());
    }

    public void removeTabAt(int position) {
        int selectedTabPosition = this.mSelectedTab != null ? this.mSelectedTab.getPosition() : 0;
        this.removeTabViewAt(position);
        Tab removedTab = this.mTabs.remove(position);
        if (removedTab != null) {
            removedTab.setPosition(-1);
        }
        int newTabCount = this.mTabs.size();
        for (int i = position; i < newTabCount; ++i) {
            this.mTabs.get(i).setPosition(i);
        }
        if (selectedTabPosition == position) {
            this.selectTab(this.mTabs.isEmpty() ? null : this.mTabs.get(Math.max(0, position - 1)));
        }
    }

    public void removeAllTabs() {
        this.mTabStrip.removeAllViews();
        Iterator<Tab> i = this.mTabs.iterator();
        while (i.hasNext()) {
            Tab tab = i.next();
            tab.setPosition(-1);
            i.remove();
        }
        this.mSelectedTab = null;
    }

    public void setTabMode(int mode) {
        if (mode != this.mMode) {
            this.mMode = mode;
            this.applyModeAndGravity();
        }
    }

    public int getTabMode() {
        return this.mMode;
    }

    public void setTabGravity(int gravity) {
        if (this.mTabGravity != gravity) {
            this.mTabGravity = gravity;
            this.applyModeAndGravity();
        }
    }

    public int getTabGravity() {
        return this.mTabGravity;
    }

    public void setTabTextColors(@Nullable ColorStateList textColor) {
        if (this.mTabTextColors != textColor) {
            this.mTabTextColors = textColor;
            this.updateAllTabs();
        }
    }

    @Nullable
    public ColorStateList getTabTextColors() {
        return this.mTabTextColors;
    }

    public void setTabTextColors(int normalColor, int selectedColor) {
        this.setTabTextColors(TabLayout.createColorStateList(normalColor, selectedColor));
    }

    public void setupWithViewPager(@NonNull ViewPager viewPager) {
        PagerAdapter adapter = viewPager.getAdapter();
        if (adapter == null) {
            throw new IllegalArgumentException("ViewPager does not have a PagerAdapter set");
        }
        this.setTabsFromPagerAdapter(adapter);
        viewPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)new TabLayoutOnPageChangeListener(this));
        this.setOnTabSelectedListener(new ViewPagerOnTabSelectedListener(viewPager));
        if (adapter.getCount() > 0) {
            int curItem = viewPager.getCurrentItem();
            if (this.getSelectedTabPosition() != curItem) {
                this.selectTab(this.getTabAt(curItem));
            }
        }
    }

    public void setTabsFromPagerAdapter(@NonNull PagerAdapter adapter) {
        this.removeAllTabs();
        int count = adapter.getCount();
        for (int i = 0; i < count; ++i) {
            this.addTab(this.newTab().setText(adapter.getPageTitle(i)));
        }
    }

    private void updateAllTabs() {
        int z = this.mTabStrip.getChildCount();
        for (int i = 0; i < z; ++i) {
            this.updateTab(i);
        }
    }

    private TabView createTabView(Tab tab) {
        TabView tabView = new TabView(this.getContext(), tab);
        tabView.setFocusable(true);
        tabView.setMinimumWidth(this.getTabMinWidth());
        if (this.mTabClickListener == null) {
            this.mTabClickListener = new View.OnClickListener(){

                public void onClick(View view) {
                    TabView tabView = (TabView)view;
                    tabView.getTab().select();
                }
            };
        }
        tabView.setOnClickListener(this.mTabClickListener);
        return tabView;
    }

    private void configureTab(Tab tab, int position) {
        tab.setPosition(position);
        this.mTabs.add(position, tab);
        int count = this.mTabs.size();
        for (int i = position + 1; i < count; ++i) {
            this.mTabs.get(i).setPosition(i);
        }
    }

    private void updateTab(int position) {
        TabView view = this.getTabView(position);
        if (view != null) {
            view.update();
        }
    }

    private TabView getTabView(int position) {
        return (TabView)this.mTabStrip.getChildAt(position);
    }

    private void addTabView(Tab tab, boolean setSelected) {
        TabView tabView = this.createTabView(tab);
        this.mTabStrip.addView((View)tabView, (ViewGroup.LayoutParams)this.createLayoutParamsForTabs());
        if (setSelected) {
            tabView.setSelected(true);
        }
    }

    private void addTabView(Tab tab, int position, boolean setSelected) {
        TabView tabView = this.createTabView(tab);
        this.mTabStrip.addView((View)tabView, position, (ViewGroup.LayoutParams)this.createLayoutParamsForTabs());
        if (setSelected) {
            tabView.setSelected(true);
        }
    }

    private LinearLayout.LayoutParams createLayoutParamsForTabs() {
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -1);
        this.updateTabViewLayoutParams(lp);
        return lp;
    }

    private void updateTabViewLayoutParams(LinearLayout.LayoutParams lp) {
        if (this.mMode == 1 && this.mTabGravity == 0) {
            lp.width = 0;
            lp.weight = 1.0f;
        } else {
            lp.width = -2;
            lp.weight = 0.0f;
        }
    }

    private int dpToPx(int dps) {
        return Math.round(this.getResources().getDisplayMetrics().density * (float)dps);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int idealHeight = this.dpToPx(this.getDefaultHeight()) + this.getPaddingTop() + this.getPaddingBottom();
        switch (View.MeasureSpec.getMode((int)heightMeasureSpec)) {
            case -2147483648: {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)Math.min(idealHeight, View.MeasureSpec.getSize((int)heightMeasureSpec)), (int)0x40000000);
                break;
            }
            case 0: {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)idealHeight, (int)0x40000000);
            }
        }
        int specWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) != 0) {
            this.mTabMaxWidth = this.mRequestedTabMaxWidth > 0 ? this.mRequestedTabMaxWidth : specWidth - this.dpToPx(56);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.getChildCount() == 1) {
            View child = this.getChildAt(0);
            boolean remeasure = false;
            switch (this.mMode) {
                case 0: {
                    remeasure = child.getMeasuredWidth() < this.getMeasuredWidth();
                    break;
                }
                case 1: {
                    boolean bl = remeasure = child.getMeasuredWidth() != this.getMeasuredWidth();
                }
            }
            if (remeasure) {
                int childHeightMeasureSpec = TabLayout.getChildMeasureSpec((int)heightMeasureSpec, (int)(this.getPaddingTop() + this.getPaddingBottom()), (int)child.getLayoutParams().height);
                int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.getMeasuredWidth(), (int)0x40000000);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
    }

    private void removeTabViewAt(int position) {
        this.mTabStrip.removeViewAt(position);
        this.requestLayout();
    }

    private void animateToTab(int newPosition) {
        int targetScrollX;
        if (newPosition == -1) {
            return;
        }
        if (this.getWindowToken() == null || !ViewCompat.isLaidOut((View)this) || this.mTabStrip.childrenNeedLayout()) {
            this.setScrollPosition(newPosition, 0.0f, true);
            return;
        }
        int startScrollX = this.getScrollX();
        if (startScrollX != (targetScrollX = this.calculateScrollXForTab(newPosition, 0.0f))) {
            if (this.mScrollAnimator == null) {
                this.mScrollAnimator = ViewUtils.createAnimator();
                this.mScrollAnimator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
                this.mScrollAnimator.setDuration(300);
                this.mScrollAnimator.setUpdateListener(new ValueAnimatorCompat.AnimatorUpdateListener(){

                    @Override
                    public void onAnimationUpdate(ValueAnimatorCompat animator) {
                        TabLayout.this.scrollTo(animator.getAnimatedIntValue(), 0);
                    }
                });
            }
            this.mScrollAnimator.setIntValues(startScrollX, targetScrollX);
            this.mScrollAnimator.start();
        }
        this.mTabStrip.animateIndicatorToPosition(newPosition, 300);
    }

    private void setSelectedTabView(int position) {
        int tabCount = this.mTabStrip.getChildCount();
        if (position < tabCount && !this.mTabStrip.getChildAt(position).isSelected()) {
            for (int i = 0; i < tabCount; ++i) {
                View child = this.mTabStrip.getChildAt(i);
                child.setSelected(i == position);
            }
        }
    }

    void selectTab(Tab tab) {
        this.selectTab(tab, true);
    }

    void selectTab(Tab tab, boolean updateIndicator) {
        if (this.mSelectedTab == tab) {
            if (this.mSelectedTab != null) {
                if (this.mOnTabSelectedListener != null) {
                    this.mOnTabSelectedListener.onTabReselected(this.mSelectedTab);
                }
                this.animateToTab(tab.getPosition());
            }
        } else {
            if (updateIndicator) {
                int newPosition;
                int n = newPosition = tab != null ? tab.getPosition() : -1;
                if (newPosition != -1) {
                    this.setSelectedTabView(newPosition);
                }
                if ((this.mSelectedTab == null || this.mSelectedTab.getPosition() == -1) && newPosition != -1) {
                    this.setScrollPosition(newPosition, 0.0f, true);
                } else {
                    this.animateToTab(newPosition);
                }
            }
            if (this.mSelectedTab != null && this.mOnTabSelectedListener != null) {
                this.mOnTabSelectedListener.onTabUnselected(this.mSelectedTab);
            }
            this.mSelectedTab = tab;
            if (this.mSelectedTab != null && this.mOnTabSelectedListener != null) {
                this.mOnTabSelectedListener.onTabSelected(this.mSelectedTab);
            }
        }
    }

    private int calculateScrollXForTab(int position, float positionOffset) {
        if (this.mMode == 0) {
            View selectedChild = this.mTabStrip.getChildAt(position);
            View nextChild = position + 1 < this.mTabStrip.getChildCount() ? this.mTabStrip.getChildAt(position + 1) : null;
            int selectedWidth = selectedChild != null ? selectedChild.getWidth() : 0;
            int nextWidth = nextChild != null ? nextChild.getWidth() : 0;
            return selectedChild.getLeft() + (int)((float)(selectedWidth + nextWidth) * positionOffset * 0.5f) + selectedChild.getWidth() / 2 - this.getWidth() / 2;
        }
        return 0;
    }

    private void applyModeAndGravity() {
        int paddingStart = 0;
        if (this.mMode == 0) {
            paddingStart = Math.max(0, this.mContentInsetStart - this.mTabPaddingStart);
        }
        ViewCompat.setPaddingRelative((View)this.mTabStrip, (int)paddingStart, (int)0, (int)0, (int)0);
        switch (this.mMode) {
            case 1: {
                this.mTabStrip.setGravity(1);
                break;
            }
            case 0: {
                this.mTabStrip.setGravity(0x800003);
            }
        }
        this.updateTabViews(true);
    }

    private void updateTabViews(boolean requestLayout) {
        for (int i = 0; i < this.mTabStrip.getChildCount(); ++i) {
            View child = this.mTabStrip.getChildAt(i);
            child.setMinimumWidth(this.getTabMinWidth());
            this.updateTabViewLayoutParams((LinearLayout.LayoutParams)child.getLayoutParams());
            if (!requestLayout) continue;
            child.requestLayout();
        }
    }

    private static ColorStateList createColorStateList(int defaultColor, int selectedColor) {
        int[][] states = new int[2][];
        int[] colors = new int[2];
        int i = 0;
        states[i] = SELECTED_STATE_SET;
        colors[i] = selectedColor;
        states[++i] = EMPTY_STATE_SET;
        colors[i] = defaultColor;
        ++i;
        return new ColorStateList((int[][])states, colors);
    }

    private int getDefaultHeight() {
        boolean hasIconAndText = false;
        int count = this.mTabs.size();
        for (int i = 0; i < count; ++i) {
            Tab tab = this.mTabs.get(i);
            if (tab == null || tab.getIcon() == null || TextUtils.isEmpty((CharSequence)tab.getText())) continue;
            hasIconAndText = true;
            break;
        }
        return hasIconAndText ? 72 : 48;
    }

    private int getTabMinWidth() {
        if (this.mRequestedTabMinWidth != -1) {
            return this.mRequestedTabMinWidth;
        }
        return this.mMode == 0 ? this.mScrollableTabMinWidth : 0;
    }

    private int getTabMaxWidth() {
        return this.mTabMaxWidth;
    }

    public static class ViewPagerOnTabSelectedListener
    implements OnTabSelectedListener {
        private final ViewPager mViewPager;

        public ViewPagerOnTabSelectedListener(ViewPager viewPager) {
            this.mViewPager = viewPager;
        }

        @Override
        public void onTabSelected(Tab tab) {
            this.mViewPager.setCurrentItem(tab.getPosition());
        }

        @Override
        public void onTabUnselected(Tab tab) {
        }

        @Override
        public void onTabReselected(Tab tab) {
        }
    }

    public static class TabLayoutOnPageChangeListener
    implements ViewPager.OnPageChangeListener {
        private final WeakReference<TabLayout> mTabLayoutRef;
        private int mPreviousScrollState;
        private int mScrollState;

        public TabLayoutOnPageChangeListener(TabLayout tabLayout) {
            this.mTabLayoutRef = new WeakReference<TabLayout>(tabLayout);
        }

        public void onPageScrollStateChanged(int state) {
            this.mPreviousScrollState = this.mScrollState;
            this.mScrollState = state;
        }

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            TabLayout tabLayout = (TabLayout)((Object)this.mTabLayoutRef.get());
            if (tabLayout != null) {
                boolean updateText = this.mScrollState == 1 || this.mScrollState == 2 && this.mPreviousScrollState == 1;
                tabLayout.setScrollPosition(position, positionOffset, updateText);
            }
        }

        public void onPageSelected(int position) {
            TabLayout tabLayout = (TabLayout)((Object)this.mTabLayoutRef.get());
            if (tabLayout != null && tabLayout.getSelectedTabPosition() != position) {
                tabLayout.selectTab(tabLayout.getTabAt(position), this.mScrollState == 0);
            }
        }
    }

    private class SlidingTabStrip
    extends LinearLayout {
        private int mSelectedIndicatorHeight;
        private final Paint mSelectedIndicatorPaint;
        private int mSelectedPosition;
        private float mSelectionOffset;
        private int mIndicatorLeft;
        private int mIndicatorRight;
        private ValueAnimatorCompat mCurrentAnimator;

        SlidingTabStrip(Context context) {
            super(context);
            this.mSelectedPosition = -1;
            this.mIndicatorLeft = -1;
            this.mIndicatorRight = -1;
            this.setWillNotDraw(false);
            this.mSelectedIndicatorPaint = new Paint();
        }

        void setSelectedIndicatorColor(int color2) {
            if (this.mSelectedIndicatorPaint.getColor() != color2) {
                this.mSelectedIndicatorPaint.setColor(color2);
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }

        void setSelectedIndicatorHeight(int height) {
            if (this.mSelectedIndicatorHeight != height) {
                this.mSelectedIndicatorHeight = height;
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }

        boolean childrenNeedLayout() {
            int z = this.getChildCount();
            for (int i = 0; i < z; ++i) {
                View child = this.getChildAt(i);
                if (child.getWidth() > 0) continue;
                return true;
            }
            return false;
        }

        void setIndicatorPositionFromTabPosition(int position, float positionOffset) {
            this.mSelectedPosition = position;
            this.mSelectionOffset = positionOffset;
            this.updateIndicatorPosition();
        }

        float getIndicatorPosition() {
            return (float)this.mSelectedPosition + this.mSelectionOffset;
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if (View.MeasureSpec.getMode((int)widthMeasureSpec) != 0x40000000) {
                return;
            }
            if (TabLayout.this.mMode == 1 && TabLayout.this.mTabGravity == 1) {
                int count = this.getChildCount();
                int largestTabWidth = 0;
                int z = count;
                for (int i = 0; i < z; ++i) {
                    View child = this.getChildAt(i);
                    if (child.getVisibility() != 0) continue;
                    largestTabWidth = Math.max(largestTabWidth, child.getMeasuredWidth());
                }
                if (largestTabWidth <= 0) {
                    return;
                }
                int gutter = TabLayout.this.dpToPx(16);
                boolean remeasure = false;
                if (largestTabWidth * count <= this.getMeasuredWidth() - gutter * 2) {
                    for (int i = 0; i < count; ++i) {
                        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.getChildAt(i).getLayoutParams();
                        if (lp.width == largestTabWidth && lp.weight == 0.0f) continue;
                        lp.width = largestTabWidth;
                        lp.weight = 0.0f;
                        remeasure = true;
                    }
                } else {
                    TabLayout.this.mTabGravity = 0;
                    TabLayout.this.updateTabViews(false);
                    remeasure = true;
                }
                if (remeasure) {
                    super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                }
            }
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
            super.onLayout(changed, l, t, r, b);
            if (this.mCurrentAnimator != null && this.mCurrentAnimator.isRunning()) {
                this.mCurrentAnimator.cancel();
                long duration = this.mCurrentAnimator.getDuration();
                this.animateIndicatorToPosition(this.mSelectedPosition, Math.round((1.0f - this.mCurrentAnimator.getAnimatedFraction()) * (float)duration));
            } else {
                this.updateIndicatorPosition();
            }
        }

        private void updateIndicatorPosition() {
            int right;
            int left;
            View selectedTitle = this.getChildAt(this.mSelectedPosition);
            if (selectedTitle != null && selectedTitle.getWidth() > 0) {
                left = selectedTitle.getLeft();
                right = selectedTitle.getRight();
                if (this.mSelectionOffset > 0.0f && this.mSelectedPosition < this.getChildCount() - 1) {
                    View nextTitle = this.getChildAt(this.mSelectedPosition + 1);
                    left = (int)(this.mSelectionOffset * (float)nextTitle.getLeft() + (1.0f - this.mSelectionOffset) * (float)left);
                    right = (int)(this.mSelectionOffset * (float)nextTitle.getRight() + (1.0f - this.mSelectionOffset) * (float)right);
                }
            } else {
                right = -1;
                left = -1;
            }
            this.setIndicatorPosition(left, right);
        }

        private void setIndicatorPosition(int left, int right) {
            if (left != this.mIndicatorLeft || right != this.mIndicatorRight) {
                this.mIndicatorLeft = left;
                this.mIndicatorRight = right;
                ViewCompat.postInvalidateOnAnimation((View)this);
            }
        }

        void animateIndicatorToPosition(final int position, int duration) {
            int startRight;
            int startLeft;
            boolean isRtl = ViewCompat.getLayoutDirection((View)this) == 1;
            View targetView = this.getChildAt(position);
            final int targetLeft = targetView.getLeft();
            final int targetRight = targetView.getRight();
            if (Math.abs(position - this.mSelectedPosition) <= 1) {
                startLeft = this.mIndicatorLeft;
                startRight = this.mIndicatorRight;
            } else {
                int offset = TabLayout.this.dpToPx(24);
                startLeft = position < this.mSelectedPosition ? (isRtl ? (startRight = targetLeft - offset) : (startRight = targetRight + offset)) : (isRtl ? (startRight = targetRight + offset) : (startRight = targetLeft - offset));
            }
            if (startLeft != targetLeft || startRight != targetRight) {
                ValueAnimatorCompat animator = TabLayout.this.mIndicatorAnimator = ViewUtils.createAnimator();
                animator.setInterpolator(AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR);
                animator.setDuration(duration);
                animator.setFloatValues(0.0f, 1.0f);
                animator.setUpdateListener(new ValueAnimatorCompat.AnimatorUpdateListener(){

                    @Override
                    public void onAnimationUpdate(ValueAnimatorCompat animator) {
                        float fraction = animator.getAnimatedFraction();
                        SlidingTabStrip.this.setIndicatorPosition(AnimationUtils.lerp(startLeft, targetLeft, fraction), AnimationUtils.lerp(startRight, targetRight, fraction));
                    }
                });
                animator.setListener(new ValueAnimatorCompat.AnimatorListenerAdapter(){

                    @Override
                    public void onAnimationEnd(ValueAnimatorCompat animator) {
                        SlidingTabStrip.this.mSelectedPosition = position;
                        SlidingTabStrip.this.mSelectionOffset = 0.0f;
                    }

                    @Override
                    public void onAnimationCancel(ValueAnimatorCompat animator) {
                        SlidingTabStrip.this.mSelectedPosition = position;
                        SlidingTabStrip.this.mSelectionOffset = 0.0f;
                    }
                });
                animator.start();
                this.mCurrentAnimator = animator;
            }
        }

        public void draw(Canvas canvas) {
            super.draw(canvas);
            if (this.mIndicatorLeft >= 0 && this.mIndicatorRight > this.mIndicatorLeft) {
                canvas.drawRect((float)this.mIndicatorLeft, (float)(this.getHeight() - this.mSelectedIndicatorHeight), (float)this.mIndicatorRight, (float)this.getHeight(), this.mSelectedIndicatorPaint);
            }
        }
    }

    class TabView
    extends LinearLayout
    implements View.OnLongClickListener {
        private final Tab mTab;
        private TextView mTextView;
        private ImageView mIconView;
        private View mCustomView;
        private TextView mCustomTextView;
        private ImageView mCustomIconView;
        private int mDefaultMaxLines;

        public TabView(Context context, Tab tab) {
            super(context);
            this.mDefaultMaxLines = 2;
            this.mTab = tab;
            if (TabLayout.this.mTabBackgroundResId != 0) {
                this.setBackgroundDrawable(TintManager.getDrawable((Context)context, (int)TabLayout.this.mTabBackgroundResId));
            }
            ViewCompat.setPaddingRelative((View)this, (int)TabLayout.this.mTabPaddingStart, (int)TabLayout.this.mTabPaddingTop, (int)TabLayout.this.mTabPaddingEnd, (int)TabLayout.this.mTabPaddingBottom);
            this.setGravity(17);
            this.setOrientation(1);
            this.update();
        }

        public void setSelected(boolean selected) {
            boolean changed = this.isSelected() != selected;
            super.setSelected(selected);
            if (changed && selected) {
                this.sendAccessibilityEvent(4);
                if (this.mTextView != null) {
                    this.mTextView.setSelected(selected);
                }
                if (this.mIconView != null) {
                    this.mIconView.setSelected(selected);
                }
            }
        }

        @TargetApi(value=14)
        public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
            super.onInitializeAccessibilityEvent(event);
            event.setClassName((CharSequence)ActionBar.Tab.class.getName());
        }

        @TargetApi(value=14)
        public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
            super.onInitializeAccessibilityNodeInfo(info);
            info.setClassName((CharSequence)ActionBar.Tab.class.getName());
        }

        public void onMeasure(int origWidthMeasureSpec, int origHeightMeasureSpec) {
            int specWidthSize = View.MeasureSpec.getSize((int)origWidthMeasureSpec);
            int specWidthMode = View.MeasureSpec.getMode((int)origWidthMeasureSpec);
            int maxWidth = TabLayout.this.getTabMaxWidth();
            int heightMeasureSpec = origHeightMeasureSpec;
            int widthMeasureSpec = maxWidth > 0 && (specWidthMode == 0 || specWidthSize > maxWidth) ? View.MeasureSpec.makeMeasureSpec((int)TabLayout.this.mTabMaxWidth, (int)specWidthMode) : origWidthMeasureSpec;
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            if (this.mTextView != null) {
                Resources res = this.getResources();
                float textSize = TabLayout.this.mTabTextSize;
                int maxLines = this.mDefaultMaxLines;
                if (this.mIconView != null && this.mIconView.getVisibility() == 0) {
                    maxLines = 1;
                } else if (this.mTextView != null && this.mTextView.getLineCount() > 1) {
                    textSize = TabLayout.this.mTabTextMultiLineSize;
                }
                float curTextSize = this.mTextView.getTextSize();
                int curLineCount = this.mTextView.getLineCount();
                int curMaxLines = TextViewCompat.getMaxLines((TextView)this.mTextView);
                if (textSize != curTextSize || curMaxLines >= 0 && maxLines != curMaxLines) {
                    Layout layout2;
                    boolean updateTextView = true;
                    if (TabLayout.this.mMode == 1 && textSize > curTextSize && curLineCount == 1 && ((layout2 = this.mTextView.getLayout()) == null || this.approximateLineWidth(layout2, 0, textSize) > (float)layout2.getWidth())) {
                        updateTextView = false;
                    }
                    if (updateTextView) {
                        this.mTextView.setTextSize(0, textSize);
                        this.mTextView.setMaxLines(maxLines);
                        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                    }
                }
            }
        }

        final void update() {
            Tab tab = this.mTab;
            View custom = tab.getCustomView();
            if (custom != null) {
                ViewParent customParent = custom.getParent();
                if (customParent != this) {
                    if (customParent != null) {
                        ((ViewGroup)customParent).removeView(custom);
                    }
                    this.addView(custom);
                }
                this.mCustomView = custom;
                if (this.mTextView != null) {
                    this.mTextView.setVisibility(8);
                }
                if (this.mIconView != null) {
                    this.mIconView.setVisibility(8);
                    this.mIconView.setImageDrawable(null);
                }
                this.mCustomTextView = (TextView)custom.findViewById(16908308);
                if (this.mCustomTextView != null) {
                    this.mDefaultMaxLines = TextViewCompat.getMaxLines((TextView)this.mCustomTextView);
                }
                this.mCustomIconView = (ImageView)custom.findViewById(16908294);
            } else {
                if (this.mCustomView != null) {
                    this.removeView(this.mCustomView);
                    this.mCustomView = null;
                }
                this.mCustomTextView = null;
                this.mCustomIconView = null;
            }
            if (this.mCustomView == null) {
                if (this.mIconView == null) {
                    ImageView iconView = (ImageView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.design_layout_tab_icon, (ViewGroup)this, false);
                    this.addView((View)iconView, 0);
                    this.mIconView = iconView;
                }
                if (this.mTextView == null) {
                    TextView textView = (TextView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.design_layout_tab_text, (ViewGroup)this, false);
                    this.addView((View)textView);
                    this.mTextView = textView;
                    this.mDefaultMaxLines = TextViewCompat.getMaxLines((TextView)this.mTextView);
                }
                this.mTextView.setTextAppearance(this.getContext(), TabLayout.this.mTabTextAppearance);
                if (TabLayout.this.mTabTextColors != null) {
                    this.mTextView.setTextColor(TabLayout.this.mTabTextColors);
                }
                this.updateTextAndIcon(tab, this.mTextView, this.mIconView);
            } else if (this.mCustomTextView != null || this.mCustomIconView != null) {
                this.updateTextAndIcon(tab, this.mCustomTextView, this.mCustomIconView);
            }
        }

        private void updateTextAndIcon(Tab tab, TextView textView, ImageView iconView) {
            boolean hasText;
            Drawable icon = tab.getIcon();
            CharSequence text = tab.getText();
            if (iconView != null) {
                if (icon != null) {
                    iconView.setImageDrawable(icon);
                    iconView.setVisibility(0);
                    this.setVisibility(0);
                } else {
                    iconView.setVisibility(8);
                    iconView.setImageDrawable(null);
                }
                iconView.setContentDescription(tab.getContentDescription());
            }
            boolean bl = hasText = !TextUtils.isEmpty((CharSequence)text);
            if (textView != null) {
                if (hasText) {
                    textView.setText(text);
                    textView.setContentDescription(tab.getContentDescription());
                    textView.setVisibility(0);
                    this.setVisibility(0);
                } else {
                    textView.setVisibility(8);
                    textView.setText(null);
                }
            }
            if (iconView != null) {
                ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)iconView.getLayoutParams();
                int bottomMargin = 0;
                if (hasText && iconView.getVisibility() == 0) {
                    bottomMargin = TabLayout.this.dpToPx(8);
                }
                if (bottomMargin != lp.bottomMargin) {
                    lp.bottomMargin = bottomMargin;
                    iconView.requestLayout();
                }
            }
            if (!hasText && !TextUtils.isEmpty((CharSequence)tab.getContentDescription())) {
                this.setOnLongClickListener(this);
            } else {
                this.setOnLongClickListener(null);
                this.setLongClickable(false);
            }
        }

        public boolean onLongClick(View v) {
            int[] screenPos = new int[2];
            this.getLocationOnScreen(screenPos);
            Context context = this.getContext();
            int width = this.getWidth();
            int height = this.getHeight();
            int screenWidth = context.getResources().getDisplayMetrics().widthPixels;
            Toast cheatSheet = Toast.makeText((Context)context, (CharSequence)this.mTab.getContentDescription(), (int)0);
            cheatSheet.setGravity(49, screenPos[0] + width / 2 - screenWidth / 2, height);
            cheatSheet.show();
            return true;
        }

        public Tab getTab() {
            return this.mTab;
        }

        private float approximateLineWidth(Layout layout2, int line, float textSize) {
            return layout2.getLineWidth(line) * (textSize / layout2.getPaint().getTextSize());
        }
    }

    public static final class Tab {
        public static final int INVALID_POSITION = -1;
        private Object mTag;
        private Drawable mIcon;
        private CharSequence mText;
        private CharSequence mContentDesc;
        private int mPosition = -1;
        private View mCustomView;
        private final TabLayout mParent;

        Tab(TabLayout parent) {
            this.mParent = parent;
        }

        @Nullable
        public Object getTag() {
            return this.mTag;
        }

        @NonNull
        public Tab setTag(@Nullable Object tag) {
            this.mTag = tag;
            return this;
        }

        @Nullable
        public View getCustomView() {
            return this.mCustomView;
        }

        @NonNull
        public Tab setCustomView(@Nullable View view) {
            this.mCustomView = view;
            if (this.mPosition >= 0) {
                this.mParent.updateTab(this.mPosition);
            }
            return this;
        }

        @NonNull
        public Tab setCustomView(@LayoutRes int resId) {
            TabView tabView = this.mParent.getTabView(this.mPosition);
            LayoutInflater inflater = LayoutInflater.from((Context)tabView.getContext());
            return this.setCustomView(inflater.inflate(resId, (ViewGroup)tabView, false));
        }

        @Nullable
        public Drawable getIcon() {
            return this.mIcon;
        }

        public int getPosition() {
            return this.mPosition;
        }

        void setPosition(int position) {
            this.mPosition = position;
        }

        @Nullable
        public CharSequence getText() {
            return this.mText;
        }

        @NonNull
        public Tab setIcon(@Nullable Drawable icon) {
            this.mIcon = icon;
            if (this.mPosition >= 0) {
                this.mParent.updateTab(this.mPosition);
            }
            return this;
        }

        @NonNull
        public Tab setIcon(@DrawableRes int resId) {
            return this.setIcon(TintManager.getDrawable((Context)this.mParent.getContext(), (int)resId));
        }

        @NonNull
        public Tab setText(@Nullable CharSequence text) {
            this.mText = text;
            if (this.mPosition >= 0) {
                this.mParent.updateTab(this.mPosition);
            }
            return this;
        }

        @NonNull
        public Tab setText(@StringRes int resId) {
            return this.setText(this.mParent.getResources().getText(resId));
        }

        public void select() {
            this.mParent.selectTab(this);
        }

        public boolean isSelected() {
            return this.mParent.getSelectedTabPosition() == this.mPosition;
        }

        @NonNull
        public Tab setContentDescription(@StringRes int resId) {
            return this.setContentDescription(this.mParent.getResources().getText(resId));
        }

        @NonNull
        public Tab setContentDescription(@Nullable CharSequence contentDesc) {
            this.mContentDesc = contentDesc;
            if (this.mPosition >= 0) {
                this.mParent.updateTab(this.mPosition);
            }
            return this;
        }

        @Nullable
        public CharSequence getContentDescription() {
            return this.mContentDesc;
        }
    }

    public static interface OnTabSelectedListener {
        public void onTabSelected(Tab var1);

        public void onTabUnselected(Tab var1);

        public void onTabReselected(Tab var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface TabGravity {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Mode {
    }
}

