/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.ColorInt;
import android.support.annotation.DrawableRes;
import android.support.annotation.FloatRange;
import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.design.R;
import android.support.design.widget.DirectedAcyclicGraph;
import android.support.design.widget.MathUtils;
import android.support.design.widget.ThemeUtils;
import android.support.design.widget.ViewGroupUtils;
import android.support.design.widget.ViewUtils;
import android.support.v4.content.ContextCompat;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.os.ParcelableCompat;
import android.support.v4.os.ParcelableCompatCreatorCallbacks;
import android.support.v4.util.Pools;
import android.support.v4.view.AbsSavedState;
import android.support.v4.view.GravityCompat;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.OnApplyWindowInsetsListener;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.WindowInsetsCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CoordinatorLayout
extends ViewGroup
implements NestedScrollingParent {
    static final String TAG = "CoordinatorLayout";
    static final String WIDGET_PACKAGE_NAME;
    private static final int TYPE_ON_INTERCEPT = 0;
    private static final int TYPE_ON_TOUCH = 1;
    static final Class<?>[] CONSTRUCTOR_PARAMS;
    static final ThreadLocal<Map<String, Constructor<Behavior>>> sConstructors;
    static final int EVENT_PRE_DRAW = 0;
    static final int EVENT_NESTED_SCROLL = 1;
    static final int EVENT_VIEW_REMOVED = 2;
    static final Comparator<View> TOP_SORTED_CHILDREN_COMPARATOR;
    private static final Pools.Pool<Rect> sRectPool;
    private final List<View> mDependencySortedChildren = new ArrayList<View>();
    private final DirectedAcyclicGraph<View> mChildDag = new DirectedAcyclicGraph();
    private final List<View> mTempList1 = new ArrayList<View>();
    private final List<View> mTempDependenciesList = new ArrayList<View>();
    private final int[] mTempIntPair = new int[2];
    private Paint mScrimPaint;
    private boolean mDisallowInterceptReset;
    private boolean mIsAttachedToWindow;
    private int[] mKeylines;
    private View mBehaviorTouchView;
    private View mNestedScrollingDirectChild;
    private View mNestedScrollingTarget;
    private OnPreDrawListener mOnPreDrawListener;
    private boolean mNeedsPreDrawListener;
    private WindowInsetsCompat mLastInsets;
    private boolean mDrawStatusBarBackground;
    private Drawable mStatusBarBackground;
    ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;
    private OnApplyWindowInsetsListener mApplyWindowInsetsListener;
    private final NestedScrollingParentHelper mNestedScrollingParentHelper = new NestedScrollingParentHelper((ViewGroup)this);

    @NonNull
    private static Rect acquireTempRect() {
        Rect rect = (Rect)sRectPool.acquire();
        if (rect == null) {
            rect = new Rect();
        }
        return rect;
    }

    private static void releaseTempRect(@NonNull Rect rect) {
        rect.setEmpty();
        sRectPool.release((Object)rect);
    }

    public CoordinatorLayout(Context context) {
        this(context, null);
    }

    public CoordinatorLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public CoordinatorLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        ThemeUtils.checkAppCompatTheme(context);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CoordinatorLayout, defStyleAttr, R.style.Widget_Design_CoordinatorLayout);
        int keylineArrayRes = a.getResourceId(R.styleable.CoordinatorLayout_keylines, 0);
        if (keylineArrayRes != 0) {
            Resources res = context.getResources();
            this.mKeylines = res.getIntArray(keylineArrayRes);
            float density = res.getDisplayMetrics().density;
            int count = this.mKeylines.length;
            int i = 0;
            while (i < count) {
                int n = i++;
                this.mKeylines[n] = (int)((float)this.mKeylines[n] * density);
            }
        }
        this.mStatusBarBackground = a.getDrawable(R.styleable.CoordinatorLayout_statusBarBackground);
        a.recycle();
        this.setupForInsets();
        super.setOnHierarchyChangeListener((ViewGroup.OnHierarchyChangeListener)new HierarchyChangeListener());
    }

    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
        this.mOnHierarchyChangeListener = onHierarchyChangeListener;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.resetTouchBehaviors();
        if (this.mNeedsPreDrawListener) {
            if (this.mOnPreDrawListener == null) {
                this.mOnPreDrawListener = new OnPreDrawListener();
            }
            ViewTreeObserver vto = this.getViewTreeObserver();
            vto.addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.mOnPreDrawListener);
        }
        if (this.mLastInsets == null && ViewCompat.getFitsSystemWindows((View)this)) {
            ViewCompat.requestApplyInsets((View)this);
        }
        this.mIsAttachedToWindow = true;
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.resetTouchBehaviors();
        if (this.mNeedsPreDrawListener && this.mOnPreDrawListener != null) {
            ViewTreeObserver vto = this.getViewTreeObserver();
            vto.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.mOnPreDrawListener);
        }
        if (this.mNestedScrollingTarget != null) {
            this.onStopNestedScroll(this.mNestedScrollingTarget);
        }
        this.mIsAttachedToWindow = false;
    }

    public void setStatusBarBackground(@Nullable Drawable bg) {
        if (this.mStatusBarBackground != bg) {
            if (this.mStatusBarBackground != null) {
                this.mStatusBarBackground.setCallback(null);
            }
            Drawable drawable = this.mStatusBarBackground = bg != null ? bg.mutate() : null;
            if (this.mStatusBarBackground != null) {
                if (this.mStatusBarBackground.isStateful()) {
                    this.mStatusBarBackground.setState(this.getDrawableState());
                }
                DrawableCompat.setLayoutDirection((Drawable)this.mStatusBarBackground, (int)ViewCompat.getLayoutDirection((View)this));
                this.mStatusBarBackground.setVisible(this.getVisibility() == 0, false);
                this.mStatusBarBackground.setCallback((Drawable.Callback)this);
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    @Nullable
    public Drawable getStatusBarBackground() {
        return this.mStatusBarBackground;
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        int[] state = this.getDrawableState();
        boolean changed = false;
        Drawable d = this.mStatusBarBackground;
        if (d != null && d.isStateful()) {
            changed |= d.setState(state);
        }
        if (changed) {
            this.invalidate();
        }
    }

    protected boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.mStatusBarBackground;
    }

    public void setVisibility(int visibility) {
        boolean visible;
        super.setVisibility(visibility);
        boolean bl = visible = visibility == 0;
        if (this.mStatusBarBackground != null && this.mStatusBarBackground.isVisible() != visible) {
            this.mStatusBarBackground.setVisible(visible, false);
        }
    }

    public void setStatusBarBackgroundResource(@DrawableRes int resId) {
        this.setStatusBarBackground(resId != 0 ? ContextCompat.getDrawable((Context)this.getContext(), (int)resId) : null);
    }

    public void setStatusBarBackgroundColor(@ColorInt int color2) {
        this.setStatusBarBackground((Drawable)new ColorDrawable(color2));
    }

    final WindowInsetsCompat setWindowInsets(WindowInsetsCompat insets) {
        if (!ViewUtils.objectEquals(this.mLastInsets, insets)) {
            this.mLastInsets = insets;
            this.mDrawStatusBarBackground = insets != null && insets.getSystemWindowInsetTop() > 0;
            this.setWillNotDraw(!this.mDrawStatusBarBackground && this.getBackground() == null);
            insets = this.dispatchApplyWindowInsetsToBehaviors(insets);
            this.requestLayout();
        }
        return insets;
    }

    final WindowInsetsCompat getLastWindowInsets() {
        return this.mLastInsets;
    }

    private void resetTouchBehaviors() {
        if (this.mBehaviorTouchView != null) {
            Behavior b = ((LayoutParams)this.mBehaviorTouchView.getLayoutParams()).getBehavior();
            if (b != null) {
                long now = SystemClock.uptimeMillis();
                MotionEvent cancelEvent = MotionEvent.obtain((long)now, (long)now, (int)3, (float)0.0f, (float)0.0f, (int)0);
                b.onTouchEvent(this, this.mBehaviorTouchView, cancelEvent);
                cancelEvent.recycle();
            }
            this.mBehaviorTouchView = null;
        }
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            lp.resetTouchBehaviorTracking();
        }
        this.mDisallowInterceptReset = false;
    }

    private void getTopSortedChildren(List<View> out) {
        out.clear();
        boolean useCustomOrder = this.isChildrenDrawingOrderEnabled();
        int childCount = this.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            int childIndex = useCustomOrder ? this.getChildDrawingOrder(childCount, i) : i;
            View child = this.getChildAt(childIndex);
            out.add(child);
        }
        if (TOP_SORTED_CHILDREN_COMPARATOR != null) {
            Collections.sort(out, TOP_SORTED_CHILDREN_COMPARATOR);
        }
    }

    private boolean performIntercept(MotionEvent ev, int type) {
        boolean intercepted = false;
        boolean newBlock = false;
        MotionEvent cancelEvent = null;
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        List<View> topmostChildList = this.mTempList1;
        this.getTopSortedChildren(topmostChildList);
        int childCount = topmostChildList.size();
        for (int i = 0; i < childCount; ++i) {
            View child = topmostChildList.get(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            Behavior b = lp.getBehavior();
            if ((intercepted || newBlock) && action != 0) {
                if (b == null) continue;
                if (cancelEvent == null) {
                    long now = SystemClock.uptimeMillis();
                    cancelEvent = MotionEvent.obtain((long)now, (long)now, (int)3, (float)0.0f, (float)0.0f, (int)0);
                }
                switch (type) {
                    case 0: {
                        b.onInterceptTouchEvent(this, child, cancelEvent);
                        break;
                    }
                    case 1: {
                        b.onTouchEvent(this, child, cancelEvent);
                    }
                }
                continue;
            }
            if (!intercepted && b != null) {
                switch (type) {
                    case 0: {
                        intercepted = b.onInterceptTouchEvent(this, child, ev);
                        break;
                    }
                    case 1: {
                        intercepted = b.onTouchEvent(this, child, ev);
                    }
                }
                if (intercepted) {
                    this.mBehaviorTouchView = child;
                }
            }
            boolean wasBlocking = lp.didBlockInteraction();
            boolean isBlocking = lp.isBlockingInteractionBelow(this, child);
            boolean bl = newBlock = isBlocking && !wasBlocking;
            if (isBlocking && !newBlock) break;
        }
        topmostChildList.clear();
        return intercepted;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        Object cancelEvent = null;
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        if (action == 0) {
            this.resetTouchBehaviors();
        }
        boolean intercepted = this.performIntercept(ev, 0);
        if (cancelEvent != null) {
            cancelEvent.recycle();
        }
        if (action == 1 || action == 3) {
            this.resetTouchBehaviors();
        }
        return intercepted;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        LayoutParams lp;
        Behavior b;
        boolean handled = false;
        boolean cancelSuper = false;
        MotionEvent cancelEvent = null;
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        if ((this.mBehaviorTouchView != null || (cancelSuper = this.performIntercept(ev, 1))) && (b = (lp = (LayoutParams)this.mBehaviorTouchView.getLayoutParams()).getBehavior()) != null) {
            handled = b.onTouchEvent(this, this.mBehaviorTouchView, ev);
        }
        if (this.mBehaviorTouchView == null) {
            handled |= super.onTouchEvent(ev);
        } else if (cancelSuper) {
            if (cancelEvent == null) {
                long now = SystemClock.uptimeMillis();
                cancelEvent = MotionEvent.obtain((long)now, (long)now, (int)3, (float)0.0f, (float)0.0f, (int)0);
            }
            super.onTouchEvent(cancelEvent);
        }
        if (handled || action == 0) {
            // empty if block
        }
        if (cancelEvent != null) {
            cancelEvent.recycle();
        }
        if (action == 1 || action == 3) {
            this.resetTouchBehaviors();
        }
        return handled;
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
        if (disallowIntercept && !this.mDisallowInterceptReset) {
            this.resetTouchBehaviors();
            this.mDisallowInterceptReset = true;
        }
    }

    private int getKeyline(int index) {
        if (this.mKeylines == null) {
            Log.e((String)TAG, (String)("No keylines defined for " + (Object)((Object)this) + " - attempted index lookup " + index));
            return 0;
        }
        if (index < 0 || index >= this.mKeylines.length) {
            Log.e((String)TAG, (String)("Keyline index " + index + " out of range for " + (Object)((Object)this)));
            return 0;
        }
        return this.mKeylines[index];
    }

    static Behavior parseBehavior(Context context, AttributeSet attrs, String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        String fullName = name.startsWith(".") ? context.getPackageName() + name : (name.indexOf(46) >= 0 ? name : (!TextUtils.isEmpty((CharSequence)WIDGET_PACKAGE_NAME) ? WIDGET_PACKAGE_NAME + '.' + name : name));
        try {
            Constructor<Behavior<Object>> c;
            Map<String, Constructor<Behavior>> constructors = sConstructors.get();
            if (constructors == null) {
                constructors = new HashMap<String, Constructor<Behavior>>();
                sConstructors.set(constructors);
            }
            if ((c = constructors.get(fullName)) == null) {
                Class<?> clazz = Class.forName(fullName, true, context.getClassLoader());
                c = clazz.getConstructor(CONSTRUCTOR_PARAMS);
                c.setAccessible(true);
                constructors.put(fullName, c);
            }
            return c.newInstance(context, attrs);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not inflate Behavior subclass " + fullName, e);
        }
    }

    LayoutParams getResolvedLayoutParams(View child) {
        LayoutParams result = (LayoutParams)child.getLayoutParams();
        if (!result.mBehaviorResolved) {
            DefaultBehavior defaultBehavior = null;
            for (Class<?> childClass = child.getClass(); childClass != null && (defaultBehavior = childClass.getAnnotation(DefaultBehavior.class)) == null; childClass = childClass.getSuperclass()) {
            }
            if (defaultBehavior != null) {
                try {
                    result.setBehavior(defaultBehavior.value().newInstance());
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)("Default behavior class " + defaultBehavior.value().getName() + " could not be instantiated. Did you forget a default constructor?"), (Throwable)e);
                }
            }
            result.mBehaviorResolved = true;
        }
        return result;
    }

    private void prepareChildren() {
        this.mDependencySortedChildren.clear();
        this.mChildDag.clear();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = this.getChildAt(i);
            LayoutParams lp = this.getResolvedLayoutParams(view);
            lp.findAnchorView(this, view);
            this.mChildDag.addNode(view);
            for (int j = 0; j < count; ++j) {
                View other;
                LayoutParams otherLp;
                if (j == i || !(otherLp = this.getResolvedLayoutParams(other = this.getChildAt(j))).dependsOn(this, other, view)) continue;
                if (!this.mChildDag.contains(other)) {
                    this.mChildDag.addNode(other);
                }
                this.mChildDag.addEdge(view, other);
            }
        }
        this.mDependencySortedChildren.addAll(this.mChildDag.getSortedList());
        Collections.reverse(this.mDependencySortedChildren);
    }

    void getDescendantRect(View descendant, Rect out) {
        ViewGroupUtils.getDescendantRect(this, descendant, out);
    }

    protected int getSuggestedMinimumWidth() {
        return Math.max(super.getSuggestedMinimumWidth(), this.getPaddingLeft() + this.getPaddingRight());
    }

    protected int getSuggestedMinimumHeight() {
        return Math.max(super.getSuggestedMinimumHeight(), this.getPaddingTop() + this.getPaddingBottom());
    }

    public void onMeasureChild(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        this.measureChildWithMargins(child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.prepareChildren();
        this.ensurePreDrawListener();
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        int layoutDirection = ViewCompat.getLayoutDirection((View)this);
        boolean isRtl = layoutDirection == 1;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int widthPadding = paddingLeft + paddingRight;
        int heightPadding = paddingTop + paddingBottom;
        int widthUsed = this.getSuggestedMinimumWidth();
        int heightUsed = this.getSuggestedMinimumHeight();
        int childState = 0;
        boolean applyInsets = this.mLastInsets != null && ViewCompat.getFitsSystemWindows((View)this);
        int childCount = this.mDependencySortedChildren.size();
        for (int i = 0; i < childCount; ++i) {
            Behavior b;
            View child = this.mDependencySortedChildren.get(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int keylineWidthUsed = 0;
            if (lp.keyline >= 0 && widthMode != 0) {
                int keylinePos = this.getKeyline(lp.keyline);
                int keylineGravity = GravityCompat.getAbsoluteGravity((int)CoordinatorLayout.resolveKeylineGravity(lp.gravity), (int)layoutDirection) & 7;
                if (keylineGravity == 3 && !isRtl || keylineGravity == 5 && isRtl) {
                    keylineWidthUsed = Math.max(0, widthSize - paddingRight - keylinePos);
                } else if (keylineGravity == 5 && !isRtl || keylineGravity == 3 && isRtl) {
                    keylineWidthUsed = Math.max(0, keylinePos - paddingLeft);
                }
            }
            int childWidthMeasureSpec = widthMeasureSpec;
            int childHeightMeasureSpec = heightMeasureSpec;
            if (applyInsets && !ViewCompat.getFitsSystemWindows((View)child)) {
                int horizInsets = this.mLastInsets.getSystemWindowInsetLeft() + this.mLastInsets.getSystemWindowInsetRight();
                int vertInsets = this.mLastInsets.getSystemWindowInsetTop() + this.mLastInsets.getSystemWindowInsetBottom();
                childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(widthSize - horizInsets), (int)widthMode);
                childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(heightSize - vertInsets), (int)heightMode);
            }
            if ((b = lp.getBehavior()) == null || !b.onMeasureChild(this, child, childWidthMeasureSpec, keylineWidthUsed, childHeightMeasureSpec, 0)) {
                this.onMeasureChild(child, childWidthMeasureSpec, keylineWidthUsed, childHeightMeasureSpec, 0);
            }
            widthUsed = Math.max(widthUsed, widthPadding + child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
            heightUsed = Math.max(heightUsed, heightPadding + child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
            childState = ViewCompat.combineMeasuredStates((int)childState, (int)ViewCompat.getMeasuredState((View)child));
        }
        int width = ViewCompat.resolveSizeAndState((int)widthUsed, (int)widthMeasureSpec, (int)(childState & 0xFF000000));
        int height = ViewCompat.resolveSizeAndState((int)heightUsed, (int)heightMeasureSpec, (int)(childState << 16));
        this.setMeasuredDimension(width, height);
    }

    private WindowInsetsCompat dispatchApplyWindowInsetsToBehaviors(WindowInsetsCompat insets) {
        LayoutParams lp;
        Behavior b;
        View child;
        if (insets.isConsumed()) {
            return insets;
        }
        int z = this.getChildCount();
        for (int i = 0; !(i >= z || ViewCompat.getFitsSystemWindows((View)(child = this.getChildAt(i))) && (b = (lp = (LayoutParams)child.getLayoutParams()).getBehavior()) != null && (insets = b.onApplyWindowInsets(this, child, insets)).isConsumed()); ++i) {
        }
        return insets;
    }

    public void onLayoutChild(View child, int layoutDirection) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp.checkAnchorChanged()) {
            throw new IllegalStateException("An anchor may not be changed after CoordinatorLayout measurement begins before layout is complete.");
        }
        if (lp.mAnchorView != null) {
            this.layoutChildWithAnchor(child, lp.mAnchorView, layoutDirection);
        } else if (lp.keyline >= 0) {
            this.layoutChildWithKeyline(child, lp.keyline, layoutDirection);
        } else {
            this.layoutChild(child, layoutDirection);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int layoutDirection = ViewCompat.getLayoutDirection((View)this);
        int childCount = this.mDependencySortedChildren.size();
        for (int i = 0; i < childCount; ++i) {
            LayoutParams lp;
            Behavior behavior;
            View child = this.mDependencySortedChildren.get(i);
            if (child.getVisibility() == 8 || (behavior = (lp = (LayoutParams)child.getLayoutParams()).getBehavior()) != null && behavior.onLayoutChild(this, child, layoutDirection)) continue;
            this.onLayoutChild(child, layoutDirection);
        }
    }

    public void onDraw(Canvas c) {
        super.onDraw(c);
        if (this.mDrawStatusBarBackground && this.mStatusBarBackground != null) {
            int inset;
            int n = inset = this.mLastInsets != null ? this.mLastInsets.getSystemWindowInsetTop() : 0;
            if (inset > 0) {
                this.mStatusBarBackground.setBounds(0, 0, this.getWidth(), inset);
                this.mStatusBarBackground.draw(c);
            }
        }
    }

    public void setFitsSystemWindows(boolean fitSystemWindows) {
        super.setFitsSystemWindows(fitSystemWindows);
        this.setupForInsets();
    }

    void recordLastChildRect(View child, Rect r) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        lp.setLastChildRect(r);
    }

    void getLastChildRect(View child, Rect out) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        out.set(lp.getLastChildRect());
    }

    void getChildRect(View child, boolean transform, Rect out) {
        if (child.isLayoutRequested() || child.getVisibility() == 8) {
            out.setEmpty();
            return;
        }
        if (transform) {
            this.getDescendantRect(child, out);
        } else {
            out.set(child.getLeft(), child.getTop(), child.getRight(), child.getBottom());
        }
    }

    private void getDesiredAnchoredChildRectWithoutConstraints(View child, int layoutDirection, Rect anchorRect, Rect out, LayoutParams lp, int childWidth, int childHeight) {
        int top;
        int left;
        int absGravity = GravityCompat.getAbsoluteGravity((int)CoordinatorLayout.resolveAnchoredChildGravity(lp.gravity), (int)layoutDirection);
        int absAnchorGravity = GravityCompat.getAbsoluteGravity((int)CoordinatorLayout.resolveGravity(lp.anchorGravity), (int)layoutDirection);
        int hgrav = absGravity & 7;
        int vgrav = absGravity & 0x70;
        int anchorHgrav = absAnchorGravity & 7;
        int anchorVgrav = absAnchorGravity & 0x70;
        switch (anchorHgrav) {
            default: {
                left = anchorRect.left;
                break;
            }
            case 5: {
                left = anchorRect.right;
                break;
            }
            case 1: {
                left = anchorRect.left + anchorRect.width() / 2;
            }
        }
        switch (anchorVgrav) {
            default: {
                top = anchorRect.top;
                break;
            }
            case 80: {
                top = anchorRect.bottom;
                break;
            }
            case 16: {
                top = anchorRect.top + anchorRect.height() / 2;
            }
        }
        switch (hgrav) {
            default: {
                left -= childWidth;
                break;
            }
            case 5: {
                break;
            }
            case 1: {
                left -= childWidth / 2;
            }
        }
        switch (vgrav) {
            default: {
                top -= childHeight;
                break;
            }
            case 80: {
                break;
            }
            case 16: {
                top -= childHeight / 2;
            }
        }
        out.set(left, top, left + childWidth, top + childHeight);
    }

    private void constrainChildRect(LayoutParams lp, Rect out, int childWidth, int childHeight) {
        int width = this.getWidth();
        int height = this.getHeight();
        int left = Math.max(this.getPaddingLeft() + lp.leftMargin, Math.min(out.left, width - this.getPaddingRight() - childWidth - lp.rightMargin));
        int top = Math.max(this.getPaddingTop() + lp.topMargin, Math.min(out.top, height - this.getPaddingBottom() - childHeight - lp.bottomMargin));
        out.set(left, top, left + childWidth, top + childHeight);
    }

    void getDesiredAnchoredChildRect(View child, int layoutDirection, Rect anchorRect, Rect out) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        int childWidth = child.getMeasuredWidth();
        int childHeight = child.getMeasuredHeight();
        this.getDesiredAnchoredChildRectWithoutConstraints(child, layoutDirection, anchorRect, out, lp, childWidth, childHeight);
        this.constrainChildRect(lp, out, childWidth, childHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void layoutChildWithAnchor(View child, View anchor, int layoutDirection) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        Rect anchorRect = CoordinatorLayout.acquireTempRect();
        Rect childRect = CoordinatorLayout.acquireTempRect();
        try {
            this.getDescendantRect(anchor, anchorRect);
            this.getDesiredAnchoredChildRect(child, layoutDirection, anchorRect, childRect);
            child.layout(childRect.left, childRect.top, childRect.right, childRect.bottom);
        }
        finally {
            CoordinatorLayout.releaseTempRect(anchorRect);
            CoordinatorLayout.releaseTempRect(childRect);
        }
    }

    private void layoutChildWithKeyline(View child, int keyline, int layoutDirection) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        int absGravity = GravityCompat.getAbsoluteGravity((int)CoordinatorLayout.resolveKeylineGravity(lp.gravity), (int)layoutDirection);
        int hgrav = absGravity & 7;
        int vgrav = absGravity & 0x70;
        int width = this.getWidth();
        int height = this.getHeight();
        int childWidth = child.getMeasuredWidth();
        int childHeight = child.getMeasuredHeight();
        if (layoutDirection == 1) {
            keyline = width - keyline;
        }
        int left = this.getKeyline(keyline) - childWidth;
        int top = 0;
        switch (hgrav) {
            default: {
                break;
            }
            case 5: {
                left += childWidth;
                break;
            }
            case 1: {
                left += childWidth / 2;
            }
        }
        switch (vgrav) {
            default: {
                break;
            }
            case 80: {
                top += childHeight;
                break;
            }
            case 16: {
                top += childHeight / 2;
            }
        }
        left = Math.max(this.getPaddingLeft() + lp.leftMargin, Math.min(left, width - this.getPaddingRight() - childWidth - lp.rightMargin));
        top = Math.max(this.getPaddingTop() + lp.topMargin, Math.min(top, height - this.getPaddingBottom() - childHeight - lp.bottomMargin));
        child.layout(left, top, left + childWidth, top + childHeight);
    }

    private void layoutChild(View child, int layoutDirection) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        Rect parent = CoordinatorLayout.acquireTempRect();
        parent.set(this.getPaddingLeft() + lp.leftMargin, this.getPaddingTop() + lp.topMargin, this.getWidth() - this.getPaddingRight() - lp.rightMargin, this.getHeight() - this.getPaddingBottom() - lp.bottomMargin);
        if (this.mLastInsets != null && ViewCompat.getFitsSystemWindows((View)this) && !ViewCompat.getFitsSystemWindows((View)child)) {
            parent.left += this.mLastInsets.getSystemWindowInsetLeft();
            parent.top += this.mLastInsets.getSystemWindowInsetTop();
            parent.right -= this.mLastInsets.getSystemWindowInsetRight();
            parent.bottom -= this.mLastInsets.getSystemWindowInsetBottom();
        }
        Rect out = CoordinatorLayout.acquireTempRect();
        GravityCompat.apply((int)CoordinatorLayout.resolveGravity(lp.gravity), (int)child.getMeasuredWidth(), (int)child.getMeasuredHeight(), (Rect)parent, (Rect)out, (int)layoutDirection);
        child.layout(out.left, out.top, out.right, out.bottom);
        CoordinatorLayout.releaseTempRect(parent);
        CoordinatorLayout.releaseTempRect(out);
    }

    private static int resolveGravity(int gravity) {
        if ((gravity & 7) == 0) {
            gravity |= 0x800003;
        }
        if ((gravity & 0x70) == 0) {
            gravity |= 0x30;
        }
        return gravity;
    }

    private static int resolveKeylineGravity(int gravity) {
        return gravity == 0 ? 8388661 : gravity;
    }

    private static int resolveAnchoredChildGravity(int gravity) {
        return gravity == 0 ? 17 : gravity;
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        float scrimAlpha;
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp.mBehavior != null && (scrimAlpha = lp.mBehavior.getScrimOpacity(this, child)) > 0.0f) {
            if (this.mScrimPaint == null) {
                this.mScrimPaint = new Paint();
            }
            this.mScrimPaint.setColor(lp.mBehavior.getScrimColor(this, child));
            this.mScrimPaint.setAlpha(MathUtils.constrain(Math.round(255.0f * scrimAlpha), 0, 255));
            int saved = canvas.save();
            if (child.isOpaque()) {
                canvas.clipRect((float)child.getLeft(), (float)child.getTop(), (float)child.getRight(), (float)child.getBottom(), Region.Op.DIFFERENCE);
            }
            canvas.drawRect((float)this.getPaddingLeft(), (float)this.getPaddingTop(), (float)(this.getWidth() - this.getPaddingRight()), (float)(this.getHeight() - this.getPaddingBottom()), this.mScrimPaint);
            canvas.restoreToCount(saved);
        }
        return super.drawChild(canvas, child, drawingTime);
    }

    final void onChildViewsChanged(int type) {
        int layoutDirection = ViewCompat.getLayoutDirection((View)this);
        int childCount = this.mDependencySortedChildren.size();
        Rect inset = CoordinatorLayout.acquireTempRect();
        Rect drawRect = CoordinatorLayout.acquireTempRect();
        Rect lastDrawRect = CoordinatorLayout.acquireTempRect();
        for (int i = 0; i < childCount; ++i) {
            View checkChild;
            int j;
            View child = this.mDependencySortedChildren.get(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (type == 0 && child.getVisibility() == 8) continue;
            for (j = 0; j < i; ++j) {
                checkChild = this.mDependencySortedChildren.get(j);
                if (lp.mAnchorDirectChild != checkChild) continue;
                this.offsetChildToAnchor(child, layoutDirection);
            }
            this.getChildRect(child, true, drawRect);
            if (lp.insetEdge != 0 && !drawRect.isEmpty()) {
                int absInsetEdge = GravityCompat.getAbsoluteGravity((int)lp.insetEdge, (int)layoutDirection);
                switch (absInsetEdge & 0x70) {
                    case 48: {
                        inset.top = Math.max(inset.top, drawRect.bottom);
                        break;
                    }
                    case 80: {
                        inset.bottom = Math.max(inset.bottom, this.getHeight() - drawRect.top);
                    }
                }
                switch (absInsetEdge & 7) {
                    case 3: {
                        inset.left = Math.max(inset.left, drawRect.right);
                        break;
                    }
                    case 5: {
                        inset.right = Math.max(inset.right, this.getWidth() - drawRect.left);
                    }
                }
            }
            if (lp.dodgeInsetEdges != 0 && child.getVisibility() == 0) {
                this.offsetChildByInset(child, inset, layoutDirection);
            }
            if (type != 2) {
                this.getLastChildRect(child, lastDrawRect);
                if (lastDrawRect.equals((Object)drawRect)) continue;
                this.recordLastChildRect(child, drawRect);
            }
            for (j = i + 1; j < childCount; ++j) {
                boolean handled;
                checkChild = this.mDependencySortedChildren.get(j);
                LayoutParams checkLp = (LayoutParams)checkChild.getLayoutParams();
                Behavior b = checkLp.getBehavior();
                if (b == null || !b.layoutDependsOn(this, checkChild, child)) continue;
                if (type == 0 && checkLp.getChangedAfterNestedScroll()) {
                    checkLp.resetChangedAfterNestedScroll();
                    continue;
                }
                switch (type) {
                    case 2: {
                        b.onDependentViewRemoved(this, checkChild, child);
                        handled = true;
                        break;
                    }
                    default: {
                        handled = b.onDependentViewChanged(this, checkChild, child);
                    }
                }
                if (type != 1) continue;
                checkLp.setChangedAfterNestedScroll(handled);
            }
        }
        CoordinatorLayout.releaseTempRect(inset);
        CoordinatorLayout.releaseTempRect(drawRect);
        CoordinatorLayout.releaseTempRect(lastDrawRect);
    }

    private void offsetChildByInset(View child, Rect inset, int layoutDirection) {
        int distance;
        int distance2;
        if (!ViewCompat.isLaidOut((View)child)) {
            return;
        }
        if (child.getWidth() <= 0 || child.getHeight() <= 0) {
            return;
        }
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        Behavior behavior = lp.getBehavior();
        Rect dodgeRect = CoordinatorLayout.acquireTempRect();
        Rect bounds = CoordinatorLayout.acquireTempRect();
        bounds.set(child.getLeft(), child.getTop(), child.getRight(), child.getBottom());
        if (behavior != null && behavior.getInsetDodgeRect(this, child, dodgeRect)) {
            if (!bounds.contains(dodgeRect)) {
                throw new IllegalArgumentException("Rect should be within the child's bounds. Rect:" + dodgeRect.toShortString() + " | Bounds:" + bounds.toShortString());
            }
        } else {
            dodgeRect.set(bounds);
        }
        CoordinatorLayout.releaseTempRect(bounds);
        if (dodgeRect.isEmpty()) {
            CoordinatorLayout.releaseTempRect(dodgeRect);
            return;
        }
        int absDodgeInsetEdges = GravityCompat.getAbsoluteGravity((int)lp.dodgeInsetEdges, (int)layoutDirection);
        boolean offsetY = false;
        if ((absDodgeInsetEdges & 0x30) == 48 && (distance2 = dodgeRect.top - lp.topMargin - lp.mInsetOffsetY) < inset.top) {
            this.setInsetOffsetY(child, inset.top - distance2);
            offsetY = true;
        }
        if ((absDodgeInsetEdges & 0x50) == 80 && (distance2 = this.getHeight() - dodgeRect.bottom - lp.bottomMargin + lp.mInsetOffsetY) < inset.bottom) {
            this.setInsetOffsetY(child, distance2 - inset.bottom);
            offsetY = true;
        }
        if (!offsetY) {
            this.setInsetOffsetY(child, 0);
        }
        boolean offsetX = false;
        if ((absDodgeInsetEdges & 3) == 3 && (distance = dodgeRect.left - lp.leftMargin - lp.mInsetOffsetX) < inset.left) {
            this.setInsetOffsetX(child, inset.left - distance);
            offsetX = true;
        }
        if ((absDodgeInsetEdges & 5) == 5 && (distance = this.getWidth() - dodgeRect.right - lp.rightMargin + lp.mInsetOffsetX) < inset.right) {
            this.setInsetOffsetX(child, distance - inset.right);
            offsetX = true;
        }
        if (!offsetX) {
            this.setInsetOffsetX(child, 0);
        }
        CoordinatorLayout.releaseTempRect(dodgeRect);
    }

    private void setInsetOffsetX(View child, int offsetX) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp.mInsetOffsetX != offsetX) {
            int dx = offsetX - lp.mInsetOffsetX;
            ViewCompat.offsetLeftAndRight((View)child, (int)dx);
            lp.mInsetOffsetX = offsetX;
        }
    }

    private void setInsetOffsetY(View child, int offsetY) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp.mInsetOffsetY != offsetY) {
            int dy = offsetY - lp.mInsetOffsetY;
            ViewCompat.offsetTopAndBottom((View)child, (int)dy);
            lp.mInsetOffsetY = offsetY;
        }
    }

    public void dispatchDependentViewsChanged(View view) {
        List dependents = this.mChildDag.getIncomingEdges(view);
        if (dependents != null && !dependents.isEmpty()) {
            for (int i = 0; i < dependents.size(); ++i) {
                View child = (View)dependents.get(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                Behavior b = lp.getBehavior();
                if (b == null) continue;
                b.onDependentViewChanged(this, child, view);
            }
        }
    }

    @NonNull
    public List<View> getDependencies(@NonNull View child) {
        List dependencies = this.mChildDag.getOutgoingEdges(child);
        this.mTempDependenciesList.clear();
        if (dependencies != null) {
            this.mTempDependenciesList.addAll(dependencies);
        }
        return this.mTempDependenciesList;
    }

    @NonNull
    public List<View> getDependents(@NonNull View child) {
        List edges = this.mChildDag.getIncomingEdges(child);
        this.mTempDependenciesList.clear();
        if (edges != null) {
            this.mTempDependenciesList.addAll(edges);
        }
        return this.mTempDependenciesList;
    }

    @VisibleForTesting
    final List<View> getDependencySortedChildren() {
        this.prepareChildren();
        return Collections.unmodifiableList(this.mDependencySortedChildren);
    }

    void ensurePreDrawListener() {
        boolean hasDependencies = false;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (!this.hasDependencies(child)) continue;
            hasDependencies = true;
            break;
        }
        if (hasDependencies != this.mNeedsPreDrawListener) {
            if (hasDependencies) {
                this.addPreDrawListener();
            } else {
                this.removePreDrawListener();
            }
        }
    }

    private boolean hasDependencies(View child) {
        return this.mChildDag.hasOutgoingEdges(child);
    }

    void addPreDrawListener() {
        if (this.mIsAttachedToWindow) {
            if (this.mOnPreDrawListener == null) {
                this.mOnPreDrawListener = new OnPreDrawListener();
            }
            ViewTreeObserver vto = this.getViewTreeObserver();
            vto.addOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.mOnPreDrawListener);
        }
        this.mNeedsPreDrawListener = true;
    }

    void removePreDrawListener() {
        if (this.mIsAttachedToWindow && this.mOnPreDrawListener != null) {
            ViewTreeObserver vto = this.getViewTreeObserver();
            vto.removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this.mOnPreDrawListener);
        }
        this.mNeedsPreDrawListener = false;
    }

    void offsetChildToAnchor(View child, int layoutDirection) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        if (lp.mAnchorView != null) {
            Behavior b;
            Rect anchorRect = CoordinatorLayout.acquireTempRect();
            Rect childRect = CoordinatorLayout.acquireTempRect();
            Rect desiredChildRect = CoordinatorLayout.acquireTempRect();
            this.getDescendantRect(lp.mAnchorView, anchorRect);
            this.getChildRect(child, false, childRect);
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            this.getDesiredAnchoredChildRectWithoutConstraints(child, layoutDirection, anchorRect, desiredChildRect, lp, childWidth, childHeight);
            boolean changed = desiredChildRect.left != childRect.left || desiredChildRect.top != childRect.top;
            this.constrainChildRect(lp, desiredChildRect, childWidth, childHeight);
            int dx = desiredChildRect.left - childRect.left;
            int dy = desiredChildRect.top - childRect.top;
            if (dx != 0) {
                ViewCompat.offsetLeftAndRight((View)child, (int)dx);
            }
            if (dy != 0) {
                ViewCompat.offsetTopAndBottom((View)child, (int)dy);
            }
            if (changed && (b = lp.getBehavior()) != null) {
                b.onDependentViewChanged(this, child, lp.mAnchorView);
            }
            CoordinatorLayout.releaseTempRect(anchorRect);
            CoordinatorLayout.releaseTempRect(childRect);
            CoordinatorLayout.releaseTempRect(desiredChildRect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPointInChildBounds(View child, int x, int y) {
        Rect r = CoordinatorLayout.acquireTempRect();
        this.getDescendantRect(child, r);
        try {
            boolean bl = r.contains(x, y);
            return bl;
        }
        finally {
            CoordinatorLayout.releaseTempRect(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doViewsOverlap(View first, View second) {
        if (first.getVisibility() == 0 && second.getVisibility() == 0) {
            Rect firstRect = CoordinatorLayout.acquireTempRect();
            this.getChildRect(first, first.getParent() != this, firstRect);
            Rect secondRect = CoordinatorLayout.acquireTempRect();
            this.getChildRect(second, second.getParent() != this, secondRect);
            try {
                boolean bl = firstRect.left <= secondRect.right && firstRect.top <= secondRect.bottom && firstRect.right >= secondRect.left && firstRect.bottom >= secondRect.top;
                return bl;
            }
            finally {
                CoordinatorLayout.releaseTempRect(firstRect);
                CoordinatorLayout.releaseTempRect(secondRect);
            }
        }
        return false;
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        if (p instanceof LayoutParams) {
            return new LayoutParams((LayoutParams)p);
        }
        if (p instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)p);
        }
        return new LayoutParams(p);
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams && super.checkLayoutParams(p);
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        boolean handled = false;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            Behavior viewBehavior = lp.getBehavior();
            if (viewBehavior != null) {
                boolean accepted = viewBehavior.onStartNestedScroll(this, view, child, target, nestedScrollAxes);
                handled |= accepted;
                lp.acceptNestedScroll(accepted);
                continue;
            }
            lp.acceptNestedScroll(false);
        }
        return handled;
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        this.mNestedScrollingParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
        this.mNestedScrollingDirectChild = child;
        this.mNestedScrollingTarget = target;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Behavior viewBehavior;
            View view = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            if (!lp.isNestedScrollAccepted() || (viewBehavior = lp.getBehavior()) == null) continue;
            viewBehavior.onNestedScrollAccepted(this, view, child, target, nestedScrollAxes);
        }
    }

    public void onStopNestedScroll(View target) {
        this.mNestedScrollingParentHelper.onStopNestedScroll(target);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View view = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            if (!lp.isNestedScrollAccepted()) continue;
            Behavior viewBehavior = lp.getBehavior();
            if (viewBehavior != null) {
                viewBehavior.onStopNestedScroll(this, view, target);
            }
            lp.resetNestedScroll();
            lp.resetChangedAfterNestedScroll();
        }
        this.mNestedScrollingDirectChild = null;
        this.mNestedScrollingTarget = null;
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        int childCount = this.getChildCount();
        boolean accepted = false;
        for (int i = 0; i < childCount; ++i) {
            Behavior viewBehavior;
            LayoutParams lp;
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8 || !(lp = (LayoutParams)view.getLayoutParams()).isNestedScrollAccepted() || (viewBehavior = lp.getBehavior()) == null) continue;
            viewBehavior.onNestedScroll(this, view, target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed);
            accepted = true;
        }
        if (accepted) {
            this.onChildViewsChanged(1);
        }
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        int xConsumed = 0;
        int yConsumed = 0;
        boolean accepted = false;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Behavior viewBehavior;
            LayoutParams lp;
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8 || !(lp = (LayoutParams)view.getLayoutParams()).isNestedScrollAccepted() || (viewBehavior = lp.getBehavior()) == null) continue;
            this.mTempIntPair[1] = 0;
            this.mTempIntPair[0] = 0;
            viewBehavior.onNestedPreScroll(this, view, target, dx, dy, this.mTempIntPair);
            xConsumed = dx > 0 ? Math.max(xConsumed, this.mTempIntPair[0]) : Math.min(xConsumed, this.mTempIntPair[0]);
            yConsumed = dy > 0 ? Math.max(yConsumed, this.mTempIntPair[1]) : Math.min(yConsumed, this.mTempIntPair[1]);
            accepted = true;
        }
        consumed[0] = xConsumed;
        consumed[1] = yConsumed;
        if (accepted) {
            this.onChildViewsChanged(1);
        }
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        boolean handled = false;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Behavior viewBehavior;
            LayoutParams lp;
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8 || !(lp = (LayoutParams)view.getLayoutParams()).isNestedScrollAccepted() || (viewBehavior = lp.getBehavior()) == null) continue;
            handled |= viewBehavior.onNestedFling(this, view, target, velocityX, velocityY, consumed);
        }
        if (handled) {
            this.onChildViewsChanged(1);
        }
        return handled;
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        boolean handled = false;
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Behavior viewBehavior;
            LayoutParams lp;
            View view = this.getChildAt(i);
            if (view.getVisibility() == 8 || !(lp = (LayoutParams)view.getLayoutParams()).isNestedScrollAccepted() || (viewBehavior = lp.getBehavior()) == null) continue;
            handled |= viewBehavior.onNestedPreFling(this, view, target, velocityX, velocityY);
        }
        return handled;
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.getNestedScrollAxes();
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        SparseArray<Parcelable> behaviorStates = ss.behaviorStates;
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            Parcelable savedState;
            View child = this.getChildAt(i);
            int childId = child.getId();
            LayoutParams lp = this.getResolvedLayoutParams(child);
            Behavior b = lp.getBehavior();
            if (childId == -1 || b == null || (savedState = (Parcelable)behaviorStates.get(childId)) == null) continue;
            b.onRestoreInstanceState(this, child, savedState);
        }
    }

    protected Parcelable onSaveInstanceState() {
        SavedState ss = new SavedState(super.onSaveInstanceState());
        SparseArray behaviorStates = new SparseArray();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            Parcelable state;
            View child = this.getChildAt(i);
            int childId = child.getId();
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            Behavior b = lp.getBehavior();
            if (childId == -1 || b == null || (state = b.onSaveInstanceState(this, child)) == null) continue;
            behaviorStates.append(childId, (Object)state);
        }
        ss.behaviorStates = behaviorStates;
        return ss;
    }

    public boolean requestChildRectangleOnScreen(View child, Rect rectangle, boolean immediate) {
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        Behavior behavior = lp.getBehavior();
        if (behavior != null && behavior.onRequestChildRectangleOnScreen(this, child, rectangle, immediate)) {
            return true;
        }
        return super.requestChildRectangleOnScreen(child, rectangle, immediate);
    }

    private void setupForInsets() {
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        if (ViewCompat.getFitsSystemWindows((View)this)) {
            if (this.mApplyWindowInsetsListener == null) {
                this.mApplyWindowInsetsListener = new OnApplyWindowInsetsListener(){

                    public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                        return CoordinatorLayout.this.setWindowInsets(insets);
                    }
                };
            }
            ViewCompat.setOnApplyWindowInsetsListener((View)this, (OnApplyWindowInsetsListener)this.mApplyWindowInsetsListener);
            this.setSystemUiVisibility(1280);
        } else {
            ViewCompat.setOnApplyWindowInsetsListener((View)this, null);
        }
    }

    static {
        Package pkg = CoordinatorLayout.class.getPackage();
        WIDGET_PACKAGE_NAME = pkg != null ? pkg.getName() : null;
        TOP_SORTED_CHILDREN_COMPARATOR = Build.VERSION.SDK_INT >= 21 ? new ViewElevationComparator() : null;
        CONSTRUCTOR_PARAMS = new Class[]{Context.class, AttributeSet.class};
        sConstructors = new ThreadLocal();
        sRectPool = new Pools.SynchronizedPool(12);
    }

    protected static class SavedState
    extends AbsSavedState {
        SparseArray<Parcelable> behaviorStates;
        public static final Parcelable.Creator<SavedState> CREATOR = ParcelableCompat.newCreator((ParcelableCompatCreatorCallbacks)new ParcelableCompatCreatorCallbacks<SavedState>(){

            public SavedState createFromParcel(Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        });

        public SavedState(Parcel source, ClassLoader loader) {
            super(source, loader);
            int size = source.readInt();
            int[] ids = new int[size];
            source.readIntArray(ids);
            Parcelable[] states = source.readParcelableArray(loader);
            this.behaviorStates = new SparseArray(size);
            for (int i = 0; i < size; ++i) {
                this.behaviorStates.append(ids[i], (Object)states[i]);
            }
        }

        public SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            int size = this.behaviorStates != null ? this.behaviorStates.size() : 0;
            dest.writeInt(size);
            int[] ids = new int[size];
            Parcelable[] states = new Parcelable[size];
            for (int i = 0; i < size; ++i) {
                ids[i] = this.behaviorStates.keyAt(i);
                states[i] = (Parcelable)this.behaviorStates.valueAt(i);
            }
            dest.writeIntArray(ids);
            dest.writeParcelableArray(states, flags);
        }
    }

    private class HierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        HierarchyChangeListener() {
        }

        public void onChildViewAdded(View parent, View child) {
            if (CoordinatorLayout.this.mOnHierarchyChangeListener != null) {
                CoordinatorLayout.this.mOnHierarchyChangeListener.onChildViewAdded(parent, child);
            }
        }

        public void onChildViewRemoved(View parent, View child) {
            CoordinatorLayout.this.onChildViewsChanged(2);
            if (CoordinatorLayout.this.mOnHierarchyChangeListener != null) {
                CoordinatorLayout.this.mOnHierarchyChangeListener.onChildViewRemoved(parent, child);
            }
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        Behavior mBehavior;
        boolean mBehaviorResolved = false;
        public int gravity = 0;
        public int anchorGravity = 0;
        public int keyline = -1;
        int mAnchorId = -1;
        public int insetEdge = 0;
        public int dodgeInsetEdges = 0;
        int mInsetOffsetX;
        int mInsetOffsetY;
        View mAnchorView;
        View mAnchorDirectChild;
        private boolean mDidBlockInteraction;
        private boolean mDidAcceptNestedScroll;
        private boolean mDidChangeAfterNestedScroll;
        final Rect mLastChildRect = new Rect();
        Object mBehaviorTag;

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        LayoutParams(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CoordinatorLayout_Layout);
            this.gravity = a.getInteger(R.styleable.CoordinatorLayout_Layout_android_layout_gravity, 0);
            this.mAnchorId = a.getResourceId(R.styleable.CoordinatorLayout_Layout_layout_anchor, -1);
            this.anchorGravity = a.getInteger(R.styleable.CoordinatorLayout_Layout_layout_anchorGravity, 0);
            this.keyline = a.getInteger(R.styleable.CoordinatorLayout_Layout_layout_keyline, -1);
            this.insetEdge = a.getInt(R.styleable.CoordinatorLayout_Layout_layout_insetEdge, 0);
            this.dodgeInsetEdges = a.getInt(R.styleable.CoordinatorLayout_Layout_layout_dodgeInsetEdges, 0);
            this.mBehaviorResolved = a.hasValue(R.styleable.CoordinatorLayout_Layout_layout_behavior);
            if (this.mBehaviorResolved) {
                this.mBehavior = CoordinatorLayout.parseBehavior(context, attrs, a.getString(R.styleable.CoordinatorLayout_Layout_layout_behavior));
            }
            a.recycle();
            if (this.mBehavior != null) {
                this.mBehavior.onAttachedToLayoutParams(this);
            }
        }

        public LayoutParams(LayoutParams p) {
            super((ViewGroup.MarginLayoutParams)p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        @IdRes
        public int getAnchorId() {
            return this.mAnchorId;
        }

        public void setAnchorId(@IdRes int id2) {
            this.invalidateAnchor();
            this.mAnchorId = id2;
        }

        @Nullable
        public Behavior getBehavior() {
            return this.mBehavior;
        }

        public void setBehavior(@Nullable Behavior behavior) {
            if (this.mBehavior != behavior) {
                if (this.mBehavior != null) {
                    this.mBehavior.onDetachedFromLayoutParams();
                }
                this.mBehavior = behavior;
                this.mBehaviorTag = null;
                this.mBehaviorResolved = true;
                if (behavior != null) {
                    behavior.onAttachedToLayoutParams(this);
                }
            }
        }

        void setLastChildRect(Rect r) {
            this.mLastChildRect.set(r);
        }

        Rect getLastChildRect() {
            return this.mLastChildRect;
        }

        boolean checkAnchorChanged() {
            return this.mAnchorView == null && this.mAnchorId != -1;
        }

        boolean didBlockInteraction() {
            if (this.mBehavior == null) {
                this.mDidBlockInteraction = false;
            }
            return this.mDidBlockInteraction;
        }

        boolean isBlockingInteractionBelow(CoordinatorLayout parent, View child) {
            if (this.mDidBlockInteraction) {
                return true;
            }
            return this.mDidBlockInteraction |= this.mBehavior != null ? this.mBehavior.blocksInteractionBelow(parent, child) : false;
        }

        void resetTouchBehaviorTracking() {
            this.mDidBlockInteraction = false;
        }

        void resetNestedScroll() {
            this.mDidAcceptNestedScroll = false;
        }

        void acceptNestedScroll(boolean accept) {
            this.mDidAcceptNestedScroll = accept;
        }

        boolean isNestedScrollAccepted() {
            return this.mDidAcceptNestedScroll;
        }

        boolean getChangedAfterNestedScroll() {
            return this.mDidChangeAfterNestedScroll;
        }

        void setChangedAfterNestedScroll(boolean changed) {
            this.mDidChangeAfterNestedScroll = changed;
        }

        void resetChangedAfterNestedScroll() {
            this.mDidChangeAfterNestedScroll = false;
        }

        boolean dependsOn(CoordinatorLayout parent, View child, View dependency) {
            return dependency == this.mAnchorDirectChild || this.shouldDodge(dependency, ViewCompat.getLayoutDirection((View)parent)) || this.mBehavior != null && this.mBehavior.layoutDependsOn(parent, child, dependency);
        }

        void invalidateAnchor() {
            this.mAnchorDirectChild = null;
            this.mAnchorView = null;
        }

        View findAnchorView(CoordinatorLayout parent, View forChild) {
            if (this.mAnchorId == -1) {
                this.mAnchorDirectChild = null;
                this.mAnchorView = null;
                return null;
            }
            if (this.mAnchorView == null || !this.verifyAnchorView(forChild, parent)) {
                this.resolveAnchorView(forChild, parent);
            }
            return this.mAnchorView;
        }

        private void resolveAnchorView(View forChild, CoordinatorLayout parent) {
            View directChild;
            this.mAnchorView = parent.findViewById(this.mAnchorId);
            if (this.mAnchorView != null) {
                if (this.mAnchorView == parent) {
                    if (parent.isInEditMode()) {
                        this.mAnchorDirectChild = null;
                        this.mAnchorView = null;
                        return;
                    }
                    throw new IllegalStateException("View can not be anchored to the the parent CoordinatorLayout");
                }
                directChild = this.mAnchorView;
                for (ViewParent p = this.mAnchorView.getParent(); p != parent && p != null; p = p.getParent()) {
                    if (p == forChild) {
                        if (parent.isInEditMode()) {
                            this.mAnchorDirectChild = null;
                            this.mAnchorView = null;
                            return;
                        }
                        throw new IllegalStateException("Anchor must not be a descendant of the anchored view");
                    }
                    if (!(p instanceof View)) continue;
                    directChild = (View)p;
                }
            } else {
                if (parent.isInEditMode()) {
                    this.mAnchorDirectChild = null;
                    this.mAnchorView = null;
                    return;
                }
                throw new IllegalStateException("Could not find CoordinatorLayout descendant view with id " + parent.getResources().getResourceName(this.mAnchorId) + " to anchor view " + forChild);
            }
            this.mAnchorDirectChild = directChild;
        }

        private boolean verifyAnchorView(View forChild, CoordinatorLayout parent) {
            if (this.mAnchorView.getId() != this.mAnchorId) {
                return false;
            }
            View directChild = this.mAnchorView;
            for (ViewParent p = this.mAnchorView.getParent(); p != parent; p = p.getParent()) {
                if (p == null || p == forChild) {
                    this.mAnchorDirectChild = null;
                    this.mAnchorView = null;
                    return false;
                }
                if (!(p instanceof View)) continue;
                directChild = (View)p;
            }
            this.mAnchorDirectChild = directChild;
            return true;
        }

        private boolean shouldDodge(View other, int layoutDirection) {
            LayoutParams lp = (LayoutParams)other.getLayoutParams();
            int absInset = GravityCompat.getAbsoluteGravity((int)lp.insetEdge, (int)layoutDirection);
            return absInset != 0 && (absInset & GravityCompat.getAbsoluteGravity((int)this.dodgeInsetEdges, (int)layoutDirection)) == absInset;
        }
    }

    public static abstract class Behavior<V extends View> {
        public Behavior() {
        }

        public Behavior(Context context, AttributeSet attrs) {
        }

        public void onAttachedToLayoutParams(@NonNull LayoutParams params) {
        }

        public void onDetachedFromLayoutParams() {
        }

        public boolean onInterceptTouchEvent(CoordinatorLayout parent, V child, MotionEvent ev) {
            return false;
        }

        public boolean onTouchEvent(CoordinatorLayout parent, V child, MotionEvent ev) {
            return false;
        }

        @ColorInt
        public int getScrimColor(CoordinatorLayout parent, V child) {
            return -16777216;
        }

        @FloatRange(from=0.0, to=1.0)
        public float getScrimOpacity(CoordinatorLayout parent, V child) {
            return 0.0f;
        }

        public boolean blocksInteractionBelow(CoordinatorLayout parent, V child) {
            return this.getScrimOpacity(parent, child) > 0.0f;
        }

        public boolean layoutDependsOn(CoordinatorLayout parent, V child, View dependency) {
            return false;
        }

        public boolean onDependentViewChanged(CoordinatorLayout parent, V child, View dependency) {
            return false;
        }

        public void onDependentViewRemoved(CoordinatorLayout parent, V child, View dependency) {
        }

        @Deprecated
        public boolean isDirty(CoordinatorLayout parent, V child) {
            return false;
        }

        public boolean onMeasureChild(CoordinatorLayout parent, V child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
            return false;
        }

        public boolean onLayoutChild(CoordinatorLayout parent, V child, int layoutDirection) {
            return false;
        }

        public static void setTag(View child, Object tag) {
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            lp.mBehaviorTag = tag;
        }

        public static Object getTag(View child) {
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            return lp.mBehaviorTag;
        }

        public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, V child, View directTargetChild, View target, int nestedScrollAxes) {
            return false;
        }

        public void onNestedScrollAccepted(CoordinatorLayout coordinatorLayout, V child, View directTargetChild, View target, int nestedScrollAxes) {
        }

        public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, V child, View target) {
        }

        public void onNestedScroll(CoordinatorLayout coordinatorLayout, V child, View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        }

        public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, V child, View target, int dx, int dy, int[] consumed) {
        }

        public boolean onNestedFling(CoordinatorLayout coordinatorLayout, V child, View target, float velocityX, float velocityY, boolean consumed) {
            return false;
        }

        public boolean onNestedPreFling(CoordinatorLayout coordinatorLayout, V child, View target, float velocityX, float velocityY) {
            return false;
        }

        @NonNull
        public WindowInsetsCompat onApplyWindowInsets(CoordinatorLayout coordinatorLayout, V child, WindowInsetsCompat insets) {
            return insets;
        }

        public boolean onRequestChildRectangleOnScreen(CoordinatorLayout coordinatorLayout, V child, Rect rectangle, boolean immediate) {
            return false;
        }

        public void onRestoreInstanceState(CoordinatorLayout parent, V child, Parcelable state) {
        }

        public Parcelable onSaveInstanceState(CoordinatorLayout parent, V child) {
            return View.BaseSavedState.EMPTY_STATE;
        }

        public boolean getInsetDodgeRect(@NonNull CoordinatorLayout parent, @NonNull V child, @NonNull Rect rect) {
            return false;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface DefaultBehavior {
        public Class<? extends Behavior> value();
    }

    static class ViewElevationComparator
    implements Comparator<View> {
        ViewElevationComparator() {
        }

        @Override
        public int compare(View lhs, View rhs) {
            float rz;
            float lz = ViewCompat.getZ((View)lhs);
            if (lz > (rz = ViewCompat.getZ((View)rhs))) {
                return -1;
            }
            if (lz < rz) {
                return 1;
            }
            return 0;
        }
    }

    class OnPreDrawListener
    implements ViewTreeObserver.OnPreDrawListener {
        OnPreDrawListener() {
        }

        public boolean onPreDraw() {
            CoordinatorLayout.this.onChildViewsChanged(0);
            return true;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface DispatchChangeEvent {
    }
}

