/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.internal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.design.internal.FlexContainer;
import android.support.design.internal.FlexItem;
import android.support.design.internal.FlexLine;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class FlexboxHelper {
    private static final int INITIAL_CAPACITY = 10;
    private final FlexContainer flexContainer;
    private boolean[] childrenFrozen;

    FlexboxHelper(FlexContainer flexContainer) {
        this.flexContainer = flexContainer;
    }

    int[] createReorderedIndices(View viewBeforeAdded, int indexForViewBeforeAdded, ViewGroup.LayoutParams paramsForViewBeforeAdded, SparseIntArray orderCache) {
        int childCount = this.flexContainer.getFlexItemCount();
        List<Order> orders = this.createOrders(childCount);
        Order orderForViewToBeAdded = new Order();
        orderForViewToBeAdded.order = viewBeforeAdded != null && paramsForViewBeforeAdded instanceof FlexItem ? ((FlexItem)paramsForViewBeforeAdded).getOrder() : 1;
        if (indexForViewBeforeAdded == -1 || indexForViewBeforeAdded == childCount) {
            orderForViewToBeAdded.index = childCount;
        } else if (indexForViewBeforeAdded < this.flexContainer.getFlexItemCount()) {
            orderForViewToBeAdded.index = indexForViewBeforeAdded;
            for (int i = indexForViewBeforeAdded; i < childCount; ++i) {
                ++orders.get((int)i).index;
            }
        } else {
            orderForViewToBeAdded.index = childCount;
        }
        orders.add(orderForViewToBeAdded);
        return this.sortOrdersIntoReorderedIndices(childCount + 1, orders, orderCache);
    }

    int[] createReorderedIndices(SparseIntArray orderCache) {
        int childCount = this.flexContainer.getFlexItemCount();
        List<Order> orders = this.createOrders(childCount);
        return this.sortOrdersIntoReorderedIndices(childCount, orders, orderCache);
    }

    @NonNull
    private List<Order> createOrders(int childCount) {
        ArrayList<Order> orders = new ArrayList<Order>(childCount);
        int i = 0;
        while (i < childCount) {
            View child = this.flexContainer.getFlexItemAt(i);
            FlexItem flexItem = (FlexItem)child.getLayoutParams();
            Order order = new Order();
            order.order = flexItem.getOrder();
            order.index = i++;
            orders.add(order);
        }
        return orders;
    }

    boolean isOrderChangedFromLastMeasurement(SparseIntArray orderCache) {
        int childCount = this.flexContainer.getFlexItemCount();
        if (orderCache.size() != childCount) {
            return true;
        }
        for (int i = 0; i < childCount; ++i) {
            FlexItem flexItem;
            View view = this.flexContainer.getFlexItemAt(i);
            if (view == null || (flexItem = (FlexItem)view.getLayoutParams()).getOrder() == orderCache.get(i)) continue;
            return true;
        }
        return false;
    }

    private int[] sortOrdersIntoReorderedIndices(int childCount, List<Order> orders, SparseIntArray orderCache) {
        Collections.sort(orders);
        orderCache.clear();
        int[] reorderedIndices = new int[childCount];
        int i = 0;
        for (Order order : orders) {
            reorderedIndices[i] = order.index;
            orderCache.append(order.index, order.order);
            ++i;
        }
        return reorderedIndices;
    }

    void calculateHorizontalFlexLines(FlexLinesResult result, int widthMeasureSpec, int heightMeasureSpec) {
        this.calculateFlexLines(result, widthMeasureSpec, heightMeasureSpec, Integer.MAX_VALUE, 0, -1, null);
    }

    private void calculateFlexLines(FlexLinesResult result, int mainMeasureSpec, int crossMeasureSpec, int needsCalcAmount, int fromIndex, int toIndex, @Nullable List<FlexLine> existingLines) {
        boolean isMainHorizontal = this.flexContainer.isMainAxisDirectionHorizontal();
        int mainMode = View.MeasureSpec.getMode((int)mainMeasureSpec);
        int mainSize = View.MeasureSpec.getSize((int)mainMeasureSpec);
        int childState = 0;
        List<FlexLine> flexLines = existingLines == null ? new ArrayList<FlexLine>() : existingLines;
        result.flexLines = flexLines;
        boolean reachedToIndex = toIndex == -1;
        int mainPaddingStart = this.getPaddingStartMain(isMainHorizontal);
        int mainPaddingEnd = this.getPaddingEndMain(isMainHorizontal);
        int crossPaddingStart = this.getPaddingStartCross(isMainHorizontal);
        int crossPaddingEnd = this.getPaddingEndCross(isMainHorizontal);
        int largestSizeInCross = Integer.MIN_VALUE;
        int sumCrossSize = 0;
        int indexInFlexLine = 0;
        FlexLine flexLine = new FlexLine();
        flexLine.firstIndex = fromIndex;
        flexLine.mainSize = mainPaddingStart + mainPaddingEnd;
        int childCount = this.flexContainer.getFlexItemCount();
        for (int i = fromIndex; i < childCount; ++i) {
            int childCrossMeasureSpec;
            int childMainMeasureSpec;
            View child = this.flexContainer.getReorderedFlexItemAt(i);
            if (child == null) {
                if (!this.isLastFlexItem(i, childCount, flexLine)) continue;
                this.addFlexLine(flexLines, flexLine, i, sumCrossSize);
                continue;
            }
            if (child.getVisibility() == 8) {
                ++flexLine.goneItemCount;
                ++flexLine.itemCount;
                if (!this.isLastFlexItem(i, childCount, flexLine)) continue;
                this.addFlexLine(flexLines, flexLine, i, sumCrossSize);
                continue;
            }
            FlexItem flexItem = (FlexItem)child.getLayoutParams();
            flexLine.indicesAlignSelfStretch.add(i);
            int childMainSize = this.getFlexItemSizeMain(flexItem, isMainHorizontal);
            if (flexItem.getFlexBasisPercent() != -1.0f && mainMode == 0x40000000) {
                childMainSize = Math.round((float)mainSize * flexItem.getFlexBasisPercent());
            }
            if (isMainHorizontal) {
                childMainMeasureSpec = this.flexContainer.getChildWidthMeasureSpec(mainMeasureSpec, mainPaddingStart + mainPaddingEnd + this.getFlexItemMarginStartMain(flexItem, true) + this.getFlexItemMarginEndMain(flexItem, true), childMainSize);
                childCrossMeasureSpec = this.flexContainer.getChildHeightMeasureSpec(crossMeasureSpec, crossPaddingStart + crossPaddingEnd + this.getFlexItemMarginStartCross(flexItem, true) + this.getFlexItemMarginEndCross(flexItem, true) + sumCrossSize, this.getFlexItemSizeCross(flexItem, true));
                child.measure(childMainMeasureSpec, childCrossMeasureSpec);
            } else {
                childCrossMeasureSpec = this.flexContainer.getChildWidthMeasureSpec(crossMeasureSpec, crossPaddingStart + crossPaddingEnd + this.getFlexItemMarginStartCross(flexItem, false) + this.getFlexItemMarginEndCross(flexItem, false) + sumCrossSize, this.getFlexItemSizeCross(flexItem, false));
                childMainMeasureSpec = this.flexContainer.getChildHeightMeasureSpec(mainMeasureSpec, mainPaddingStart + mainPaddingEnd + this.getFlexItemMarginStartMain(flexItem, false) + this.getFlexItemMarginEndMain(flexItem, false), childMainSize);
                child.measure(childCrossMeasureSpec, childMainMeasureSpec);
            }
            this.flexContainer.updateViewCache(i, child);
            this.checkSizeConstraints(child, i);
            childState = View.combineMeasuredStates((int)childState, (int)child.getMeasuredState());
            if (this.isWrapRequired(child, mainMode, mainSize, flexLine.mainSize, this.getViewMeasuredSizeMain(child, isMainHorizontal) + this.getFlexItemMarginStartMain(flexItem, isMainHorizontal) + this.getFlexItemMarginEndMain(flexItem, isMainHorizontal), flexItem, i, indexInFlexLine)) {
                if (flexLine.getItemCountNotGone() > 0) {
                    this.addFlexLine(flexLines, flexLine, i > 0 ? i - 1 : 0, sumCrossSize);
                    sumCrossSize += flexLine.crossSize;
                }
                if (isMainHorizontal) {
                    if (flexItem.getHeight() == -1) {
                        childCrossMeasureSpec = this.flexContainer.getChildHeightMeasureSpec(crossMeasureSpec, this.flexContainer.getPaddingTop() + this.flexContainer.getPaddingBottom() + flexItem.getMarginTop() + flexItem.getMarginBottom() + sumCrossSize, flexItem.getHeight());
                        child.measure(childMainMeasureSpec, childCrossMeasureSpec);
                        this.checkSizeConstraints(child, i);
                    }
                } else if (flexItem.getWidth() == -1) {
                    childCrossMeasureSpec = this.flexContainer.getChildWidthMeasureSpec(crossMeasureSpec, this.flexContainer.getPaddingLeft() + this.flexContainer.getPaddingRight() + flexItem.getMarginLeft() + flexItem.getMarginRight() + sumCrossSize, flexItem.getWidth());
                    child.measure(childCrossMeasureSpec, childMainMeasureSpec);
                    this.checkSizeConstraints(child, i);
                }
                flexLine = new FlexLine();
                flexLine.itemCount = 1;
                flexLine.mainSize = mainPaddingStart + mainPaddingEnd;
                flexLine.firstIndex = i;
                indexInFlexLine = 0;
                largestSizeInCross = Integer.MIN_VALUE;
            } else {
                ++flexLine.itemCount;
                ++indexInFlexLine;
            }
            flexLine.mainSize += this.getViewMeasuredSizeMain(child, isMainHorizontal) + this.getFlexItemMarginStartMain(flexItem, isMainHorizontal) + this.getFlexItemMarginEndMain(flexItem, isMainHorizontal);
            flexLine.motalFlexGrow += flexItem.getFlexGrow();
            flexLine.totalFlexShrink += flexItem.getFlexShrink();
            this.flexContainer.onNewFlexItemAdded(child, i, indexInFlexLine, flexLine);
            largestSizeInCross = Math.max(largestSizeInCross, this.getViewMeasuredSizeCross(child, isMainHorizontal) + this.getFlexItemMarginStartCross(flexItem, isMainHorizontal) + this.getFlexItemMarginEndCross(flexItem, isMainHorizontal) + this.flexContainer.getDecorationLengthCrossAxis(child));
            flexLine.crossSize = Math.max(flexLine.crossSize, largestSizeInCross);
            if (isMainHorizontal) {
                flexLine.maxBaseline = Math.max(flexLine.maxBaseline, child.getBaseline() + flexItem.getMarginTop());
            }
            if (this.isLastFlexItem(i, childCount, flexLine)) {
                this.addFlexLine(flexLines, flexLine, i, sumCrossSize);
                sumCrossSize += flexLine.crossSize;
            }
            if (toIndex != -1 && !flexLines.isEmpty() && flexLines.get((int)(flexLines.size() - 1)).lastIndex >= toIndex && i >= toIndex && !reachedToIndex) {
                sumCrossSize = -flexLine.getCrossSize();
                reachedToIndex = true;
            }
            if (sumCrossSize > needsCalcAmount && reachedToIndex) break;
        }
        result.childState = childState;
    }

    private int getPaddingStartMain(boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return this.flexContainer.getPaddingStart();
        }
        return this.flexContainer.getPaddingTop();
    }

    private int getPaddingEndMain(boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return this.flexContainer.getPaddingEnd();
        }
        return this.flexContainer.getPaddingBottom();
    }

    private int getPaddingStartCross(boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return this.flexContainer.getPaddingTop();
        }
        return this.flexContainer.getPaddingStart();
    }

    private int getPaddingEndCross(boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return this.flexContainer.getPaddingBottom();
        }
        return this.flexContainer.getPaddingEnd();
    }

    private int getViewMeasuredSizeMain(View view, boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return view.getMeasuredWidth();
        }
        return view.getMeasuredHeight();
    }

    private int getViewMeasuredSizeCross(View view, boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return view.getMeasuredHeight();
        }
        return view.getMeasuredWidth();
    }

    private int getFlexItemSizeMain(FlexItem flexItem, boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return flexItem.getWidth();
        }
        return flexItem.getHeight();
    }

    private int getFlexItemSizeCross(FlexItem flexItem, boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return flexItem.getHeight();
        }
        return flexItem.getWidth();
    }

    private int getFlexItemMarginStartMain(FlexItem flexItem, boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return flexItem.getMarginLeft();
        }
        return flexItem.getMarginTop();
    }

    private int getFlexItemMarginEndMain(FlexItem flexItem, boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return flexItem.getMarginRight();
        }
        return flexItem.getMarginBottom();
    }

    private int getFlexItemMarginStartCross(FlexItem flexItem, boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return flexItem.getMarginTop();
        }
        return flexItem.getMarginLeft();
    }

    private int getFlexItemMarginEndCross(FlexItem flexItem, boolean isMainHorizontal) {
        if (isMainHorizontal) {
            return flexItem.getMarginBottom();
        }
        return flexItem.getMarginRight();
    }

    private boolean isWrapRequired(View view, int mode, int maxSize, int currentLength, int childLength, FlexItem flexItem, int index, int indexInFlexLine) {
        if (this.flexContainer.getFlexWrap() == 0) {
            return false;
        }
        if (flexItem.isWrapBefore()) {
            return true;
        }
        if (mode == 0) {
            return false;
        }
        int decorationLength = this.flexContainer.getDecorationLengthMainAxis(view, index, indexInFlexLine);
        if (decorationLength > 0) {
            childLength += decorationLength;
        }
        return maxSize < currentLength + childLength;
    }

    private boolean isLastFlexItem(int childIndex, int childCount, FlexLine flexLine) {
        return childIndex == childCount - 1 && flexLine.getItemCountNotGone() != 0;
    }

    private void addFlexLine(List<FlexLine> flexLines, FlexLine flexLine, int viewIndex, int usedCrossSizeSoFar) {
        flexLine.sumCrossSizeBefore = usedCrossSizeSoFar;
        this.flexContainer.onNewFlexLineAdded(flexLine);
        flexLine.lastIndex = viewIndex;
        flexLines.add(flexLine);
    }

    private void checkSizeConstraints(View view, int index) {
        boolean needsMeasure = false;
        FlexItem flexItem = (FlexItem)view.getLayoutParams();
        int childWidth = view.getMeasuredWidth();
        int childHeight = view.getMeasuredHeight();
        if (childWidth < flexItem.getMinWidth()) {
            needsMeasure = true;
            childWidth = flexItem.getMinWidth();
        } else if (childWidth > flexItem.getMaxWidth()) {
            needsMeasure = true;
            childWidth = flexItem.getMaxWidth();
        }
        if (childHeight < flexItem.getMinHeight()) {
            needsMeasure = true;
            childHeight = flexItem.getMinHeight();
        } else if (childHeight > flexItem.getMaxHeight()) {
            needsMeasure = true;
            childHeight = flexItem.getMaxHeight();
        }
        if (needsMeasure) {
            int widthSpec = View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0x40000000);
            int heightSpec = View.MeasureSpec.makeMeasureSpec((int)childHeight, (int)0x40000000);
            view.measure(widthSpec, heightSpec);
            this.flexContainer.updateViewCache(index, view);
        }
    }

    void determineMainSize(int widthMeasureSpec, int heightMeasureSpec) {
        this.determineMainSize(widthMeasureSpec, heightMeasureSpec, 0);
    }

    private void determineMainSize(int widthMeasureSpec, int heightMeasureSpec, int fromIndex) {
        this.ensureChildrenFrozen(this.flexContainer.getFlexItemCount());
        if (fromIndex >= this.flexContainer.getFlexItemCount()) {
            return;
        }
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int mainSize = widthMode == 0x40000000 ? widthSize : this.flexContainer.getLargestMainSize();
        int paddingAlongMainAxis = this.flexContainer.getPaddingLeft() + this.flexContainer.getPaddingRight();
        int flexLineIndex = 0;
        List<FlexLine> flexLines = this.flexContainer.getFlexLinesInternal();
        int size = flexLines.size();
        for (int i = flexLineIndex; i < size; ++i) {
            FlexLine flexLine = flexLines.get(i);
            if (flexLine.mainSize < mainSize) {
                this.expandFlexItems(heightMeasureSpec, flexLine, mainSize, paddingAlongMainAxis, false);
                continue;
            }
            this.shrinkFlexItems(heightMeasureSpec, flexLine, mainSize, paddingAlongMainAxis, false);
        }
    }

    private void ensureChildrenFrozen(int size) {
        if (this.childrenFrozen == null) {
            this.childrenFrozen = new boolean[Math.max(10, size)];
        } else if (this.childrenFrozen.length < size) {
            int newCapacity = this.childrenFrozen.length * 2;
            this.childrenFrozen = new boolean[Math.max(newCapacity, size)];
        } else {
            Arrays.fill(this.childrenFrozen, false);
        }
    }

    private void expandFlexItems(int heightMeasureSpec, FlexLine flexLine, int maxMainSize, int paddingAlongMainAxis, boolean calledRecursively) {
        if (flexLine.motalFlexGrow <= 0.0f || maxMainSize < flexLine.mainSize) {
            return;
        }
        int sizeBeforeExpand = flexLine.mainSize;
        boolean needsReexpand = false;
        float unitSpace = (float)(maxMainSize - flexLine.mainSize) / flexLine.motalFlexGrow;
        flexLine.mainSize = paddingAlongMainAxis + flexLine.dividerLengthInMainSize;
        int largestCrossSize = 0;
        if (!calledRecursively) {
            flexLine.crossSize = Integer.MIN_VALUE;
        }
        float accumulatedRoundError = 0.0f;
        for (int i = 0; i < flexLine.itemCount; ++i) {
            int index = flexLine.firstIndex + i;
            View child = this.flexContainer.getReorderedFlexItemAt(index);
            if (child == null || child.getVisibility() == 8) continue;
            FlexItem flexItem = (FlexItem)child.getLayoutParams();
            int childMeasuredWidth = child.getMeasuredWidth();
            int childMeasuredHeight = child.getMeasuredHeight();
            if (!this.childrenFrozen[index] && flexItem.getFlexGrow() > 0.0f) {
                int newWidth;
                float rawCalculatedWidth = (float)childMeasuredWidth + unitSpace * flexItem.getFlexGrow();
                if (i == flexLine.itemCount - 1) {
                    rawCalculatedWidth += accumulatedRoundError;
                    accumulatedRoundError = 0.0f;
                }
                if ((newWidth = Math.round(rawCalculatedWidth)) > flexItem.getMaxWidth()) {
                    needsReexpand = true;
                    newWidth = flexItem.getMaxWidth();
                    this.childrenFrozen[index] = true;
                    flexLine.motalFlexGrow -= flexItem.getFlexGrow();
                } else if ((double)(accumulatedRoundError += rawCalculatedWidth - (float)newWidth) > 1.0) {
                    ++newWidth;
                    accumulatedRoundError -= 1.0f;
                } else if ((double)accumulatedRoundError < -1.0) {
                    --newWidth;
                    accumulatedRoundError += 1.0f;
                }
                int childHeightMeasureSpec = this.getChildHeightMeasureSpecInternal(heightMeasureSpec, flexItem, flexLine.sumCrossSizeBefore);
                int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)newWidth, (int)0x40000000);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                childMeasuredWidth = child.getMeasuredWidth();
                childMeasuredHeight = child.getMeasuredHeight();
                this.flexContainer.updateViewCache(index, child);
            }
            largestCrossSize = Math.max(largestCrossSize, childMeasuredHeight + flexItem.getMarginTop() + flexItem.getMarginBottom() + this.flexContainer.getDecorationLengthCrossAxis(child));
            flexLine.mainSize += childMeasuredWidth + flexItem.getMarginLeft() + flexItem.getMarginRight();
            flexLine.crossSize = Math.max(flexLine.crossSize, largestCrossSize);
        }
        if (needsReexpand && sizeBeforeExpand != flexLine.mainSize) {
            this.expandFlexItems(heightMeasureSpec, flexLine, maxMainSize, paddingAlongMainAxis, true);
        }
    }

    private void shrinkFlexItems(int heightMeasureSpec, FlexLine flexLine, int maxMainSize, int paddingAlongMainAxis, boolean calledRecursively) {
        int sizeBeforeShrink = flexLine.mainSize;
        if (flexLine.totalFlexShrink <= 0.0f || maxMainSize > flexLine.mainSize) {
            return;
        }
        boolean needsReshrink = false;
        float unitShrink = (float)(flexLine.mainSize - maxMainSize) / flexLine.totalFlexShrink;
        float accumulatedRoundError = 0.0f;
        flexLine.mainSize = paddingAlongMainAxis + flexLine.dividerLengthInMainSize;
        int largestCrossSize = 0;
        if (!calledRecursively) {
            flexLine.crossSize = Integer.MIN_VALUE;
        }
        for (int i = 0; i < flexLine.itemCount; ++i) {
            int index = flexLine.firstIndex + i;
            View child = this.flexContainer.getReorderedFlexItemAt(index);
            if (child == null || child.getVisibility() == 8) continue;
            FlexItem flexItem = (FlexItem)child.getLayoutParams();
            int childMeasuredWidth = child.getMeasuredWidth();
            int childMeasuredHeight = child.getMeasuredHeight();
            if (!this.childrenFrozen[index] && flexItem.getFlexShrink() > 0.0f) {
                int newWidth;
                float rawCalculatedWidth = (float)childMeasuredWidth - unitShrink * flexItem.getFlexShrink();
                if (i == flexLine.itemCount - 1) {
                    rawCalculatedWidth += accumulatedRoundError;
                    accumulatedRoundError = 0.0f;
                }
                if ((newWidth = Math.round(rawCalculatedWidth)) < flexItem.getMinWidth()) {
                    needsReshrink = true;
                    newWidth = flexItem.getMinWidth();
                    this.childrenFrozen[index] = true;
                    flexLine.totalFlexShrink -= flexItem.getFlexShrink();
                } else if ((double)(accumulatedRoundError += rawCalculatedWidth - (float)newWidth) > 1.0) {
                    ++newWidth;
                    accumulatedRoundError -= 1.0f;
                } else if ((double)accumulatedRoundError < -1.0) {
                    --newWidth;
                    accumulatedRoundError += 1.0f;
                }
                int childHeightMeasureSpec = this.getChildHeightMeasureSpecInternal(heightMeasureSpec, flexItem, flexLine.sumCrossSizeBefore);
                int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)newWidth, (int)0x40000000);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
                childMeasuredWidth = child.getMeasuredWidth();
                childMeasuredHeight = child.getMeasuredHeight();
                this.flexContainer.updateViewCache(index, child);
            }
            largestCrossSize = Math.max(largestCrossSize, childMeasuredHeight + flexItem.getMarginTop() + flexItem.getMarginBottom() + this.flexContainer.getDecorationLengthCrossAxis(child));
            flexLine.mainSize += childMeasuredWidth + flexItem.getMarginLeft() + flexItem.getMarginRight();
            flexLine.crossSize = Math.max(flexLine.crossSize, largestCrossSize);
        }
        if (needsReshrink && sizeBeforeShrink != flexLine.mainSize) {
            this.shrinkFlexItems(heightMeasureSpec, flexLine, maxMainSize, paddingAlongMainAxis, true);
        }
    }

    private int getChildHeightMeasureSpecInternal(int heightMeasureSpec, FlexItem flexItem, int padding) {
        int childHeightMeasureSpec = this.flexContainer.getChildHeightMeasureSpec(heightMeasureSpec, this.flexContainer.getPaddingTop() + this.flexContainer.getPaddingBottom() + flexItem.getMarginTop() + flexItem.getMarginBottom() + padding, flexItem.getHeight());
        int childHeight = View.MeasureSpec.getSize((int)childHeightMeasureSpec);
        if (childHeight > flexItem.getMaxHeight()) {
            childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)flexItem.getMaxHeight(), (int)View.MeasureSpec.getMode((int)childHeightMeasureSpec));
        } else if (childHeight < flexItem.getMinHeight()) {
            childHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)flexItem.getMinHeight(), (int)View.MeasureSpec.getMode((int)childHeightMeasureSpec));
        }
        return childHeightMeasureSpec;
    }

    void determineCrossSize(int heightMeasureSpec, int paddingAlongCrossAxis) {
        int mode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int size = View.MeasureSpec.getSize((int)heightMeasureSpec);
        List<FlexLine> flexLines = this.flexContainer.getFlexLinesInternal();
        if (mode == 0x40000000) {
            int totalCrossSize = this.flexContainer.getSumOfCrossSize() + paddingAlongCrossAxis;
            if (flexLines.size() == 1) {
                flexLines.get((int)0).crossSize = size - paddingAlongCrossAxis;
            } else if (flexLines.size() >= 2 && totalCrossSize < size) {
                float freeSpaceUnit = (float)(size - totalCrossSize) / (float)flexLines.size();
                float accumulatedError = 0.0f;
                int flexLinesSize = flexLines.size();
                for (int i = 0; i < flexLinesSize; ++i) {
                    int newCrossSize;
                    FlexLine flexLine = flexLines.get(i);
                    float newCrossSizeAsFloat = (float)flexLine.crossSize + freeSpaceUnit;
                    if (i == flexLines.size() - 1) {
                        newCrossSizeAsFloat += accumulatedError;
                        accumulatedError = 0.0f;
                    }
                    if ((accumulatedError += newCrossSizeAsFloat - (float)(newCrossSize = Math.round(newCrossSizeAsFloat))) > 1.0f) {
                        accumulatedError -= 1.0f;
                    } else if (accumulatedError < -1.0f) {
                        --newCrossSize;
                        accumulatedError += 1.0f;
                    }
                    flexLine.crossSize = ++newCrossSize;
                }
            }
        }
    }

    void stretchViews() {
        if (0 >= this.flexContainer.getFlexItemCount()) {
            return;
        }
        int flexLineIndex = 0;
        List<FlexLine> flexLines = this.flexContainer.getFlexLinesInternal();
        int size = flexLines.size();
        for (int i = flexLineIndex; i < size; ++i) {
            FlexLine flexLine = flexLines.get(i);
            int itemCount = flexLine.itemCount;
            for (int j = 0; j < itemCount; ++j) {
                View view;
                int viewIndex = flexLine.firstIndex + j;
                if (j >= this.flexContainer.getFlexItemCount() || (view = this.flexContainer.getReorderedFlexItemAt(viewIndex)) == null || view.getVisibility() == 8) continue;
                this.stretchViewVertically(view, flexLine.crossSize, viewIndex);
            }
        }
    }

    private void stretchViewVertically(View view, int crossSize, int index) {
        FlexItem flexItem = (FlexItem)view.getLayoutParams();
        int newHeight = crossSize - flexItem.getMarginTop() - flexItem.getMarginBottom() - this.flexContainer.getDecorationLengthCrossAxis(view);
        newHeight = Math.max(newHeight, flexItem.getMinHeight());
        newHeight = Math.min(newHeight, flexItem.getMaxHeight());
        int measuredWidth = view.getMeasuredWidth();
        int childWidthSpec = View.MeasureSpec.makeMeasureSpec((int)measuredWidth, (int)0x40000000);
        int childHeightSpec = View.MeasureSpec.makeMeasureSpec((int)newHeight, (int)0x40000000);
        view.measure(childWidthSpec, childHeightSpec);
        this.flexContainer.updateViewCache(index, view);
    }

    void layoutSingleChildHorizontal(View view, int left, int top, int right, int bottom) {
        FlexItem flexItem = (FlexItem)view.getLayoutParams();
        view.layout(left, top + flexItem.getMarginTop(), right, bottom + flexItem.getMarginTop());
    }

    static class FlexLinesResult {
        List<FlexLine> flexLines;
        int childState;

        FlexLinesResult() {
        }

        void reset() {
            this.flexLines = null;
            this.childState = 0;
        }
    }

    private static class Order
    implements Comparable<Order> {
        int index;
        int order;

        private Order() {
        }

        @Override
        public int compareTo(@NonNull Order another) {
            if (this.order != another.order) {
                return this.order - another.order;
            }
            return this.index - another.index;
        }

        public String toString() {
            return "Order{order=" + this.order + ", index=" + this.index + '}';
        }
    }
}

