/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.widget;

import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.design.R;
import android.support.design.animation.AnimationUtils;
import android.support.design.internal.ThemeEnforcement;
import android.support.design.widget.CoordinatorLayout;
import android.support.design.widget.HeaderBehavior;
import android.support.design.widget.HeaderScrollingViewBehavior;
import android.support.design.widget.ViewUtilsLollipop;
import android.support.v4.math.MathUtils;
import android.support.v4.util.ObjectsCompat;
import android.support.v4.view.AbsSavedState;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.OnApplyWindowInsetsListener;
import android.support.v4.view.ViewCompat;
import android.support.v4.view.WindowInsetsCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.LinearLayout;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

@CoordinatorLayout.DefaultBehavior(value=Behavior.class)
public class AppBarLayout
extends LinearLayout {
    static final int PENDING_ACTION_NONE = 0;
    static final int PENDING_ACTION_EXPANDED = 1;
    static final int PENDING_ACTION_COLLAPSED = 2;
    static final int PENDING_ACTION_ANIMATE_ENABLED = 4;
    static final int PENDING_ACTION_FORCE = 8;
    private static final int INVALID_SCROLL_RANGE = -1;
    private int totalScrollRange = -1;
    private int downPreScrollRange = -1;
    private int downScrollRange = -1;
    private boolean haveChildWithInterpolator;
    private int pendingAction = 0;
    private WindowInsetsCompat lastInsets;
    private List<BaseOnOffsetChangedListener> listeners;
    private boolean liftable;
    private boolean lifted;
    private boolean liftOnScroll;
    private int[] tmpStatesArray;

    public AppBarLayout(Context context) {
        this(context, null);
    }

    public AppBarLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.setOrientation(1);
        if (Build.VERSION.SDK_INT >= 21) {
            ViewUtilsLollipop.setBoundsViewOutlineProvider((View)this);
            ViewUtilsLollipop.setStateListAnimatorFromAttrs((View)this, attrs, 0, R.style.Widget_Design_AppBarLayout);
        }
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.AppBarLayout, 0, R.style.Widget_Design_AppBarLayout);
        ViewCompat.setBackground((View)this, (Drawable)a.getDrawable(R.styleable.AppBarLayout_android_background));
        if (a.hasValue(R.styleable.AppBarLayout_expanded)) {
            this.setExpanded(a.getBoolean(R.styleable.AppBarLayout_expanded, false), false, false);
        }
        if (Build.VERSION.SDK_INT >= 21 && a.hasValue(R.styleable.AppBarLayout_elevation)) {
            ViewUtilsLollipop.setDefaultAppBarLayoutStateListAnimator((View)this, a.getDimensionPixelSize(R.styleable.AppBarLayout_elevation, 0));
        }
        if (Build.VERSION.SDK_INT >= 26) {
            if (a.hasValue(R.styleable.AppBarLayout_android_keyboardNavigationCluster)) {
                this.setKeyboardNavigationCluster(a.getBoolean(R.styleable.AppBarLayout_android_keyboardNavigationCluster, false));
            }
            if (a.hasValue(R.styleable.AppBarLayout_android_touchscreenBlocksFocus)) {
                this.setTouchscreenBlocksFocus(a.getBoolean(R.styleable.AppBarLayout_android_touchscreenBlocksFocus, false));
            }
        }
        this.liftOnScroll = a.getBoolean(R.styleable.AppBarLayout_liftOnScroll, false);
        a.recycle();
        ViewCompat.setOnApplyWindowInsetsListener((View)this, (OnApplyWindowInsetsListener)new OnApplyWindowInsetsListener(){

            public WindowInsetsCompat onApplyWindowInsets(View v, WindowInsetsCompat insets) {
                return AppBarLayout.this.onWindowInsetChanged(insets);
            }
        });
    }

    public void addOnOffsetChangedListener(BaseOnOffsetChangedListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<BaseOnOffsetChangedListener>();
        }
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void addOnOffsetChangedListener(OnOffsetChangedListener listener) {
        this.addOnOffsetChangedListener((BaseOnOffsetChangedListener)listener);
    }

    public void removeOnOffsetChangedListener(BaseOnOffsetChangedListener listener) {
        if (this.listeners != null && listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void removeOnOffsetChangedListener(OnOffsetChangedListener listener) {
        this.removeOnOffsetChangedListener((BaseOnOffsetChangedListener)listener);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.invalidateScrollRanges();
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        this.invalidateScrollRanges();
        this.haveChildWithInterpolator = false;
        int z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            View child = this.getChildAt(i);
            LayoutParams childLp = (LayoutParams)child.getLayoutParams();
            Interpolator interpolator = childLp.getScrollInterpolator();
            if (interpolator == null) continue;
            this.haveChildWithInterpolator = true;
            break;
        }
        this.setLiftableState(this.liftOnScroll || this.hasCollapsibleChild());
    }

    private boolean hasCollapsibleChild() {
        int z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            if (!((LayoutParams)this.getChildAt(i).getLayoutParams()).isCollapsible()) continue;
            return true;
        }
        return false;
    }

    private void invalidateScrollRanges() {
        this.totalScrollRange = -1;
        this.downPreScrollRange = -1;
        this.downScrollRange = -1;
    }

    public void setOrientation(int orientation) {
        if (orientation != 1) {
            throw new IllegalArgumentException("AppBarLayout is always vertical and does not support horizontal orientation");
        }
        super.setOrientation(orientation);
    }

    public void setExpanded(boolean expanded) {
        this.setExpanded(expanded, ViewCompat.isLaidOut((View)this));
    }

    public void setExpanded(boolean expanded, boolean animate) {
        this.setExpanded(expanded, animate, true);
    }

    private void setExpanded(boolean expanded, boolean animate, boolean force) {
        this.pendingAction = (expanded ? 1 : 2) | (animate ? 4 : 0) | (force ? 8 : 0);
        this.requestLayout();
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        if (Build.VERSION.SDK_INT >= 19 && p instanceof LinearLayout.LayoutParams) {
            return new LayoutParams((LinearLayout.LayoutParams)p);
        }
        if (p instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)p);
        }
        return new LayoutParams(p);
    }

    boolean hasChildWithInterpolator() {
        return this.haveChildWithInterpolator;
    }

    public final int getTotalScrollRange() {
        if (this.totalScrollRange != -1) {
            return this.totalScrollRange;
        }
        int range = 0;
        int z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = child.getMeasuredHeight();
            int flags = lp.scrollFlags;
            if ((flags & 1) == 0) break;
            range += childHeight + lp.topMargin + lp.bottomMargin;
            if ((flags & 2) == 0) continue;
            range -= ViewCompat.getMinimumHeight((View)child);
            break;
        }
        this.totalScrollRange = Math.max(0, range - this.getTopInset());
        return this.totalScrollRange;
    }

    boolean hasScrollableChildren() {
        return this.getTotalScrollRange() != 0;
    }

    int getUpNestedPreScrollRange() {
        return this.getTotalScrollRange();
    }

    int getDownNestedPreScrollRange() {
        if (this.downPreScrollRange != -1) {
            return this.downPreScrollRange;
        }
        int range = 0;
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = child.getMeasuredHeight();
            int flags = lp.scrollFlags;
            if ((flags & 5) == 5) {
                range += lp.topMargin + lp.bottomMargin;
                if ((flags & 8) != 0) {
                    range += ViewCompat.getMinimumHeight((View)child);
                    continue;
                }
                if ((flags & 2) != 0) {
                    range += childHeight - ViewCompat.getMinimumHeight((View)child);
                    continue;
                }
                range += childHeight - this.getTopInset();
                continue;
            }
            if (range > 0) break;
        }
        this.downPreScrollRange = Math.max(0, range);
        return this.downPreScrollRange;
    }

    int getDownNestedScrollRange() {
        if (this.downScrollRange != -1) {
            return this.downScrollRange;
        }
        int range = 0;
        int z = this.getChildCount();
        for (int i = 0; i < z; ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childHeight = child.getMeasuredHeight();
            childHeight += lp.topMargin + lp.bottomMargin;
            int flags = lp.scrollFlags;
            if ((flags & 1) == 0) break;
            range += childHeight;
            if ((flags & 2) == 0) continue;
            range -= ViewCompat.getMinimumHeight((View)child) + this.getTopInset();
            break;
        }
        this.downScrollRange = Math.max(0, range);
        return this.downScrollRange;
    }

    void dispatchOffsetUpdates(int offset) {
        if (this.listeners != null) {
            int z = this.listeners.size();
            for (int i = 0; i < z; ++i) {
                BaseOnOffsetChangedListener listener = this.listeners.get(i);
                if (listener == null) continue;
                listener.onOffsetChanged(this, offset);
            }
        }
    }

    public final int getMinimumHeightForVisibleOverlappingContent() {
        int lastChildMinHeight;
        int topInset = this.getTopInset();
        int minHeight = ViewCompat.getMinimumHeight((View)this);
        if (minHeight != 0) {
            return minHeight * 2 + topInset;
        }
        int childCount = this.getChildCount();
        int n = lastChildMinHeight = childCount >= 1 ? ViewCompat.getMinimumHeight((View)this.getChildAt(childCount - 1)) : 0;
        if (lastChildMinHeight != 0) {
            return lastChildMinHeight * 2 + topInset;
        }
        return this.getHeight() / 3;
    }

    protected int[] onCreateDrawableState(int extraSpace) {
        if (this.tmpStatesArray == null) {
            this.tmpStatesArray = new int[4];
        }
        int[] extraStates = this.tmpStatesArray;
        int[] states = super.onCreateDrawableState(extraSpace + extraStates.length);
        extraStates[0] = this.liftable ? R.attr.state_liftable : -R.attr.state_liftable;
        extraStates[1] = this.liftable && this.lifted ? R.attr.state_lifted : -R.attr.state_lifted;
        extraStates[2] = this.liftable ? R.attr.state_collapsible : -R.attr.state_collapsible;
        extraStates[3] = this.liftable && this.lifted ? R.attr.state_collapsed : -R.attr.state_collapsed;
        return AppBarLayout.mergeDrawableStates((int[])states, (int[])extraStates);
    }

    private boolean setLiftableState(boolean liftable) {
        if (this.liftable != liftable) {
            this.liftable = liftable;
            this.refreshDrawableState();
            return true;
        }
        return false;
    }

    boolean setLiftedState(boolean lifted) {
        if (this.lifted != lifted) {
            this.lifted = lifted;
            this.refreshDrawableState();
            return true;
        }
        return false;
    }

    public void setLiftOnScroll(boolean liftOnScroll) {
        this.liftOnScroll = liftOnScroll;
    }

    public boolean isLiftOnScroll() {
        return this.liftOnScroll;
    }

    @Deprecated
    public void setTargetElevation(float elevation) {
        if (Build.VERSION.SDK_INT >= 21) {
            ViewUtilsLollipop.setDefaultAppBarLayoutStateListAnimator((View)this, elevation);
        }
    }

    @Deprecated
    public float getTargetElevation() {
        return 0.0f;
    }

    int getPendingAction() {
        return this.pendingAction;
    }

    void resetPendingAction() {
        this.pendingAction = 0;
    }

    @VisibleForTesting
    final int getTopInset() {
        return this.lastInsets != null ? this.lastInsets.getSystemWindowInsetTop() : 0;
    }

    WindowInsetsCompat onWindowInsetChanged(WindowInsetsCompat insets) {
        WindowInsetsCompat newInsets = null;
        if (ViewCompat.getFitsSystemWindows((View)this)) {
            newInsets = insets;
        }
        if (!ObjectsCompat.equals((Object)this.lastInsets, (Object)newInsets)) {
            this.lastInsets = newInsets;
            this.invalidateScrollRanges();
        }
        return insets;
    }

    public static class ScrollingViewBehavior
    extends HeaderScrollingViewBehavior {
        public ScrollingViewBehavior() {
        }

        public ScrollingViewBehavior(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ScrollingViewBehavior_Layout);
            this.setOverlayTop(a.getDimensionPixelSize(R.styleable.ScrollingViewBehavior_Layout_behavior_overlapTop, 0));
            a.recycle();
        }

        public boolean layoutDependsOn(CoordinatorLayout parent, View child, View dependency) {
            return dependency instanceof AppBarLayout;
        }

        public boolean onDependentViewChanged(CoordinatorLayout parent, View child, View dependency) {
            this.offsetChildAsNeeded(child, dependency);
            this.updateLiftedStateIfNeeded(child, dependency);
            return false;
        }

        public boolean onRequestChildRectangleOnScreen(CoordinatorLayout parent, View child, Rect rectangle, boolean immediate) {
            AppBarLayout header = this.findFirstDependency((List<View>)parent.getDependencies(child));
            if (header != null) {
                rectangle.offset(child.getLeft(), child.getTop());
                Rect parentRect = this.tempRect1;
                parentRect.set(0, 0, parent.getWidth(), parent.getHeight());
                if (!parentRect.contains(rectangle)) {
                    header.setExpanded(false, !immediate);
                    return true;
                }
            }
            return false;
        }

        private void offsetChildAsNeeded(View child, View dependency) {
            CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)dependency.getLayoutParams()).getBehavior();
            if (behavior instanceof BaseBehavior) {
                BaseBehavior ablBehavior = (BaseBehavior)behavior;
                ViewCompat.offsetTopAndBottom((View)child, (int)(dependency.getBottom() - child.getTop() + ablBehavior.offsetDelta + this.getVerticalLayoutGap() - this.getOverlapPixelsForOffset(dependency)));
            }
        }

        @Override
        float getOverlapRatioForOffset(View header) {
            if (header instanceof AppBarLayout) {
                AppBarLayout abl = (AppBarLayout)header;
                int totalScrollRange = abl.getTotalScrollRange();
                int preScrollDown = abl.getDownNestedPreScrollRange();
                int offset = ScrollingViewBehavior.getAppBarLayoutOffset(abl);
                if (preScrollDown != 0 && totalScrollRange + offset <= preScrollDown) {
                    return 0.0f;
                }
                int availScrollRange = totalScrollRange - preScrollDown;
                if (availScrollRange != 0) {
                    return 1.0f + (float)offset / (float)availScrollRange;
                }
            }
            return 0.0f;
        }

        private static int getAppBarLayoutOffset(AppBarLayout abl) {
            CoordinatorLayout.Behavior behavior = ((CoordinatorLayout.LayoutParams)abl.getLayoutParams()).getBehavior();
            if (behavior instanceof BaseBehavior) {
                return ((BaseBehavior)behavior).getTopBottomOffsetForScrollingSibling();
            }
            return 0;
        }

        AppBarLayout findFirstDependency(List<View> views) {
            int z = views.size();
            for (int i = 0; i < z; ++i) {
                View view = views.get(i);
                if (!(view instanceof AppBarLayout)) continue;
                return (AppBarLayout)view;
            }
            return null;
        }

        @Override
        int getScrollRange(View v) {
            if (v instanceof AppBarLayout) {
                return ((AppBarLayout)v).getTotalScrollRange();
            }
            return super.getScrollRange(v);
        }

        private void updateLiftedStateIfNeeded(View child, View dependency) {
            AppBarLayout appBarLayout;
            if (dependency instanceof AppBarLayout && (appBarLayout = (AppBarLayout)dependency).isLiftOnScroll()) {
                appBarLayout.setLiftedState(child.getScrollY() > 0);
            }
        }
    }

    protected static class BaseBehavior<T extends AppBarLayout>
    extends HeaderBehavior<T> {
        private static final int MAX_OFFSET_ANIMATION_DURATION = 600;
        private static final int INVALID_POSITION = -1;
        private int offsetDelta;
        private int lastStartedType;
        private ValueAnimator offsetAnimator;
        private int offsetToChildIndexOnLayout = -1;
        private boolean offsetToChildIndexOnLayoutIsMinHeight;
        private float offsetToChildIndexOnLayoutPerc;
        private WeakReference<View> lastNestedScrollingChildRef;
        private BaseDragCallback onDragCallback;

        public BaseBehavior() {
        }

        public BaseBehavior(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public boolean onStartNestedScroll(CoordinatorLayout parent, T child, View directTargetChild, View target, int nestedScrollAxes, int type) {
            boolean started;
            boolean bl = started = (nestedScrollAxes & 2) != 0 && (((AppBarLayout)((Object)child)).isLiftOnScroll() || ((AppBarLayout)((Object)child)).hasScrollableChildren()) && parent.getHeight() - directTargetChild.getHeight() <= child.getHeight();
            if (started && this.offsetAnimator != null) {
                this.offsetAnimator.cancel();
            }
            this.lastNestedScrollingChildRef = null;
            this.lastStartedType = type;
            return started;
        }

        public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, T child, View target, int dx, int dy, int[] consumed, int type) {
            if (dy != 0) {
                int max;
                int min;
                if (dy < 0) {
                    min = -((AppBarLayout)((Object)child)).getTotalScrollRange();
                    max = min + ((AppBarLayout)((Object)child)).getDownNestedPreScrollRange();
                } else {
                    min = -((AppBarLayout)((Object)child)).getUpNestedPreScrollRange();
                    max = 0;
                }
                if (min != max) {
                    consumed[1] = this.scroll(coordinatorLayout, child, dy, min, max);
                    this.stopNestedScrollIfNeeded(dy, child, target, type);
                }
            }
        }

        public void onNestedScroll(CoordinatorLayout coordinatorLayout, T child, View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type) {
            if (dyUnconsumed < 0) {
                this.scroll(coordinatorLayout, child, dyUnconsumed, -((AppBarLayout)((Object)child)).getDownNestedScrollRange(), 0);
                this.stopNestedScrollIfNeeded(dyUnconsumed, child, target, type);
            }
            if (((AppBarLayout)((Object)child)).isLiftOnScroll()) {
                ((AppBarLayout)((Object)child)).setLiftedState(target.getScrollY() > 0);
            }
        }

        private void stopNestedScrollIfNeeded(int dy, T child, View target, int type) {
            if (type == 1) {
                int curOffset = this.getTopBottomOffsetForScrollingSibling();
                if (dy < 0 && curOffset == 0 || dy > 0 && curOffset == -((AppBarLayout)((Object)child)).getDownNestedScrollRange()) {
                    ViewCompat.stopNestedScroll((View)target, (int)1);
                }
            }
        }

        public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, T abl, View target, int type) {
            if (this.lastStartedType == 0 || type == 1) {
                this.snapToChildIfNeeded(coordinatorLayout, abl);
            }
            this.lastNestedScrollingChildRef = new WeakReference<View>(target);
        }

        public void setDragCallback(@Nullable BaseDragCallback callback) {
            this.onDragCallback = callback;
        }

        private void animateOffsetTo(CoordinatorLayout coordinatorLayout, T child, int offset, float velocity) {
            int duration;
            int distance = Math.abs(this.getTopBottomOffsetForScrollingSibling() - offset);
            if ((velocity = Math.abs(velocity)) > 0.0f) {
                duration = 3 * Math.round(1000.0f * ((float)distance / velocity));
            } else {
                float distanceRatio = (float)distance / (float)child.getHeight();
                duration = (int)((distanceRatio + 1.0f) * 150.0f);
            }
            this.animateOffsetWithDuration(coordinatorLayout, child, offset, duration);
        }

        private void animateOffsetWithDuration(final CoordinatorLayout coordinatorLayout, T child, int offset, int duration) {
            int currentOffset = this.getTopBottomOffsetForScrollingSibling();
            if (currentOffset == offset) {
                if (this.offsetAnimator != null && this.offsetAnimator.isRunning()) {
                    this.offsetAnimator.cancel();
                }
                return;
            }
            if (this.offsetAnimator == null) {
                this.offsetAnimator = new ValueAnimator();
                this.offsetAnimator.setInterpolator(AnimationUtils.DECELERATE_INTERPOLATOR);
                this.offsetAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener((AppBarLayout)((Object)child)){
                    final /* synthetic */ AppBarLayout val$child;
                    {
                        this.val$child = appBarLayout;
                    }

                    public void onAnimationUpdate(ValueAnimator animator) {
                        BaseBehavior.this.setHeaderTopBottomOffset(coordinatorLayout, this.val$child, (Integer)animator.getAnimatedValue());
                    }
                });
            } else {
                this.offsetAnimator.cancel();
            }
            this.offsetAnimator.setDuration((long)Math.min(duration, 600));
            this.offsetAnimator.setIntValues(new int[]{currentOffset, offset});
            this.offsetAnimator.start();
        }

        private int getChildIndexOnOffset(T abl, int offset) {
            int count = abl.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = abl.getChildAt(i);
                int top = child.getTop();
                int bottom = child.getBottom();
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (BaseBehavior.checkFlag(lp.getScrollFlags(), 32)) {
                    top -= lp.topMargin;
                    bottom += lp.bottomMargin;
                }
                if (top > -offset || bottom < -offset) continue;
                return i;
            }
            return -1;
        }

        private void snapToChildIfNeeded(CoordinatorLayout coordinatorLayout, T abl) {
            View offsetChild;
            LayoutParams lp;
            int flags;
            int offset = this.getTopBottomOffsetForScrollingSibling();
            int offsetChildIndex = this.getChildIndexOnOffset(abl, offset);
            if (offsetChildIndex >= 0 && ((flags = (lp = (LayoutParams)(offsetChild = abl.getChildAt(offsetChildIndex)).getLayoutParams()).getScrollFlags()) & 0x11) == 17) {
                int snapTop = -offsetChild.getTop();
                int snapBottom = -offsetChild.getBottom();
                if (offsetChildIndex == abl.getChildCount() - 1) {
                    snapBottom += ((AppBarLayout)((Object)abl)).getTopInset();
                }
                if (BaseBehavior.checkFlag(flags, 2)) {
                    snapBottom += ViewCompat.getMinimumHeight((View)offsetChild);
                } else if (BaseBehavior.checkFlag(flags, 5)) {
                    int seam = snapBottom + ViewCompat.getMinimumHeight((View)offsetChild);
                    if (offset < seam) {
                        snapTop = seam;
                    } else {
                        snapBottom = seam;
                    }
                }
                if (BaseBehavior.checkFlag(flags, 32)) {
                    snapTop += lp.topMargin;
                    snapBottom -= lp.bottomMargin;
                }
                int newOffset = offset < (snapBottom + snapTop) / 2 ? snapBottom : snapTop;
                this.animateOffsetTo(coordinatorLayout, abl, MathUtils.clamp((int)newOffset, (int)(-((AppBarLayout)((Object)abl)).getTotalScrollRange()), (int)0), 0.0f);
            }
        }

        private static boolean checkFlag(int flags, int check) {
            return (flags & check) == check;
        }

        public boolean onMeasureChild(CoordinatorLayout parent, T child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
            CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)child.getLayoutParams();
            if (lp.height == -2) {
                parent.onMeasureChild(child, parentWidthMeasureSpec, widthUsed, View.MeasureSpec.makeMeasureSpec((int)0, (int)0), heightUsed);
                return true;
            }
            return super.onMeasureChild(parent, child, parentWidthMeasureSpec, widthUsed, parentHeightMeasureSpec, heightUsed);
        }

        @Override
        public boolean onLayoutChild(CoordinatorLayout parent, T abl, int layoutDirection) {
            boolean handled = super.onLayoutChild(parent, abl, layoutDirection);
            int pendingAction = ((AppBarLayout)((Object)abl)).getPendingAction();
            if (this.offsetToChildIndexOnLayout >= 0 && (pendingAction & 8) == 0) {
                View child = abl.getChildAt(this.offsetToChildIndexOnLayout);
                int offset = -child.getBottom();
                offset = this.offsetToChildIndexOnLayoutIsMinHeight ? (offset += ViewCompat.getMinimumHeight((View)child) + ((AppBarLayout)((Object)abl)).getTopInset()) : (offset += Math.round((float)child.getHeight() * this.offsetToChildIndexOnLayoutPerc));
                this.setHeaderTopBottomOffset(parent, abl, offset);
            } else if (pendingAction != 0) {
                boolean animate;
                boolean bl = animate = (pendingAction & 4) != 0;
                if ((pendingAction & 2) != 0) {
                    int offset = -((AppBarLayout)((Object)abl)).getUpNestedPreScrollRange();
                    if (animate) {
                        this.animateOffsetTo(parent, abl, offset, 0.0f);
                    } else {
                        this.setHeaderTopBottomOffset(parent, abl, offset);
                    }
                } else if ((pendingAction & 1) != 0) {
                    if (animate) {
                        this.animateOffsetTo(parent, abl, 0, 0.0f);
                    } else {
                        this.setHeaderTopBottomOffset(parent, abl, 0);
                    }
                }
            }
            ((AppBarLayout)((Object)abl)).resetPendingAction();
            this.offsetToChildIndexOnLayout = -1;
            this.setTopAndBottomOffset(MathUtils.clamp((int)this.getTopAndBottomOffset(), (int)(-((AppBarLayout)((Object)abl)).getTotalScrollRange()), (int)0));
            this.updateAppBarLayoutDrawableState(parent, abl, this.getTopAndBottomOffset(), 0, true);
            ((AppBarLayout)((Object)abl)).dispatchOffsetUpdates(this.getTopAndBottomOffset());
            return handled;
        }

        @Override
        boolean canDragView(T view) {
            if (this.onDragCallback != null) {
                return this.onDragCallback.canDrag(view);
            }
            if (this.lastNestedScrollingChildRef != null) {
                View scrollingView = (View)this.lastNestedScrollingChildRef.get();
                return scrollingView != null && scrollingView.isShown() && !scrollingView.canScrollVertically(-1);
            }
            return true;
        }

        @Override
        void onFlingFinished(CoordinatorLayout parent, T layout) {
            this.snapToChildIfNeeded(parent, layout);
        }

        @Override
        int getMaxDragOffset(T view) {
            return -((AppBarLayout)((Object)view)).getDownNestedScrollRange();
        }

        @Override
        int getScrollRangeForDragFling(T view) {
            return ((AppBarLayout)((Object)view)).getTotalScrollRange();
        }

        @Override
        int setHeaderTopBottomOffset(CoordinatorLayout coordinatorLayout, T appBarLayout, int newOffset, int minOffset, int maxOffset) {
            int curOffset = this.getTopBottomOffsetForScrollingSibling();
            int consumed = 0;
            if (minOffset != 0 && curOffset >= minOffset && curOffset <= maxOffset) {
                if (curOffset != (newOffset = MathUtils.clamp((int)newOffset, (int)minOffset, (int)maxOffset))) {
                    int interpolatedOffset = ((AppBarLayout)((Object)appBarLayout)).hasChildWithInterpolator() ? this.interpolateOffset(appBarLayout, newOffset) : newOffset;
                    boolean offsetChanged = this.setTopAndBottomOffset(interpolatedOffset);
                    consumed = curOffset - newOffset;
                    this.offsetDelta = newOffset - interpolatedOffset;
                    if (!offsetChanged && ((AppBarLayout)((Object)appBarLayout)).hasChildWithInterpolator()) {
                        coordinatorLayout.dispatchDependentViewsChanged(appBarLayout);
                    }
                    ((AppBarLayout)((Object)appBarLayout)).dispatchOffsetUpdates(this.getTopAndBottomOffset());
                    this.updateAppBarLayoutDrawableState(coordinatorLayout, appBarLayout, newOffset, newOffset < curOffset ? -1 : 1, false);
                }
            } else {
                this.offsetDelta = 0;
            }
            return consumed;
        }

        @VisibleForTesting
        boolean isOffsetAnimatorRunning() {
            return this.offsetAnimator != null && this.offsetAnimator.isRunning();
        }

        private int interpolateOffset(T layout, int offset) {
            int absOffset = Math.abs(offset);
            int z = layout.getChildCount();
            for (int i = 0; i < z; ++i) {
                View child = layout.getChildAt(i);
                LayoutParams childLp = (LayoutParams)child.getLayoutParams();
                Interpolator interpolator = childLp.getScrollInterpolator();
                if (absOffset < child.getTop() || absOffset > child.getBottom()) continue;
                if (interpolator == null) break;
                int childScrollableHeight = 0;
                int flags = childLp.getScrollFlags();
                if ((flags & 1) != 0) {
                    childScrollableHeight += child.getHeight() + childLp.topMargin + childLp.bottomMargin;
                    if ((flags & 2) != 0) {
                        childScrollableHeight -= ViewCompat.getMinimumHeight((View)child);
                    }
                }
                if (ViewCompat.getFitsSystemWindows((View)child)) {
                    childScrollableHeight -= ((AppBarLayout)((Object)layout)).getTopInset();
                }
                if (childScrollableHeight <= 0) break;
                int offsetForView = absOffset - child.getTop();
                int interpolatedDiff = Math.round((float)childScrollableHeight * interpolator.getInterpolation((float)offsetForView / (float)childScrollableHeight));
                return Integer.signum(offset) * (child.getTop() + interpolatedDiff);
            }
            return offset;
        }

        private void updateAppBarLayoutDrawableState(CoordinatorLayout parent, T layout, int offset, int direction, boolean forceJump) {
            View child = BaseBehavior.getAppBarChildOnOffset(layout, offset);
            if (child != null) {
                View scrollingChild;
                LayoutParams childLp = (LayoutParams)child.getLayoutParams();
                int flags = childLp.getScrollFlags();
                boolean lifted = false;
                if ((flags & 1) != 0) {
                    int minHeight = ViewCompat.getMinimumHeight((View)child);
                    if (direction > 0 && (flags & 0xC) != 0) {
                        lifted = -offset >= child.getBottom() - minHeight - ((AppBarLayout)((Object)layout)).getTopInset();
                    } else if ((flags & 2) != 0) {
                        boolean bl = lifted = -offset >= child.getBottom() - minHeight - ((AppBarLayout)((Object)layout)).getTopInset();
                    }
                }
                if (((AppBarLayout)((Object)layout)).isLiftOnScroll() && (scrollingChild = this.findFirstScrollingChild(parent)) != null) {
                    lifted = scrollingChild.getScrollY() > 0;
                }
                boolean changed = ((AppBarLayout)((Object)layout)).setLiftedState(lifted);
                if (Build.VERSION.SDK_INT >= 11 && (forceJump || changed && this.shouldJumpElevationState(parent, layout))) {
                    layout.jumpDrawablesToCurrentState();
                }
            }
        }

        private boolean shouldJumpElevationState(CoordinatorLayout parent, T layout) {
            List dependencies = parent.getDependents(layout);
            int size = dependencies.size();
            for (int i = 0; i < size; ++i) {
                View dependency = (View)dependencies.get(i);
                CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)dependency.getLayoutParams();
                CoordinatorLayout.Behavior behavior = lp.getBehavior();
                if (!(behavior instanceof ScrollingViewBehavior)) continue;
                return ((ScrollingViewBehavior)behavior).getOverlayTop() != 0;
            }
            return false;
        }

        private static View getAppBarChildOnOffset(AppBarLayout layout, int offset) {
            int absOffset = Math.abs(offset);
            int z = layout.getChildCount();
            for (int i = 0; i < z; ++i) {
                View child = layout.getChildAt(i);
                if (absOffset < child.getTop() || absOffset > child.getBottom()) continue;
                return child;
            }
            return null;
        }

        @Nullable
        private View findFirstScrollingChild(CoordinatorLayout parent) {
            int z = parent.getChildCount();
            for (int i = 0; i < z; ++i) {
                View child = parent.getChildAt(i);
                if (!(child instanceof NestedScrollingChild)) continue;
                return child;
            }
            return null;
        }

        @Override
        int getTopBottomOffsetForScrollingSibling() {
            return this.getTopAndBottomOffset() + this.offsetDelta;
        }

        public Parcelable onSaveInstanceState(CoordinatorLayout parent, T abl) {
            Parcelable superState = super.onSaveInstanceState(parent, abl);
            int offset = this.getTopAndBottomOffset();
            int count = abl.getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = abl.getChildAt(i);
                int visBottom = child.getBottom() + offset;
                if (child.getTop() + offset > 0 || visBottom < 0) continue;
                SavedState ss = new SavedState(superState);
                ss.firstVisibleChildIndex = i;
                ss.firstVisibleChildAtMinimumHeight = visBottom == ViewCompat.getMinimumHeight((View)child) + ((AppBarLayout)((Object)abl)).getTopInset();
                ss.firstVisibleChildPercentageShown = (float)visBottom / (float)child.getHeight();
                return ss;
            }
            return superState;
        }

        public void onRestoreInstanceState(CoordinatorLayout parent, T appBarLayout, Parcelable state) {
            if (state instanceof SavedState) {
                SavedState ss = (SavedState)state;
                super.onRestoreInstanceState(parent, appBarLayout, ss.getSuperState());
                this.offsetToChildIndexOnLayout = ss.firstVisibleChildIndex;
                this.offsetToChildIndexOnLayoutPerc = ss.firstVisibleChildPercentageShown;
                this.offsetToChildIndexOnLayoutIsMinHeight = ss.firstVisibleChildAtMinimumHeight;
            } else {
                super.onRestoreInstanceState(parent, appBarLayout, state);
                this.offsetToChildIndexOnLayout = -1;
            }
        }

        protected static class SavedState
        extends AbsSavedState {
            int firstVisibleChildIndex;
            float firstVisibleChildPercentageShown;
            boolean firstVisibleChildAtMinimumHeight;
            public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

                public SavedState createFromParcel(Parcel source, ClassLoader loader) {
                    return new SavedState(source, loader);
                }

                public SavedState createFromParcel(Parcel source) {
                    return new SavedState(source, null);
                }

                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            };

            public SavedState(Parcel source, ClassLoader loader) {
                super(source, loader);
                this.firstVisibleChildIndex = source.readInt();
                this.firstVisibleChildPercentageShown = source.readFloat();
                this.firstVisibleChildAtMinimumHeight = source.readByte() != 0;
            }

            public SavedState(Parcelable superState) {
                super(superState);
            }

            public void writeToParcel(Parcel dest, int flags) {
                super.writeToParcel(dest, flags);
                dest.writeInt(this.firstVisibleChildIndex);
                dest.writeFloat(this.firstVisibleChildPercentageShown);
                dest.writeByte((byte)(this.firstVisibleChildAtMinimumHeight ? 1 : 0));
            }
        }

        public static abstract class BaseDragCallback<T extends AppBarLayout> {
            public abstract boolean canDrag(@NonNull T var1);
        }
    }

    public static class Behavior
    extends BaseBehavior<AppBarLayout> {
        public Behavior() {
        }

        public Behavior(Context context, AttributeSet attrs) {
            super(context, attrs);
        }

        public static abstract class DragCallback
        extends BaseBehavior.BaseDragCallback<AppBarLayout> {
        }
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        public static final int SCROLL_FLAG_SCROLL = 1;
        public static final int SCROLL_FLAG_EXIT_UNTIL_COLLAPSED = 2;
        public static final int SCROLL_FLAG_ENTER_ALWAYS = 4;
        public static final int SCROLL_FLAG_ENTER_ALWAYS_COLLAPSED = 8;
        public static final int SCROLL_FLAG_SNAP = 16;
        public static final int SCROLL_FLAG_SNAP_MARGINS = 32;
        static final int FLAG_QUICK_RETURN = 5;
        static final int FLAG_SNAP = 17;
        static final int COLLAPSIBLE_FLAGS = 10;
        int scrollFlags = 1;
        Interpolator scrollInterpolator;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.AppBarLayout_Layout);
            this.scrollFlags = a.getInt(R.styleable.AppBarLayout_Layout_layout_scrollFlags, 0);
            if (a.hasValue(R.styleable.AppBarLayout_Layout_layout_scrollInterpolator)) {
                int resId = a.getResourceId(R.styleable.AppBarLayout_Layout_layout_scrollInterpolator, 0);
                this.scrollInterpolator = android.view.animation.AnimationUtils.loadInterpolator((Context)c, (int)resId);
            }
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(int width, int height, float weight) {
            super(width, height, weight);
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        @RequiresApi(value=19)
        public LayoutParams(LinearLayout.LayoutParams source) {
            super(source);
        }

        @RequiresApi(value=19)
        public LayoutParams(LayoutParams source) {
            super((LinearLayout.LayoutParams)source);
            this.scrollFlags = source.scrollFlags;
            this.scrollInterpolator = source.scrollInterpolator;
        }

        public void setScrollFlags(int flags) {
            this.scrollFlags = flags;
        }

        public int getScrollFlags() {
            return this.scrollFlags;
        }

        public void setScrollInterpolator(Interpolator interpolator) {
            this.scrollInterpolator = interpolator;
        }

        public Interpolator getScrollInterpolator() {
            return this.scrollInterpolator;
        }

        boolean isCollapsible() {
            return (this.scrollFlags & 1) == 1 && (this.scrollFlags & 0xA) != 0;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public static @interface ScrollFlags {
        }
    }

    public static interface OnOffsetChangedListener
    extends BaseOnOffsetChangedListener<AppBarLayout> {
        @Override
        public void onOffsetChanged(AppBarLayout var1, int var2);
    }

    public static interface BaseOnOffsetChangedListener<T extends AppBarLayout> {
        public void onOffsetChanged(T var1, int var2);
    }
}

