/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.animation;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.design.animation.AnimationUtils;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;

public class MotionTiming {
    private long delay = 0L;
    private long duration = 300L;
    @Nullable
    private TimeInterpolator interpolator = null;
    private int repeatCount = 0;
    private int repeatMode = 1;

    public MotionTiming(long delay, long duration) {
        this.delay = delay;
        this.duration = duration;
    }

    public MotionTiming(long delay, long duration, @NonNull TimeInterpolator interpolator) {
        this.delay = delay;
        this.duration = duration;
        this.interpolator = interpolator;
    }

    public void apply(Animator animator) {
        animator.setStartDelay(this.getDelay());
        animator.setDuration(this.getDuration());
        animator.setInterpolator(this.getInterpolator());
        if (animator instanceof ValueAnimator) {
            ((ValueAnimator)animator).setRepeatCount(this.getRepeatCount());
            ((ValueAnimator)animator).setRepeatMode(this.getRepeatMode());
        }
    }

    public long getDelay() {
        return this.delay;
    }

    public long getDuration() {
        return this.duration;
    }

    public TimeInterpolator getInterpolator() {
        return this.interpolator != null ? this.interpolator : AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public int getRepeatMode() {
        return this.repeatMode;
    }

    static MotionTiming createFromAnimator(ValueAnimator animator) {
        MotionTiming timing = new MotionTiming(animator.getStartDelay(), animator.getDuration(), MotionTiming.getInterpolatorCompat(animator));
        timing.repeatCount = animator.getRepeatCount();
        timing.repeatMode = animator.getRepeatMode();
        return timing;
    }

    private static TimeInterpolator getInterpolatorCompat(ValueAnimator animator) {
        TimeInterpolator interpolator = animator.getInterpolator();
        if (interpolator instanceof AccelerateDecelerateInterpolator || interpolator == null) {
            return AnimationUtils.FAST_OUT_SLOW_IN_INTERPOLATOR;
        }
        if (interpolator instanceof AccelerateInterpolator) {
            return AnimationUtils.FAST_OUT_LINEAR_IN_INTERPOLATOR;
        }
        if (interpolator instanceof DecelerateInterpolator) {
            return AnimationUtils.LINEAR_OUT_SLOW_IN_INTERPOLATOR;
        }
        return interpolator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MotionTiming that = (MotionTiming)o;
        if (this.getDelay() != that.getDelay()) {
            return false;
        }
        if (this.getDuration() != that.getDuration()) {
            return false;
        }
        if (this.getRepeatCount() != that.getRepeatCount()) {
            return false;
        }
        if (this.getRepeatMode() != that.getRepeatMode()) {
            return false;
        }
        return this.getInterpolator().getClass().equals(that.getInterpolator().getClass());
    }

    public int hashCode() {
        int result = (int)(this.getDelay() ^ this.getDelay() >>> 32);
        result = 31 * result + (int)(this.getDuration() ^ this.getDuration() >>> 32);
        result = 31 * result + this.getInterpolator().getClass().hashCode();
        result = 31 * result + this.getRepeatCount();
        result = 31 * result + this.getRepeatMode();
        return result;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append('\n');
        out.append(this.getClass().getName());
        out.append('{');
        out.append(Integer.toHexString(System.identityHashCode(this)));
        out.append(" delay: ");
        out.append(this.getDelay());
        out.append(" duration: ");
        out.append(this.getDuration());
        out.append(" interpolator: ");
        out.append(this.getInterpolator().getClass());
        out.append(" repeatCount: ");
        out.append(this.getRepeatCount());
        out.append(" repeatMode: ");
        out.append(this.getRepeatMode());
        out.append("}\n");
        return out.toString();
    }
}

