/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.expandable;

import android.os.Bundle;
import android.support.annotation.IdRes;
import android.support.design.expandable.ExpandableWidget;
import android.support.design.widget.CoordinatorLayout;
import android.view.View;
import android.view.ViewParent;

public final class ExpandableWidgetHelper {
    private final View widget;
    private boolean expanded = false;
    @IdRes
    private int expandedComponentIdHint = 0;

    public ExpandableWidgetHelper(ExpandableWidget widget) {
        this.widget = (View)widget;
    }

    public boolean setExpanded(boolean expanded) {
        if (this.expanded != expanded) {
            this.expanded = expanded;
            this.dispatchExpandedStateChanged();
            return true;
        }
        return false;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public Bundle onSaveInstanceState() {
        Bundle state = new Bundle();
        state.putBoolean("expanded", this.expanded);
        state.putInt("expandedComponentIdHint", this.expandedComponentIdHint);
        return state;
    }

    public void onRestoreInstanceState(Bundle state) {
        this.expanded = state.getBoolean("expanded", false);
        this.expandedComponentIdHint = state.getInt("expandedComponentIdHint", 0);
        if (this.expanded) {
            this.dispatchExpandedStateChanged();
        }
    }

    public void setExpandedComponentIdHint(@IdRes int expandedComponentIdHint) {
        this.expandedComponentIdHint = expandedComponentIdHint;
    }

    @IdRes
    public int getExpandedComponentIdHint() {
        return this.expandedComponentIdHint;
    }

    private void dispatchExpandedStateChanged() {
        ViewParent parent = this.widget.getParent();
        if (parent instanceof CoordinatorLayout) {
            ((CoordinatorLayout)parent).dispatchDependentViewsChanged(this.widget);
        }
    }
}

