/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.design.R;
import android.support.design.internal.ThemeEnforcement;
import android.support.v7.widget.LinearLayoutCompat;
import android.util.AttributeSet;
import android.view.Gravity;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ForegroundLinearLayout
extends LinearLayoutCompat {
    private Drawable foreground;
    private final Rect selfBounds = new Rect();
    private final Rect overlayBounds = new Rect();
    private int foregroundGravity = 119;
    protected boolean mForegroundInPadding = true;
    boolean foregroundBoundsChanged = false;

    public ForegroundLinearLayout(Context context) {
        this(context, null);
    }

    public ForegroundLinearLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ForegroundLinearLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.ForegroundLinearLayout, defStyle, 0, new int[0]);
        this.foregroundGravity = a.getInt(R.styleable.ForegroundLinearLayout_android_foregroundGravity, this.foregroundGravity);
        Drawable d = a.getDrawable(R.styleable.ForegroundLinearLayout_android_foreground);
        if (d != null) {
            this.setForeground(d);
        }
        this.mForegroundInPadding = a.getBoolean(R.styleable.ForegroundLinearLayout_foregroundInsidePadding, true);
        a.recycle();
    }

    public int getForegroundGravity() {
        return this.foregroundGravity;
    }

    public void setForegroundGravity(int foregroundGravity) {
        if (this.foregroundGravity != foregroundGravity) {
            if ((foregroundGravity & 0x800007) == 0) {
                foregroundGravity |= 0x800003;
            }
            if ((foregroundGravity & 0x70) == 0) {
                foregroundGravity |= 0x30;
            }
            this.foregroundGravity = foregroundGravity;
            if (this.foregroundGravity == 119 && this.foreground != null) {
                Rect padding = new Rect();
                this.foreground.getPadding(padding);
            }
            this.requestLayout();
        }
    }

    protected boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.foreground;
    }

    @RequiresApi(value=11)
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.foreground != null) {
            this.foreground.jumpToCurrentState();
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.foreground != null && this.foreground.isStateful()) {
            this.foreground.setState(this.getDrawableState());
        }
    }

    public void setForeground(Drawable drawable2) {
        if (this.foreground != drawable2) {
            if (this.foreground != null) {
                this.foreground.setCallback(null);
                this.unscheduleDrawable(this.foreground);
            }
            this.foreground = drawable2;
            if (drawable2 != null) {
                this.setWillNotDraw(false);
                drawable2.setCallback((Drawable.Callback)this);
                if (drawable2.isStateful()) {
                    drawable2.setState(this.getDrawableState());
                }
                if (this.foregroundGravity == 119) {
                    Rect padding = new Rect();
                    drawable2.getPadding(padding);
                }
            } else {
                this.setWillNotDraw(true);
            }
            this.requestLayout();
            this.invalidate();
        }
    }

    public Drawable getForeground() {
        return this.foreground;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.foregroundBoundsChanged |= changed;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.foregroundBoundsChanged = true;
    }

    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        if (this.foreground != null) {
            Drawable foreground = this.foreground;
            if (this.foregroundBoundsChanged) {
                this.foregroundBoundsChanged = false;
                Rect selfBounds = this.selfBounds;
                Rect overlayBounds = this.overlayBounds;
                int w = this.getRight() - this.getLeft();
                int h = this.getBottom() - this.getTop();
                if (this.mForegroundInPadding) {
                    selfBounds.set(0, 0, w, h);
                } else {
                    selfBounds.set(this.getPaddingLeft(), this.getPaddingTop(), w - this.getPaddingRight(), h - this.getPaddingBottom());
                }
                Gravity.apply((int)this.foregroundGravity, (int)foreground.getIntrinsicWidth(), (int)foreground.getIntrinsicHeight(), (Rect)selfBounds, (Rect)overlayBounds);
                foreground.setBounds(overlayBounds);
            }
            foreground.draw(canvas);
        }
    }

    @TargetApi(value=21)
    @RequiresApi(value=21)
    public void drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.foreground != null) {
            this.foreground.setHotspot(x, y);
        }
    }
}

