/*
 * Decompiled with CFR 0.152.
 */
package android.support.design.transformation;

import android.content.Context;
import android.os.Build;
import android.support.annotation.CallSuper;
import android.support.design.R;
import android.support.design.animation.MotionSpec;
import android.support.design.animation.Positioning;
import android.support.design.transformation.FabTransformationBehavior;
import android.support.design.transformation.FabTransformationScrimBehavior;
import android.support.design.widget.CoordinatorLayout;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewParent;
import java.util.HashMap;
import java.util.Map;

public class FabTransformationSheetBehavior
extends FabTransformationBehavior {
    private Map<View, Integer> importantForAccessibilityMap;

    public FabTransformationSheetBehavior() {
    }

    public FabTransformationSheetBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected FabTransformationBehavior.FabTransformationSpec onCreateMotionSpec(Context context, boolean expanded) {
        int specRes = expanded ? R.animator.mtrl_fab_transformation_sheet_expand_spec : R.animator.mtrl_fab_transformation_sheet_collapse_spec;
        FabTransformationBehavior.FabTransformationSpec spec = new FabTransformationBehavior.FabTransformationSpec();
        spec.timings = MotionSpec.createFromResource(context, specRes);
        spec.positioning = new Positioning(17, 0.0f, 0.0f);
        return spec;
    }

    @Override
    @CallSuper
    protected boolean onExpandedStateChange(View dependency, View child, boolean expanded, boolean animated) {
        this.updateImportantForAccessibility(child, expanded);
        return super.onExpandedStateChange(dependency, child, expanded, animated);
    }

    private void updateImportantForAccessibility(View sheet, boolean expanded) {
        ViewParent viewParent = sheet.getParent();
        if (!(viewParent instanceof CoordinatorLayout)) {
            return;
        }
        CoordinatorLayout parent = (CoordinatorLayout)viewParent;
        int childCount = parent.getChildCount();
        if (Build.VERSION.SDK_INT >= 16 && expanded) {
            this.importantForAccessibilityMap = new HashMap<View, Integer>(childCount);
        }
        for (int i = 0; i < childCount; ++i) {
            boolean hasScrimBehavior;
            View child = parent.getChildAt(i);
            boolean bl = hasScrimBehavior = child.getLayoutParams() instanceof CoordinatorLayout.LayoutParams && ((CoordinatorLayout.LayoutParams)child.getLayoutParams()).getBehavior() instanceof FabTransformationScrimBehavior;
            if (child == sheet || hasScrimBehavior) continue;
            if (!expanded) {
                if (this.importantForAccessibilityMap == null || !this.importantForAccessibilityMap.containsKey(child)) continue;
                ViewCompat.setImportantForAccessibility((View)child, (int)this.importantForAccessibilityMap.get(child));
                continue;
            }
            if (Build.VERSION.SDK_INT >= 16) {
                this.importantForAccessibilityMap.put(child, child.getImportantForAccessibility());
            }
            ViewCompat.setImportantForAccessibility((View)child, (int)4);
        }
        if (!expanded) {
            this.importantForAccessibilityMap = null;
        }
    }
}

