/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.app.Dialog;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.v7.app.MediaRouteDialogHelper;
import android.support.v7.app.MediaRouterThemeHelper;
import android.support.v7.media.MediaRouteSelector;
import android.support.v7.media.MediaRouter;
import android.support.v7.mediarouter.R;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class MediaRouteChooserDialog
extends Dialog {
    private static final String TAG = "MediaRouteChooserDialog";
    private final MediaRouter mRouter;
    private final MediaRouterCallback mCallback;
    private MediaRouteSelector mSelector = MediaRouteSelector.EMPTY;
    private ArrayList<MediaRouter.RouteInfo> mRoutes;
    private RouteAdapter mAdapter;
    private ListView mListView;
    private boolean mAttachedToWindow;
    private AsyncTask<Void, Void, Void> mRefreshRoutesTask;
    private AsyncTask<Void, Void, Void> mOnItemClickTask;

    public MediaRouteChooserDialog(Context context) {
        this(context, 0);
    }

    public MediaRouteChooserDialog(Context context, int theme) {
        super(MediaRouterThemeHelper.createThemedContext(context, theme), theme);
        context = this.getContext();
        this.mRouter = MediaRouter.getInstance(context);
        this.mCallback = new MediaRouterCallback();
    }

    @NonNull
    public MediaRouteSelector getRouteSelector() {
        return this.mSelector;
    }

    public void setRouteSelector(@NonNull MediaRouteSelector selector) {
        if (selector == null) {
            throw new IllegalArgumentException("selector must not be null");
        }
        if (!this.mSelector.equals(selector)) {
            this.mSelector = selector;
            if (this.mAttachedToWindow) {
                this.mRouter.removeCallback(this.mCallback);
                this.mRouter.addCallback(selector, this.mCallback, 1);
            }
            this.refreshRoutes();
        }
    }

    public void onFilterRoutes(@NonNull List<MediaRouter.RouteInfo> routes) {
        int i = routes.size();
        while (i-- > 0) {
            if (this.onFilterRoute(routes.get(i))) continue;
            routes.remove(i);
        }
    }

    public boolean onFilterRoute(@NonNull MediaRouter.RouteInfo route) {
        return !route.isDefaultOrBluetooth() && route.isEnabled() && route.matchesSelector(this.mSelector);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.mr_chooser_dialog);
        this.setTitle(R.string.mr_chooser_title);
        this.mRoutes = new ArrayList();
        this.mAdapter = new RouteAdapter(this.getContext(), this.mRoutes);
        this.mListView = (ListView)this.findViewById(R.id.mr_chooser_list);
        this.mListView.setAdapter((ListAdapter)this.mAdapter);
        this.mListView.setOnItemClickListener((AdapterView.OnItemClickListener)this.mAdapter);
        this.mListView.setEmptyView(this.findViewById(16908292));
        this.updateLayout();
    }

    void updateLayout() {
        this.getWindow().setLayout(MediaRouteDialogHelper.getDialogWidth(this.getContext()), -2);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttachedToWindow = true;
        this.mRouter.addCallback(this.mSelector, this.mCallback, 1);
        this.refreshRoutes();
    }

    public void onDetachedFromWindow() {
        this.mAttachedToWindow = false;
        this.mRouter.removeCallback(this.mCallback);
        super.onDetachedFromWindow();
    }

    public void refreshRoutes() {
        if (this.mAttachedToWindow) {
            if (this.mRefreshRoutesTask != null) {
                this.mRefreshRoutesTask.cancel(true);
                this.mRefreshRoutesTask = null;
            }
            this.mRefreshRoutesTask = new AsyncTask<Void, Void, Void>(){
                private ArrayList<MediaRouter.RouteInfo> mNewRoutes;

                protected void onPreExecute() {
                    this.mNewRoutes = new ArrayList<MediaRouter.RouteInfo>(MediaRouteChooserDialog.this.mRouter.getRoutes());
                    MediaRouteChooserDialog.this.onFilterRoutes(this.mNewRoutes);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Void doInBackground(Void ... params) {
                    MediaRouteChooserDialog mediaRouteChooserDialog = MediaRouteChooserDialog.this;
                    synchronized (mediaRouteChooserDialog) {
                        if (!this.isCancelled()) {
                            RouteComparator.getInstance(MediaRouteChooserDialog.this.getContext()).loadRouteUsageScores(this.mNewRoutes);
                        }
                    }
                    return null;
                }

                protected void onPostExecute(Void params) {
                    MediaRouteChooserDialog.this.mRoutes.clear();
                    MediaRouteChooserDialog.this.mRoutes.addAll(this.mNewRoutes);
                    Collections.sort(MediaRouteChooserDialog.this.mRoutes, RouteComparator.sInstance);
                    MediaRouteChooserDialog.this.mAdapter.notifyDataSetChanged();
                    MediaRouteChooserDialog.this.mRefreshRoutesTask = null;
                }
            }.execute((Object[])new Void[0]);
        }
    }

    private static final class RouteComparator
    implements Comparator<MediaRouter.RouteInfo> {
        private static final String PREF_ROUTE_IDS = "android.support.v7.app.MediaRouteChooserDialog_route_ids";
        private static final String PREF_USAGE_SCORE_PREFIX = "android.support.v7.app.MediaRouteChooserDialog_route_usage_score_";
        private static final float MIN_USAGE_SCORE = 0.1f;
        private static final float USAGE_SCORE_DECAY_FACTOR = 0.95f;
        private static RouteComparator sInstance;
        private final HashMap<String, Float> mRouteUsageScoreMap = new HashMap();
        private final SharedPreferences mPreferences;

        public static RouteComparator getInstance(Context context) {
            if (sInstance == null) {
                sInstance = new RouteComparator(context);
            }
            return sInstance;
        }

        private RouteComparator(Context context) {
            this.mPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        }

        @Override
        public int compare(MediaRouter.RouteInfo lhs, MediaRouter.RouteInfo rhs) {
            Float rhsUsageScore;
            if (lhs == null) {
                return rhs == null ? 0 : -1;
            }
            if (rhs == null) {
                return 1;
            }
            Float lhsUsageScore = this.mRouteUsageScoreMap.get(lhs.getId());
            if (lhsUsageScore == null) {
                lhsUsageScore = Float.valueOf(0.0f);
            }
            if ((rhsUsageScore = this.mRouteUsageScoreMap.get(rhs.getId())) == null) {
                rhsUsageScore = Float.valueOf(0.0f);
            }
            if (!lhsUsageScore.equals(rhsUsageScore)) {
                return lhsUsageScore.floatValue() > rhsUsageScore.floatValue() ? -1 : 1;
            }
            return lhs.getName().compareTo(rhs.getName());
        }

        private void loadRouteUsageScores(List<MediaRouter.RouteInfo> routes) {
            for (MediaRouter.RouteInfo route : routes) {
                if (this.mRouteUsageScoreMap.get(route.getId()) != null) continue;
                this.mRouteUsageScoreMap.put(route.getId(), Float.valueOf(this.mPreferences.getFloat(PREF_USAGE_SCORE_PREFIX + route.getId(), 0.0f)));
            }
        }

        private void storeRouteUsageScores(String selectedRouteId) {
            SharedPreferences.Editor prefEditor = this.mPreferences.edit();
            ArrayList<String> routeIds = new ArrayList<String>(Arrays.asList(this.mPreferences.getString(PREF_ROUTE_IDS, "").split(",")));
            if (!routeIds.contains(selectedRouteId)) {
                routeIds.add(selectedRouteId);
            }
            StringBuilder routeIdsBuilder = new StringBuilder();
            for (String routeId : routeIds) {
                String routeUsageScoreKey = PREF_USAGE_SCORE_PREFIX + routeId;
                float newUsageScore = this.mPreferences.getFloat(routeUsageScoreKey, 0.0f) * 0.95f;
                if (selectedRouteId.equals(routeId)) {
                    newUsageScore += 1.0f;
                }
                if (newUsageScore < 0.1f) {
                    this.mRouteUsageScoreMap.remove(routeId);
                    prefEditor.remove(routeId);
                    continue;
                }
                this.mRouteUsageScoreMap.put(routeId, Float.valueOf(newUsageScore));
                prefEditor.putFloat(routeUsageScoreKey, newUsageScore);
                if (routeIdsBuilder.length() > 0) {
                    routeIdsBuilder.append(',');
                }
                routeIdsBuilder.append(routeId);
            }
            prefEditor.putString(PREF_ROUTE_IDS, routeIdsBuilder.toString());
            prefEditor.commit();
        }
    }

    private final class MediaRouterCallback
    extends MediaRouter.Callback {
        private MediaRouterCallback() {
        }

        @Override
        public void onRouteAdded(MediaRouter router, MediaRouter.RouteInfo info) {
            MediaRouteChooserDialog.this.refreshRoutes();
        }

        @Override
        public void onRouteRemoved(MediaRouter router, MediaRouter.RouteInfo info) {
            MediaRouteChooserDialog.this.refreshRoutes();
        }

        @Override
        public void onRouteChanged(MediaRouter router, MediaRouter.RouteInfo info) {
            MediaRouteChooserDialog.this.refreshRoutes();
        }

        @Override
        public void onRouteSelected(MediaRouter router, MediaRouter.RouteInfo route) {
            MediaRouteChooserDialog.this.dismiss();
        }
    }

    private final class RouteAdapter
    extends ArrayAdapter<MediaRouter.RouteInfo>
    implements AdapterView.OnItemClickListener {
        private final LayoutInflater mInflater;
        private final Drawable mDefaultIcon;
        private final Drawable mTvIcon;
        private final Drawable mSpeakerIcon;
        private final Drawable mSpeakerGroupIcon;

        public RouteAdapter(Context context, List<MediaRouter.RouteInfo> routes) {
            super(context, 0, routes);
            this.mInflater = LayoutInflater.from((Context)context);
            TypedArray styledAttributes = this.getContext().obtainStyledAttributes(new int[]{R.attr.mediaRouteDefaultIconDrawable, R.attr.mediaRouteTvIconDrawable, R.attr.mediaRouteSpeakerIconDrawable, R.attr.mediaRouteSpeakerGroupIconDrawable});
            this.mDefaultIcon = styledAttributes.getDrawable(0);
            this.mTvIcon = styledAttributes.getDrawable(1);
            this.mSpeakerIcon = styledAttributes.getDrawable(2);
            this.mSpeakerGroupIcon = styledAttributes.getDrawable(3);
            styledAttributes.recycle();
        }

        public boolean areAllItemsEnabled() {
            return false;
        }

        public boolean isEnabled(int position) {
            return ((MediaRouter.RouteInfo)this.getItem(position)).isEnabled();
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            boolean isConnectedOrConnecting;
            View view = convertView;
            if (view == null) {
                view = this.mInflater.inflate(R.layout.mr_chooser_list_item, parent, false);
            }
            MediaRouter.RouteInfo route = (MediaRouter.RouteInfo)this.getItem(position);
            TextView text1 = (TextView)view.findViewById(R.id.mr_chooser_route_name);
            TextView text2 = (TextView)view.findViewById(R.id.mr_chooser_route_desc);
            text1.setText((CharSequence)route.getName());
            String description = route.getDescription();
            boolean bl = isConnectedOrConnecting = route.getConnectionState() == 2 || route.getConnectionState() == 1;
            if (isConnectedOrConnecting && !TextUtils.isEmpty((CharSequence)description)) {
                text1.setGravity(80);
                text2.setVisibility(0);
                text2.setText((CharSequence)description);
            } else {
                text1.setGravity(16);
                text2.setVisibility(8);
                text2.setText((CharSequence)"");
            }
            view.setEnabled(route.isEnabled());
            ImageView iconView = (ImageView)view.findViewById(R.id.mr_chooser_route_icon);
            if (iconView != null) {
                iconView.setImageDrawable(this.getIconDrawable(route));
            }
            return view;
        }

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            final MediaRouter.RouteInfo route = (MediaRouter.RouteInfo)this.getItem(position);
            if (route.isEnabled() && MediaRouteChooserDialog.this.mOnItemClickTask == null) {
                MediaRouteChooserDialog.this.mOnItemClickTask = new AsyncTask<Void, Void, Void>(){

                    protected void onPreExecute() {
                        route.select();
                    }

                    protected Void doInBackground(Void ... params) {
                        RouteComparator.getInstance(RouteAdapter.this.getContext()).storeRouteUsageScores(route.getId());
                        return null;
                    }

                    protected void onPostExecute(Void params) {
                        MediaRouteChooserDialog.this.dismiss();
                        MediaRouteChooserDialog.this.mOnItemClickTask = null;
                    }
                }.execute((Object[])new Void[0]);
            }
        }

        private Drawable getIconDrawable(MediaRouter.RouteInfo route) {
            Uri iconUri = route.getIconUri();
            if (iconUri != null) {
                try {
                    InputStream is = this.getContext().getContentResolver().openInputStream(iconUri);
                    Drawable drawable2 = Drawable.createFromStream((InputStream)is, null);
                    if (drawable2 != null) {
                        return drawable2;
                    }
                }
                catch (IOException e) {
                    Log.w((String)MediaRouteChooserDialog.TAG, (String)("Failed to load " + iconUri), (Throwable)e);
                }
            }
            return this.getDefaultIconDrawable(route);
        }

        private Drawable getDefaultIconDrawable(MediaRouter.RouteInfo route) {
            switch (route.getDeviceType()) {
                case 1: {
                    return this.mTvIcon;
                }
                case 2: {
                    return this.mSpeakerIcon;
                }
            }
            if (route instanceof MediaRouter.RouteGroup) {
                return this.mSpeakerGroupIcon;
            }
            return this.mDefaultIcon;
        }
    }
}

