/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.graphics.Rect;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import java.util.Arrays;

public class GridLayoutManager
extends LinearLayoutManager {
    private static final boolean DEBUG = false;
    private static final String TAG = "GridLayoutManager";
    public static final int DEFAULT_SPAN_COUNT = -1;
    boolean mPendingSpanCountChange = false;
    int mSpanCount = -1;
    int[] mCachedBorders;
    View[] mSet;
    final SparseIntArray mPreLayoutSpanSizeCache = new SparseIntArray();
    final SparseIntArray mPreLayoutSpanIndexCache = new SparseIntArray();
    SpanSizeLookup mSpanSizeLookup = new DefaultSpanSizeLookup();
    final Rect mDecorInsets = new Rect();

    public GridLayoutManager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        RecyclerView.LayoutManager.Properties properties = GridLayoutManager.getProperties(context, attrs, defStyleAttr, defStyleRes);
        this.setSpanCount(properties.spanCount);
    }

    public GridLayoutManager(Context context, int spanCount) {
        super(context);
        this.setSpanCount(spanCount);
    }

    public GridLayoutManager(Context context, int spanCount, int orientation, boolean reverseLayout) {
        super(context, orientation, reverseLayout);
        this.setSpanCount(spanCount);
    }

    @Override
    public void setStackFromEnd(boolean stackFromEnd) {
        if (stackFromEnd) {
            throw new UnsupportedOperationException("GridLayoutManager does not support stack from end. Consider using reverse layout");
        }
        super.setStackFromEnd(false);
    }

    @Override
    public int getRowCountForAccessibility(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mOrientation == 0) {
            return this.mSpanCount;
        }
        if (state.getItemCount() < 1) {
            return 0;
        }
        return this.getSpanGroupIndex(recycler, state, state.getItemCount() - 1) + 1;
    }

    @Override
    public int getColumnCountForAccessibility(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (this.mOrientation == 1) {
            return this.mSpanCount;
        }
        if (state.getItemCount() < 1) {
            return 0;
        }
        return this.getSpanGroupIndex(recycler, state, state.getItemCount() - 1) + 1;
    }

    @Override
    public void onInitializeAccessibilityNodeInfoForItem(RecyclerView.Recycler recycler, RecyclerView.State state, View host, AccessibilityNodeInfoCompat info) {
        ViewGroup.LayoutParams lp = host.getLayoutParams();
        if (!(lp instanceof LayoutParams)) {
            super.onInitializeAccessibilityNodeInfoForItem(host, info);
            return;
        }
        LayoutParams glp = (LayoutParams)lp;
        int spanGroupIndex = this.getSpanGroupIndex(recycler, state, glp.getViewLayoutPosition());
        if (this.mOrientation == 0) {
            info.setCollectionItemInfo((Object)AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)glp.getSpanIndex(), (int)glp.getSpanSize(), (int)spanGroupIndex, (int)1, (this.mSpanCount > 1 && glp.getSpanSize() == this.mSpanCount ? 1 : 0) != 0, (boolean)false));
        } else {
            info.setCollectionItemInfo((Object)AccessibilityNodeInfoCompat.CollectionItemInfoCompat.obtain((int)spanGroupIndex, (int)1, (int)glp.getSpanIndex(), (int)glp.getSpanSize(), (this.mSpanCount > 1 && glp.getSpanSize() == this.mSpanCount ? 1 : 0) != 0, (boolean)false));
        }
    }

    @Override
    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        if (state.isPreLayout()) {
            this.cachePreLayoutSpanMapping();
        }
        super.onLayoutChildren(recycler, state);
        this.clearPreLayoutSpanMappingCache();
    }

    @Override
    public void onLayoutCompleted(RecyclerView.State state) {
        super.onLayoutCompleted(state);
        this.mPendingSpanCountChange = false;
    }

    private void clearPreLayoutSpanMappingCache() {
        this.mPreLayoutSpanSizeCache.clear();
        this.mPreLayoutSpanIndexCache.clear();
    }

    private void cachePreLayoutSpanMapping() {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            LayoutParams lp = (LayoutParams)this.getChildAt(i).getLayoutParams();
            int viewPosition = lp.getViewLayoutPosition();
            this.mPreLayoutSpanSizeCache.put(viewPosition, lp.getSpanSize());
            this.mPreLayoutSpanIndexCache.put(viewPosition, lp.getSpanIndex());
        }
    }

    @Override
    public void onItemsAdded(RecyclerView recyclerView, int positionStart, int itemCount) {
        this.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    @Override
    public void onItemsChanged(RecyclerView recyclerView) {
        this.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    @Override
    public void onItemsRemoved(RecyclerView recyclerView, int positionStart, int itemCount) {
        this.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    @Override
    public void onItemsUpdated(RecyclerView recyclerView, int positionStart, int itemCount, Object payload) {
        this.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    @Override
    public void onItemsMoved(RecyclerView recyclerView, int from, int to, int itemCount) {
        this.mSpanSizeLookup.invalidateSpanIndexCache();
    }

    @Override
    public RecyclerView.LayoutParams generateDefaultLayoutParams() {
        if (this.mOrientation == 0) {
            return new LayoutParams(-2, -1);
        }
        return new LayoutParams(-1, -2);
    }

    @Override
    public RecyclerView.LayoutParams generateLayoutParams(Context c, AttributeSet attrs) {
        return new LayoutParams(c, attrs);
    }

    @Override
    public RecyclerView.LayoutParams generateLayoutParams(ViewGroup.LayoutParams lp) {
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            return new LayoutParams((ViewGroup.MarginLayoutParams)lp);
        }
        return new LayoutParams(lp);
    }

    @Override
    public boolean checkLayoutParams(RecyclerView.LayoutParams lp) {
        return lp instanceof LayoutParams;
    }

    public void setSpanSizeLookup(SpanSizeLookup spanSizeLookup) {
        this.mSpanSizeLookup = spanSizeLookup;
    }

    public SpanSizeLookup getSpanSizeLookup() {
        return this.mSpanSizeLookup;
    }

    private void updateMeasurements() {
        int totalSpace = this.getOrientation() == 1 ? this.getWidth() - this.getPaddingRight() - this.getPaddingLeft() : this.getHeight() - this.getPaddingBottom() - this.getPaddingTop();
        this.calculateItemBorders(totalSpace);
    }

    @Override
    public void setMeasuredDimension(Rect childrenBounds, int wSpec, int hSpec) {
        int width;
        int height;
        if (this.mCachedBorders == null) {
            super.setMeasuredDimension(childrenBounds, wSpec, hSpec);
        }
        int horizontalPadding = this.getPaddingLeft() + this.getPaddingRight();
        int verticalPadding = this.getPaddingTop() + this.getPaddingBottom();
        if (this.mOrientation == 1) {
            int usedHeight = childrenBounds.height() + verticalPadding;
            height = GridLayoutManager.chooseSize(hSpec, usedHeight, this.getMinimumHeight());
            width = GridLayoutManager.chooseSize(wSpec, this.mCachedBorders[this.mCachedBorders.length - 1] + horizontalPadding, this.getMinimumWidth());
        } else {
            int usedWidth = childrenBounds.width() + horizontalPadding;
            width = GridLayoutManager.chooseSize(wSpec, usedWidth, this.getMinimumWidth());
            height = GridLayoutManager.chooseSize(hSpec, this.mCachedBorders[this.mCachedBorders.length - 1] + verticalPadding, this.getMinimumHeight());
        }
        this.setMeasuredDimension(width, height);
    }

    private void calculateItemBorders(int totalSpace) {
        this.mCachedBorders = GridLayoutManager.calculateItemBorders(this.mCachedBorders, this.mSpanCount, totalSpace);
    }

    static int[] calculateItemBorders(int[] cachedBorders, int spanCount, int totalSpace) {
        if (cachedBorders == null || cachedBorders.length != spanCount + 1 || cachedBorders[cachedBorders.length - 1] != totalSpace) {
            cachedBorders = new int[spanCount + 1];
        }
        cachedBorders[0] = 0;
        int sizePerSpan = totalSpace / spanCount;
        int sizePerSpanRemainder = totalSpace % spanCount;
        int consumedPixels = 0;
        int additionalSize = 0;
        for (int i = 1; i <= spanCount; ++i) {
            int itemSize = sizePerSpan;
            if ((additionalSize += sizePerSpanRemainder) > 0 && spanCount - additionalSize < sizePerSpanRemainder) {
                ++itemSize;
                additionalSize -= spanCount;
            }
            cachedBorders[i] = consumedPixels += itemSize;
        }
        return cachedBorders;
    }

    int getSpaceForSpanRange(int startSpan, int spanSize) {
        if (this.mOrientation == 1 && this.isLayoutRTL()) {
            return this.mCachedBorders[this.mSpanCount - startSpan] - this.mCachedBorders[this.mSpanCount - startSpan - spanSize];
        }
        return this.mCachedBorders[startSpan + spanSize] - this.mCachedBorders[startSpan];
    }

    @Override
    void onAnchorReady(RecyclerView.Recycler recycler, RecyclerView.State state, LinearLayoutManager.AnchorInfo anchorInfo, int itemDirection) {
        super.onAnchorReady(recycler, state, anchorInfo, itemDirection);
        this.updateMeasurements();
        if (state.getItemCount() > 0 && !state.isPreLayout()) {
            this.ensureAnchorIsInCorrectSpan(recycler, state, anchorInfo, itemDirection);
        }
        this.ensureViewSet();
    }

    private void ensureViewSet() {
        if (this.mSet == null || this.mSet.length != this.mSpanCount) {
            this.mSet = new View[this.mSpanCount];
        }
    }

    @Override
    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.updateMeasurements();
        this.ensureViewSet();
        return super.scrollHorizontallyBy(dx, recycler, state);
    }

    @Override
    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.updateMeasurements();
        this.ensureViewSet();
        return super.scrollVerticallyBy(dy, recycler, state);
    }

    private void ensureAnchorIsInCorrectSpan(RecyclerView.Recycler recycler, RecyclerView.State state, LinearLayoutManager.AnchorInfo anchorInfo, int itemDirection) {
        boolean layingOutInPrimaryDirection = itemDirection == 1;
        int span = this.getSpanIndex(recycler, state, anchorInfo.mPosition);
        if (layingOutInPrimaryDirection) {
            while (span > 0 && anchorInfo.mPosition > 0) {
                --anchorInfo.mPosition;
                span = this.getSpanIndex(recycler, state, anchorInfo.mPosition);
            }
        } else {
            int next;
            int pos;
            int indexLimit = state.getItemCount() - 1;
            int bestSpan = span;
            for (pos = anchorInfo.mPosition; pos < indexLimit && (next = this.getSpanIndex(recycler, state, pos + 1)) > bestSpan; ++pos) {
                bestSpan = next;
            }
            anchorInfo.mPosition = pos;
        }
    }

    @Override
    View findReferenceChild(RecyclerView.Recycler recycler, RecyclerView.State state, int start, int end, int itemCount) {
        this.ensureLayoutState();
        View invalidMatch = null;
        View outOfBoundsMatch = null;
        int boundsStart = this.mOrientationHelper.getStartAfterPadding();
        int boundsEnd = this.mOrientationHelper.getEndAfterPadding();
        int diff = end > start ? 1 : -1;
        for (int i = start; i != end; i += diff) {
            int span;
            View view = this.getChildAt(i);
            int position = this.getPosition(view);
            if (position < 0 || position >= itemCount || (span = this.getSpanIndex(recycler, state, position)) != 0) continue;
            if (((RecyclerView.LayoutParams)view.getLayoutParams()).isItemRemoved()) {
                if (invalidMatch != null) continue;
                invalidMatch = view;
                continue;
            }
            if (this.mOrientationHelper.getDecoratedStart(view) >= boundsEnd || this.mOrientationHelper.getDecoratedEnd(view) < boundsStart) {
                if (outOfBoundsMatch != null) continue;
                outOfBoundsMatch = view;
                continue;
            }
            return view;
        }
        return outOfBoundsMatch != null ? outOfBoundsMatch : invalidMatch;
    }

    private int getSpanGroupIndex(RecyclerView.Recycler recycler, RecyclerView.State state, int viewPosition) {
        if (!state.isPreLayout()) {
            return this.mSpanSizeLookup.getSpanGroupIndex(viewPosition, this.mSpanCount);
        }
        int adapterPosition = recycler.convertPreLayoutPositionToPostLayout(viewPosition);
        if (adapterPosition == -1) {
            Log.w((String)TAG, (String)("Cannot find span size for pre layout position. " + viewPosition));
            return 0;
        }
        return this.mSpanSizeLookup.getSpanGroupIndex(adapterPosition, this.mSpanCount);
    }

    private int getSpanIndex(RecyclerView.Recycler recycler, RecyclerView.State state, int pos) {
        if (!state.isPreLayout()) {
            return this.mSpanSizeLookup.getCachedSpanIndex(pos, this.mSpanCount);
        }
        int cached = this.mPreLayoutSpanIndexCache.get(pos, -1);
        if (cached != -1) {
            return cached;
        }
        int adapterPosition = recycler.convertPreLayoutPositionToPostLayout(pos);
        if (adapterPosition == -1) {
            Log.w((String)TAG, (String)("Cannot find span size for pre layout position. It is not cached, not in the adapter. Pos:" + pos));
            return 0;
        }
        return this.mSpanSizeLookup.getCachedSpanIndex(adapterPosition, this.mSpanCount);
    }

    private int getSpanSize(RecyclerView.Recycler recycler, RecyclerView.State state, int pos) {
        if (!state.isPreLayout()) {
            return this.mSpanSizeLookup.getSpanSize(pos);
        }
        int cached = this.mPreLayoutSpanSizeCache.get(pos, -1);
        if (cached != -1) {
            return cached;
        }
        int adapterPosition = recycler.convertPreLayoutPositionToPostLayout(pos);
        if (adapterPosition == -1) {
            Log.w((String)TAG, (String)("Cannot find span size for pre layout position. It is not cached, not in the adapter. Pos:" + pos));
            return 1;
        }
        return this.mSpanSizeLookup.getSpanSize(adapterPosition);
    }

    @Override
    int getItemPrefetchCount() {
        return this.mSpanCount;
    }

    @Override
    int gatherPrefetchIndicesForLayoutState(RecyclerView.State state, LinearLayoutManager.LayoutState layoutState, int[] outIndices) {
        int count;
        int remainingSpan = this.mSpanCount;
        for (count = 0; count < this.mSpanCount && layoutState.hasMore(state) && remainingSpan > 0; ++count) {
            int pos;
            outIndices[count] = pos = layoutState.mCurrentPosition;
            int spanSize = this.mSpanSizeLookup.getSpanSize(pos);
            remainingSpan -= spanSize;
            layoutState.mCurrentPosition += layoutState.mItemDirection;
        }
        return count;
    }

    @Override
    void layoutChunk(RecyclerView.Recycler recycler, RecyclerView.State state, LinearLayoutManager.LayoutState layoutState, LinearLayoutManager.LayoutChunkResult result) {
        int size;
        View view;
        int i;
        int currentOtherDirSize;
        int otherDirSpecMode = this.mOrientationHelper.getModeInOther();
        boolean flexibleInOtherDir = otherDirSpecMode != 0x40000000;
        int n = currentOtherDirSize = this.getChildCount() > 0 ? this.mCachedBorders[this.mSpanCount] : 0;
        if (flexibleInOtherDir) {
            this.updateMeasurements();
        }
        boolean layingOutInPrimaryDirection = layoutState.mItemDirection == 1;
        int count = 0;
        int consumedSpanCount = 0;
        int remainingSpan = this.mSpanCount;
        if (!layingOutInPrimaryDirection) {
            int itemSpanIndex = this.getSpanIndex(recycler, state, layoutState.mCurrentPosition);
            int itemSpanSize = this.getSpanSize(recycler, state, layoutState.mCurrentPosition);
            remainingSpan = itemSpanIndex + itemSpanSize;
        }
        while (count < this.mSpanCount && layoutState.hasMore(state) && remainingSpan > 0) {
            View view2;
            int pos = layoutState.mCurrentPosition;
            int spanSize = this.getSpanSize(recycler, state, pos);
            if (spanSize > this.mSpanCount) {
                throw new IllegalArgumentException("Item at position " + pos + " requires " + spanSize + " spans but GridLayoutManager has only " + this.mSpanCount + " spans.");
            }
            if ((remainingSpan -= spanSize) < 0 || (view2 = layoutState.next(recycler)) == null) break;
            consumedSpanCount += spanSize;
            this.mSet[count] = view2;
            ++count;
        }
        if (count == 0) {
            result.mFinished = true;
            return;
        }
        int maxSize = 0;
        float maxSizeInOther = 0.0f;
        this.assignSpans(recycler, state, count, consumedSpanCount, layingOutInPrimaryDirection);
        for (i = 0; i < count; ++i) {
            view = this.mSet[i];
            if (layoutState.mScrapList == null) {
                if (layingOutInPrimaryDirection) {
                    this.addView(view);
                } else {
                    this.addView(view, 0);
                }
            } else if (layingOutInPrimaryDirection) {
                this.addDisappearingView(view);
            } else {
                this.addDisappearingView(view, 0);
            }
            this.calculateItemDecorationsForChild(view, this.mDecorInsets);
            this.measureChild(view, otherDirSpecMode, false);
            size = this.mOrientationHelper.getDecoratedMeasurement(view);
            if (size > maxSize) {
                maxSize = size;
            }
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            float otherSize = 1.0f * (float)this.mOrientationHelper.getDecoratedMeasurementInOther(view) / (float)lp.mSpanSize;
            if (!(otherSize > maxSizeInOther)) continue;
            maxSizeInOther = otherSize;
        }
        if (flexibleInOtherDir) {
            this.guessMeasurement(maxSizeInOther, currentOtherDirSize);
            maxSize = 0;
            for (i = 0; i < count; ++i) {
                view = this.mSet[i];
                this.measureChild(view, 0x40000000, true);
                size = this.mOrientationHelper.getDecoratedMeasurement(view);
                if (size <= maxSize) continue;
                maxSize = size;
            }
        }
        for (i = 0; i < count; ++i) {
            int hSpec;
            int wSpec;
            view = this.mSet[i];
            if (this.mOrientationHelper.getDecoratedMeasurement(view) == maxSize) continue;
            LayoutParams lp = (LayoutParams)view.getLayoutParams();
            Rect decorInsets = lp.mDecorInsets;
            int verticalInsets = decorInsets.top + decorInsets.bottom + lp.topMargin + lp.bottomMargin;
            int horizontalInsets = decorInsets.left + decorInsets.right + lp.leftMargin + lp.rightMargin;
            int totalSpaceInOther = this.getSpaceForSpanRange(lp.mSpanIndex, lp.mSpanSize);
            if (this.mOrientation == 1) {
                wSpec = GridLayoutManager.getChildMeasureSpec(totalSpaceInOther, 0x40000000, horizontalInsets, lp.width, false);
                hSpec = View.MeasureSpec.makeMeasureSpec((int)(maxSize - verticalInsets), (int)0x40000000);
            } else {
                wSpec = View.MeasureSpec.makeMeasureSpec((int)(maxSize - horizontalInsets), (int)0x40000000);
                hSpec = GridLayoutManager.getChildMeasureSpec(totalSpaceInOther, 0x40000000, verticalInsets, lp.height, false);
            }
            this.measureChildWithDecorationsAndMargin(view, wSpec, hSpec, true);
        }
        result.mConsumed = maxSize;
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        if (this.mOrientation == 1) {
            if (layoutState.mLayoutDirection == -1) {
                bottom = layoutState.mOffset;
                top = bottom - maxSize;
            } else {
                top = layoutState.mOffset;
                bottom = top + maxSize;
            }
        } else if (layoutState.mLayoutDirection == -1) {
            right = layoutState.mOffset;
            left = right - maxSize;
        } else {
            left = layoutState.mOffset;
            right = left + maxSize;
        }
        for (int i2 = 0; i2 < count; ++i2) {
            View view3 = this.mSet[i2];
            LayoutParams params = (LayoutParams)view3.getLayoutParams();
            if (this.mOrientation == 1) {
                if (this.isLayoutRTL()) {
                    right = this.getPaddingLeft() + this.mCachedBorders[this.mSpanCount - params.mSpanIndex];
                    left = right - this.mOrientationHelper.getDecoratedMeasurementInOther(view3);
                } else {
                    left = this.getPaddingLeft() + this.mCachedBorders[params.mSpanIndex];
                    right = left + this.mOrientationHelper.getDecoratedMeasurementInOther(view3);
                }
            } else {
                top = this.getPaddingTop() + this.mCachedBorders[params.mSpanIndex];
                bottom = top + this.mOrientationHelper.getDecoratedMeasurementInOther(view3);
            }
            this.layoutDecoratedWithMargins(view3, left, top, right, bottom);
            if (params.isItemRemoved() || params.isItemChanged()) {
                result.mIgnoreConsumed = true;
            }
            result.mFocusable |= view3.isFocusable();
        }
        Arrays.fill(this.mSet, null);
    }

    private void measureChild(View view, int otherDirParentSpecMode, boolean alreadyMeasured) {
        int hSpec;
        int wSpec;
        LayoutParams lp = (LayoutParams)view.getLayoutParams();
        Rect decorInsets = lp.mDecorInsets;
        int verticalInsets = decorInsets.top + decorInsets.bottom + lp.topMargin + lp.bottomMargin;
        int horizontalInsets = decorInsets.left + decorInsets.right + lp.leftMargin + lp.rightMargin;
        int availableSpaceInOther = this.getSpaceForSpanRange(lp.mSpanIndex, lp.mSpanSize);
        if (this.mOrientation == 1) {
            wSpec = GridLayoutManager.getChildMeasureSpec(availableSpaceInOther, otherDirParentSpecMode, horizontalInsets, lp.width, false);
            hSpec = GridLayoutManager.getChildMeasureSpec(this.mOrientationHelper.getTotalSpace(), this.getHeightMode(), verticalInsets, lp.height, true);
        } else {
            hSpec = GridLayoutManager.getChildMeasureSpec(availableSpaceInOther, otherDirParentSpecMode, verticalInsets, lp.height, false);
            wSpec = GridLayoutManager.getChildMeasureSpec(this.mOrientationHelper.getTotalSpace(), this.getWidthMode(), horizontalInsets, lp.width, true);
        }
        this.measureChildWithDecorationsAndMargin(view, wSpec, hSpec, alreadyMeasured);
    }

    private void guessMeasurement(float maxSizeInOther, int currentOtherDirSize) {
        int contentSize = Math.round(maxSizeInOther * (float)this.mSpanCount);
        this.calculateItemBorders(Math.max(contentSize, currentOtherDirSize));
    }

    private void measureChildWithDecorationsAndMargin(View child, int widthSpec, int heightSpec, boolean alreadyMeasured) {
        RecyclerView.LayoutParams lp = (RecyclerView.LayoutParams)child.getLayoutParams();
        boolean measure = alreadyMeasured ? this.shouldReMeasureChild(child, widthSpec, heightSpec, lp) : this.shouldMeasureChild(child, widthSpec, heightSpec, lp);
        if (measure) {
            child.measure(widthSpec, heightSpec);
        }
    }

    private void assignSpans(RecyclerView.Recycler recycler, RecyclerView.State state, int count, int consumedSpanCount, boolean layingOutInPrimaryDirection) {
        int diff;
        int end;
        int start;
        if (layingOutInPrimaryDirection) {
            start = 0;
            end = count;
            diff = 1;
        } else {
            start = count - 1;
            end = -1;
            diff = -1;
        }
        int span = 0;
        for (int i = start; i != end; i += diff) {
            View view = this.mSet[i];
            LayoutParams params = (LayoutParams)view.getLayoutParams();
            params.mSpanSize = this.getSpanSize(recycler, state, this.getPosition(view));
            params.mSpanIndex = span;
            span += params.mSpanSize;
        }
    }

    public int getSpanCount() {
        return this.mSpanCount;
    }

    public void setSpanCount(int spanCount) {
        if (spanCount == this.mSpanCount) {
            return;
        }
        this.mPendingSpanCountChange = true;
        if (spanCount < 1) {
            throw new IllegalArgumentException("Span count should be at least 1. Provided " + spanCount);
        }
        this.mSpanCount = spanCount;
        this.mSpanSizeLookup.invalidateSpanIndexCache();
        this.requestLayout();
    }

    @Override
    public View onFocusSearchFailed(View focused, int focusDirection, RecyclerView.Recycler recycler, RecyclerView.State state) {
        View candidate;
        int limit;
        int inc;
        int start;
        boolean ascend;
        View prevFocusedChild = this.findContainingItemView(focused);
        if (prevFocusedChild == null) {
            return null;
        }
        LayoutParams lp = (LayoutParams)prevFocusedChild.getLayoutParams();
        int prevSpanStart = lp.mSpanIndex;
        int prevSpanEnd = lp.mSpanIndex + lp.mSpanSize;
        View view = super.onFocusSearchFailed(focused, focusDirection, recycler, state);
        if (view == null) {
            return null;
        }
        int layoutDir = this.convertFocusDirectionToLayoutDirection(focusDirection);
        boolean bl = ascend = layoutDir == 1 != this.mShouldReverseLayout;
        if (ascend) {
            start = this.getChildCount() - 1;
            inc = -1;
            limit = -1;
        } else {
            start = 0;
            inc = 1;
            limit = this.getChildCount();
        }
        boolean preferLastSpan = this.mOrientation == 1 && this.isLayoutRTL();
        View weakCandidate = null;
        int weakCandidateSpanIndex = -1;
        int weakCandidateOverlap = 0;
        for (int i = start; i != limit && (candidate = this.getChildAt(i)) != prevFocusedChild; i += inc) {
            if (!candidate.isFocusable()) continue;
            LayoutParams candidateLp = (LayoutParams)candidate.getLayoutParams();
            int candidateStart = candidateLp.mSpanIndex;
            int candidateEnd = candidateLp.mSpanIndex + candidateLp.mSpanSize;
            if (candidateStart == prevSpanStart && candidateEnd == prevSpanEnd) {
                return candidate;
            }
            boolean assignAsWeek = false;
            if (weakCandidate == null) {
                assignAsWeek = true;
            } else {
                int maxStart = Math.max(candidateStart, prevSpanStart);
                int minEnd = Math.min(candidateEnd, prevSpanEnd);
                int overlap = minEnd - maxStart;
                if (overlap > weakCandidateOverlap) {
                    assignAsWeek = true;
                } else if (overlap == weakCandidateOverlap && preferLastSpan == candidateStart > weakCandidateSpanIndex) {
                    assignAsWeek = true;
                }
            }
            if (!assignAsWeek) continue;
            weakCandidate = candidate;
            weakCandidateSpanIndex = candidateLp.mSpanIndex;
            weakCandidateOverlap = Math.min(candidateEnd, prevSpanEnd) - Math.max(candidateStart, prevSpanStart);
        }
        return weakCandidate;
    }

    @Override
    public boolean supportsPredictiveItemAnimations() {
        return this.mPendingSavedState == null && !this.mPendingSpanCountChange;
    }

    public static class LayoutParams
    extends RecyclerView.LayoutParams {
        public static final int INVALID_SPAN_ID = -1;
        int mSpanIndex = -1;
        int mSpanSize = 0;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(RecyclerView.LayoutParams source) {
            super(source);
        }

        public int getSpanIndex() {
            return this.mSpanIndex;
        }

        public int getSpanSize() {
            return this.mSpanSize;
        }
    }

    public static final class DefaultSpanSizeLookup
    extends SpanSizeLookup {
        @Override
        public int getSpanSize(int position) {
            return 1;
        }

        @Override
        public int getSpanIndex(int position, int spanCount) {
            return position % spanCount;
        }
    }

    public static abstract class SpanSizeLookup {
        final SparseIntArray mSpanIndexCache = new SparseIntArray();
        private boolean mCacheSpanIndices = false;

        public abstract int getSpanSize(int var1);

        public void setSpanIndexCacheEnabled(boolean cacheSpanIndices) {
            this.mCacheSpanIndices = cacheSpanIndices;
        }

        public void invalidateSpanIndexCache() {
            this.mSpanIndexCache.clear();
        }

        public boolean isSpanIndexCacheEnabled() {
            return this.mCacheSpanIndices;
        }

        int getCachedSpanIndex(int position, int spanCount) {
            if (!this.mCacheSpanIndices) {
                return this.getSpanIndex(position, spanCount);
            }
            int existing = this.mSpanIndexCache.get(position, -1);
            if (existing != -1) {
                return existing;
            }
            int value = this.getSpanIndex(position, spanCount);
            this.mSpanIndexCache.put(position, value);
            return value;
        }

        public int getSpanIndex(int position, int spanCount) {
            int prevKey;
            int positionSpanSize = this.getSpanSize(position);
            if (positionSpanSize == spanCount) {
                return 0;
            }
            int span = 0;
            int startPos = 0;
            if (this.mCacheSpanIndices && this.mSpanIndexCache.size() > 0 && (prevKey = this.findReferenceIndexFromCache(position)) >= 0) {
                span = this.mSpanIndexCache.get(prevKey) + this.getSpanSize(prevKey);
                startPos = prevKey + 1;
            }
            for (int i = startPos; i < position; ++i) {
                int size = this.getSpanSize(i);
                if ((span += size) == spanCount) {
                    span = 0;
                    continue;
                }
                if (span <= spanCount) continue;
                span = size;
            }
            if (span + positionSpanSize <= spanCount) {
                return span;
            }
            return 0;
        }

        int findReferenceIndexFromCache(int position) {
            int lo = 0;
            int hi = this.mSpanIndexCache.size() - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                int midVal = this.mSpanIndexCache.keyAt(mid);
                if (midVal < position) {
                    lo = mid + 1;
                    continue;
                }
                hi = mid - 1;
            }
            int index = lo - 1;
            if (index >= 0 && index < this.mSpanIndexCache.size()) {
                return this.mSpanIndexCache.keyAt(index);
            }
            return -1;
        }

        public int getSpanGroupIndex(int adapterPosition, int spanCount) {
            int span = 0;
            int group = 0;
            int positionSpanSize = this.getSpanSize(adapterPosition);
            for (int i = 0; i < adapterPosition; ++i) {
                int size = this.getSpanSize(i);
                if ((span += size) == spanCount) {
                    span = 0;
                    ++group;
                    continue;
                }
                if (span <= spanCount) continue;
                span = size;
                ++group;
            }
            if (span + positionSpanSize > spanCount) {
                ++group;
            }
            return group;
        }
    }
}

