/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.content.res;

import android.content.res.Resources;
import android.content.res.TypedArray;
import android.support.annotation.ArrayRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.compat.R;
import android.util.AttributeSet;
import android.util.Base64;
import android.util.Xml;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class FontResourcesParserCompat {
    private static final int NORMAL_WEIGHT = 400;
    private static final int ITALIC = 1;

    @Nullable
    public static FamilyResourceEntry parse(XmlPullParser parser, Resources resources) throws XmlPullParserException, IOException {
        int type;
        while ((type = parser.next()) != 2 && type != 1) {
        }
        if (type != 2) {
            throw new XmlPullParserException("No start tag found");
        }
        return FontResourcesParserCompat.readFamilies(parser, resources);
    }

    @Nullable
    private static FamilyResourceEntry readFamilies(XmlPullParser parser, Resources resources) throws XmlPullParserException, IOException {
        parser.require(2, null, "font-family");
        String tag = parser.getName();
        if (tag.equals("font-family")) {
            return FontResourcesParserCompat.readFamily(parser, resources);
        }
        FontResourcesParserCompat.skip(parser);
        return null;
    }

    @Nullable
    private static FamilyResourceEntry readFamily(XmlPullParser parser, Resources resources) throws XmlPullParserException, IOException {
        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
        TypedArray array = resources.obtainAttributes(attrs, R.styleable.FontFamily);
        String authority = array.getString(R.styleable.FontFamily_fontProviderAuthority);
        String providerPackage = array.getString(R.styleable.FontFamily_fontProviderPackage);
        String query = array.getString(R.styleable.FontFamily_fontProviderQuery);
        int certsId = array.getResourceId(R.styleable.FontFamily_fontProviderCerts, 0);
        array.recycle();
        if (authority != null && providerPackage != null && query != null) {
            while (parser.next() != 3) {
                FontResourcesParserCompat.skip(parser);
            }
            List<List<byte[]>> certs = FontResourcesParserCompat.readCerts(resources, certsId);
            return new ProviderResourceEntry(authority, providerPackage, query, certs);
        }
        ArrayList<FontFileResourceEntry> fonts = new ArrayList<FontFileResourceEntry>();
        while (parser.next() != 3) {
            if (parser.getEventType() != 2) continue;
            String tag = parser.getName();
            if (tag.equals("font")) {
                fonts.add(FontResourcesParserCompat.readFont(parser, resources));
                continue;
            }
            FontResourcesParserCompat.skip(parser);
        }
        if (fonts.isEmpty()) {
            return null;
        }
        return new FontFamilyFilesResourceEntry(fonts.toArray(new FontFileResourceEntry[fonts.size()]));
    }

    public static List<List<byte[]>> readCerts(Resources resources, @ArrayRes int certsId) {
        TypedArray typedArray;
        ArrayList<List<byte[]>> certs = null;
        if (certsId != 0 && (typedArray = resources.obtainTypedArray(certsId)).length() > 0) {
            boolean isArrayOfArrays;
            certs = new ArrayList<List<byte[]>>();
            boolean bl = isArrayOfArrays = typedArray.getResourceId(0, 0) != 0;
            if (isArrayOfArrays) {
                for (int i = 0; i < typedArray.length(); ++i) {
                    int certId = typedArray.getResourceId(i, 0);
                    String[] certsArray = resources.getStringArray(certId);
                    List<byte[]> certsList = FontResourcesParserCompat.toByteArrayList(certsArray);
                    certs.add(certsList);
                }
            } else {
                String[] certsArray = resources.getStringArray(certsId);
                List<byte[]> certsList = FontResourcesParserCompat.toByteArrayList(certsArray);
                certs.add(certsList);
            }
        }
        return certs;
    }

    private static List<byte[]> toByteArrayList(String[] stringArray) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        for (String item : stringArray) {
            result.add(Base64.decode((String)item, (int)0));
        }
        return result;
    }

    private static FontFileResourceEntry readFont(XmlPullParser parser, Resources resources) throws XmlPullParserException, IOException {
        AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
        TypedArray array = resources.obtainAttributes(attrs, R.styleable.FontFamilyFont);
        int weight = array.getInt(R.styleable.FontFamilyFont_fontWeight, 400);
        boolean isItalic = 1 == array.getInt(R.styleable.FontFamilyFont_fontStyle, 0);
        String filename = array.getString(R.styleable.FontFamilyFont_font);
        int resourceId = array.getResourceId(R.styleable.FontFamilyFont_font, 0);
        array.recycle();
        while (parser.next() != 3) {
            FontResourcesParserCompat.skip(parser);
        }
        return new FontFileResourceEntry(filename, weight, isItalic, resourceId);
    }

    private static void skip(XmlPullParser parser) throws XmlPullParserException, IOException {
        int depth = 1;
        while (depth > 0) {
            switch (parser.next()) {
                case 2: {
                    ++depth;
                    break;
                }
                case 3: {
                    --depth;
                }
            }
        }
    }

    public static final class FontFamilyFilesResourceEntry
    implements FamilyResourceEntry {
        @NonNull
        private final FontFileResourceEntry[] mEntries;

        public FontFamilyFilesResourceEntry(@NonNull FontFileResourceEntry[] entries) {
            this.mEntries = entries;
        }

        @NonNull
        public FontFileResourceEntry[] getEntries() {
            return this.mEntries;
        }
    }

    public static final class FontFileResourceEntry {
        @NonNull
        private final String mFileName;
        private int mWeight;
        private boolean mItalic;
        private int mResourceId;

        public FontFileResourceEntry(@NonNull String fileName, int weight, boolean italic, int resourceId) {
            this.mFileName = fileName;
            this.mWeight = weight;
            this.mItalic = italic;
            this.mResourceId = resourceId;
        }

        @NonNull
        public String getFileName() {
            return this.mFileName;
        }

        public int getWeight() {
            return this.mWeight;
        }

        public boolean isItalic() {
            return this.mItalic;
        }

        public int getResourceId() {
            return this.mResourceId;
        }
    }

    public static final class ProviderResourceEntry
    implements FamilyResourceEntry {
        @NonNull
        private final String mProviderAuthority;
        @NonNull
        private final String mProviderPackage;
        @NonNull
        private final String mQuery;
        @Nullable
        private final List<List<byte[]>> mCerts;

        public ProviderResourceEntry(@NonNull String authority, @NonNull String pkg, @NonNull String query, @Nullable List<List<byte[]>> certs) {
            this.mProviderAuthority = authority;
            this.mProviderPackage = pkg;
            this.mQuery = query;
            this.mCerts = certs;
        }

        @NonNull
        public String getAuthority() {
            return this.mProviderAuthority;
        }

        @NonNull
        public String getPackage() {
            return this.mProviderPackage;
        }

        @NonNull
        public String getQuery() {
            return this.mQuery;
        }

        @Nullable
        public List<List<byte[]>> getCerts() {
            return this.mCerts;
        }
    }

    public static interface FamilyResourceEntry {
    }
}

