/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.res.FontResourcesParserCompat;
import android.support.v4.graphics.TypefaceCompat;
import android.support.v4.graphics.fonts.FontResult;
import android.support.v4.os.ResultReceiver;
import android.support.v4.provider.FontRequest;
import android.support.v4.provider.FontsContractCompat;
import android.support.v4.provider.FontsContractInternal;
import android.support.v4.util.LruCache;
import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
@RequiresApi(value=14)
class TypefaceCompatBaseImpl
implements TypefaceCompat.TypefaceCompatImpl {
    private static final String TAG = "TypefaceCompatBaseImpl";
    private static final String CACHE_FILE_PREFIX = "cached_font_";
    private static final boolean VERBOSE_TRACING = false;
    private static final int SYNC_FETCH_TIMEOUT_MS = 500;
    private static final LruCache<String, TypefaceCompat.TypefaceHolder> sDynamicTypefaceCache = new LruCache(16);
    private static final Object sLock = new Object();
    @GuardedBy(value="sLock")
    private static FontsContractInternal sFontsContract;
    private final Context mApplicationContext;

    TypefaceCompatBaseImpl(Context context) {
        this.mApplicationContext = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void create(final @NonNull FontRequest request, final @NonNull TypefaceCompat.FontRequestCallback callback) {
        TypefaceCompat.TypefaceHolder cachedTypeface = TypefaceCompatBaseImpl.findFromCache(request.getProviderAuthority(), request.getQuery());
        if (cachedTypeface != null) {
            callback.onTypefaceRetrieved(cachedTypeface.getTypeface());
        }
        Object object = sLock;
        synchronized (object) {
            if (sFontsContract == null) {
                sFontsContract = new FontsContractInternal(this.mApplicationContext);
            }
            ResultReceiver receiver = new ResultReceiver(null){

                @Override
                public void onReceiveResult(int resultCode, Bundle resultData) {
                    TypefaceCompatBaseImpl.this.receiveResult(request, callback, resultCode, resultData);
                }
            };
            sFontsContract.getFont(request, receiver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TypefaceCompat.TypefaceHolder findFromCache(String providerAuthority, String query) {
        LruCache<String, TypefaceCompat.TypefaceHolder> lruCache = sDynamicTypefaceCache;
        synchronized (lruCache) {
            String key = TypefaceCompatBaseImpl.createProviderUid(providerAuthority, query);
            TypefaceCompat.TypefaceHolder typeface = sDynamicTypefaceCache.get(key);
            if (typeface != null) {
                return typeface;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void putInCache(String providerAuthority, String query, TypefaceCompat.TypefaceHolder typeface) {
        String key = TypefaceCompatBaseImpl.createProviderUid(providerAuthority, query);
        LruCache<String, TypefaceCompat.TypefaceHolder> lruCache = sDynamicTypefaceCache;
        synchronized (lruCache) {
            sDynamicTypefaceCache.put(key, typeface);
        }
    }

    @VisibleForTesting
    void receiveResult(FontRequest request, TypefaceCompat.FontRequestCallback callback, int resultCode, Bundle resultData) {
        TypefaceCompat.TypefaceHolder cachedTypeface = TypefaceCompatBaseImpl.findFromCache(request.getProviderAuthority(), request.getQuery());
        if (cachedTypeface != null) {
            callback.onTypefaceRetrieved(cachedTypeface.getTypeface());
            return;
        }
        if (resultCode != 0) {
            callback.onTypefaceRequestFailed(resultCode);
            return;
        }
        if (resultData == null) {
            callback.onTypefaceRequestFailed(1);
            return;
        }
        ArrayList resultList = resultData.getParcelableArrayList("font_results");
        if (resultList == null || resultList.isEmpty()) {
            callback.onTypefaceRequestFailed(1);
            return;
        }
        TypefaceCompat.TypefaceHolder typeface = this.createTypeface(resultList);
        if (typeface == null) {
            Log.e((String)TAG, (String)("Error creating font " + request.getQuery()));
            callback.onTypefaceRequestFailed(-3);
            return;
        }
        TypefaceCompatBaseImpl.putInCache(request.getProviderAuthority(), request.getQuery(), typeface);
        callback.onTypefaceRetrieved(typeface.getTypeface());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypefaceCompat.TypefaceHolder createTypeface(List<FontResult> resultList) {
        Typeface typeface = null;
        FontResult result = resultList.get(0);
        FileDescriptor fd = result.getFileDescriptor().getFileDescriptor();
        File tmpFile = this.copyToCacheFile(new FileInputStream(fd));
        if (tmpFile != null) {
            try {
                typeface = Typeface.createFromFile((String)tmpFile.getPath());
            }
            catch (RuntimeException e) {
                TypefaceCompat.TypefaceHolder typefaceHolder = null;
                return typefaceHolder;
            }
            finally {
                tmpFile.delete();
            }
        }
        if (typeface == null) {
            return null;
        }
        return new TypefaceCompat.TypefaceHolder(typeface, result.getWeight(), result.getItalic());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypefaceCompat.TypefaceHolder createTypeface(@NonNull FontsContractCompat.FontInfo[] fonts, Map<Uri, ByteBuffer> uriBuffer) {
        if (fonts.length < 1) {
            return null;
        }
        Typeface typeface = null;
        FontsContractCompat.FontInfo font = fonts[0];
        ByteBuffer buffer = uriBuffer.get(font.getUri());
        File tmpFile = this.copyToCacheFile(buffer);
        if (tmpFile != null) {
            try {
                typeface = Typeface.createFromFile((String)tmpFile.getPath());
            }
            catch (RuntimeException e) {
                TypefaceCompat.TypefaceHolder typefaceHolder = null;
                return typefaceHolder;
            }
            finally {
                tmpFile.delete();
            }
        }
        if (typeface == null) {
            return null;
        }
        return new TypefaceCompat.TypefaceHolder(typeface, font.getWeight(), font.isItalic());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copyToCacheFile(InputStream is) {
        File cacheFile;
        FileOutputStream fos = null;
        try {
            int readLen;
            cacheFile = new File(this.mApplicationContext.getCacheDir(), CACHE_FILE_PREFIX + Thread.currentThread().getId());
            fos = new FileOutputStream(cacheFile, false);
            byte[] buffer = new byte[1024];
            while ((readLen = is.read(buffer)) != -1) {
                fos.write(buffer, 0, readLen);
            }
            TypefaceCompatBaseImpl.closeQuietly(is);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Error copying font file descriptor to temp local file.", (Throwable)e);
            File file = null;
            return file;
        }
        finally {
            TypefaceCompatBaseImpl.closeQuietly(is);
            TypefaceCompatBaseImpl.closeQuietly(fos);
        }
        TypefaceCompatBaseImpl.closeQuietly(fos);
        return cacheFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copyToCacheFile(ByteBuffer is) {
        File cacheFile;
        FileOutputStream fos = null;
        try {
            cacheFile = new File(this.mApplicationContext.getCacheDir(), CACHE_FILE_PREFIX + Thread.currentThread().getId());
            fos = new FileOutputStream(cacheFile, false);
            byte[] buffer = new byte[1024];
            while (is.hasRemaining()) {
                int len = Math.min(1024, is.remaining());
                is.get(buffer, 0, len);
                fos.write(buffer, 0, len);
            }
            TypefaceCompatBaseImpl.closeQuietly(fos);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"Error copying font file descriptor to temp local file.", (Throwable)e);
            File file = null;
            return file;
        }
        finally {
            TypefaceCompatBaseImpl.closeQuietly(fos);
        }
        return cacheFile;
    }

    static void closeQuietly(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException io) {
                Log.e((String)TAG, (String)"Error closing input stream", (Throwable)io);
            }
        }
    }

    private static String createProviderUid(String authority, String query) {
        return "provider:" + authority + "-" + query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public TypefaceCompat.TypefaceHolder createFromResourcesFontFile(Resources resources, int id, int style) {
        InputStream is = null;
        try {
            is = resources.openRawResource(id);
            Typeface baseTypeface = this.createTypeface(resources, is);
            if (baseTypeface == null) {
                TypefaceCompat.TypefaceHolder typefaceHolder = null;
                return typefaceHolder;
            }
            Typeface typeface = Typeface.create((Typeface)baseTypeface, (int)style);
            if (typeface == null) {
                TypefaceCompat.TypefaceHolder typefaceHolder = null;
                return typefaceHolder;
            }
            TypefaceCompat.TypefaceHolder result = new TypefaceCompat.TypefaceHolder(typeface, 400, false);
            String key = TypefaceCompatBaseImpl.createAssetUid(resources, id, style);
            sDynamicTypefaceCache.put(key, result);
            TypefaceCompat.TypefaceHolder typefaceHolder = result;
            return typefaceHolder;
        }
        catch (IOException iOException) {
        }
        finally {
            TypefaceCompatBaseImpl.closeQuietly(is);
        }
        return null;
    }

    @Override
    @Nullable
    public TypefaceCompat.TypefaceHolder createFromResourcesFamilyXml(FontResourcesParserCompat.FamilyResourceEntry entry, Resources resources, int id, int style) {
        if (entry instanceof FontResourcesParserCompat.ProviderResourceEntry) {
            FontResourcesParserCompat.ProviderResourceEntry providerEntry = (FontResourcesParserCompat.ProviderResourceEntry)entry;
            return this.createFromResources(providerEntry);
        }
        FontResourcesParserCompat.FontFamilyFilesResourceEntry filesEntry = (FontResourcesParserCompat.FontFamilyFilesResourceEntry)entry;
        TypefaceCompat.TypefaceHolder typeface = this.createFromResources(filesEntry, resources, id, style);
        if (typeface != null) {
            String key = TypefaceCompatBaseImpl.createAssetUid(resources, id, style);
            sDynamicTypefaceCache.put(key, typeface);
        }
        return typeface;
    }

    private FontResourcesParserCompat.FontFileResourceEntry findBestEntry(FontResourcesParserCompat.FontFamilyFilesResourceEntry entry, int targetWeight, boolean isTargetItalic) {
        FontResourcesParserCompat.FontFileResourceEntry bestEntry = null;
        int bestScore = Integer.MAX_VALUE;
        for (FontResourcesParserCompat.FontFileResourceEntry e : entry.getEntries()) {
            int score = Math.abs(e.getWeight() - targetWeight) * 2 + (isTargetItalic == e.isItalic() ? 0 : 1);
            if (bestEntry != null && bestScore <= score) continue;
            bestEntry = e;
            bestScore = score;
        }
        return bestEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Nullable
    TypefaceCompat.TypefaceHolder createFromResources(FontResourcesParserCompat.FontFamilyFilesResourceEntry entry, Resources resources, int id, int style) {
        block9: {
            TypefaceCompat.TypefaceHolder typefaceHolder;
            Typeface typeface;
            InputStream is;
            FontResourcesParserCompat.FontFileResourceEntry best;
            block8: {
                Typeface baseTypeface;
                block7: {
                    best = this.findBestEntry(entry, (style & 1) == 0 ? 400 : 700, (style & 2) != 0);
                    if (best == null) {
                        return null;
                    }
                    is = null;
                    is = resources.openRawResource(best.getResourceId());
                    baseTypeface = this.createTypeface(resources, is);
                    if (baseTypeface != null) break block7;
                    TypefaceCompat.TypefaceHolder typefaceHolder2 = null;
                    TypefaceCompatBaseImpl.closeQuietly(is);
                    return typefaceHolder2;
                }
                typeface = Typeface.create((Typeface)baseTypeface, (int)style);
                if (typeface != null) break block8;
                TypefaceCompat.TypefaceHolder typefaceHolder3 = null;
                TypefaceCompatBaseImpl.closeQuietly(is);
                return typefaceHolder3;
            }
            try {
                typefaceHolder = new TypefaceCompat.TypefaceHolder(typeface, best.getWeight(), best.isItalic());
            }
            catch (IOException iOException) {
                TypefaceCompatBaseImpl.closeQuietly(is);
                break block9;
                catch (Throwable throwable) {
                    TypefaceCompatBaseImpl.closeQuietly(is);
                    throw throwable;
                }
            }
            TypefaceCompatBaseImpl.closeQuietly(is);
            return typefaceHolder;
        }
        return null;
    }

    @Nullable
    private TypefaceCompat.TypefaceHolder createFromResources(FontResourcesParserCompat.ProviderResourceEntry entry) {
        TypefaceCompat.TypefaceHolder cached = TypefaceCompatBaseImpl.findFromCache(entry.getAuthority(), entry.getQuery());
        if (cached != null) {
            return cached;
        }
        FontRequest request = new FontRequest(entry.getAuthority(), entry.getPackage(), entry.getQuery(), entry.getCerts());
        WaitableCallback callback = new WaitableCallback(entry.getAuthority() + "/" + entry.getQuery());
        this.create(request, callback);
        Typeface typeface = callback.waitWithTimeout(500L);
        return new TypefaceCompat.TypefaceHolder(typeface, 400, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypefaceCompat.TypefaceHolder findFromCache(Resources resources, int id, int style) {
        String key = TypefaceCompatBaseImpl.createAssetUid(resources, id, style);
        LruCache<String, TypefaceCompat.TypefaceHolder> lruCache = sDynamicTypefaceCache;
        synchronized (lruCache) {
            return sDynamicTypefaceCache.get(key);
        }
    }

    private static String createAssetUid(Resources resources, int id, int style) {
        return resources.getResourcePackageName(id) + "-" + id + "-" + style;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Typeface createTypeface(Resources resources, InputStream is) throws IOException {
        File tmpFile = this.copyToCacheFile(is);
        if (tmpFile != null) {
            try {
                Typeface typeface = Typeface.createFromFile((String)tmpFile.getPath());
                return typeface;
            }
            catch (RuntimeException e) {
                Log.e((String)TAG, (String)"Failed to create font", (Throwable)e);
                Typeface typeface = null;
                return typeface;
            }
            finally {
                tmpFile.delete();
            }
        }
        return null;
    }

    static void closeQuietly(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException io) {
                Log.e((String)TAG, (String)"Error closing stream", (Throwable)io);
            }
        }
    }

    private static final class WaitableCallback
    extends TypefaceCompat.FontRequestCallback {
        private final ReentrantLock mLock = new ReentrantLock();
        private final Condition mCond = this.mLock.newCondition();
        private final String mFontTitle;
        private static final int NOT_STARTED = 0;
        private static final int WAITING = 1;
        private static final int FINISHED = 2;
        @GuardedBy(value="mLock")
        private int mState = 0;
        @GuardedBy(value="mLock")
        private Typeface mTypeface;

        WaitableCallback(String fontTitle) {
            this.mFontTitle = fontTitle;
        }

        @Override
        public void onTypefaceRetrieved(Typeface typeface) {
            this.mLock.lock();
            try {
                if (this.mState == 1) {
                    this.mTypeface = typeface;
                    this.mState = 2;
                }
                this.mCond.signal();
            }
            finally {
                this.mLock.unlock();
            }
        }

        @Override
        public void onTypefaceRequestFailed(int reason) {
            Log.w((String)TypefaceCompatBaseImpl.TAG, (String)("Remote font fetch failed(" + reason + "): " + this.mFontTitle));
            this.mLock.lock();
            try {
                if (this.mState == 1) {
                    this.mTypeface = null;
                    this.mState = 2;
                }
                this.mCond.signal();
            }
            finally {
                this.mLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Typeface waitWithTimeout(long timeoutMillis) {
            this.mLock.lock();
            try {
                if (this.mState == 2) {
                    Typeface typeface = this.mTypeface;
                    return typeface;
                }
                if (this.mState != 0) {
                    Typeface typeface = null;
                    return typeface;
                }
                this.mState = 1;
                long remainingNanos = TimeUnit.MILLISECONDS.toNanos(timeoutMillis);
                while (this.mState == 1) {
                    try {
                        remainingNanos = this.mCond.awaitNanos(remainingNanos);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.mState == 2) {
                        long elapsedMillis = timeoutMillis - TimeUnit.NANOSECONDS.toMillis(remainingNanos);
                        Log.w((String)TypefaceCompatBaseImpl.TAG, (String)("Remote font fetched in " + elapsedMillis + "ms :" + this.mFontTitle));
                        Typeface typeface = this.mTypeface;
                        return typeface;
                    }
                    if (remainingNanos >= 0L) continue;
                    Log.w((String)TypefaceCompatBaseImpl.TAG, (String)("Remote font fetch timed out: " + this.mFontTitle));
                    this.mState = 2;
                    Typeface typeface = null;
                    return typeface;
                }
                Typeface typeface = null;
                return typeface;
            }
            finally {
                this.mLock.unlock();
            }
        }
    }
}

