/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics.drawable;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Shader;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Parcelable;
import android.support.annotation.DrawableRes;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.v4.os.BuildCompat;

public class IconCompat {
    private static final float ADAPTIVE_ICON_INSET_FACTOR = 0.25f;
    private static final float DEFAULT_VIEW_PORT_SCALE = 0.6666667f;
    private static final float ICON_DIAMETER_FACTOR = 0.9166667f;
    private static final float BLUR_FACTOR = 0.010416667f;
    private static final float KEY_SHADOW_OFFSET_FACTOR = 0.020833334f;
    private static final int KEY_SHADOW_ALPHA = 61;
    private static final int AMBIENT_SHADOW_ALPHA = 30;
    private static final int TYPE_BITMAP = 1;
    private static final int TYPE_RESOURCE = 2;
    private static final int TYPE_DATA = 3;
    private static final int TYPE_URI = 4;
    private static final int TYPE_ADAPTIVE_BITMAP = 5;
    private final int mType;
    private Object mObj1;
    private int mInt1;
    private int mInt2;

    public static IconCompat createWithResource(Context context, @DrawableRes int resId) {
        if (context == null) {
            throw new IllegalArgumentException("Context must not be null.");
        }
        IconCompat rep = new IconCompat(2);
        rep.mInt1 = resId;
        rep.mObj1 = context;
        return rep;
    }

    public static IconCompat createWithBitmap(Bitmap bits) {
        if (bits == null) {
            throw new IllegalArgumentException("Bitmap must not be null.");
        }
        IconCompat rep = new IconCompat(1);
        rep.mObj1 = bits;
        return rep;
    }

    public static IconCompat createWithAdaptiveBitmap(Bitmap bits) {
        if (bits == null) {
            throw new IllegalArgumentException("Bitmap must not be null.");
        }
        IconCompat rep = new IconCompat(5);
        rep.mObj1 = bits;
        return rep;
    }

    public static IconCompat createWithData(byte[] data, int offset, int length) {
        if (data == null) {
            throw new IllegalArgumentException("Data must not be null.");
        }
        IconCompat rep = new IconCompat(3);
        rep.mObj1 = data;
        rep.mInt1 = offset;
        rep.mInt2 = length;
        return rep;
    }

    public static IconCompat createWithContentUri(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Uri must not be null.");
        }
        IconCompat rep = new IconCompat(4);
        rep.mObj1 = uri;
        return rep;
    }

    public static IconCompat createWithContentUri(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("Uri must not be null.");
        }
        return IconCompat.createWithContentUri(uri.toString());
    }

    private IconCompat(int mType) {
        this.mType = mType;
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @TargetApi(value=10000)
    public Icon toIcon() {
        switch (this.mType) {
            case 1: {
                return Icon.createWithBitmap((Bitmap)((Bitmap)this.mObj1));
            }
            case 5: {
                if (BuildCompat.isAtLeastO()) {
                    return Icon.createWithAdaptiveBitmap((Bitmap)((Bitmap)this.mObj1));
                }
                return Icon.createWithBitmap((Bitmap)IconCompat.createLegacyIconFromAdaptiveIcon((Bitmap)this.mObj1));
            }
            case 2: {
                return Icon.createWithResource((Context)((Context)this.mObj1), (int)this.mInt1);
            }
            case 3: {
                return Icon.createWithData((byte[])((byte[])this.mObj1), (int)this.mInt1, (int)this.mInt2);
            }
            case 4: {
                return Icon.createWithContentUri((String)((String)this.mObj1));
            }
        }
        throw new IllegalArgumentException("Unknown type");
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void addToShortcutIntent(Intent outIntent) {
        switch (this.mType) {
            case 1: {
                outIntent.putExtra("android.intent.extra.shortcut.ICON", (Parcelable)((Bitmap)this.mObj1));
                break;
            }
            case 5: {
                outIntent.putExtra("android.intent.extra.shortcut.ICON", (Parcelable)IconCompat.createLegacyIconFromAdaptiveIcon((Bitmap)this.mObj1));
                break;
            }
            case 2: {
                outIntent.putExtra("android.intent.extra.shortcut.ICON_RESOURCE", (Parcelable)Intent.ShortcutIconResource.fromContext((Context)((Context)this.mObj1), (int)this.mInt1));
                break;
            }
            default: {
                throw new IllegalArgumentException("Icon type not supported for intent shortcuts");
            }
        }
    }

    @VisibleForTesting
    static Bitmap createLegacyIconFromAdaptiveIcon(Bitmap adaptiveIconBitmap) {
        int size = (int)(0.6666667f * (float)Math.min(adaptiveIconBitmap.getWidth(), adaptiveIconBitmap.getHeight()));
        Bitmap icon = Bitmap.createBitmap((int)size, (int)size, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(icon);
        Paint paint = new Paint(3);
        float center = (float)size * 0.5f;
        float radius = center * 0.9166667f;
        float blur = 0.010416667f * (float)size;
        paint.setColor(0);
        paint.setShadowLayer(blur, 0.0f, 0.020833334f * (float)size, 0x3D000000);
        canvas.drawCircle(center, center, radius, paint);
        paint.setShadowLayer(blur, 0.0f, 0.0f, 0x1E000000);
        canvas.drawCircle(center, center, radius, paint);
        paint.clearShadowLayer();
        paint.setColor(-16777216);
        BitmapShader shader = new BitmapShader(adaptiveIconBitmap, Shader.TileMode.CLAMP, Shader.TileMode.CLAMP);
        Matrix shift = new Matrix();
        shift.setTranslate((float)(-(adaptiveIconBitmap.getWidth() - size) / 2), (float)(-(adaptiveIconBitmap.getHeight() - size) / 2));
        shader.setLocalMatrix(shift);
        paint.setShader((Shader)shader);
        canvas.drawCircle(center, center, radius, paint);
        canvas.setBitmap(null);
        return icon;
    }
}

