/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.provider;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Typeface;
import android.net.Uri;
import android.os.Build;
import android.os.CancellationSignal;
import android.os.Handler;
import android.os.ParcelFileDescriptor;
import android.provider.BaseColumns;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.res.FontResourcesParserCompat;
import android.support.v4.graphics.TypefaceCompat;
import android.support.v4.provider.FontRequest;
import android.support.v4.util.Preconditions;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FontsContractCompat {
    private static final String TAG = "FontsContractCompat";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final String PARCEL_FONT_RESULTS = "font_results";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int RESULT_CODE_PROVIDER_NOT_FOUND = -1;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int RESULT_CODE_WRONG_CERTIFICATES = -2;
    private static final Comparator<byte[]> sByteArrayComparator = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] l, byte[] r) {
            if (l.length != r.length) {
                return l.length - r.length;
            }
            for (int i = 0; i < l.length; ++i) {
                if (l[i] == r[i]) continue;
                return l[i] - r[i];
            }
            return 0;
        }
    };

    private FontsContractCompat() {
    }

    public static void requestFont(final @NonNull Context context, final @NonNull FontRequest request, final @NonNull FontRequestCallback callback, @NonNull Handler handler) {
        final Handler callerThreadHandler = new Handler();
        handler.post(new Runnable(){

            @Override
            public void run() {
                FontFamilyResult result;
                try {
                    result = FontsContractCompat.fetchFonts(context, null, request);
                }
                catch (PackageManager.NameNotFoundException e) {
                    callerThreadHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onTypefaceRequestFailed(-1);
                        }
                    });
                    return;
                }
                if (result.getStatusCode() != 0) {
                    switch (result.getStatusCode()) {
                        case 1: {
                            callerThreadHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    callback.onTypefaceRequestFailed(-2);
                                }
                            });
                            return;
                        }
                        case 2: {
                            callerThreadHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    callback.onTypefaceRequestFailed(-3);
                                }
                            });
                            return;
                        }
                    }
                    callerThreadHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onTypefaceRequestFailed(-3);
                        }
                    });
                    return;
                }
                FontInfo[] fonts = result.getFonts();
                if (fonts == null || fonts.length == 0) {
                    callerThreadHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onTypefaceRequestFailed(1);
                        }
                    });
                    return;
                }
                for (FontInfo font : fonts) {
                    if (font.getResultCode() == 0) continue;
                    final int resultCode = font.getResultCode();
                    if (resultCode < 0) {
                        callerThreadHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                callback.onTypefaceRequestFailed(-3);
                            }
                        });
                    } else {
                        callerThreadHandler.post(new Runnable(){

                            @Override
                            public void run() {
                                callback.onTypefaceRequestFailed(resultCode);
                            }
                        });
                    }
                    return;
                }
                final Typeface typeface = FontsContractCompat.buildTypeface(context, null, fonts);
                if (typeface == null) {
                    callerThreadHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            callback.onTypefaceRequestFailed(-3);
                        }
                    });
                    return;
                }
                callerThreadHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onTypefaceRetrieved(typeface);
                    }
                });
            }
        });
    }

    private static Map<Uri, ByteBuffer> prepareFontData(Context context, FontInfo[] fonts, CancellationSignal cancellationSignal) {
        HashMap<Uri, MappedByteBuffer> out = new HashMap<Uri, MappedByteBuffer>();
        ContentResolver resolver = context.getContentResolver();
        for (FontInfo font : fonts) {
            Uri uri;
            if (font.getResultCode() != 0 || out.containsKey(uri = font.getUri())) continue;
            MappedByteBuffer buffer = null;
            ParcelFileDescriptor pfd = null;
            FileInputStream fis = null;
            try {
                pfd = Build.VERSION.SDK_INT > 19 ? resolver.openFileDescriptor(uri, "r", cancellationSignal) : resolver.openFileDescriptor(uri, "r");
                fis = new FileInputStream(pfd.getFileDescriptor());
                FileChannel fileChannel = fis.getChannel();
                long size = fileChannel.size();
                buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            out.put(uri, buffer);
        }
        return Collections.unmodifiableMap(out);
    }

    public static Typeface buildTypeface(@NonNull Context context, @Nullable CancellationSignal cancellationSignal, @NonNull FontInfo[] fonts) {
        Map<Uri, ByteBuffer> uriBuffer = FontsContractCompat.prepareFontData(context, fonts, cancellationSignal);
        return TypefaceCompat.createTypeface(context, fonts, uriBuffer).getTypeface();
    }

    @NonNull
    public static FontFamilyResult fetchFonts(@NonNull Context context, @Nullable CancellationSignal cancellationSignal, @NonNull FontRequest request) throws PackageManager.NameNotFoundException {
        ProviderInfo providerInfo = FontsContractCompat.getProvider(context.getPackageManager(), request, context.getResources());
        if (providerInfo == null) {
            return new FontFamilyResult(1, null);
        }
        FontInfo[] fonts = FontsContractCompat.getFontFromProvider(context, request, providerInfo.authority, cancellationSignal);
        return new FontFamilyResult(0, fonts);
    }

    @VisibleForTesting
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public static ProviderInfo getProvider(@NonNull PackageManager packageManager, @NonNull FontRequest request, @Nullable Resources resources) throws PackageManager.NameNotFoundException {
        String providerAuthority = request.getProviderAuthority();
        ProviderInfo info = packageManager.resolveContentProvider(providerAuthority, 0);
        if (info == null) {
            throw new PackageManager.NameNotFoundException("No package found for authority: " + providerAuthority);
        }
        if (!info.packageName.equals(request.getProviderPackage())) {
            throw new PackageManager.NameNotFoundException("Found content provider " + providerAuthority + ", but package was not " + request.getProviderPackage());
        }
        PackageInfo packageInfo = packageManager.getPackageInfo(info.packageName, 64);
        List<byte[]> signatures = FontsContractCompat.convertToByteArrayList(packageInfo.signatures);
        Collections.sort(signatures, sByteArrayComparator);
        List<List<byte[]>> requestCertificatesList = FontsContractCompat.getCertificates(request, resources);
        for (int i = 0; i < requestCertificatesList.size(); ++i) {
            ArrayList<byte[]> requestSignatures = new ArrayList<byte[]>((Collection)requestCertificatesList.get(i));
            Collections.sort(requestSignatures, sByteArrayComparator);
            if (!FontsContractCompat.equalsByteArrayList(signatures, requestSignatures)) continue;
            return info;
        }
        return null;
    }

    private static List<List<byte[]>> getCertificates(FontRequest request, Resources resources) {
        if (request.getCertificates() != null) {
            return request.getCertificates();
        }
        int resourceId = request.getCertificatesArrayResId();
        return FontResourcesParserCompat.readCerts(resources, resourceId);
    }

    private static boolean equalsByteArrayList(List<byte[]> signatures, List<byte[]> requestSignatures) {
        if (signatures.size() != requestSignatures.size()) {
            return false;
        }
        for (int i = 0; i < signatures.size(); ++i) {
            if (Arrays.equals(signatures.get(i), requestSignatures.get(i))) continue;
            return false;
        }
        return true;
    }

    private static List<byte[]> convertToByteArrayList(Signature[] signatures) {
        ArrayList<byte[]> shas = new ArrayList<byte[]>();
        for (int i = 0; i < signatures.length; ++i) {
            shas.add(signatures[i].toByteArray());
        }
        return shas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @NonNull
    static FontInfo[] getFontFromProvider(Context context, FontRequest request, String authority, CancellationSignal cancellationSignal) {
        ArrayList<FontInfo> result = new ArrayList<FontInfo>();
        Uri uri = new Uri.Builder().scheme("content").authority(authority).build();
        Uri fileBaseUri = new Uri.Builder().scheme("content").authority(authority).appendPath("file").build();
        try (Cursor cursor = null;){
            cursor = Build.VERSION.SDK_INT > 16 ? context.getContentResolver().query(uri, new String[]{"_id", "file_id", "font_ttc_index", "font_variation_settings", "font_weight", "font_italic", "result_code"}, "query = ?", new String[]{request.getQuery()}, null, cancellationSignal) : context.getContentResolver().query(uri, new String[]{"_id", "file_id", "font_ttc_index", "font_variation_settings", "font_weight", "font_italic", "result_code"}, "query = ?", new String[]{request.getQuery()}, null);
            if (cursor != null && cursor.getCount() > 0) {
                int resultCodeColumnIndex = cursor.getColumnIndex("result_code");
                result = new ArrayList();
                int idColumnIndex = cursor.getColumnIndex("_id");
                int fileIdColumnIndex = cursor.getColumnIndex("file_id");
                int ttcIndexColumnIndex = cursor.getColumnIndex("font_ttc_index");
                int weightColumnIndex = cursor.getColumnIndex("font_weight");
                int italicColumnIndex = cursor.getColumnIndex("font_italic");
                while (cursor.moveToNext()) {
                    Uri fileUri;
                    long id;
                    int ttcIndex;
                    int resultCode = resultCodeColumnIndex != -1 ? cursor.getInt(resultCodeColumnIndex) : 0;
                    int n = ttcIndex = ttcIndexColumnIndex != -1 ? cursor.getInt(ttcIndexColumnIndex) : 0;
                    if (fileIdColumnIndex == -1) {
                        id = cursor.getLong(idColumnIndex);
                        fileUri = ContentUris.withAppendedId((Uri)uri, (long)id);
                    } else {
                        id = cursor.getLong(fileIdColumnIndex);
                        fileUri = ContentUris.withAppendedId((Uri)fileBaseUri, (long)id);
                    }
                    int weight = weightColumnIndex != -1 ? cursor.getInt(weightColumnIndex) : 400;
                    boolean italic = italicColumnIndex != -1 && cursor.getInt(italicColumnIndex) == 1;
                    result.add(new FontInfo(fileUri, ttcIndex, weight, italic, resultCode));
                }
            }
        }
        return result.toArray(new FontInfo[0]);
    }

    public static class FontRequestCallback {
        public static final int FAIL_REASON_PROVIDER_NOT_FOUND = -1;
        public static final int FAIL_REASON_WRONG_CERTIFICATES = -2;
        public static final int FAIL_REASON_FONT_LOAD_ERROR = -3;
        public static final int FAIL_REASON_FONT_NOT_FOUND = 1;
        public static final int FAIL_REASON_FONT_UNAVAILABLE = 2;
        public static final int FAIL_REASON_MALFORMED_QUERY = 3;

        public void onTypefaceRetrieved(Typeface typeface) {
        }

        public void onTypefaceRequestFailed(int reason) {
        }
    }

    public static class FontFamilyResult {
        public static final int STATUS_OK = 0;
        public static final int STATUS_WRONG_CERTIFICATES = 1;
        public static final int STATUS_UNEXPECTED_DATA_PROVIDED = 2;
        private final int mStatusCode;
        private final FontInfo[] mFonts;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public FontFamilyResult(int statusCode, @Nullable FontInfo[] fonts) {
            this.mStatusCode = statusCode;
            this.mFonts = fonts;
        }

        public int getStatusCode() {
            return this.mStatusCode;
        }

        public FontInfo[] getFonts() {
            return this.mFonts;
        }
    }

    public static class FontInfo {
        private final Uri mUri;
        private final int mTtcIndex;
        private final int mWeight;
        private final boolean mItalic;
        private final int mResultCode;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public FontInfo(@NonNull Uri uri, @IntRange(from=0L) int ttcIndex, @IntRange(from=1L, to=1000L) int weight, boolean italic, int resultCode) {
            this.mUri = Preconditions.checkNotNull(uri);
            this.mTtcIndex = ttcIndex;
            this.mWeight = weight;
            this.mItalic = italic;
            this.mResultCode = resultCode;
        }

        @NonNull
        public Uri getUri() {
            return this.mUri;
        }

        @IntRange(from=0L)
        public int getTtcIndex() {
            return this.mTtcIndex;
        }

        @IntRange(from=1L, to=1000L)
        public int getWeight() {
            return this.mWeight;
        }

        public boolean isItalic() {
            return this.mItalic;
        }

        public int getResultCode() {
            return this.mResultCode;
        }
    }

    public static final class Columns
    implements BaseColumns {
        public static final String FILE_ID = "file_id";
        public static final String TTC_INDEX = "font_ttc_index";
        public static final String VARIATION_SETTINGS = "font_variation_settings";
        public static final String WEIGHT = "font_weight";
        public static final String ITALIC = "font_italic";
        public static final String RESULT_CODE = "result_code";
        public static final int RESULT_CODE_OK = 0;
        public static final int RESULT_CODE_FONT_NOT_FOUND = 1;
        public static final int RESULT_CODE_FONT_UNAVAILABLE = 2;
        public static final int RESULT_CODE_MALFORMED_QUERY = 3;
    }
}

