/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.provider;

import android.content.ContentUris;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.Signature;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.ParcelFileDescriptor;
import android.support.annotation.GuardedBy;
import android.support.annotation.RestrictTo;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.res.FontResourcesParserCompat;
import android.support.v4.graphics.fonts.FontResult;
import android.support.v4.os.ResultReceiver;
import android.support.v4.provider.FontRequest;
import android.util.Log;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class FontsContractInternal {
    private static final String TAG = "FontsContractCompat";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final String PARCEL_FONT_RESULTS = "font_results";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int RESULT_CODE_PROVIDER_NOT_FOUND = -1;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int RESULT_CODE_WRONG_CERTIFICATES = -2;
    private static final int THREAD_RENEWAL_THRESHOLD_MS = 10000;
    private final Context mContext;
    private final PackageManager mPackageManager;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private Handler mHandler;
    @GuardedBy(value="mLock")
    private HandlerThread mThread;
    private final Runnable mReplaceDispatcherThreadRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = FontsContractInternal.this.mLock;
            synchronized (object) {
                if (FontsContractInternal.this.mThread != null) {
                    FontsContractInternal.this.mThread.quit();
                    FontsContractInternal.this.mThread = null;
                    FontsContractInternal.this.mHandler = null;
                }
            }
        }
    };
    private static final Comparator<byte[]> sByteArrayComparator = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] l, byte[] r) {
            if (l.length != r.length) {
                return l.length - r.length;
            }
            for (int i = 0; i < l.length; ++i) {
                if (l[i] == r[i]) continue;
                return l[i] - r[i];
            }
            return 0;
        }
    };

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public FontsContractInternal(Context context) {
        this.mContext = context.getApplicationContext();
        this.mPackageManager = this.mContext.getPackageManager();
    }

    @VisibleForTesting
    FontsContractInternal(Context context, PackageManager packageManager) {
        this.mContext = context;
        this.mPackageManager = packageManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void getFont(final FontRequest request, final ResultReceiver receiver) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mHandler == null) {
                this.mThread = new HandlerThread("fonts", 10);
                this.mThread.start();
                this.mHandler = new Handler(this.mThread.getLooper());
            }
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    ProviderInfo providerInfo = FontsContractInternal.this.getProvider(request, receiver);
                    if (providerInfo == null) {
                        return;
                    }
                    FontsContractInternal.this.getFontFromProvider(request, receiver, providerInfo.authority);
                }
            });
            this.mHandler.removeCallbacks(this.mReplaceDispatcherThreadRunnable);
            this.mHandler.postDelayed(this.mReplaceDispatcherThreadRunnable, 10000L);
        }
    }

    @VisibleForTesting
    ProviderInfo getProvider(FontRequest request, ResultReceiver receiver) {
        List<byte[]> signatures;
        String providerAuthority = request.getProviderAuthority();
        ProviderInfo info = this.mPackageManager.resolveContentProvider(providerAuthority, 0);
        if (info == null) {
            Log.e((String)TAG, (String)("Can't find content provider " + providerAuthority));
            receiver.send(-1, null);
            return null;
        }
        if (!info.packageName.equals(request.getProviderPackage())) {
            Log.e((String)TAG, (String)("Found content provider " + providerAuthority + ", but package was not " + request.getProviderPackage()));
            receiver.send(-1, null);
            return null;
        }
        try {
            PackageInfo packageInfo = this.mPackageManager.getPackageInfo(info.packageName, 64);
            signatures = this.convertToByteArrayList(packageInfo.signatures);
            Collections.sort(signatures, sByteArrayComparator);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)("Can't find content provider " + providerAuthority), (Throwable)e);
            receiver.send(-1, null);
            return null;
        }
        List<List<byte[]>> requestCertificatesList = this.getCertificates(request);
        for (int i = 0; i < requestCertificatesList.size(); ++i) {
            ArrayList<byte[]> requestSignatures = new ArrayList<byte[]>((Collection)requestCertificatesList.get(i));
            Collections.sort(requestSignatures, sByteArrayComparator);
            if (!this.equalsByteArrayList(signatures, requestSignatures)) continue;
            return info;
        }
        Log.e((String)TAG, (String)("Certificates don't match for given provider " + providerAuthority));
        receiver.send(-2, null);
        return null;
    }

    private List<List<byte[]>> getCertificates(FontRequest request) {
        if (request.getCertificates() != null) {
            return request.getCertificates();
        }
        int resourceId = request.getCertificatesArrayResId();
        return FontResourcesParserCompat.readCerts(this.mContext.getResources(), resourceId);
    }

    private boolean equalsByteArrayList(List<byte[]> signatures, List<byte[]> requestSignatures) {
        if (signatures.size() != requestSignatures.size()) {
            return false;
        }
        for (int i = 0; i < signatures.size(); ++i) {
            if (Arrays.equals(signatures.get(i), requestSignatures.get(i))) continue;
            return false;
        }
        return true;
    }

    private List<byte[]> convertToByteArrayList(Signature[] signatures) {
        ArrayList<byte[]> shas = new ArrayList<byte[]>();
        for (int i = 0; i < signatures.length; ++i) {
            shas.add(signatures[i].toByteArray());
        }
        return shas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void getFontFromProvider(FontRequest request, ResultReceiver receiver, String authority) {
        ArrayList<FontResult> result = new ArrayList<FontResult>();
        Uri uri = new Uri.Builder().scheme("content").authority(authority).build();
        Uri fileBaseUri = new Uri.Builder().scheme("content").authority(authority).appendPath("file").build();
        try (Cursor cursor = null;){
            cursor = this.mContext.getContentResolver().query(uri, new String[]{"_id", "file_id", "font_ttc_index", "font_variation_settings", "font_weight", "font_italic", "result_code"}, "query = ?", new String[]{request.getQuery()}, null);
            if (cursor != null && cursor.getCount() > 0) {
                int resultCodeColumnIndex = cursor.getColumnIndex("result_code");
                int idColumnIndex = cursor.getColumnIndex("_id");
                int fileIdColumnIndex = cursor.getColumnIndex("file_id");
                int ttcIndexColumnIndex = cursor.getColumnIndex("font_ttc_index");
                int vsColumnIndex = cursor.getColumnIndex("font_variation_settings");
                int weightColumnIndex = cursor.getColumnIndex("font_weight");
                int italicColumnIndex = cursor.getColumnIndex("font_italic");
                while (cursor.moveToNext()) {
                    Uri fileUri;
                    long id;
                    int resultCode;
                    int n = resultCode = resultCodeColumnIndex != -1 ? cursor.getInt(resultCodeColumnIndex) : 0;
                    if (resultCode != 0) {
                        if (resultCode < 0) {
                            resultCode = 1;
                        }
                        for (int i = 0; i < result.size(); ++i) {
                            try {
                                ((FontResult)result.get(i)).getFileDescriptor().close();
                                continue;
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        receiver.send(resultCode, null);
                        return;
                    }
                    if (fileIdColumnIndex == -1) {
                        id = cursor.getLong(idColumnIndex);
                        fileUri = ContentUris.withAppendedId((Uri)uri, (long)id);
                    } else {
                        id = cursor.getLong(fileIdColumnIndex);
                        fileUri = ContentUris.withAppendedId((Uri)fileBaseUri, (long)id);
                    }
                    try {
                        boolean italic;
                        int weight;
                        String variationSettings;
                        ParcelFileDescriptor pfd = this.mContext.getContentResolver().openFileDescriptor(fileUri, "r");
                        if (pfd == null) continue;
                        int ttcIndex = ttcIndexColumnIndex != -1 ? cursor.getInt(ttcIndexColumnIndex) : 0;
                        String string = variationSettings = vsColumnIndex != -1 ? cursor.getString(vsColumnIndex) : null;
                        if (weightColumnIndex != -1 && italicColumnIndex != -1) {
                            weight = cursor.getInt(weightColumnIndex);
                            italic = cursor.getInt(italicColumnIndex) == 1;
                        } else {
                            weight = 400;
                            italic = false;
                        }
                        result.add(new FontResult(pfd, ttcIndex, variationSettings, weight, italic));
                    }
                    catch (FileNotFoundException e) {
                        Log.e((String)TAG, (String)("FileNotFoundException raised when interacting with content provider " + authority), (Throwable)e);
                    }
                }
            }
        }
        if (result != null && !result.isEmpty()) {
            Bundle bundle = new Bundle();
            bundle.putParcelableArrayList(PARCEL_FONT_RESULTS, result);
            receiver.send(0, bundle);
            return;
        }
        receiver.send(1, null);
    }
}

