/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.graphics;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.content.res.FontResourcesParserCompat;
import android.support.v4.graphics.TypefaceCompatBaseImpl;
import android.support.v4.provider.FontsContractCompat;
import android.support.v4.util.LruCache;
import android.widget.TextView;
import java.nio.ByteBuffer;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class TypefaceCompat {
    private static final TypefaceCompatImpl sTypefaceCompatImpl = new TypefaceCompatBaseImpl();
    private static final LruCache<String, Typeface> sTypefaceCache = new LruCache(16);

    private TypefaceCompat() {
    }

    public static Typeface findFromCache(Resources resources, int id, int style) {
        return sTypefaceCache.get(TypefaceCompat.createResourceUid(resources, id, style));
    }

    private static String createResourceUid(Resources resources, int id, int style) {
        return resources.getResourcePackageName(id) + "-" + id + "-" + style;
    }

    public static Typeface createFromResourcesFamilyXml(Context context, FontResourcesParserCompat.FamilyResourceEntry entry, Resources resources, int id, int style, @Nullable TextView targetView) {
        Typeface typeface;
        if (entry instanceof FontResourcesParserCompat.ProviderResourceEntry) {
            FontResourcesParserCompat.ProviderResourceEntry providerEntry = (FontResourcesParserCompat.ProviderResourceEntry)entry;
            typeface = FontsContractCompat.getFontSync(context, providerEntry.getRequest(), targetView, providerEntry.getFetchStrategy(), providerEntry.getTimeout(), style);
        } else {
            typeface = sTypefaceCompatImpl.createFromFontFamilyFilesResourceEntry(context, (FontResourcesParserCompat.FontFamilyFilesResourceEntry)entry, resources, id, style);
        }
        if (typeface != null) {
            sTypefaceCache.put(TypefaceCompat.createResourceUid(resources, id, style), typeface);
        }
        return typeface;
    }

    @Nullable
    public static Typeface createFromResourcesFontFile(Context context, Resources resources, int id, int style) {
        Typeface typeface = sTypefaceCompatImpl.createFromResourcesFontFile(context, resources, id, style);
        if (typeface != null) {
            sTypefaceCache.put(TypefaceCompat.createResourceUid(resources, id, style), typeface);
        }
        return typeface;
    }

    public static Typeface createTypeface(Context context, @NonNull FontsContractCompat.FontInfo[] fonts, Map<Uri, ByteBuffer> uriBuffer) {
        return sTypefaceCompatImpl.createTypeface(context, fonts, uriBuffer);
    }

    static interface TypefaceCompatImpl {
        public Typeface createFromResourcesFontFile(Context var1, Resources var2, int var3, int var4);

        public Typeface createFromFontFamilyFilesResourceEntry(Context var1, FontResourcesParserCompat.FontFamilyFilesResourceEntry var2, Resources var3, int var4, int var5);

        public Typeface createTypeface(Context var1, @NonNull FontsContractCompat.FontInfo[] var2, Map<Uri, ByteBuffer> var3);
    }
}

