/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.media.AudioAttributes;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.media.AudioAttributesCompatApi21;
import android.util.SparseIntArray;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Arrays;

public class AudioAttributesCompat {
    private static final String TAG = "AudioAttributesCompat";
    public static final int CONTENT_TYPE_UNKNOWN = 0;
    public static final int CONTENT_TYPE_SPEECH = 1;
    public static final int CONTENT_TYPE_MUSIC = 2;
    public static final int CONTENT_TYPE_MOVIE = 3;
    public static final int CONTENT_TYPE_SONIFICATION = 4;
    public static final int USAGE_UNKNOWN = 0;
    public static final int USAGE_MEDIA = 1;
    public static final int USAGE_VOICE_COMMUNICATION = 2;
    public static final int USAGE_VOICE_COMMUNICATION_SIGNALLING = 3;
    public static final int USAGE_ALARM = 4;
    public static final int USAGE_NOTIFICATION = 5;
    public static final int USAGE_NOTIFICATION_RINGTONE = 6;
    public static final int USAGE_NOTIFICATION_COMMUNICATION_REQUEST = 7;
    public static final int USAGE_NOTIFICATION_COMMUNICATION_INSTANT = 8;
    public static final int USAGE_NOTIFICATION_COMMUNICATION_DELAYED = 9;
    public static final int USAGE_NOTIFICATION_EVENT = 10;
    public static final int USAGE_ASSISTANCE_ACCESSIBILITY = 11;
    public static final int USAGE_ASSISTANCE_NAVIGATION_GUIDANCE = 12;
    public static final int USAGE_ASSISTANCE_SONIFICATION = 13;
    public static final int USAGE_GAME = 14;
    private static final int USAGE_VIRTUAL_SOURCE = 15;
    public static final int USAGE_ASSISTANT = 16;
    private static final int SUPPRESSIBLE_NOTIFICATION = 1;
    private static final int SUPPRESSIBLE_CALL = 2;
    private static final SparseIntArray SUPPRESSIBLE_USAGES = new SparseIntArray();
    private static boolean sForceLegacyBehavior;
    private static final int[] SDK_USAGES;
    public static final int FLAG_AUDIBILITY_ENFORCED = 1;
    private static final int FLAG_SECURE = 2;
    private static final int FLAG_SCO = 4;
    private static final int FLAG_BEACON = 8;
    public static final int FLAG_HW_AV_SYNC = 16;
    private static final int FLAG_HW_HOTWORD = 32;
    private static final int FLAG_BYPASS_INTERRUPTION_POLICY = 64;
    private static final int FLAG_BYPASS_MUTE = 128;
    private static final int FLAG_LOW_LATENCY = 256;
    private static final int FLAG_DEEP_BUFFER = 512;
    private static final int FLAG_ALL = 1023;
    private static final int FLAG_ALL_PUBLIC = 273;
    int mUsage = 0;
    int mContentType = 0;
    int mFlags = 0;
    Integer mLegacyStream;
    private AudioAttributesCompatApi21.Wrapper mAudioAttributesWrapper;

    private AudioAttributesCompat() {
    }

    public int getVolumeControlStream() {
        if (this == null) {
            throw new IllegalArgumentException("Invalid null audio attributes");
        }
        if (Build.VERSION.SDK_INT >= 26 && !sForceLegacyBehavior && this.unwrap() != null) {
            return ((AudioAttributes)this.unwrap()).getVolumeControlStream();
        }
        return AudioAttributesCompat.toVolumeStreamType(true, this);
    }

    @Nullable
    public Object unwrap() {
        if (this.mAudioAttributesWrapper != null) {
            return this.mAudioAttributesWrapper.unwrap();
        }
        return null;
    }

    public int getLegacyStreamType() {
        if (this.mLegacyStream != null) {
            return this.mLegacyStream;
        }
        if (Build.VERSION.SDK_INT >= 21 && !sForceLegacyBehavior) {
            return AudioAttributesCompatApi21.toLegacyStreamType(this.mAudioAttributesWrapper);
        }
        return AudioAttributesCompat.toVolumeStreamType(false, this.mFlags, this.mUsage);
    }

    @Nullable
    public static AudioAttributesCompat wrap(@NonNull Object aa) {
        if (Build.VERSION.SDK_INT >= 21 && !sForceLegacyBehavior) {
            AudioAttributesCompat aac = new AudioAttributesCompat();
            aac.mAudioAttributesWrapper = AudioAttributesCompatApi21.Wrapper.wrap((AudioAttributes)aa);
            return aac;
        }
        return null;
    }

    public int getContentType() {
        if (Build.VERSION.SDK_INT >= 21 && !sForceLegacyBehavior && this.mAudioAttributesWrapper != null) {
            return this.mAudioAttributesWrapper.unwrap().getContentType();
        }
        return this.mContentType;
    }

    public int getUsage() {
        if (Build.VERSION.SDK_INT >= 21 && !sForceLegacyBehavior && this.mAudioAttributesWrapper != null) {
            return this.mAudioAttributesWrapper.unwrap().getUsage();
        }
        return this.mUsage;
    }

    public int getFlags() {
        if (Build.VERSION.SDK_INT >= 21 && !sForceLegacyBehavior && this.mAudioAttributesWrapper != null) {
            return this.mAudioAttributesWrapper.unwrap().getFlags();
        }
        int flags = this.mFlags;
        int legacyStream = this.getLegacyStreamType();
        if (legacyStream == 6) {
            flags |= 4;
        } else if (legacyStream == 7) {
            flags |= 1;
        }
        return flags & 0x111;
    }

    public int hashCode() {
        if (Build.VERSION.SDK_INT >= 21 && !sForceLegacyBehavior && this.mAudioAttributesWrapper != null) {
            return this.mAudioAttributesWrapper.unwrap().hashCode();
        }
        return Arrays.hashCode(new Object[]{this.mContentType, this.mFlags, this.mUsage, this.mLegacyStream});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("AudioAttributesCompat:");
        if (this.unwrap() != null) {
            sb.append(" audioattributes=").append(this.unwrap());
        } else {
            if (this.mLegacyStream != null) {
                sb.append(" stream=").append(this.mLegacyStream);
                sb.append(" derived");
            }
            sb.append(" usage=").append(this.usageToString()).append(" content=").append(this.mContentType).append(" flags=0x").append(Integer.toHexString(this.mFlags).toUpperCase());
        }
        return sb.toString();
    }

    String usageToString() {
        return AudioAttributesCompat.usageToString(this.mUsage);
    }

    static String usageToString(int usage) {
        switch (usage) {
            case 0: {
                return new String("USAGE_UNKNOWN");
            }
            case 1: {
                return new String("USAGE_MEDIA");
            }
            case 2: {
                return new String("USAGE_VOICE_COMMUNICATION");
            }
            case 3: {
                return new String("USAGE_VOICE_COMMUNICATION_SIGNALLING");
            }
            case 4: {
                return new String("USAGE_ALARM");
            }
            case 5: {
                return new String("USAGE_NOTIFICATION");
            }
            case 6: {
                return new String("USAGE_NOTIFICATION_RINGTONE");
            }
            case 7: {
                return new String("USAGE_NOTIFICATION_COMMUNICATION_REQUEST");
            }
            case 8: {
                return new String("USAGE_NOTIFICATION_COMMUNICATION_INSTANT");
            }
            case 9: {
                return new String("USAGE_NOTIFICATION_COMMUNICATION_DELAYED");
            }
            case 10: {
                return new String("USAGE_NOTIFICATION_EVENT");
            }
            case 11: {
                return new String("USAGE_ASSISTANCE_ACCESSIBILITY");
            }
            case 12: {
                return new String("USAGE_ASSISTANCE_NAVIGATION_GUIDANCE");
            }
            case 13: {
                return new String("USAGE_ASSISTANCE_SONIFICATION");
            }
            case 14: {
                return new String("USAGE_GAME");
            }
            case 16: {
                return new String("USAGE_ASSISTANT");
            }
        }
        return new String("unknown usage " + usage);
    }

    private static int usageForStreamType(int streamType) {
        switch (streamType) {
            case 0: {
                return 2;
            }
            case 1: 
            case 7: {
                return 13;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 2;
            }
            case 8: {
                return 3;
            }
            case 10: {
                return 11;
            }
        }
        return 0;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void setForceLegacyBehavior(boolean force) {
        sForceLegacyBehavior = force;
    }

    static int toVolumeStreamType(boolean fromGetVolumeControlStream, AudioAttributesCompat aa) {
        return AudioAttributesCompat.toVolumeStreamType(fromGetVolumeControlStream, aa.getFlags(), aa.getUsage());
    }

    static int toVolumeStreamType(boolean fromGetVolumeControlStream, int flags, int usage) {
        if ((flags & 1) == 1) {
            return fromGetVolumeControlStream ? 1 : 7;
        }
        if ((flags & 4) == 4) {
            return fromGetVolumeControlStream ? 0 : 6;
        }
        switch (usage) {
            case 1: 
            case 12: 
            case 14: 
            case 16: {
                return 3;
            }
            case 13: {
                return 1;
            }
            case 2: {
                return 0;
            }
            case 3: {
                return fromGetVolumeControlStream ? 0 : 8;
            }
            case 4: {
                return 4;
            }
            case 6: {
                return 2;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return 5;
            }
            case 11: {
                return 10;
            }
            case 0: {
                return fromGetVolumeControlStream ? Integer.MIN_VALUE : 3;
            }
        }
        if (fromGetVolumeControlStream) {
            throw new IllegalArgumentException("Unknown usage value " + usage + " in audio attributes");
        }
        return 3;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudioAttributesCompat that = (AudioAttributesCompat)o;
        if (Build.VERSION.SDK_INT >= 21 && !sForceLegacyBehavior && this.mAudioAttributesWrapper != null) {
            return this.mAudioAttributesWrapper.unwrap().equals(that.unwrap());
        }
        return this.mContentType == that.getContentType() && this.mFlags == that.getFlags() && this.mUsage == that.getUsage() && this.mLegacyStream == that.mLegacyStream;
    }

    static {
        SUPPRESSIBLE_USAGES.put(5, 1);
        SUPPRESSIBLE_USAGES.put(6, 2);
        SUPPRESSIBLE_USAGES.put(7, 2);
        SUPPRESSIBLE_USAGES.put(8, 1);
        SUPPRESSIBLE_USAGES.put(9, 1);
        SUPPRESSIBLE_USAGES.put(10, 1);
        SDK_USAGES = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16};
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface AttributeContentType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface AttributeUsage {
    }

    private static abstract class AudioManagerHidden {
        public static final int STREAM_BLUETOOTH_SCO = 6;
        public static final int STREAM_SYSTEM_ENFORCED = 7;
        public static final int STREAM_TTS = 9;
        public static final int STREAM_ACCESSIBILITY = 10;

        private AudioManagerHidden() {
        }
    }

    public static class Builder {
        private int mUsage = 0;
        private int mContentType = 0;
        private int mFlags = 0;
        private Integer mLegacyStream;
        private Object mAAObject;

        public Builder() {
        }

        public Builder(AudioAttributesCompat aa) {
            this.mUsage = aa.mUsage;
            this.mContentType = aa.mContentType;
            this.mFlags = aa.mFlags;
            this.mLegacyStream = aa.mLegacyStream;
            this.mAAObject = aa.unwrap();
        }

        public AudioAttributesCompat build() {
            if (!sForceLegacyBehavior && Build.VERSION.SDK_INT >= 21) {
                if (this.mAAObject != null) {
                    return AudioAttributesCompat.wrap(this.mAAObject);
                }
                AudioAttributes.Builder api21Builder = new AudioAttributes.Builder().setContentType(this.mContentType).setFlags(this.mFlags).setUsage(this.mUsage);
                if (this.mLegacyStream != null) {
                    api21Builder.setLegacyStreamType(this.mLegacyStream.intValue());
                }
                return AudioAttributesCompat.wrap(api21Builder.build());
            }
            AudioAttributesCompat aac = new AudioAttributesCompat();
            aac.mContentType = this.mContentType;
            aac.mFlags = this.mFlags;
            aac.mUsage = this.mUsage;
            aac.mLegacyStream = this.mLegacyStream;
            aac.mAudioAttributesWrapper = null;
            return aac;
        }

        public Builder setUsage(int usage) {
            switch (usage) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    this.mUsage = usage;
                    break;
                }
                case 16: {
                    if (!sForceLegacyBehavior && Build.VERSION.SDK_INT > 25) {
                        this.mUsage = usage;
                        break;
                    }
                    this.mUsage = 12;
                    break;
                }
                default: {
                    this.mUsage = 0;
                }
            }
            return this;
        }

        public Builder setContentType(int contentType) {
            switch (contentType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.mContentType = contentType;
                    break;
                }
                default: {
                    this.mUsage = 0;
                }
            }
            return this;
        }

        public Builder setFlags(int flags) {
            this.mFlags |= (flags &= 0x3FF);
            return this;
        }

        public Builder setLegacyStreamType(int streamType) {
            if (streamType == 10) {
                throw new IllegalArgumentException("STREAM_ACCESSIBILITY is not a legacy stream type that was used for audio playback");
            }
            this.mLegacyStream = streamType;
            this.mUsage = AudioAttributesCompat.usageForStreamType(streamType);
            return this;
        }
    }
}

