/*
 * Decompiled with CFR 0.152.
 */
package android.support.mediacompat;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.util.ObjectsCompat;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public final class Rating2 {
    public static final int RATING_NONE = 0;
    public static final int RATING_HEART = 1;
    public static final int RATING_THUMB_UP_DOWN = 2;
    public static final int RATING_3_STARS = 3;
    public static final int RATING_4_STARS = 4;
    public static final int RATING_5_STARS = 5;
    public static final int RATING_PERCENTAGE = 6;
    private static final String TAG = "Rating2";
    private static final float RATING_NOT_RATED = -1.0f;
    private static final String KEY_STYLE = "android.media.rating2.style";
    private static final String KEY_VALUE = "android.media.rating2.value";
    private final int mRatingStyle;
    private final float mRatingValue;

    private Rating2(int ratingStyle, float rating) {
        this.mRatingStyle = ratingStyle;
        this.mRatingValue = rating;
    }

    public String toString() {
        return "Rating2:style=" + this.mRatingStyle + " rating=" + (this.mRatingValue < 0.0f ? "unrated" : String.valueOf(this.mRatingValue));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Rating2)) {
            return false;
        }
        Rating2 other = (Rating2)obj;
        return this.mRatingStyle == other.mRatingStyle && this.mRatingValue == other.mRatingValue;
    }

    public int hashCode() {
        return ObjectsCompat.hash((Object[])new Object[]{this.mRatingStyle, Float.valueOf(this.mRatingValue)});
    }

    public static Rating2 fromBundle(@Nullable Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        return new Rating2(bundle.getInt(KEY_STYLE), bundle.getFloat(KEY_VALUE));
    }

    public Bundle toBundle() {
        Bundle bundle = new Bundle();
        bundle.putInt(KEY_STYLE, this.mRatingStyle);
        bundle.putFloat(KEY_VALUE, this.mRatingValue);
        return bundle;
    }

    @Nullable
    public static Rating2 newUnratedRating(int ratingStyle) {
        switch (ratingStyle) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return new Rating2(ratingStyle, -1.0f);
            }
        }
        return null;
    }

    @Nullable
    public static Rating2 newHeartRating(boolean hasHeart) {
        return new Rating2(1, hasHeart ? 1.0f : 0.0f);
    }

    @Nullable
    public static Rating2 newThumbRating(boolean thumbIsUp) {
        return new Rating2(2, thumbIsUp ? 1.0f : 0.0f);
    }

    @Nullable
    public static Rating2 newStarRating(int starRatingStyle, float starRating) {
        float maxRating;
        switch (starRatingStyle) {
            case 3: {
                maxRating = 3.0f;
                break;
            }
            case 4: {
                maxRating = 4.0f;
                break;
            }
            case 5: {
                maxRating = 5.0f;
                break;
            }
            default: {
                Log.e((String)TAG, (String)("Invalid rating style (" + starRatingStyle + ") for a star rating"));
                return null;
            }
        }
        if (starRating < 0.0f || starRating > maxRating) {
            Log.e((String)TAG, (String)"Trying to set out of range star-based rating");
            return null;
        }
        return new Rating2(starRatingStyle, starRating);
    }

    @Nullable
    public static Rating2 newPercentageRating(float percent) {
        if (percent < 0.0f || percent > 100.0f) {
            Log.e((String)TAG, (String)"Invalid percentage-based rating value");
            return null;
        }
        return new Rating2(6, percent);
    }

    public boolean isRated() {
        return this.mRatingValue >= 0.0f;
    }

    public int getRatingStyle() {
        return this.mRatingStyle;
    }

    public boolean hasHeart() {
        return this.mRatingStyle == 1 && this.mRatingValue == 1.0f;
    }

    public boolean isThumbUp() {
        return this.mRatingStyle == 2 && this.mRatingValue == 1.0f;
    }

    public float getStarRating() {
        switch (this.mRatingStyle) {
            case 3: 
            case 4: 
            case 5: {
                if (!this.isRated()) break;
                return this.mRatingValue;
            }
        }
        return -1.0f;
    }

    public float getPercentRating() {
        if (this.mRatingStyle != 6 || !this.isRated()) {
            return -1.0f;
        }
        return this.mRatingValue;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface StarStyle {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface Style {
    }
}

