/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.support.v4.media.IMediaController2;
import java.util.ArrayList;
import java.util.List;

public interface IMediaSession2
extends IInterface {
    public void connect(IMediaController2 var1, String var2) throws RemoteException;

    public void release(IMediaController2 var1) throws RemoteException;

    public void setVolumeTo(IMediaController2 var1, int var2, int var3) throws RemoteException;

    public void adjustVolume(IMediaController2 var1, int var2, int var3) throws RemoteException;

    public void play(IMediaController2 var1) throws RemoteException;

    public void pause(IMediaController2 var1) throws RemoteException;

    public void reset(IMediaController2 var1) throws RemoteException;

    public void prepare(IMediaController2 var1) throws RemoteException;

    public void fastForward(IMediaController2 var1) throws RemoteException;

    public void rewind(IMediaController2 var1) throws RemoteException;

    public void seekTo(IMediaController2 var1, long var2) throws RemoteException;

    public void sendCustomCommand(IMediaController2 var1, Bundle var2, Bundle var3, ResultReceiver var4) throws RemoteException;

    public void prepareFromUri(IMediaController2 var1, Uri var2, Bundle var3) throws RemoteException;

    public void prepareFromSearch(IMediaController2 var1, String var2, Bundle var3) throws RemoteException;

    public void prepareFromMediaId(IMediaController2 var1, String var2, Bundle var3) throws RemoteException;

    public void playFromUri(IMediaController2 var1, Uri var2, Bundle var3) throws RemoteException;

    public void playFromSearch(IMediaController2 var1, String var2, Bundle var3) throws RemoteException;

    public void playFromMediaId(IMediaController2 var1, String var2, Bundle var3) throws RemoteException;

    public void setRating(IMediaController2 var1, String var2, Bundle var3) throws RemoteException;

    public void setPlaybackSpeed(IMediaController2 var1, float var2) throws RemoteException;

    public void setPlaylist(IMediaController2 var1, List<Bundle> var2, Bundle var3) throws RemoteException;

    public void updatePlaylistMetadata(IMediaController2 var1, Bundle var2) throws RemoteException;

    public void addPlaylistItem(IMediaController2 var1, int var2, Bundle var3) throws RemoteException;

    public void removePlaylistItem(IMediaController2 var1, Bundle var2) throws RemoteException;

    public void replacePlaylistItem(IMediaController2 var1, int var2, Bundle var3) throws RemoteException;

    public void skipToPlaylistItem(IMediaController2 var1, Bundle var2) throws RemoteException;

    public void skipToPreviousItem(IMediaController2 var1) throws RemoteException;

    public void skipToNextItem(IMediaController2 var1) throws RemoteException;

    public void setRepeatMode(IMediaController2 var1, int var2) throws RemoteException;

    public void setShuffleMode(IMediaController2 var1, int var2) throws RemoteException;

    public void subscribeRoutesInfo(IMediaController2 var1) throws RemoteException;

    public void unsubscribeRoutesInfo(IMediaController2 var1) throws RemoteException;

    public void selectRoute(IMediaController2 var1, Bundle var2) throws RemoteException;

    public void getLibraryRoot(IMediaController2 var1, Bundle var2) throws RemoteException;

    public void getItem(IMediaController2 var1, String var2) throws RemoteException;

    public void getChildren(IMediaController2 var1, String var2, int var3, int var4, Bundle var5) throws RemoteException;

    public void search(IMediaController2 var1, String var2, Bundle var3) throws RemoteException;

    public void getSearchResult(IMediaController2 var1, String var2, int var3, int var4, Bundle var5) throws RemoteException;

    public void subscribe(IMediaController2 var1, String var2, Bundle var3) throws RemoteException;

    public void unsubscribe(IMediaController2 var1, String var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMediaSession2 {
        private static final String DESCRIPTOR = "android.support.v4.media.IMediaSession2";
        static final int TRANSACTION_connect = 1;
        static final int TRANSACTION_release = 2;
        static final int TRANSACTION_setVolumeTo = 3;
        static final int TRANSACTION_adjustVolume = 4;
        static final int TRANSACTION_play = 5;
        static final int TRANSACTION_pause = 6;
        static final int TRANSACTION_reset = 7;
        static final int TRANSACTION_prepare = 8;
        static final int TRANSACTION_fastForward = 9;
        static final int TRANSACTION_rewind = 10;
        static final int TRANSACTION_seekTo = 11;
        static final int TRANSACTION_sendCustomCommand = 12;
        static final int TRANSACTION_prepareFromUri = 13;
        static final int TRANSACTION_prepareFromSearch = 14;
        static final int TRANSACTION_prepareFromMediaId = 15;
        static final int TRANSACTION_playFromUri = 16;
        static final int TRANSACTION_playFromSearch = 17;
        static final int TRANSACTION_playFromMediaId = 18;
        static final int TRANSACTION_setRating = 19;
        static final int TRANSACTION_setPlaybackSpeed = 20;
        static final int TRANSACTION_setPlaylist = 21;
        static final int TRANSACTION_updatePlaylistMetadata = 22;
        static final int TRANSACTION_addPlaylistItem = 23;
        static final int TRANSACTION_removePlaylistItem = 24;
        static final int TRANSACTION_replacePlaylistItem = 25;
        static final int TRANSACTION_skipToPlaylistItem = 26;
        static final int TRANSACTION_skipToPreviousItem = 27;
        static final int TRANSACTION_skipToNextItem = 28;
        static final int TRANSACTION_setRepeatMode = 29;
        static final int TRANSACTION_setShuffleMode = 30;
        static final int TRANSACTION_subscribeRoutesInfo = 31;
        static final int TRANSACTION_unsubscribeRoutesInfo = 32;
        static final int TRANSACTION_selectRoute = 33;
        static final int TRANSACTION_getLibraryRoot = 34;
        static final int TRANSACTION_getItem = 35;
        static final int TRANSACTION_getChildren = 36;
        static final int TRANSACTION_search = 37;
        static final int TRANSACTION_getSearchResult = 38;
        static final int TRANSACTION_subscribe = 39;
        static final int TRANSACTION_unsubscribe = 40;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IMediaSession2 asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IMediaSession2) {
                return (IMediaSession2)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.connect(_arg0, _arg1);
                    return true;
                }
                case 2: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    this.release(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.setVolumeTo(_arg0, _arg1, _arg2);
                    return true;
                }
                case 4: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.adjustVolume(_arg0, _arg1, _arg2);
                    return true;
                }
                case 5: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    this.play(_arg0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    this.pause(_arg0);
                    return true;
                }
                case 7: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    this.reset(_arg0);
                    return true;
                }
                case 8: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    this.prepare(_arg0);
                    return true;
                }
                case 9: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    this.fastForward(_arg0);
                    return true;
                }
                case 10: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    this.rewind(_arg0);
                    return true;
                }
                case 11: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    long _arg1 = data.readLong();
                    this.seekTo(_arg0, _arg1);
                    return true;
                }
                case 12: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    Bundle _arg1 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    Bundle _arg2 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    ResultReceiver _arg3 = 0 != data.readInt() ? (ResultReceiver)ResultReceiver.CREATOR.createFromParcel(data) : null;
                    this.sendCustomCommand(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 13: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    Uri _arg1 = 0 != data.readInt() ? (Uri)Uri.CREATOR.createFromParcel(data) : null;
                    Bundle _arg2 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.prepareFromUri(_arg0, _arg1, _arg2);
                    return true;
                }
                case 14: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    Bundle _arg2 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.prepareFromSearch(_arg0, _arg1, _arg2);
                    return true;
                }
                case 15: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    Bundle _arg2 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.prepareFromMediaId(_arg0, _arg1, _arg2);
                    return true;
                }
                case 16: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    Uri _arg1 = 0 != data.readInt() ? (Uri)Uri.CREATOR.createFromParcel(data) : null;
                    Bundle _arg2 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.playFromUri(_arg0, _arg1, _arg2);
                    return true;
                }
                case 17: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    Bundle _arg2 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.playFromSearch(_arg0, _arg1, _arg2);
                    return true;
                }
                case 18: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    Bundle _arg2 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.playFromMediaId(_arg0, _arg1, _arg2);
                    return true;
                }
                case 19: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    Bundle _arg2 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.setRating(_arg0, _arg1, _arg2);
                    return true;
                }
                case 20: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    float _arg1 = data.readFloat();
                    this.setPlaybackSpeed(_arg0, _arg1);
                    return true;
                }
                case 21: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    ArrayList _arg1 = data.createTypedArrayList(Bundle.CREATOR);
                    Bundle _arg2 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.setPlaylist(_arg0, _arg1, _arg2);
                    return true;
                }
                case 22: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    Bundle _arg1 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.updatePlaylistMetadata(_arg0, _arg1);
                    return true;
                }
                case 23: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    Bundle _arg2 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.addPlaylistItem(_arg0, _arg1, _arg2);
                    return true;
                }
                case 24: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    Bundle _arg1 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.removePlaylistItem(_arg0, _arg1);
                    return true;
                }
                case 25: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    Bundle _arg2 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.replacePlaylistItem(_arg0, _arg1, _arg2);
                    return true;
                }
                case 26: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    Bundle _arg1 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.skipToPlaylistItem(_arg0, _arg1);
                    return true;
                }
                case 27: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    this.skipToPreviousItem(_arg0);
                    return true;
                }
                case 28: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    this.skipToNextItem(_arg0);
                    return true;
                }
                case 29: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.setRepeatMode(_arg0, _arg1);
                    return true;
                }
                case 30: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.setShuffleMode(_arg0, _arg1);
                    return true;
                }
                case 31: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    this.subscribeRoutesInfo(_arg0);
                    return true;
                }
                case 32: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    this.unsubscribeRoutesInfo(_arg0);
                    return true;
                }
                case 33: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    Bundle _arg1 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.selectRoute(_arg0, _arg1);
                    return true;
                }
                case 34: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    Bundle _arg1 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.getLibraryRoot(_arg0, _arg1);
                    return true;
                }
                case 35: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.getItem(_arg0, _arg1);
                    return true;
                }
                case 36: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    Bundle _arg4 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.getChildren(_arg0, _arg1, _arg2, _arg3, _arg4);
                    return true;
                }
                case 37: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    Bundle _arg2 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.search(_arg0, _arg1, _arg2);
                    return true;
                }
                case 38: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    int _arg3 = data.readInt();
                    Bundle _arg4 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.getSearchResult(_arg0, _arg1, _arg2, _arg3, _arg4);
                    return true;
                }
                case 39: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    Bundle _arg2 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    this.subscribe(_arg0, _arg1, _arg2);
                    return true;
                }
                case 40: {
                    data.enforceInterface(DESCRIPTOR);
                    IMediaController2 _arg0 = IMediaController2.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.unsubscribe(_arg0, _arg1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IMediaSession2 {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connect(IMediaController2 caller, String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    _data.writeString(callingPackage);
                    this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void release(IMediaController2 caller) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setVolumeTo(IMediaController2 caller, int value, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    _data.writeInt(value);
                    _data.writeInt(flags);
                    this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void adjustVolume(IMediaController2 caller, int direction, int flags) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    _data.writeInt(direction);
                    _data.writeInt(flags);
                    this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void play(IMediaController2 caller) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void pause(IMediaController2 caller) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    this.mRemote.transact(6, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void reset(IMediaController2 caller) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    this.mRemote.transact(7, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void prepare(IMediaController2 caller) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    this.mRemote.transact(8, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void fastForward(IMediaController2 caller) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    this.mRemote.transact(9, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void rewind(IMediaController2 caller) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    this.mRemote.transact(10, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void seekTo(IMediaController2 caller, long pos) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    _data.writeLong(pos);
                    this.mRemote.transact(11, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendCustomCommand(IMediaController2 caller, Bundle command, Bundle args, ResultReceiver receiver) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    if (command != null) {
                        _data.writeInt(1);
                        command.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (args != null) {
                        _data.writeInt(1);
                        args.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (receiver != null) {
                        _data.writeInt(1);
                        receiver.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(12, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void prepareFromUri(IMediaController2 caller, Uri uri, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    if (uri != null) {
                        _data.writeInt(1);
                        uri.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (extras != null) {
                        _data.writeInt(1);
                        extras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(13, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void prepareFromSearch(IMediaController2 caller, String query, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    _data.writeString(query);
                    if (extras != null) {
                        _data.writeInt(1);
                        extras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(14, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void prepareFromMediaId(IMediaController2 caller, String mediaId, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    _data.writeString(mediaId);
                    if (extras != null) {
                        _data.writeInt(1);
                        extras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(15, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playFromUri(IMediaController2 caller, Uri uri, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    if (uri != null) {
                        _data.writeInt(1);
                        uri.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (extras != null) {
                        _data.writeInt(1);
                        extras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(16, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playFromSearch(IMediaController2 caller, String query, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    _data.writeString(query);
                    if (extras != null) {
                        _data.writeInt(1);
                        extras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(17, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void playFromMediaId(IMediaController2 caller, String mediaId, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    _data.writeString(mediaId);
                    if (extras != null) {
                        _data.writeInt(1);
                        extras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(18, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRating(IMediaController2 caller, String mediaId, Bundle rating) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    _data.writeString(mediaId);
                    if (rating != null) {
                        _data.writeInt(1);
                        rating.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(19, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPlaybackSpeed(IMediaController2 caller, float speed) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    _data.writeFloat(speed);
                    this.mRemote.transact(20, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPlaylist(IMediaController2 caller, List<Bundle> playlist, Bundle metadata) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    _data.writeTypedList(playlist);
                    if (metadata != null) {
                        _data.writeInt(1);
                        metadata.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(21, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updatePlaylistMetadata(IMediaController2 caller, Bundle metadata) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    if (metadata != null) {
                        _data.writeInt(1);
                        metadata.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(22, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addPlaylistItem(IMediaController2 caller, int index, Bundle mediaItem) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    _data.writeInt(index);
                    if (mediaItem != null) {
                        _data.writeInt(1);
                        mediaItem.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(23, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removePlaylistItem(IMediaController2 caller, Bundle mediaItem) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    if (mediaItem != null) {
                        _data.writeInt(1);
                        mediaItem.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(24, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void replacePlaylistItem(IMediaController2 caller, int index, Bundle mediaItem) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    _data.writeInt(index);
                    if (mediaItem != null) {
                        _data.writeInt(1);
                        mediaItem.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(25, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void skipToPlaylistItem(IMediaController2 caller, Bundle mediaItem) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    if (mediaItem != null) {
                        _data.writeInt(1);
                        mediaItem.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(26, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void skipToPreviousItem(IMediaController2 caller) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    this.mRemote.transact(27, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void skipToNextItem(IMediaController2 caller) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    this.mRemote.transact(28, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setRepeatMode(IMediaController2 caller, int repeatMode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    _data.writeInt(repeatMode);
                    this.mRemote.transact(29, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setShuffleMode(IMediaController2 caller, int shuffleMode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    _data.writeInt(shuffleMode);
                    this.mRemote.transact(30, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void subscribeRoutesInfo(IMediaController2 caller) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    this.mRemote.transact(31, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void unsubscribeRoutesInfo(IMediaController2 caller) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    this.mRemote.transact(32, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void selectRoute(IMediaController2 caller, Bundle route) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    if (route != null) {
                        _data.writeInt(1);
                        route.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(33, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getLibraryRoot(IMediaController2 caller, Bundle rootHints) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    if (rootHints != null) {
                        _data.writeInt(1);
                        rootHints.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(34, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getItem(IMediaController2 caller, String mediaId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    _data.writeString(mediaId);
                    this.mRemote.transact(35, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getChildren(IMediaController2 caller, String parentId, int page, int pageSize, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    _data.writeString(parentId);
                    _data.writeInt(page);
                    _data.writeInt(pageSize);
                    if (extras != null) {
                        _data.writeInt(1);
                        extras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(36, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void search(IMediaController2 caller, String query, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    _data.writeString(query);
                    if (extras != null) {
                        _data.writeInt(1);
                        extras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(37, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getSearchResult(IMediaController2 caller, String query, int page, int pageSize, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    _data.writeString(query);
                    _data.writeInt(page);
                    _data.writeInt(pageSize);
                    if (extras != null) {
                        _data.writeInt(1);
                        extras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(38, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void subscribe(IMediaController2 caller, String parentId, Bundle extras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    _data.writeString(parentId);
                    if (extras != null) {
                        _data.writeInt(1);
                        extras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    this.mRemote.transact(39, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unsubscribe(IMediaController2 caller, String parentId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(caller != null ? caller.asBinder() : null);
                    _data.writeString(parentId);
                    this.mRemote.transact(40, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }
}

