/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.support.annotation.GuardedBy;
import android.support.v4.media.BaseMediaPlayer;
import android.support.v4.media.MediaBrowserServiceCompat;
import android.support.v4.media.MediaItem2;
import android.support.v4.media.MediaLibraryService2;
import android.support.v4.media.MediaLibraryService2LegacyStub;
import android.support.v4.media.MediaPlaylistAgent;
import android.support.v4.media.MediaSession2;
import android.support.v4.media.MediaSession2ImplBase;
import android.support.v4.media.VolumeProviderCompat;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;

@TargetApi(value=19)
class MediaLibrarySessionImplBase
extends MediaSession2ImplBase
implements MediaLibraryService2.MediaLibrarySession.SupportLibraryImpl {
    private final MediaBrowserServiceCompat mBrowserServiceLegacyStub;
    @GuardedBy(value="mLock")
    private final ArrayMap<MediaSession2.ControllerInfo, Set<String>> mSubscriptions = new ArrayMap();

    MediaLibrarySessionImplBase(MediaLibraryService2.MediaLibrarySession instance, Context context, String id, BaseMediaPlayer player, MediaPlaylistAgent playlistAgent, VolumeProviderCompat volumeProvider, PendingIntent sessionActivity, Executor callbackExecutor, MediaSession2.SessionCallback callback) {
        super(instance, context, id, player, playlistAgent, volumeProvider, sessionActivity, callbackExecutor, callback);
        this.mBrowserServiceLegacyStub = new MediaLibraryService2LegacyStub(this);
        this.mBrowserServiceLegacyStub.attachToBaseContext(context);
        this.mBrowserServiceLegacyStub.onCreate();
    }

    @Override
    public MediaLibraryService2.MediaLibrarySession getInstance() {
        return (MediaLibraryService2.MediaLibrarySession)super.getInstance();
    }

    @Override
    public MediaLibraryService2.MediaLibrarySession.MediaLibrarySessionCallback getCallback() {
        return (MediaLibraryService2.MediaLibrarySession.MediaLibrarySessionCallback)super.getCallback();
    }

    @Override
    public IBinder getLegacySessionBinder() {
        Intent intent = new Intent("android.media.browse.MediaBrowserService");
        return this.mBrowserServiceLegacyStub.onBind(intent);
    }

    @Override
    public void notifyChildrenChanged(final String parentId, final int itemCount, final Bundle extras) {
        if (TextUtils.isEmpty((CharSequence)parentId)) {
            throw new IllegalArgumentException("query shouldn't be empty");
        }
        if (itemCount < 0) {
            throw new IllegalArgumentException("itemCount shouldn't be negative");
        }
        List<MediaSession2.ControllerInfo> controllers = this.getConnectedControllers();
        MediaSession2ImplBase.NotifyRunnable runnable = new MediaSession2ImplBase.NotifyRunnable(){

            @Override
            public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                callback.onChildrenChanged(parentId, itemCount, extras);
            }
        };
        for (int i = 0; i < controllers.size(); ++i) {
            if (!this.isSubscribed(controllers.get(i), parentId)) continue;
            this.notifyToController(controllers.get(i), runnable);
        }
    }

    @Override
    public void notifyChildrenChanged(final MediaSession2.ControllerInfo controller, final String parentId, final int itemCount, final Bundle extras) {
        if (controller == null) {
            throw new IllegalArgumentException("controller shouldn't be null");
        }
        if (TextUtils.isEmpty((CharSequence)parentId)) {
            throw new IllegalArgumentException("query shouldn't be empty");
        }
        if (itemCount < 0) {
            throw new IllegalArgumentException("itemCount shouldn't be negative");
        }
        this.notifyToController(controller, new MediaSession2ImplBase.NotifyRunnable(){

            @Override
            public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                if (!MediaLibrarySessionImplBase.this.isSubscribed(controller, parentId)) {
                    if (MediaSession2ImplBase.DEBUG) {
                        Log.d((String)"MS2ImplBase", (String)("Skipping notifyChildrenChanged() to " + controller + " because it hasn't subscribed"));
                        MediaLibrarySessionImplBase.this.dumpSubscription();
                    }
                    return;
                }
                callback.onChildrenChanged(parentId, itemCount, extras);
            }
        });
    }

    @Override
    public void notifySearchResultChanged(MediaSession2.ControllerInfo controller, final String query, final int itemCount, final Bundle extras) {
        if (controller == null) {
            throw new IllegalArgumentException("controller shouldn't be null");
        }
        if (TextUtils.isEmpty((CharSequence)query)) {
            throw new IllegalArgumentException("query shouldn't be empty");
        }
        this.notifyToController(controller, new MediaSession2ImplBase.NotifyRunnable(){

            @Override
            public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                callback.onSearchResultChanged(query, itemCount, extras);
            }
        });
    }

    @Override
    public void onGetLibraryRootOnExecutor(MediaSession2.ControllerInfo controller, final Bundle rootHints) {
        final MediaLibraryService2.LibraryRoot root = this.getCallback().onGetLibraryRoot(this.getInstance(), controller, rootHints);
        this.notifyToController(controller, new MediaSession2ImplBase.NotifyRunnable(){

            @Override
            public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                callback.onGetLibraryRootDone(rootHints, root == null ? null : root.getRootId(), root == null ? null : root.getExtras());
            }
        });
    }

    @Override
    public void onGetItemOnExecutor(MediaSession2.ControllerInfo controller, final String mediaId) {
        final MediaItem2 result = this.getCallback().onGetItem(this.getInstance(), controller, mediaId);
        this.notifyToController(controller, new MediaSession2ImplBase.NotifyRunnable(){

            @Override
            public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                callback.onGetItemDone(mediaId, result);
            }
        });
    }

    @Override
    public void onGetChildrenOnExecutor(MediaSession2.ControllerInfo controller, final String parentId, final int page, final int pageSize, final Bundle extras) {
        final List<MediaItem2> result = this.getCallback().onGetChildren(this.getInstance(), controller, parentId, page, pageSize, extras);
        if (result != null && result.size() > pageSize) {
            throw new IllegalArgumentException("onGetChildren() shouldn't return media items more than pageSize. result.size()=" + result.size() + " pageSize=" + pageSize);
        }
        this.notifyToController(controller, new MediaSession2ImplBase.NotifyRunnable(){

            @Override
            public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                callback.onGetChildrenDone(parentId, page, pageSize, result, extras);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSubscribeOnExecutor(MediaSession2.ControllerInfo controller, String parentId, Bundle option) {
        Object object = this.mLock;
        synchronized (object) {
            HashSet<String> subscription = (HashSet<String>)this.mSubscriptions.get((Object)controller);
            if (subscription == null) {
                subscription = new HashSet<String>();
                this.mSubscriptions.put((Object)controller, subscription);
            }
            subscription.add(parentId);
        }
        this.getCallback().onSubscribe(this.getInstance(), controller, parentId, option);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUnsubscribeOnExecutor(MediaSession2.ControllerInfo controller, String parentId) {
        this.getCallback().onUnsubscribe(this.getInstance(), controller, parentId);
        Object object = this.mLock;
        synchronized (object) {
            this.mSubscriptions.remove((Object)controller);
        }
    }

    @Override
    public void onSearchOnExecutor(MediaSession2.ControllerInfo controller, String query, Bundle extras) {
        this.getCallback().onSearch(this.getInstance(), controller, query, extras);
    }

    @Override
    public void onGetSearchResultOnExecutor(MediaSession2.ControllerInfo controller, final String query, final int page, final int pageSize, final Bundle extras) {
        final List<MediaItem2> result = this.getCallback().onGetSearchResult(this.getInstance(), controller, query, page, pageSize, extras);
        if (result != null && result.size() > pageSize) {
            throw new IllegalArgumentException("onGetSearchResult() shouldn't return media items more than pageSize. result.size()=" + result.size() + " pageSize=" + pageSize);
        }
        this.notifyToController(controller, new MediaSession2ImplBase.NotifyRunnable(){

            @Override
            public void run(MediaSession2.ControllerCb callback) throws RemoteException {
                callback.onGetSearchResultDone(query, page, pageSize, result, extras);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSubscribed(MediaSession2.ControllerInfo controller, String parentId) {
        Object object = this.mLock;
        synchronized (object) {
            Set subscriptions = (Set)this.mSubscriptions.get((Object)controller);
            if (subscriptions == null || !subscriptions.contains(parentId)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpSubscription() {
        if (!DEBUG) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            Log.d((String)"MS2ImplBase", (String)("Dumping subscription, controller sz=" + this.mSubscriptions.size()));
            for (int i = 0; i < this.mSubscriptions.size(); ++i) {
                Log.d((String)"MS2ImplBase", (String)("  controller " + this.mSubscriptions.valueAt(i)));
                for (String parentId : (Set)this.mSubscriptions.valueAt(i)) {
                    Log.d((String)"MS2ImplBase", (String)("  - " + parentId));
                }
            }
        }
    }
}

