/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.mediacompat.Rating2;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Set;

public final class MediaMetadata2 {
    private static final String TAG = "MediaMetadata2";
    public static final String METADATA_KEY_TITLE = "android.media.metadata.TITLE";
    public static final String METADATA_KEY_ARTIST = "android.media.metadata.ARTIST";
    public static final String METADATA_KEY_DURATION = "android.media.metadata.DURATION";
    public static final String METADATA_KEY_ALBUM = "android.media.metadata.ALBUM";
    public static final String METADATA_KEY_AUTHOR = "android.media.metadata.AUTHOR";
    public static final String METADATA_KEY_WRITER = "android.media.metadata.WRITER";
    public static final String METADATA_KEY_COMPOSER = "android.media.metadata.COMPOSER";
    public static final String METADATA_KEY_COMPILATION = "android.media.metadata.COMPILATION";
    public static final String METADATA_KEY_DATE = "android.media.metadata.DATE";
    public static final String METADATA_KEY_YEAR = "android.media.metadata.YEAR";
    public static final String METADATA_KEY_GENRE = "android.media.metadata.GENRE";
    public static final String METADATA_KEY_TRACK_NUMBER = "android.media.metadata.TRACK_NUMBER";
    public static final String METADATA_KEY_NUM_TRACKS = "android.media.metadata.NUM_TRACKS";
    public static final String METADATA_KEY_DISC_NUMBER = "android.media.metadata.DISC_NUMBER";
    public static final String METADATA_KEY_ALBUM_ARTIST = "android.media.metadata.ALBUM_ARTIST";
    public static final String METADATA_KEY_ART = "android.media.metadata.ART";
    public static final String METADATA_KEY_ART_URI = "android.media.metadata.ART_URI";
    public static final String METADATA_KEY_ALBUM_ART = "android.media.metadata.ALBUM_ART";
    public static final String METADATA_KEY_ALBUM_ART_URI = "android.media.metadata.ALBUM_ART_URI";
    public static final String METADATA_KEY_USER_RATING = "android.media.metadata.USER_RATING";
    public static final String METADATA_KEY_RATING = "android.media.metadata.RATING";
    public static final String METADATA_KEY_DISPLAY_TITLE = "android.media.metadata.DISPLAY_TITLE";
    public static final String METADATA_KEY_DISPLAY_SUBTITLE = "android.media.metadata.DISPLAY_SUBTITLE";
    public static final String METADATA_KEY_DISPLAY_DESCRIPTION = "android.media.metadata.DISPLAY_DESCRIPTION";
    public static final String METADATA_KEY_DISPLAY_ICON = "android.media.metadata.DISPLAY_ICON";
    public static final String METADATA_KEY_DISPLAY_ICON_URI = "android.media.metadata.DISPLAY_ICON_URI";
    public static final String METADATA_KEY_MEDIA_ID = "android.media.metadata.MEDIA_ID";
    public static final String METADATA_KEY_MEDIA_URI = "android.media.metadata.MEDIA_URI";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final String METADATA_KEY_RADIO_FREQUENCY = "android.media.metadata.RADIO_FREQUENCY";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final String METADATA_KEY_RADIO_PROGRAM_NAME = "android.media.metadata.RADIO_PROGRAM_NAME";
    public static final String METADATA_KEY_BT_FOLDER_TYPE = "android.media.metadata.BT_FOLDER_TYPE";
    public static final long BT_FOLDER_TYPE_MIXED = 0L;
    public static final long BT_FOLDER_TYPE_TITLES = 1L;
    public static final long BT_FOLDER_TYPE_ALBUMS = 2L;
    public static final long BT_FOLDER_TYPE_ARTISTS = 3L;
    public static final long BT_FOLDER_TYPE_GENRES = 4L;
    public static final long BT_FOLDER_TYPE_PLAYLISTS = 5L;
    public static final long BT_FOLDER_TYPE_YEARS = 6L;
    public static final String METADATA_KEY_ADVERTISEMENT = "android.media.metadata.ADVERTISEMENT";
    public static final String METADATA_KEY_DOWNLOAD_STATUS = "android.media.metadata.DOWNLOAD_STATUS";
    public static final long STATUS_NOT_DOWNLOADED = 0L;
    public static final long STATUS_DOWNLOADING = 1L;
    public static final long STATUS_DOWNLOADED = 2L;
    public static final String METADATA_KEY_EXTRAS = "android.media.metadata.EXTRAS";
    static final int METADATA_TYPE_LONG = 0;
    static final int METADATA_TYPE_TEXT = 1;
    static final int METADATA_TYPE_BITMAP = 2;
    static final int METADATA_TYPE_RATING = 3;
    static final int METADATA_TYPE_FLOAT = 4;
    static final ArrayMap<String, Integer> METADATA_KEYS_TYPE = new ArrayMap();
    private static final String[] PREFERRED_DESCRIPTION_ORDER;
    private static final String[] PREFERRED_BITMAP_ORDER;
    private static final String[] PREFERRED_URI_ORDER;
    final Bundle mBundle;

    MediaMetadata2(Bundle bundle) {
        this.mBundle = new Bundle(bundle);
        this.mBundle.setClassLoader(MediaMetadata2.class.getClassLoader());
    }

    public boolean containsKey(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key shouldn't be null");
        }
        return this.mBundle.containsKey(key);
    }

    @Nullable
    public CharSequence getText(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key shouldn't be null");
        }
        return this.mBundle.getCharSequence(key);
    }

    @Nullable
    public String getMediaId() {
        return this.getString(METADATA_KEY_MEDIA_ID);
    }

    @Nullable
    public String getString(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key shouldn't be null");
        }
        CharSequence text = this.mBundle.getCharSequence(key);
        if (text != null) {
            return text.toString();
        }
        return null;
    }

    public long getLong(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key shouldn't be null");
        }
        return this.mBundle.getLong(key, 0L);
    }

    @Nullable
    public Rating2 getRating(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key shouldn't be null");
        }
        Rating2 rating = null;
        try {
            rating = Rating2.fromBundle(this.mBundle.getBundle(key));
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Failed to retrieve a key as Rating.", (Throwable)e);
        }
        return rating;
    }

    public float getFloat(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key shouldn't be null");
        }
        return this.mBundle.getFloat(key);
    }

    @Nullable
    public Bitmap getBitmap(@NonNull String key) {
        if (key == null) {
            throw new IllegalArgumentException("key shouldn't be null");
        }
        Bitmap bmp = null;
        try {
            bmp = (Bitmap)this.mBundle.getParcelable(key);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Failed to retrieve a key as Bitmap.", (Throwable)e);
        }
        return bmp;
    }

    @Nullable
    public Bundle getExtras() {
        try {
            return this.mBundle.getBundle(METADATA_KEY_EXTRAS);
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)"Failed to retrieve an extra");
            return null;
        }
    }

    public int size() {
        return this.mBundle.size();
    }

    @NonNull
    public Set<String> keySet() {
        return this.mBundle.keySet();
    }

    @NonNull
    public Bundle toBundle() {
        return this.mBundle;
    }

    @NonNull
    public static MediaMetadata2 fromBundle(@Nullable Bundle bundle) {
        return bundle == null ? null : new MediaMetadata2(bundle);
    }

    static {
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_TITLE, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_ARTIST, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_DURATION, (Object)0);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_ALBUM, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_AUTHOR, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_WRITER, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_COMPOSER, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_COMPILATION, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_DATE, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_YEAR, (Object)0);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_GENRE, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_TRACK_NUMBER, (Object)0);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_NUM_TRACKS, (Object)0);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_DISC_NUMBER, (Object)0);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_ALBUM_ARTIST, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_ART, (Object)2);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_ART_URI, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_ALBUM_ART, (Object)2);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_ALBUM_ART_URI, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_USER_RATING, (Object)3);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_RATING, (Object)3);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_DISPLAY_TITLE, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_DISPLAY_SUBTITLE, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_DISPLAY_DESCRIPTION, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_DISPLAY_ICON, (Object)2);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_DISPLAY_ICON_URI, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_MEDIA_ID, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_MEDIA_URI, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_RADIO_FREQUENCY, (Object)4);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_RADIO_PROGRAM_NAME, (Object)1);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_BT_FOLDER_TYPE, (Object)0);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_ADVERTISEMENT, (Object)0);
        METADATA_KEYS_TYPE.put((Object)METADATA_KEY_DOWNLOAD_STATUS, (Object)0);
        PREFERRED_DESCRIPTION_ORDER = new String[]{METADATA_KEY_TITLE, METADATA_KEY_ARTIST, METADATA_KEY_ALBUM, METADATA_KEY_ALBUM_ARTIST, METADATA_KEY_WRITER, METADATA_KEY_AUTHOR, METADATA_KEY_COMPOSER};
        PREFERRED_BITMAP_ORDER = new String[]{METADATA_KEY_DISPLAY_ICON, METADATA_KEY_ART, METADATA_KEY_ALBUM_ART};
        PREFERRED_URI_ORDER = new String[]{METADATA_KEY_DISPLAY_ICON_URI, METADATA_KEY_ART_URI, METADATA_KEY_ALBUM_ART_URI};
    }

    public static final class Builder {
        final Bundle mBundle;

        public Builder() {
            this.mBundle = new Bundle();
        }

        public Builder(@NonNull MediaMetadata2 source) {
            this.mBundle = new Bundle(source.toBundle());
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public Builder(MediaMetadata2 source, int maxBitmapSize) {
            this(source);
            for (String key : this.mBundle.keySet()) {
                Bitmap bmp;
                Object value = this.mBundle.get(key);
                if (!(value instanceof Bitmap) || (bmp = (Bitmap)value).getHeight() <= maxBitmapSize && bmp.getWidth() <= maxBitmapSize) continue;
                this.putBitmap(key, this.scaleBitmap(bmp, maxBitmapSize));
            }
        }

        @NonNull
        public Builder putText(@NonNull String key, @Nullable CharSequence value) {
            if (key == null) {
                throw new IllegalArgumentException("key shouldn't be null");
            }
            if (METADATA_KEYS_TYPE.containsKey((Object)key) && (Integer)METADATA_KEYS_TYPE.get((Object)key) != 1) {
                throw new IllegalArgumentException("The " + key + " key cannot be used to put a CharSequence");
            }
            this.mBundle.putCharSequence(key, value);
            return this;
        }

        @NonNull
        public Builder putString(@NonNull String key, @Nullable String value) {
            if (key == null) {
                throw new IllegalArgumentException("key shouldn't be null");
            }
            if (METADATA_KEYS_TYPE.containsKey((Object)key) && (Integer)METADATA_KEYS_TYPE.get((Object)key) != 1) {
                throw new IllegalArgumentException("The " + key + " key cannot be used to put a String");
            }
            this.mBundle.putCharSequence(key, (CharSequence)value);
            return this;
        }

        @NonNull
        public Builder putLong(@NonNull String key, long value) {
            if (key == null) {
                throw new IllegalArgumentException("key shouldn't be null");
            }
            if (METADATA_KEYS_TYPE.containsKey((Object)key) && (Integer)METADATA_KEYS_TYPE.get((Object)key) != 0) {
                throw new IllegalArgumentException("The " + key + " key cannot be used to put a long");
            }
            this.mBundle.putLong(key, value);
            return this;
        }

        @NonNull
        public Builder putRating(@NonNull String key, @Nullable Rating2 value) {
            if (key == null) {
                throw new IllegalArgumentException("key shouldn't be null");
            }
            if (METADATA_KEYS_TYPE.containsKey((Object)key) && (Integer)METADATA_KEYS_TYPE.get((Object)key) != 3) {
                throw new IllegalArgumentException("The " + key + " key cannot be used to put a Rating");
            }
            this.mBundle.putBundle(key, value == null ? null : value.toBundle());
            return this;
        }

        @NonNull
        public Builder putBitmap(@NonNull String key, @Nullable Bitmap value) {
            if (key == null) {
                throw new IllegalArgumentException("key shouldn't be null");
            }
            if (METADATA_KEYS_TYPE.containsKey((Object)key) && (Integer)METADATA_KEYS_TYPE.get((Object)key) != 2) {
                throw new IllegalArgumentException("The " + key + " key cannot be used to put a Bitmap");
            }
            this.mBundle.putParcelable(key, (Parcelable)value);
            return this;
        }

        @NonNull
        public Builder putFloat(@NonNull String key, float value) {
            if (key == null) {
                throw new IllegalArgumentException("key shouldn't be null");
            }
            if (METADATA_KEYS_TYPE.containsKey((Object)key) && (Integer)METADATA_KEYS_TYPE.get((Object)key) != 4) {
                throw new IllegalArgumentException("The " + key + " key cannot be used to put a float");
            }
            this.mBundle.putFloat(key, value);
            return this;
        }

        public Builder setExtras(@Nullable Bundle extras) {
            this.mBundle.putBundle(MediaMetadata2.METADATA_KEY_EXTRAS, extras);
            return this;
        }

        @NonNull
        public MediaMetadata2 build() {
            return new MediaMetadata2(this.mBundle);
        }

        private Bitmap scaleBitmap(Bitmap bmp, int maxSize) {
            float maxSizeF = maxSize;
            float widthScale = maxSizeF / (float)bmp.getWidth();
            float heightScale = maxSizeF / (float)bmp.getHeight();
            float scale = Math.min(widthScale, heightScale);
            int height = (int)((float)bmp.getHeight() * scale);
            int width = (int)((float)bmp.getWidth() * scale);
            return Bitmap.createScaledBitmap((Bitmap)bmp, (int)width, (int)height, (boolean)true);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface FloatKey {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface RatingKey {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface BitmapKey {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface LongKey {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface TextKey {
    }
}

