/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.media.DataSourceDesc;
import android.support.v4.media.MediaItem2;
import android.support.v4.media.MediaMetadata2;
import android.support.v4.util.SimpleArrayMap;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.concurrent.Executor;

public abstract class MediaPlaylistAgent {
    private static final String TAG = "MediaPlaylistAgent";
    public static final int REPEAT_MODE_NONE = 0;
    public static final int REPEAT_MODE_ONE = 1;
    public static final int REPEAT_MODE_ALL = 2;
    public static final int REPEAT_MODE_GROUP = 3;
    public static final int SHUFFLE_MODE_NONE = 0;
    public static final int SHUFFLE_MODE_ALL = 1;
    public static final int SHUFFLE_MODE_GROUP = 2;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private final SimpleArrayMap<PlaylistEventCallback, Executor> mCallbacks = new SimpleArrayMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerPlaylistEventCallback(@NonNull Executor executor, @NonNull PlaylistEventCallback callback) {
        if (executor == null) {
            throw new IllegalArgumentException("executor shouldn't be null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback shouldn't be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mCallbacks.get((Object)callback) != null) {
                Log.w((String)TAG, (String)"callback is already added. Ignoring.");
                return;
            }
            this.mCallbacks.put((Object)callback, (Object)executor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterPlaylistEventCallback(@NonNull PlaylistEventCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback shouldn't be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mCallbacks.remove((Object)callback);
        }
    }

    public final void notifyPlaylistChanged() {
        SimpleArrayMap<PlaylistEventCallback, Executor> callbacks = this.getCallbacks();
        final List<MediaItem2> playlist = this.getPlaylist();
        final MediaMetadata2 metadata = this.getPlaylistMetadata();
        for (int i = 0; i < callbacks.size(); ++i) {
            final PlaylistEventCallback callback = (PlaylistEventCallback)callbacks.keyAt(i);
            Executor executor = (Executor)callbacks.valueAt(i);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.onPlaylistChanged(MediaPlaylistAgent.this, playlist, metadata);
                }
            });
        }
    }

    public final void notifyPlaylistMetadataChanged() {
        SimpleArrayMap<PlaylistEventCallback, Executor> callbacks = this.getCallbacks();
        for (int i = 0; i < callbacks.size(); ++i) {
            final PlaylistEventCallback callback = (PlaylistEventCallback)callbacks.keyAt(i);
            Executor executor = (Executor)callbacks.valueAt(i);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.onPlaylistMetadataChanged(MediaPlaylistAgent.this, MediaPlaylistAgent.this.getPlaylistMetadata());
                }
            });
        }
    }

    public final void notifyShuffleModeChanged() {
        SimpleArrayMap<PlaylistEventCallback, Executor> callbacks = this.getCallbacks();
        for (int i = 0; i < callbacks.size(); ++i) {
            final PlaylistEventCallback callback = (PlaylistEventCallback)callbacks.keyAt(i);
            Executor executor = (Executor)callbacks.valueAt(i);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.onShuffleModeChanged(MediaPlaylistAgent.this, MediaPlaylistAgent.this.getShuffleMode());
                }
            });
        }
    }

    public final void notifyRepeatModeChanged() {
        SimpleArrayMap<PlaylistEventCallback, Executor> callbacks = this.getCallbacks();
        for (int i = 0; i < callbacks.size(); ++i) {
            final PlaylistEventCallback callback = (PlaylistEventCallback)callbacks.keyAt(i);
            Executor executor = (Executor)callbacks.valueAt(i);
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.onRepeatModeChanged(MediaPlaylistAgent.this, MediaPlaylistAgent.this.getRepeatMode());
                }
            });
        }
    }

    @Nullable
    public abstract List<MediaItem2> getPlaylist();

    public abstract void setPlaylist(@NonNull List<MediaItem2> var1, @Nullable MediaMetadata2 var2);

    @Nullable
    public abstract MediaMetadata2 getPlaylistMetadata();

    public abstract void updatePlaylistMetadata(@Nullable MediaMetadata2 var1);

    public abstract MediaItem2 getCurrentMediaItem();

    public abstract void addPlaylistItem(int var1, @NonNull MediaItem2 var2);

    public abstract void removePlaylistItem(@NonNull MediaItem2 var1);

    public abstract void replacePlaylistItem(int var1, @NonNull MediaItem2 var2);

    public abstract void skipToPlaylistItem(@NonNull MediaItem2 var1);

    public abstract void skipToPreviousItem();

    public abstract void skipToNextItem();

    public abstract int getRepeatMode();

    public abstract void setRepeatMode(int var1);

    public abstract int getShuffleMode();

    public abstract void setShuffleMode(int var1);

    @Nullable
    public MediaItem2 getMediaItem(@NonNull DataSourceDesc dsd) {
        if (dsd == null) {
            throw new IllegalArgumentException("dsd shouldn't be null");
        }
        List<MediaItem2> itemList = this.getPlaylist();
        if (itemList == null) {
            return null;
        }
        for (int i = 0; i < itemList.size(); ++i) {
            MediaItem2 item = itemList.get(i);
            if (item == null || !item.getDataSourceDesc().equals(dsd)) continue;
            return item;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SimpleArrayMap<PlaylistEventCallback, Executor> getCallbacks() {
        SimpleArrayMap callbacks = new SimpleArrayMap();
        Object object = this.mLock;
        synchronized (object) {
            callbacks.putAll(this.mCallbacks);
        }
        return callbacks;
    }

    public static abstract class PlaylistEventCallback {
        public void onPlaylistChanged(@NonNull MediaPlaylistAgent playlistAgent, @NonNull List<MediaItem2> list, @Nullable MediaMetadata2 metadata) {
        }

        public void onPlaylistMetadataChanged(@NonNull MediaPlaylistAgent playlistAgent, @Nullable MediaMetadata2 metadata) {
        }

        public void onShuffleModeChanged(@NonNull MediaPlaylistAgent playlistAgent, int shuffleMode) {
        }

        public void onRepeatModeChanged(@NonNull MediaPlaylistAgent playlistAgent, int repeatMode) {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ShuffleMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface RepeatMode {
    }
}

