/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.mediacompat.Rating2;
import android.support.v4.media.AudioFocusHandler;
import android.support.v4.media.BaseMediaPlayer;
import android.support.v4.media.DataSourceDesc;
import android.support.v4.media.MediaController2;
import android.support.v4.media.MediaInterface2;
import android.support.v4.media.MediaItem2;
import android.support.v4.media.MediaMetadata2;
import android.support.v4.media.MediaPlaylistAgent;
import android.support.v4.media.MediaSession2ImplBase;
import android.support.v4.media.SessionCommand2;
import android.support.v4.media.SessionCommandGroup2;
import android.support.v4.media.SessionToken2;
import android.support.v4.media.VolumeProviderCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.support.v4.media.session.PlaybackStateCompat;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

@TargetApi(value=19)
public class MediaSession2
implements MediaInterface2.SessionPlayer,
AutoCloseable {
    public static final int ERROR_CODE_UNKNOWN_ERROR = 0;
    public static final int ERROR_CODE_APP_ERROR = 1;
    public static final int ERROR_CODE_NOT_SUPPORTED = 2;
    public static final int ERROR_CODE_AUTHENTICATION_EXPIRED = 3;
    public static final int ERROR_CODE_PREMIUM_ACCOUNT_REQUIRED = 4;
    public static final int ERROR_CODE_CONCURRENT_STREAM_LIMIT = 5;
    public static final int ERROR_CODE_PARENTAL_CONTROL_RESTRICTED = 6;
    public static final int ERROR_CODE_NOT_AVAILABLE_IN_REGION = 7;
    public static final int ERROR_CODE_CONTENT_ALREADY_PLAYING = 8;
    public static final int ERROR_CODE_SKIP_LIMIT_REACHED = 9;
    public static final int ERROR_CODE_ACTION_ABORTED = 10;
    public static final int ERROR_CODE_END_OF_QUEUE = 11;
    public static final int ERROR_CODE_SETUP_REQUIRED = 12;
    static final String TAG = "MediaSession2";
    private final SupportLibraryImpl mImpl;

    MediaSession2(Context context, String id, BaseMediaPlayer player, MediaPlaylistAgent playlistAgent, VolumeProviderCompat volumeProvider, PendingIntent sessionActivity, Executor callbackExecutor, SessionCallback callback) {
        this.mImpl = this.createImpl(context, id, player, playlistAgent, volumeProvider, sessionActivity, callbackExecutor, callback);
    }

    SupportLibraryImpl createImpl(Context context, String id, BaseMediaPlayer player, MediaPlaylistAgent playlistAgent, VolumeProviderCompat volumeProvider, PendingIntent sessionActivity, Executor callbackExecutor, SessionCallback callback) {
        return new MediaSession2ImplBase(this, context, id, player, playlistAgent, volumeProvider, sessionActivity, callbackExecutor, callback);
    }

    SupportLibraryImpl getImpl() {
        return this.mImpl;
    }

    public void updatePlayer(@NonNull BaseMediaPlayer player, @Nullable MediaPlaylistAgent playlistAgent, @Nullable VolumeProviderCompat volumeProvider) {
        this.mImpl.updatePlayer(player, playlistAgent, volumeProvider);
    }

    @Override
    public void close() {
        try {
            this.mImpl.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @NonNull
    public BaseMediaPlayer getPlayer() {
        return this.mImpl.getPlayer();
    }

    @NonNull
    public MediaPlaylistAgent getPlaylistAgent() {
        return this.mImpl.getPlaylistAgent();
    }

    @Nullable
    public VolumeProviderCompat getVolumeProvider() {
        return this.mImpl.getVolumeProvider();
    }

    @NonNull
    public SessionToken2 getToken() {
        return this.mImpl.getToken();
    }

    @NonNull
    Context getContext() {
        return this.mImpl.getContext();
    }

    @NonNull
    Executor getCallbackExecutor() {
        return this.mImpl.getCallbackExecutor();
    }

    @NonNull
    SessionCallback getCallback() {
        return this.mImpl.getCallback();
    }

    @NonNull
    AudioFocusHandler getAudioFocusHandler() {
        return this.mImpl.getAudioFocusHandler();
    }

    @NonNull
    public List<ControllerInfo> getConnectedControllers() {
        return this.mImpl.getConnectedControllers();
    }

    public void setCustomLayout(@NonNull ControllerInfo controller, @NonNull List<CommandButton> layout) {
        this.mImpl.setCustomLayout(controller, layout);
    }

    public void setAllowedCommands(@NonNull ControllerInfo controller, @NonNull SessionCommandGroup2 commands) {
        this.mImpl.setAllowedCommands(controller, commands);
    }

    public void sendCustomCommand(@NonNull SessionCommand2 command, @Nullable Bundle args) {
        this.mImpl.sendCustomCommand(command, args);
    }

    public void sendCustomCommand(@NonNull ControllerInfo controller, @NonNull SessionCommand2 command, @Nullable Bundle args, @Nullable ResultReceiver receiver) {
        this.mImpl.sendCustomCommand(controller, command, args, receiver);
    }

    @Override
    public void play() {
        this.mImpl.play();
    }

    @Override
    public void pause() {
        this.mImpl.pause();
    }

    @Override
    public void reset() {
        this.mImpl.reset();
    }

    @Override
    public void prepare() {
        this.mImpl.prepare();
    }

    @Override
    public void seekTo(long pos) {
        this.mImpl.seekTo(pos);
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void skipForward() {
        this.mImpl.skipForward();
    }

    @Override
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void skipBackward() {
        this.mImpl.skipBackward();
    }

    @Override
    public void notifyError(int errorCode, @Nullable Bundle extras) {
        this.mImpl.notifyError(errorCode, extras);
    }

    public void notifyRoutesInfoChanged(@NonNull ControllerInfo controller, @Nullable List<Bundle> routes) {
        this.mImpl.notifyRoutesInfoChanged(controller, routes);
    }

    @Override
    public int getPlayerState() {
        return this.mImpl.getPlayerState();
    }

    @Override
    public long getCurrentPosition() {
        return this.mImpl.getCurrentPosition();
    }

    @Override
    public long getDuration() {
        return this.mImpl.getDuration();
    }

    @Override
    public long getBufferedPosition() {
        return this.mImpl.getBufferedPosition();
    }

    @Override
    public int getBufferingState() {
        return this.mImpl.getBufferingState();
    }

    @Override
    public float getPlaybackSpeed() {
        return this.mImpl.getPlaybackSpeed();
    }

    @Override
    public void setPlaybackSpeed(float speed) {
        this.mImpl.setPlaybackSpeed(speed);
    }

    @Override
    public void setOnDataSourceMissingHelper(@NonNull OnDataSourceMissingHelper helper) {
        this.mImpl.setOnDataSourceMissingHelper(helper);
    }

    @Override
    public void clearOnDataSourceMissingHelper() {
        this.mImpl.clearOnDataSourceMissingHelper();
    }

    @Override
    public List<MediaItem2> getPlaylist() {
        return this.mImpl.getPlaylist();
    }

    @Override
    public void setPlaylist(@NonNull List<MediaItem2> list, @Nullable MediaMetadata2 metadata) {
        this.mImpl.setPlaylist(list, metadata);
    }

    @Override
    public void skipToPlaylistItem(@NonNull MediaItem2 item) {
        this.mImpl.skipToPlaylistItem(item);
    }

    @Override
    public void skipToPreviousItem() {
        this.mImpl.skipToPreviousItem();
    }

    @Override
    public void skipToNextItem() {
        this.mImpl.skipToNextItem();
    }

    @Override
    public MediaMetadata2 getPlaylistMetadata() {
        return this.mImpl.getPlaylistMetadata();
    }

    @Override
    public void addPlaylistItem(int index, @NonNull MediaItem2 item) {
        this.mImpl.addPlaylistItem(index, item);
    }

    @Override
    public void removePlaylistItem(@NonNull MediaItem2 item) {
        this.mImpl.removePlaylistItem(item);
    }

    @Override
    public void replacePlaylistItem(int index, @NonNull MediaItem2 item) {
        this.mImpl.replacePlaylistItem(index, item);
    }

    @Override
    public MediaItem2 getCurrentMediaItem() {
        return this.mImpl.getCurrentMediaItem();
    }

    @Override
    public void updatePlaylistMetadata(@Nullable MediaMetadata2 metadata) {
        this.mImpl.updatePlaylistMetadata(metadata);
    }

    @Override
    public int getRepeatMode() {
        return this.mImpl.getRepeatMode();
    }

    @Override
    public void setRepeatMode(int repeatMode) {
        this.mImpl.setRepeatMode(repeatMode);
    }

    @Override
    public int getShuffleMode() {
        return this.mImpl.getShuffleMode();
    }

    @Override
    public void setShuffleMode(int shuffleMode) {
        this.mImpl.setShuffleMode(shuffleMode);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public MediaSessionCompat getSessionCompat() {
        return this.mImpl.getSessionCompat();
    }

    IBinder getSessionBinder() {
        return this.mImpl.getSessionBinder();
    }

    static class MainHandlerExecutor
    implements Executor {
        private final Handler mHandler;

        MainHandlerExecutor(Context context) {
            this.mHandler = new Handler(context.getMainLooper());
        }

        @Override
        public void execute(Runnable command) {
            if (!this.mHandler.post(command)) {
                throw new RejectedExecutionException(this.mHandler + " is shutting down");
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    static abstract class BuilderBase<T extends MediaSession2, U extends BuilderBase<T, U, C>, C extends SessionCallback> {
        final Context mContext;
        BaseMediaPlayer mPlayer;
        String mId;
        Executor mCallbackExecutor;
        C mCallback;
        MediaPlaylistAgent mPlaylistAgent;
        VolumeProviderCompat mVolumeProvider;
        PendingIntent mSessionActivity;

        BuilderBase(Context context) {
            if (context == null) {
                throw new IllegalArgumentException("context shouldn't be null");
            }
            this.mContext = context;
            this.mId = "";
        }

        @NonNull
        U setPlayer(@NonNull BaseMediaPlayer player) {
            if (player == null) {
                throw new IllegalArgumentException("player shouldn't be null");
            }
            this.mPlayer = player;
            return (U)this;
        }

        U setPlaylistAgent(@NonNull MediaPlaylistAgent playlistAgent) {
            if (playlistAgent == null) {
                throw new IllegalArgumentException("playlistAgent shouldn't be null");
            }
            this.mPlaylistAgent = playlistAgent;
            return (U)this;
        }

        @NonNull
        U setVolumeProvider(@Nullable VolumeProviderCompat volumeProvider) {
            this.mVolumeProvider = volumeProvider;
            return (U)this;
        }

        @NonNull
        U setSessionActivity(@Nullable PendingIntent pi) {
            this.mSessionActivity = pi;
            return (U)this;
        }

        @NonNull
        U setId(@NonNull String id) {
            if (id == null) {
                throw new IllegalArgumentException("id shouldn't be null");
            }
            this.mId = id;
            return (U)this;
        }

        @NonNull
        U setSessionCallback(@NonNull Executor executor, @NonNull C callback) {
            if (executor == null) {
                throw new IllegalArgumentException("executor shouldn't be null");
            }
            if (callback == null) {
                throw new IllegalArgumentException("callback shouldn't be null");
            }
            this.mCallbackExecutor = executor;
            this.mCallback = callback;
            return (U)this;
        }

        @NonNull
        abstract T build();
    }

    static interface SupportLibraryImpl
    extends MediaInterface2.SessionPlayer,
    AutoCloseable {
        public void updatePlayer(@NonNull BaseMediaPlayer var1, @Nullable MediaPlaylistAgent var2, @Nullable VolumeProviderCompat var3);

        @NonNull
        public BaseMediaPlayer getPlayer();

        @NonNull
        public MediaPlaylistAgent getPlaylistAgent();

        @Nullable
        public VolumeProviderCompat getVolumeProvider();

        @NonNull
        public SessionToken2 getToken();

        @NonNull
        public List<ControllerInfo> getConnectedControllers();

        public void setCustomLayout(@NonNull ControllerInfo var1, @NonNull List<CommandButton> var2);

        public void setAllowedCommands(@NonNull ControllerInfo var1, @NonNull SessionCommandGroup2 var2);

        public void sendCustomCommand(@NonNull SessionCommand2 var1, @Nullable Bundle var2);

        public void sendCustomCommand(@NonNull ControllerInfo var1, @NonNull SessionCommand2 var2, @Nullable Bundle var3, @Nullable ResultReceiver var4);

        public void notifyRoutesInfoChanged(@NonNull ControllerInfo var1, @Nullable List<Bundle> var2);

        public MediaSession2 getInstance();

        public IBinder getSessionBinder();

        public MediaSessionCompat getSessionCompat();

        public Context getContext();

        public Executor getCallbackExecutor();

        public SessionCallback getCallback();

        public boolean isClosed();

        public PlaybackStateCompat getPlaybackStateCompat();

        public MediaController2.PlaybackInfo getPlaybackInfo();

        public AudioFocusHandler getAudioFocusHandler();

        public PendingIntent getSessionActivity();
    }

    static abstract class ControllerCb {
        ControllerCb() {
        }

        public int hashCode() {
            return this.getId().hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ControllerCb)) {
                return false;
            }
            ControllerCb other = (ControllerCb)obj;
            return this.getId().equals(other.getId());
        }

        @NonNull
        abstract IBinder getId();

        abstract void onCustomLayoutChanged(@NonNull List<CommandButton> var1) throws RemoteException;

        abstract void onPlaybackInfoChanged(@NonNull MediaController2.PlaybackInfo var1) throws RemoteException;

        abstract void onAllowedCommandsChanged(@NonNull SessionCommandGroup2 var1) throws RemoteException;

        abstract void onCustomCommand(@NonNull SessionCommand2 var1, @Nullable Bundle var2, @Nullable ResultReceiver var3) throws RemoteException;

        abstract void onPlayerStateChanged(long var1, long var3, int var5) throws RemoteException;

        abstract void onPlaybackSpeedChanged(long var1, long var3, float var5) throws RemoteException;

        abstract void onBufferingStateChanged(@NonNull MediaItem2 var1, int var2, long var3) throws RemoteException;

        abstract void onSeekCompleted(long var1, long var3, long var5) throws RemoteException;

        abstract void onError(int var1, @Nullable Bundle var2) throws RemoteException;

        abstract void onCurrentMediaItemChanged(@Nullable MediaItem2 var1) throws RemoteException;

        abstract void onPlaylistChanged(@NonNull List<MediaItem2> var1, @Nullable MediaMetadata2 var2) throws RemoteException;

        abstract void onPlaylistMetadataChanged(@Nullable MediaMetadata2 var1) throws RemoteException;

        abstract void onShuffleModeChanged(int var1) throws RemoteException;

        abstract void onRepeatModeChanged(int var1) throws RemoteException;

        abstract void onRoutesInfoChanged(@Nullable List<Bundle> var1) throws RemoteException;

        abstract void onDisconnected() throws RemoteException;

        abstract void onGetLibraryRootDone(@Nullable Bundle var1, @Nullable String var2, @Nullable Bundle var3) throws RemoteException;

        abstract void onChildrenChanged(@NonNull String var1, int var2, @Nullable Bundle var3) throws RemoteException;

        abstract void onGetChildrenDone(@NonNull String var1, int var2, int var3, @Nullable List<MediaItem2> var4, @Nullable Bundle var5) throws RemoteException;

        abstract void onGetItemDone(@NonNull String var1, @Nullable MediaItem2 var2) throws RemoteException;

        abstract void onSearchResultChanged(@NonNull String var1, int var2, @Nullable Bundle var3) throws RemoteException;

        abstract void onGetSearchResultDone(@NonNull String var1, int var2, int var3, @Nullable List<MediaItem2> var4, @Nullable Bundle var5) throws RemoteException;
    }

    public static final class CommandButton {
        private static final String KEY_COMMAND = "android.media.media_session2.command_button.command";
        private static final String KEY_ICON_RES_ID = "android.media.media_session2.command_button.icon_res_id";
        private static final String KEY_DISPLAY_NAME = "android.media.media_session2.command_button.display_name";
        private static final String KEY_EXTRAS = "android.media.media_session2.command_button.extras";
        private static final String KEY_ENABLED = "android.media.media_session2.command_button.enabled";
        private SessionCommand2 mCommand;
        private int mIconResId;
        private String mDisplayName;
        private Bundle mExtras;
        private boolean mEnabled;

        private CommandButton(@Nullable SessionCommand2 command, int iconResId, @Nullable String displayName, Bundle extras, boolean enabled) {
            this.mCommand = command;
            this.mIconResId = iconResId;
            this.mDisplayName = displayName;
            this.mExtras = extras;
            this.mEnabled = enabled;
        }

        @Nullable
        public SessionCommand2 getCommand() {
            return this.mCommand;
        }

        public int getIconResId() {
            return this.mIconResId;
        }

        @Nullable
        public String getDisplayName() {
            return this.mDisplayName;
        }

        @Nullable
        public Bundle getExtras() {
            return this.mExtras;
        }

        public boolean isEnabled() {
            return this.mEnabled;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public Bundle toBundle() {
            Bundle bundle = new Bundle();
            bundle.putBundle(KEY_COMMAND, this.mCommand.toBundle());
            bundle.putInt(KEY_ICON_RES_ID, this.mIconResId);
            bundle.putString(KEY_DISPLAY_NAME, this.mDisplayName);
            bundle.putBundle(KEY_EXTRAS, this.mExtras);
            bundle.putBoolean(KEY_ENABLED, this.mEnabled);
            return bundle;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @Nullable
        public static CommandButton fromBundle(Bundle bundle) {
            if (bundle == null) {
                return null;
            }
            Builder builder = new Builder();
            builder.setCommand(SessionCommand2.fromBundle(bundle.getBundle(KEY_COMMAND)));
            builder.setIconResId(bundle.getInt(KEY_ICON_RES_ID, 0));
            builder.setDisplayName(bundle.getString(KEY_DISPLAY_NAME));
            builder.setExtras(bundle.getBundle(KEY_EXTRAS));
            builder.setEnabled(bundle.getBoolean(KEY_ENABLED));
            try {
                return builder.build();
            }
            catch (IllegalStateException e) {
                return null;
            }
        }

        public static final class Builder {
            private SessionCommand2 mCommand;
            private int mIconResId;
            private String mDisplayName;
            private Bundle mExtras;
            private boolean mEnabled;

            @NonNull
            public Builder setCommand(@Nullable SessionCommand2 command) {
                this.mCommand = command;
                return this;
            }

            @NonNull
            public Builder setIconResId(int resId) {
                this.mIconResId = resId;
                return this;
            }

            @NonNull
            public Builder setDisplayName(@Nullable String displayName) {
                this.mDisplayName = displayName;
                return this;
            }

            @NonNull
            public Builder setEnabled(boolean enabled) {
                this.mEnabled = enabled;
                return this;
            }

            @NonNull
            public Builder setExtras(@Nullable Bundle extras) {
                this.mExtras = extras;
                return this;
            }

            @NonNull
            public CommandButton build() {
                return new CommandButton(this.mCommand, this.mIconResId, this.mDisplayName, this.mExtras, this.mEnabled);
            }
        }
    }

    public static final class ControllerInfo {
        private final int mUid;
        private final String mPackageName;
        private final boolean mIsTrusted;
        private final ControllerCb mControllerCb;

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        ControllerInfo(@NonNull String packageName, int pid, int uid, @NonNull ControllerCb cb) {
            this.mUid = uid;
            this.mPackageName = packageName;
            this.mIsTrusted = false;
            this.mControllerCb = cb;
        }

        @NonNull
        public String getPackageName() {
            return this.mPackageName;
        }

        public int getUid() {
            return this.mUid;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public boolean isTrusted() {
            return this.mIsTrusted;
        }

        public int hashCode() {
            return this.mControllerCb.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ControllerInfo)) {
                return false;
            }
            ControllerInfo other = (ControllerInfo)obj;
            return this.mControllerCb.equals(other.mControllerCb);
        }

        public String toString() {
            return "ControllerInfo {pkg=" + this.mPackageName + ", uid=" + this.mUid + "})";
        }

        @NonNull
        IBinder getId() {
            return this.mControllerCb.getId();
        }

        @NonNull
        ControllerCb getControllerCb() {
            return this.mControllerCb;
        }
    }

    public static final class Builder
    extends BuilderBase<MediaSession2, Builder, SessionCallback> {
        public Builder(Context context) {
            super(context);
        }

        @Override
        @NonNull
        public Builder setPlayer(@NonNull BaseMediaPlayer player) {
            return (Builder)super.setPlayer(player);
        }

        @Override
        @NonNull
        public Builder setPlaylistAgent(@NonNull MediaPlaylistAgent playlistAgent) {
            return (Builder)super.setPlaylistAgent(playlistAgent);
        }

        @Override
        @NonNull
        public Builder setVolumeProvider(@Nullable VolumeProviderCompat volumeProvider) {
            return (Builder)super.setVolumeProvider(volumeProvider);
        }

        @Override
        @NonNull
        public Builder setSessionActivity(@Nullable PendingIntent pi) {
            return (Builder)super.setSessionActivity(pi);
        }

        @Override
        @NonNull
        public Builder setId(@NonNull String id) {
            return (Builder)super.setId(id);
        }

        @Override
        @NonNull
        public Builder setSessionCallback(@NonNull Executor executor, @NonNull SessionCallback callback) {
            return (Builder)super.setSessionCallback(executor, callback);
        }

        @Override
        @NonNull
        public MediaSession2 build() {
            if (this.mCallbackExecutor == null) {
                this.mCallbackExecutor = new MainHandlerExecutor(this.mContext);
            }
            if (this.mCallback == null) {
                this.mCallback = new SessionCallback(){};
            }
            return new MediaSession2(this.mContext, this.mId, this.mPlayer, this.mPlaylistAgent, this.mVolumeProvider, this.mSessionActivity, this.mCallbackExecutor, this.mCallback);
        }
    }

    public static abstract class SessionCallback {
        @Nullable
        public SessionCommandGroup2 onConnect(@NonNull MediaSession2 session, @NonNull ControllerInfo controller) {
            SessionCommandGroup2 commands = new SessionCommandGroup2();
            commands.addAllPredefinedCommands();
            return commands;
        }

        public void onDisconnected(@NonNull MediaSession2 session, @NonNull ControllerInfo controller) {
        }

        public boolean onCommandRequest(@NonNull MediaSession2 session, @NonNull ControllerInfo controller, @NonNull SessionCommand2 command) {
            return true;
        }

        public void onSetRating(@NonNull MediaSession2 session, @NonNull ControllerInfo controller, @NonNull String mediaId, @NonNull Rating2 rating) {
        }

        public void onCustomCommand(@NonNull MediaSession2 session, @NonNull ControllerInfo controller, @NonNull SessionCommand2 customCommand, @Nullable Bundle args, @Nullable ResultReceiver cb) {
        }

        public void onPlayFromMediaId(@NonNull MediaSession2 session, @NonNull ControllerInfo controller, @NonNull String mediaId, @Nullable Bundle extras) {
        }

        public void onPlayFromSearch(@NonNull MediaSession2 session, @NonNull ControllerInfo controller, @NonNull String query, @Nullable Bundle extras) {
        }

        public void onPlayFromUri(@NonNull MediaSession2 session, @NonNull ControllerInfo controller, @NonNull Uri uri, @Nullable Bundle extras) {
        }

        public void onPrepareFromMediaId(@NonNull MediaSession2 session, @NonNull ControllerInfo controller, @NonNull String mediaId, @Nullable Bundle extras) {
        }

        public void onPrepareFromSearch(@NonNull MediaSession2 session, @NonNull ControllerInfo controller, @NonNull String query, @Nullable Bundle extras) {
        }

        public void onPrepareFromUri(@NonNull MediaSession2 session, @NonNull ControllerInfo controller, @NonNull Uri uri, @Nullable Bundle extras) {
        }

        public void onFastForward(@NonNull MediaSession2 session, ControllerInfo controller) {
        }

        public void onRewind(@NonNull MediaSession2 session, ControllerInfo controller) {
        }

        public void onSubscribeRoutesInfo(@NonNull MediaSession2 session, @NonNull ControllerInfo controller) {
        }

        public void onUnsubscribeRoutesInfo(@NonNull MediaSession2 session, @NonNull ControllerInfo controller) {
        }

        public void onSelectRoute(@NonNull MediaSession2 session, @NonNull ControllerInfo controller, @NonNull Bundle route) {
        }

        public void onCurrentMediaItemChanged(@NonNull MediaSession2 session, @NonNull BaseMediaPlayer player, @Nullable MediaItem2 item) {
        }

        public void onMediaPrepared(@NonNull MediaSession2 session, @NonNull BaseMediaPlayer player, @NonNull MediaItem2 item) {
        }

        public void onPlayerStateChanged(@NonNull MediaSession2 session, @NonNull BaseMediaPlayer player, int state) {
        }

        public void onBufferingStateChanged(@NonNull MediaSession2 session, @NonNull BaseMediaPlayer player, @NonNull MediaItem2 item, int state) {
        }

        public void onPlaybackSpeedChanged(@NonNull MediaSession2 session, @NonNull BaseMediaPlayer player, float speed) {
        }

        public void onSeekCompleted(@NonNull MediaSession2 session, @NonNull BaseMediaPlayer player, long position) {
        }

        public void onPlaylistChanged(@NonNull MediaSession2 session, @NonNull MediaPlaylistAgent playlistAgent, @NonNull List<MediaItem2> list, @Nullable MediaMetadata2 metadata) {
        }

        public void onPlaylistMetadataChanged(@NonNull MediaSession2 session, @NonNull MediaPlaylistAgent playlistAgent, @Nullable MediaMetadata2 metadata) {
        }

        public void onShuffleModeChanged(@NonNull MediaSession2 session, @NonNull MediaPlaylistAgent playlistAgent, int shuffleMode) {
        }

        public void onRepeatModeChanged(@NonNull MediaSession2 session, @NonNull MediaPlaylistAgent playlistAgent, int repeatMode) {
        }
    }

    public static interface OnDataSourceMissingHelper {
        @Nullable
        public DataSourceDesc onDataSourceMissing(@NonNull MediaSession2 var1, @NonNull MediaItem2 var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ErrorCode {
    }
}

