/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.annotation.TargetApi;
import android.support.annotation.GuardedBy;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.media.BaseMediaPlayer;
import android.support.v4.media.DataSourceDesc;
import android.support.v4.media.MediaItem2;
import android.support.v4.media.MediaMetadata2;
import android.support.v4.media.MediaPlaylistAgent;
import android.support.v4.media.MediaSession2;
import android.support.v4.media.MediaSession2ImplBase;
import android.support.v4.util.ArrayMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

@TargetApi(value=19)
class SessionPlaylistAgentImplBase
extends MediaPlaylistAgent {
    @VisibleForTesting
    static final int END_OF_PLAYLIST = -1;
    @VisibleForTesting
    static final int NO_VALID_ITEMS = -2;
    private final PlayItem mEopPlayItem = new PlayItem(-1, null);
    private final Object mLock = new Object();
    private final MediaSession2ImplBase mSession;
    private final MyPlayerEventCallback mPlayerCallback;
    @GuardedBy(value="mLock")
    private BaseMediaPlayer mPlayer;
    @GuardedBy(value="mLock")
    private MediaSession2.OnDataSourceMissingHelper mDsmHelper;
    @GuardedBy(value="mLock")
    private ArrayList<MediaItem2> mPlaylist = new ArrayList();
    @GuardedBy(value="mLock")
    private ArrayList<MediaItem2> mShuffledList = new ArrayList();
    @GuardedBy(value="mLock")
    private Map<MediaItem2, DataSourceDesc> mItemDsdMap = new ArrayMap();
    @GuardedBy(value="mLock")
    private MediaMetadata2 mMetadata;
    @GuardedBy(value="mLock")
    private int mRepeatMode;
    @GuardedBy(value="mLock")
    private int mShuffleMode;
    @GuardedBy(value="mLock")
    private PlayItem mCurrent;

    SessionPlaylistAgentImplBase(@NonNull MediaSession2ImplBase session, @NonNull BaseMediaPlayer player) {
        if (session == null) {
            throw new IllegalArgumentException("sessionImpl shouldn't be null");
        }
        if (player == null) {
            throw new IllegalArgumentException("player shouldn't be null");
        }
        this.mSession = session;
        this.mPlayer = player;
        this.mPlayerCallback = new MyPlayerEventCallback();
        this.mPlayer.registerPlayerEventCallback(this.mSession.getCallbackExecutor(), this.mPlayerCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayer(@NonNull BaseMediaPlayer player) {
        if (player == null) {
            throw new IllegalArgumentException("player shouldn't be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (player == this.mPlayer) {
                return;
            }
            this.mPlayer.unregisterPlayerEventCallback(this.mPlayerCallback);
            this.mPlayer = player;
            this.mPlayer.registerPlayerEventCallback(this.mSession.getCallbackExecutor(), this.mPlayerCallback);
            this.updatePlayerDataSourceLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnDataSourceMissingHelper(MediaSession2.OnDataSourceMissingHelper helper) {
        Object object = this.mLock;
        synchronized (object) {
            this.mDsmHelper = helper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearOnDataSourceMissingHelper() {
        Object object = this.mLock;
        synchronized (object) {
            this.mDsmHelper = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public List<MediaItem2> getPlaylist() {
        Object object = this.mLock;
        synchronized (object) {
            return Collections.unmodifiableList(this.mPlaylist);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPlaylist(@NonNull List<MediaItem2> list, @Nullable MediaMetadata2 metadata) {
        if (list == null) {
            throw new IllegalArgumentException("list shouldn't be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.mItemDsdMap.clear();
            this.mPlaylist.clear();
            this.mPlaylist.addAll(list);
            this.applyShuffleModeLocked();
            this.mMetadata = metadata;
            this.mCurrent = this.getNextValidPlayItemLocked(-1, 1);
            this.updatePlayerDataSourceLocked();
        }
        this.notifyPlaylistChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public MediaMetadata2 getPlaylistMetadata() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mMetadata;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePlaylistMetadata(@Nullable MediaMetadata2 metadata) {
        Object object = this.mLock;
        synchronized (object) {
            if (metadata == this.mMetadata) {
                return;
            }
            this.mMetadata = metadata;
        }
        this.notifyPlaylistMetadataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MediaItem2 getCurrentMediaItem() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCurrent == null ? null : this.mCurrent.mediaItem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPlaylistItem(int index, @NonNull MediaItem2 item) {
        if (item == null) {
            throw new IllegalArgumentException("item shouldn't be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            int shuffledIdx = index = SessionPlaylistAgentImplBase.clamp(index, this.mPlaylist.size());
            this.mPlaylist.add(index, item);
            if (this.mShuffleMode == 0) {
                this.mShuffledList.add(index, item);
            } else {
                shuffledIdx = (int)(Math.random() * (double)(this.mShuffledList.size() + 1));
                this.mShuffledList.add(shuffledIdx, item);
            }
            if (!this.hasValidItem()) {
                this.mCurrent = this.getNextValidPlayItemLocked(-1, 1);
                this.updatePlayerDataSourceLocked();
            } else {
                this.updateCurrentIfNeededLocked();
            }
        }
        this.notifyPlaylistChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePlaylistItem(@NonNull MediaItem2 item) {
        if (item == null) {
            throw new IllegalArgumentException("item shouldn't be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mPlaylist.remove(item)) {
                return;
            }
            this.mShuffledList.remove(item);
            this.mItemDsdMap.remove(item);
            this.updateCurrentIfNeededLocked();
        }
        this.notifyPlaylistChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replacePlaylistItem(int index, @NonNull MediaItem2 item) {
        if (item == null) {
            throw new IllegalArgumentException("item shouldn't be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mPlaylist.size() <= 0) {
                return;
            }
            index = SessionPlaylistAgentImplBase.clamp(index, this.mPlaylist.size() - 1);
            int shuffledIdx = this.mShuffledList.indexOf(this.mPlaylist.get(index));
            this.mItemDsdMap.remove(this.mShuffledList.get(shuffledIdx));
            this.mShuffledList.set(shuffledIdx, item);
            this.mPlaylist.set(index, item);
            if (!this.hasValidItem()) {
                this.mCurrent = this.getNextValidPlayItemLocked(-1, 1);
                this.updatePlayerDataSourceLocked();
            } else {
                this.updateCurrentIfNeededLocked();
            }
        }
        this.notifyPlaylistChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void skipToPlaylistItem(@NonNull MediaItem2 item) {
        if (item == null) {
            throw new IllegalArgumentException("item shouldn't be null");
        }
        Object object = this.mLock;
        synchronized (object) {
            if (!this.hasValidItem() || item.equals(this.mCurrent.mediaItem)) {
                return;
            }
            int shuffledIdx = this.mShuffledList.indexOf(item);
            if (shuffledIdx < 0) {
                return;
            }
            this.mCurrent = new PlayItem(shuffledIdx);
            this.updateCurrentIfNeededLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void skipToPreviousItem() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.hasValidItem()) {
                return;
            }
            PlayItem prev = this.getNextValidPlayItemLocked(this.mCurrent.shuffledIdx, -1);
            if (prev != this.mEopPlayItem) {
                this.mCurrent = prev;
            }
            this.updateCurrentIfNeededLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void skipToNextItem() {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.hasValidItem() || this.mCurrent == this.mEopPlayItem) {
                return;
            }
            PlayItem next = this.getNextValidPlayItemLocked(this.mCurrent.shuffledIdx, 1);
            if (next != this.mEopPlayItem) {
                this.mCurrent = next;
            }
            this.updateCurrentIfNeededLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRepeatMode() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mRepeatMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRepeatMode(int repeatMode) {
        if (repeatMode < 0 || repeatMode > 3) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mRepeatMode == repeatMode) {
                return;
            }
            this.mRepeatMode = repeatMode;
            switch (repeatMode) {
                case 1: {
                    if (this.mCurrent == null || this.mCurrent == this.mEopPlayItem) break;
                    this.mPlayer.loopCurrent(true);
                    break;
                }
                case 2: 
                case 3: {
                    if (this.mCurrent == this.mEopPlayItem) {
                        this.mCurrent = this.getNextValidPlayItemLocked(-1, 1);
                        this.updatePlayerDataSourceLocked();
                    }
                }
                case 0: {
                    this.mPlayer.loopCurrent(false);
                }
            }
        }
        this.notifyRepeatModeChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getShuffleMode() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mShuffleMode;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShuffleMode(int shuffleMode) {
        if (shuffleMode < 0 || shuffleMode > 2) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            if (this.mShuffleMode == shuffleMode) {
                return;
            }
            this.mShuffleMode = shuffleMode;
            this.applyShuffleModeLocked();
            this.updateCurrentIfNeededLocked();
        }
        this.notifyShuffleModeChanged();
    }

    @Override
    public MediaItem2 getMediaItem(DataSourceDesc dsd) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    int getCurShuffledIndex() {
        Object object = this.mLock;
        synchronized (object) {
            return this.hasValidItem() ? this.mCurrent.shuffledIdx : -2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasValidItem() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mCurrent != null;
        }
    }

    private DataSourceDesc retrieveDataSourceDescLocked(MediaItem2 item) {
        DataSourceDesc dsd = item.getDataSourceDesc();
        if (dsd != null) {
            this.mItemDsdMap.put(item, dsd);
            return dsd;
        }
        dsd = this.mItemDsdMap.get(item);
        if (dsd != null) {
            return dsd;
        }
        MediaSession2.OnDataSourceMissingHelper helper = this.mDsmHelper;
        if (helper != null && (dsd = helper.onDataSourceMissing(this.mSession.getInstance(), item)) != null) {
            this.mItemDsdMap.put(item, dsd);
        }
        return dsd;
    }

    private PlayItem getNextValidPlayItemLocked(int curShuffledIdx, int direction) {
        int size = this.mPlaylist.size();
        if (curShuffledIdx == -1) {
            curShuffledIdx = direction > 0 ? -1 : size;
        }
        for (int i = 0; i < size; ++i) {
            DataSourceDesc dsd;
            if ((curShuffledIdx += direction) < 0 || curShuffledIdx >= this.mPlaylist.size()) {
                if (this.mRepeatMode == 0) {
                    return i == size - 1 ? null : this.mEopPlayItem;
                }
                int n = curShuffledIdx = curShuffledIdx < 0 ? this.mPlaylist.size() - 1 : 0;
            }
            if ((dsd = this.retrieveDataSourceDescLocked(this.mShuffledList.get(curShuffledIdx))) == null) continue;
            return new PlayItem(curShuffledIdx, dsd);
        }
        return null;
    }

    private void updateCurrentIfNeededLocked() {
        if (!this.hasValidItem() || this.mCurrent.isValid()) {
            return;
        }
        int shuffledIdx = this.mShuffledList.indexOf(this.mCurrent.mediaItem);
        if (shuffledIdx >= 0) {
            this.mCurrent.shuffledIdx = shuffledIdx;
            return;
        }
        if (this.mCurrent.shuffledIdx >= this.mShuffledList.size()) {
            this.mCurrent = this.getNextValidPlayItemLocked(this.mShuffledList.size() - 1, 1);
        } else {
            this.mCurrent.mediaItem = this.mShuffledList.get(this.mCurrent.shuffledIdx);
            if (this.retrieveDataSourceDescLocked(this.mCurrent.mediaItem) == null) {
                this.mCurrent = this.getNextValidPlayItemLocked(this.mCurrent.shuffledIdx, 1);
            }
        }
        this.updatePlayerDataSourceLocked();
    }

    private void updatePlayerDataSourceLocked() {
        if (this.mCurrent == null || this.mCurrent == this.mEopPlayItem) {
            return;
        }
        if (this.mPlayer.getCurrentDataSource() != this.mCurrent.dsd) {
            this.mPlayer.setDataSource(this.mCurrent.dsd);
            this.mPlayer.loopCurrent(this.mRepeatMode == 1);
        }
    }

    private void applyShuffleModeLocked() {
        this.mShuffledList.clear();
        this.mShuffledList.addAll(this.mPlaylist);
        if (this.mShuffleMode == 1 || this.mShuffleMode == 2) {
            Collections.shuffle(this.mShuffledList);
        }
    }

    private static int clamp(int value, int size) {
        if (value < 0) {
            return 0;
        }
        return value > size ? size : value;
    }

    private class PlayItem {
        public int shuffledIdx;
        public DataSourceDesc dsd;
        public MediaItem2 mediaItem;

        PlayItem(int shuffledIdx) {
            this(shuffledIdx, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        PlayItem(int shuffledIdx, DataSourceDesc dsd) {
            this.shuffledIdx = shuffledIdx;
            if (shuffledIdx >= 0) {
                this.mediaItem = (MediaItem2)SessionPlaylistAgentImplBase.this.mShuffledList.get(shuffledIdx);
                if (dsd == null) {
                    Object object = SessionPlaylistAgentImplBase.this.mLock;
                    synchronized (object) {
                        this.dsd = SessionPlaylistAgentImplBase.this.retrieveDataSourceDescLocked(this.mediaItem);
                    }
                } else {
                    this.dsd = dsd;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isValid() {
            if (this == SessionPlaylistAgentImplBase.this.mEopPlayItem) {
                return true;
            }
            if (this.mediaItem == null) {
                return false;
            }
            if (this.dsd == null) {
                return false;
            }
            if (this.mediaItem.getDataSourceDesc() != null && !this.mediaItem.getDataSourceDesc().equals(this.dsd)) {
                return false;
            }
            Object object = SessionPlaylistAgentImplBase.this.mLock;
            synchronized (object) {
                if (this.shuffledIdx >= SessionPlaylistAgentImplBase.this.mShuffledList.size()) {
                    return false;
                }
                if (this.mediaItem != SessionPlaylistAgentImplBase.this.mShuffledList.get(this.shuffledIdx)) {
                    return false;
                }
            }
            return true;
        }
    }

    private class MyPlayerEventCallback
    extends BaseMediaPlayer.PlayerEventCallback {
        private MyPlayerEventCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCurrentDataSourceChanged(@NonNull BaseMediaPlayer mpb, @Nullable DataSourceDesc dsd) {
            Object object = SessionPlaylistAgentImplBase.this.mLock;
            synchronized (object) {
                if (SessionPlaylistAgentImplBase.this.mPlayer != mpb) {
                    return;
                }
                if (dsd == null && SessionPlaylistAgentImplBase.this.mCurrent != null) {
                    SessionPlaylistAgentImplBase.this.mCurrent = SessionPlaylistAgentImplBase.this.getNextValidPlayItemLocked(((SessionPlaylistAgentImplBase)SessionPlaylistAgentImplBase.this).mCurrent.shuffledIdx, 1);
                    SessionPlaylistAgentImplBase.this.updateCurrentIfNeededLocked();
                }
            }
        }
    }
}

