/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.media.SessionToken2ImplBase;
import android.support.v4.media.SessionToken2ImplLegacy;
import android.support.v4.media.session.MediaControllerCompat;
import android.support.v4.media.session.MediaSessionCompat;
import android.text.TextUtils;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.concurrent.Executor;

public final class SessionToken2 {
    private static final String TAG = "SessionToken2";
    private static final long WAIT_TIME_MS_FOR_SESSION_READY = 300L;
    public static final int TYPE_SESSION = 0;
    public static final int TYPE_SESSION_SERVICE = 1;
    public static final int TYPE_LIBRARY_SERVICE = 2;
    static final int TYPE_SESSION_LEGACY = 100;
    static final int UID_UNKNOWN = -1;
    static final String KEY_UID = "android.media.token.uid";
    static final String KEY_TYPE = "android.media.token.type";
    static final String KEY_PACKAGE_NAME = "android.media.token.package_name";
    static final String KEY_SERVICE_NAME = "android.media.token.service_name";
    static final String KEY_SESSION_ID = "android.media.token.session_id";
    static final String KEY_SESSION_BINDER = "android.media.token.session_binder";
    static final String KEY_TOKEN_LEGACY = "android.media.token.LEGACY";
    private final SupportLibraryImpl mImpl;

    public SessionToken2(@NonNull Context context, @NonNull ComponentName serviceComponent) {
        this.mImpl = new SessionToken2ImplBase(context, serviceComponent);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    SessionToken2(SupportLibraryImpl impl) {
        this.mImpl = impl;
    }

    public int hashCode() {
        return this.mImpl.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SessionToken2)) {
            return false;
        }
        SessionToken2 other = (SessionToken2)obj;
        return this.mImpl.equals(other.mImpl);
    }

    public String toString() {
        return this.mImpl.toString();
    }

    public int getUid() {
        return this.mImpl.getUid();
    }

    @NonNull
    public String getPackageName() {
        return this.mImpl.getPackageName();
    }

    @Nullable
    public String getServiceName() {
        return this.mImpl.getServiceName();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public ComponentName getComponentName() {
        return this.mImpl.getComponentName();
    }

    public String getId() {
        return this.mImpl.getSessionId();
    }

    public int getType() {
        return this.mImpl.getType();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isLegacySession() {
        return this.mImpl instanceof SessionToken2ImplLegacy;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Object getBinder() {
        return this.mImpl.getBinder();
    }

    public Bundle toBundle() {
        return this.mImpl.toBundle();
    }

    public static SessionToken2 fromBundle(@NonNull Bundle bundle) {
        if (bundle == null) {
            return null;
        }
        int type = bundle.getInt(KEY_TYPE, -1);
        if (type == 100) {
            return new SessionToken2(SessionToken2ImplLegacy.fromBundle(bundle));
        }
        return new SessionToken2(SessionToken2ImplBase.fromBundle(bundle));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void createSessionToken2(final @NonNull Context context, final @NonNull MediaSessionCompat.Token token, @NonNull Executor executor, final @NonNull OnSessionToken2CreatedListener listener) {
        if (context == null) {
            throw new IllegalArgumentException("context shouldn't be null");
        }
        if (token == null) {
            throw new IllegalArgumentException("token shouldn't be null");
        }
        if (executor == null) {
            throw new IllegalArgumentException("executor shouldn't be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener shouldn't be null");
        }
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    final MediaControllerCompat controller = new MediaControllerCompat(context, token);
                    MediaControllerCompat.Callback callback = new MediaControllerCompat.Callback(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onSessionReady() {
                            OnSessionToken2CreatedListener onSessionToken2CreatedListener = listener;
                            synchronized (onSessionToken2CreatedListener) {
                                listener.onSessionToken2Created(token, controller.getSessionToken2());
                                listener.notify();
                            }
                        }
                    };
                    controller.registerCallback(callback);
                    if (controller.isSessionReady()) {
                        listener.onSessionToken2Created(token, controller.getSessionToken2());
                    }
                    OnSessionToken2CreatedListener onSessionToken2CreatedListener = listener;
                    synchronized (onSessionToken2CreatedListener) {
                        listener.wait(300L);
                        if (!controller.isSessionReady()) {
                            SessionToken2 token2 = new SessionToken2(new SessionToken2ImplLegacy(token));
                            token.setSessionToken2(token2);
                            listener.onSessionToken2Created(token, token2);
                        }
                    }
                }
                catch (RemoteException e) {
                    Log.e((String)SessionToken2.TAG, (String)"Failed to create session token2.", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Log.e((String)SessionToken2.TAG, (String)"Failed to create session token2.", (Throwable)e);
                }
            }
        });
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static String getSessionId(ResolveInfo resolveInfo) {
        if (resolveInfo == null || resolveInfo.serviceInfo == null) {
            return null;
        }
        if (resolveInfo.serviceInfo.metaData == null) {
            return "";
        }
        return resolveInfo.serviceInfo.metaData.getString("android.media.session", "");
    }

    private static String getSessionIdFromService(PackageManager manager, String serviceInterface, ComponentName serviceComponent) {
        Intent serviceIntent = new Intent(serviceInterface);
        serviceIntent.setPackage(serviceComponent.getPackageName());
        List list = manager.queryIntentServices(serviceIntent, 128);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ResolveInfo resolveInfo = (ResolveInfo)list.get(i);
                if (resolveInfo == null || resolveInfo.serviceInfo == null || !TextUtils.equals((CharSequence)resolveInfo.serviceInfo.name, (CharSequence)serviceComponent.getClassName())) continue;
                return SessionToken2.getSessionId(resolveInfo);
            }
        }
        return null;
    }

    static interface SupportLibraryImpl {
        public int getUid();

        @NonNull
        public String getPackageName();

        @Nullable
        public String getServiceName();

        @Nullable
        public ComponentName getComponentName();

        public String getSessionId();

        public int getType();

        public Bundle toBundle();

        public Object getBinder();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface OnSessionToken2CreatedListener {
        public void onSessionToken2Created(MediaSessionCompat.Token var1, SessionToken2 var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface TokenType {
    }
}

