/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media.subtitle;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.v4.media.subtitle.Cea708CCParser;
import android.support.v4.media.subtitle.ClosedCaptionWidget;
import android.support.v4.media.subtitle.SubtitleController;
import android.support.v4.media.subtitle.SubtitleTrack;
import android.support.v4.media.subtitle.SubtitleView;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.CharacterStyle;
import android.text.style.RelativeSizeSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.UnderlineSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.CaptioningManager;
import android.widget.RelativeLayout;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

@RequiresApi(value=28)
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class Cea708CaptionRenderer
extends SubtitleController.Renderer {
    private final Context mContext;
    private Cea708CCWidget mCCWidget;

    public Cea708CaptionRenderer(Context context) {
        this.mContext = context;
    }

    @Override
    public boolean supports(MediaFormat format) {
        if (format.containsKey("mime")) {
            String mimeType = format.getString("mime");
            return "text/cea-708".equals(mimeType);
        }
        return false;
    }

    @Override
    public SubtitleTrack createTrack(MediaFormat format) {
        String mimeType = format.getString("mime");
        if ("text/cea-708".equals(mimeType)) {
            if (this.mCCWidget == null) {
                this.mCCWidget = new Cea708CCWidget(this.mContext);
            }
            return new Cea708CaptionTrack(this.mCCWidget, format);
        }
        throw new RuntimeException("No matching format: " + format.toString());
    }

    class Cea708CCWidget
    extends ClosedCaptionWidget
    implements Cea708CCParser.DisplayListener {
        private final CCHandler mCCHandler;

        Cea708CCWidget(Context context) {
            this(context, null);
        }

        Cea708CCWidget(Context context, AttributeSet attrs) {
            this(context, attrs, 0);
        }

        Cea708CCWidget(Context context, AttributeSet attrs, int defStyleAttr) {
            this(context, attrs, defStyleAttr, 0);
        }

        Cea708CCWidget(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            super(context, attrs, defStyleAttr, defStyleRes);
            this.mCCHandler = new CCHandler((CCLayout)this.mClosedCaptionLayout);
        }

        @Override
        public ClosedCaptionWidget.ClosedCaptionLayout createCaptionLayout(Context context) {
            return new CCLayout(context);
        }

        @Override
        public void emitEvent(Cea708CCParser.CaptionEvent event) {
            this.mCCHandler.processCaptionEvent(event);
            this.setSize(this.getWidth(), this.getHeight());
            if (this.mListener != null) {
                this.mListener.onChanged(this);
            }
        }

        public void onDraw(Canvas canvas) {
            super.onDraw(canvas);
            ((ViewGroup)this.mClosedCaptionLayout).draw(canvas);
        }

        class CCView
        extends SubtitleView {
            CCView(Context context) {
                this(context, null);
            }

            CCView(Context context, AttributeSet attrs) {
                this(context, attrs, 0);
            }

            CCView(Context context, AttributeSet attrs, int defStyleAttr) {
                this(context, attrs, defStyleAttr, 0);
            }

            CCView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
                super(context, attrs, defStyleAttr, defStyleRes);
            }

            void setCaptionStyle(CaptioningManager.CaptionStyle style) {
                if (style.hasForegroundColor()) {
                    this.setForegroundColor(style.foregroundColor);
                }
                if (style.hasBackgroundColor()) {
                    this.setBackgroundColor(style.backgroundColor);
                }
                if (style.hasEdgeType()) {
                    this.setEdgeType(style.edgeType);
                }
                if (style.hasEdgeColor()) {
                    this.setEdgeColor(style.edgeColor);
                }
                this.setTypeface(style.getTypeface());
            }
        }

        private class CCWindowLayout
        extends RelativeLayout
        implements View.OnLayoutChangeListener {
            private static final String TAG = "CCWindowLayout";
            private static final float PROPORTION_PEN_SIZE_SMALL = 0.75f;
            private static final float PROPORTION_PEN_SIZE_LARGE = 1.25f;
            private static final int ANCHOR_RELATIVE_POSITIONING_MAX = 99;
            private static final int ANCHOR_VERTICAL_MAX = 74;
            private static final int ANCHOR_HORIZONTAL_16_9_MAX = 209;
            private static final int MAX_COLUMN_COUNT_16_9 = 42;
            private static final int ANCHOR_MODE_DIVIDER = 3;
            private static final int ANCHOR_HORIZONTAL_MODE_LEFT = 0;
            private static final int ANCHOR_HORIZONTAL_MODE_CENTER = 1;
            private static final int ANCHOR_HORIZONTAL_MODE_RIGHT = 2;
            private static final int ANCHOR_VERTICAL_MODE_TOP = 0;
            private static final int ANCHOR_VERTICAL_MODE_CENTER = 1;
            private static final int ANCHOR_VERTICAL_MODE_BOTTOM = 2;
            private CCLayout mCCLayout;
            private CCView mCCView;
            private CaptioningManager.CaptionStyle mCaptionStyle;
            private int mRowLimit;
            private final SpannableStringBuilder mBuilder;
            private final List<CharacterStyle> mCharacterStyles;
            private int mCaptionWindowId;
            private int mRow;
            private float mFontScale;
            private float mTextSize;
            private String mWidestChar;
            private int mLastCaptionLayoutWidth;
            private int mLastCaptionLayoutHeight;

            CCWindowLayout(Context context) {
                this(context, null);
            }

            CCWindowLayout(Context context, AttributeSet attrs) {
                this(context, attrs, 0);
            }

            CCWindowLayout(Context context, AttributeSet attrs, int defStyleAttr) {
                this(context, attrs, defStyleAttr, 0);
            }

            CCWindowLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
                super(context, attrs, defStyleAttr, defStyleRes);
                this.mRowLimit = 0;
                this.mBuilder = new SpannableStringBuilder();
                this.mCharacterStyles = new ArrayList<CharacterStyle>();
                this.mRow = -1;
                this.mCCView = new CCView(context);
                RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
                this.addView(this.mCCView, (ViewGroup.LayoutParams)params);
                CaptioningManager captioningManager = (CaptioningManager)context.getSystemService("captioning");
                this.mFontScale = captioningManager.getFontScale();
                this.setCaptionStyle(captioningManager.getUserStyle());
                this.mCCView.setText("");
                this.updateWidestChar();
            }

            public void setCaptionStyle(CaptioningManager.CaptionStyle style) {
                this.mCaptionStyle = style;
                this.mCCView.setCaptionStyle(style);
            }

            public void setFontScale(float fontScale) {
                this.mFontScale = fontScale;
                this.updateTextSize();
            }

            public int getCaptionWindowId() {
                return this.mCaptionWindowId;
            }

            public void setCaptionWindowId(int captionWindowId) {
                this.mCaptionWindowId = captionWindowId;
            }

            public void clear() {
                this.clearText();
                this.hide();
            }

            public void show() {
                this.setVisibility(0);
                this.requestLayout();
            }

            public void hide() {
                this.setVisibility(4);
                this.requestLayout();
            }

            public void setPenAttr(Cea708CCParser.CaptionPenAttr penAttr) {
                this.mCharacterStyles.clear();
                if (penAttr.italic) {
                    this.mCharacterStyles.add((CharacterStyle)new StyleSpan(2));
                }
                if (penAttr.underline) {
                    this.mCharacterStyles.add((CharacterStyle)new UnderlineSpan());
                }
                switch (penAttr.penSize) {
                    case 0: {
                        this.mCharacterStyles.add((CharacterStyle)new RelativeSizeSpan(0.75f));
                        break;
                    }
                    case 2: {
                        this.mCharacterStyles.add((CharacterStyle)new RelativeSizeSpan(1.25f));
                    }
                }
                switch (penAttr.penOffset) {
                    case 0: {
                        this.mCharacterStyles.add((CharacterStyle)new SubscriptSpan());
                        break;
                    }
                    case 2: {
                        this.mCharacterStyles.add((CharacterStyle)new SuperscriptSpan());
                    }
                }
            }

            public void setPenColor(Cea708CCParser.CaptionPenColor penColor) {
            }

            public void setPenLocation(int row, int column) {
                if (this.mRow >= 0) {
                    for (int r = this.mRow; r < row; ++r) {
                        this.appendText("\n");
                    }
                }
                this.mRow = row;
            }

            public void setWindowAttr(Cea708CCParser.CaptionWindowAttr windowAttr) {
            }

            public void sendBuffer(String buffer) {
                this.appendText(buffer);
            }

            public void sendControl(char control) {
            }

            public void initWindow(CCLayout ccLayout, Cea708CCParser.CaptionWindow captionWindow) {
                float gap;
                if (this.mCCLayout != ccLayout) {
                    if (this.mCCLayout != null) {
                        this.mCCLayout.removeOnLayoutChangeListener(this);
                    }
                    this.mCCLayout = ccLayout;
                    this.mCCLayout.addOnLayoutChangeListener(this);
                    this.updateWidestChar();
                }
                float scaleRow = (float)captionWindow.anchorVertical / (float)(captionWindow.relativePositioning ? 99 : 74);
                float scaleCol = (float)captionWindow.anchorHorizontal / (float)(captionWindow.relativePositioning ? 99 : 209);
                if (scaleRow < 0.0f || scaleRow > 1.0f) {
                    Log.i((String)TAG, (String)("The vertical position of the anchor point should be at the range of 0 and 1 but " + scaleRow));
                    scaleRow = Math.max(0.0f, Math.min(scaleRow, 1.0f));
                }
                if (scaleCol < 0.0f || scaleCol > 1.0f) {
                    Log.i((String)TAG, (String)("The horizontal position of the anchor point should be at the range of 0 and 1 but " + scaleCol));
                    scaleCol = Math.max(0.0f, Math.min(scaleCol, 1.0f));
                }
                int gravity = 17;
                int horizontalMode = captionWindow.anchorId % 3;
                int verticalMode = captionWindow.anchorId / 3;
                float scaleStartRow = 0.0f;
                float scaleEndRow = 1.0f;
                float scaleStartCol = 0.0f;
                float scaleEndCol = 1.0f;
                switch (horizontalMode) {
                    case 0: {
                        gravity = 3;
                        this.mCCView.setAlignment(Layout.Alignment.ALIGN_NORMAL);
                        scaleStartCol = scaleCol;
                        break;
                    }
                    case 1: {
                        float halfMaxWidthScale;
                        gap = Math.min(1.0f - scaleCol, scaleCol);
                        int columnCount = captionWindow.columnCount + 1;
                        columnCount = Math.min(this.getScreenColumnCount(), columnCount);
                        StringBuilder widestTextBuilder = new StringBuilder();
                        for (int i = 0; i < columnCount; ++i) {
                            widestTextBuilder.append(this.mWidestChar);
                        }
                        Paint paint = new Paint();
                        paint.setTypeface(this.mCaptionStyle.getTypeface());
                        paint.setTextSize(this.mTextSize);
                        float maxWindowWidth = paint.measureText(widestTextBuilder.toString());
                        float f = halfMaxWidthScale = this.mCCLayout.getWidth() > 0 ? maxWindowWidth / 2.0f / ((float)this.mCCLayout.getWidth() * 0.8f) : 0.0f;
                        if (halfMaxWidthScale > 0.0f && halfMaxWidthScale < scaleCol) {
                            gravity = 3;
                            this.mCCView.setAlignment(Layout.Alignment.ALIGN_NORMAL);
                            scaleStartCol = scaleCol - halfMaxWidthScale;
                            scaleEndCol = 1.0f;
                            break;
                        }
                        gravity = 1;
                        this.mCCView.setAlignment(Layout.Alignment.ALIGN_CENTER);
                        scaleStartCol = scaleCol - gap;
                        scaleEndCol = scaleCol + gap;
                        break;
                    }
                    case 2: {
                        gravity = 5;
                        scaleEndCol = scaleCol;
                    }
                }
                switch (verticalMode) {
                    case 0: {
                        gravity |= 0x30;
                        scaleStartRow = scaleRow;
                        break;
                    }
                    case 1: {
                        gravity |= 0x10;
                        gap = Math.min(1.0f - scaleRow, scaleRow);
                        scaleStartRow = scaleRow - gap;
                        scaleEndRow = scaleRow + gap;
                        break;
                    }
                    case 2: {
                        gravity |= 0x50;
                        scaleEndRow = scaleRow;
                    }
                }
                CCLayout cCLayout = this.mCCLayout;
                cCLayout.getClass();
                this.mCCLayout.addOrUpdateViewToSafeTitleArea(this, cCLayout.new ScaledLayout.ScaledLayoutParams(scaleStartRow, scaleEndRow, scaleStartCol, scaleEndCol));
                this.setCaptionWindowId(captionWindow.id);
                this.setRowLimit(captionWindow.rowCount);
                this.setGravity(gravity);
                if (captionWindow.visible) {
                    this.show();
                } else {
                    this.hide();
                }
            }

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                int width = right - left;
                int height = bottom - top;
                if (width != this.mLastCaptionLayoutWidth || height != this.mLastCaptionLayoutHeight) {
                    this.mLastCaptionLayoutWidth = width;
                    this.mLastCaptionLayoutHeight = height;
                    this.updateTextSize();
                }
            }

            private void updateWidestChar() {
                Paint paint = new Paint();
                paint.setTypeface(this.mCaptionStyle.getTypeface());
                Charset latin1 = Charset.forName("ISO-8859-1");
                float widestCharWidth = 0.0f;
                for (int i = 0; i < 256; ++i) {
                    byte[] byArray = new byte[]{(byte)i};
                    String ch = new String(byArray, latin1);
                    float charWidth = paint.measureText(ch);
                    if (!(widestCharWidth < charWidth)) continue;
                    widestCharWidth = charWidth;
                    this.mWidestChar = ch;
                }
                this.updateTextSize();
            }

            private void updateTextSize() {
                if (this.mCCLayout == null) {
                    return;
                }
                StringBuilder widestTextBuilder = new StringBuilder();
                int screenColumnCount = this.getScreenColumnCount();
                for (int i = 0; i < screenColumnCount; ++i) {
                    widestTextBuilder.append(this.mWidestChar);
                }
                String widestText = widestTextBuilder.toString();
                Paint paint = new Paint();
                paint.setTypeface(this.mCaptionStyle.getTypeface());
                float startFontSize = 0.0f;
                float endFontSize = 255.0f;
                while (startFontSize < endFontSize) {
                    float testTextSize = (startFontSize + endFontSize) / 2.0f;
                    paint.setTextSize(testTextSize);
                    float width = paint.measureText(widestText);
                    if ((float)this.mCCLayout.getWidth() * 0.8f > width) {
                        startFontSize = testTextSize + 0.01f;
                        continue;
                    }
                    endFontSize = testTextSize - 0.01f;
                }
                this.mTextSize = endFontSize * this.mFontScale;
                this.mCCView.setTextSize(this.mTextSize);
            }

            private int getScreenColumnCount() {
                return 42;
            }

            public void removeFromCaptionView() {
                if (this.mCCLayout != null) {
                    this.mCCLayout.removeViewFromSafeTitleArea(this);
                    this.mCCLayout.removeOnLayoutChangeListener(this);
                    this.mCCLayout = null;
                }
            }

            public void setText(String text) {
                this.updateText(text, false);
            }

            public void appendText(String text) {
                this.updateText(text, true);
            }

            public void clearText() {
                this.mBuilder.clear();
                this.mCCView.setText("");
            }

            private void updateText(String text, boolean appended) {
                int start;
                int last;
                if (!appended) {
                    this.mBuilder.clear();
                }
                if (text != null && text.length() > 0) {
                    int length = this.mBuilder.length();
                    this.mBuilder.append((CharSequence)text);
                    for (CharacterStyle characterStyle : this.mCharacterStyles) {
                        this.mBuilder.setSpan((Object)characterStyle, length, this.mBuilder.length(), 33);
                    }
                }
                String[] lines = TextUtils.split((String)this.mBuilder.toString(), (String)"\n");
                String truncatedText = TextUtils.join((CharSequence)"\n", (Object[])Arrays.copyOfRange(lines, Math.max(0, lines.length - (this.mRowLimit + 1)), lines.length));
                this.mBuilder.delete(0, this.mBuilder.length() - truncatedText.length());
                int end = last = this.mBuilder.length() - 1;
                for (start = 0; start <= end && this.mBuilder.charAt(start) <= ' '; ++start) {
                }
                while (end >= start && this.mBuilder.charAt(end) <= ' ') {
                    --end;
                }
                if (start == 0 && end == last) {
                    this.mCCView.setText((CharSequence)this.mBuilder);
                } else {
                    SpannableStringBuilder trim = new SpannableStringBuilder();
                    trim.append((CharSequence)this.mBuilder);
                    if (end < last) {
                        trim.delete(end + 1, last + 1);
                    }
                    if (start > 0) {
                        trim.delete(0, start);
                    }
                    this.mCCView.setText((CharSequence)trim);
                }
            }

            public void setRowLimit(int rowLimit) {
                if (rowLimit < 0) {
                    throw new IllegalArgumentException("A rowLimit should have a positive number");
                }
                this.mRowLimit = rowLimit;
            }
        }

        class CCHandler
        implements Handler.Callback {
            private static final String TAG = "CCHandler";
            private static final boolean DEBUG = false;
            private static final int TENTHS_OF_SECOND_IN_MILLIS = 100;
            private static final int CAPTION_WINDOWS_MAX = 8;
            private static final int CAPTION_ALL_WINDOWS_BITMAP = 255;
            private static final int MSG_DELAY_CANCEL = 1;
            private static final int MSG_CAPTION_CLEAR = 2;
            private static final long CAPTION_CLEAR_INTERVAL_MS = 60000L;
            private final CCLayout mCCLayout;
            private boolean mIsDelayed = false;
            private CCWindowLayout mCurrentWindowLayout;
            private final CCWindowLayout[] mCaptionWindowLayouts = new CCWindowLayout[8];
            private final ArrayList<Cea708CCParser.CaptionEvent> mPendingCaptionEvents = new ArrayList();
            private final Handler mHandler;

            CCHandler(CCLayout ccLayout) {
                this.mCCLayout = ccLayout;
                this.mHandler = new Handler((Handler.Callback)this);
            }

            public boolean handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        this.delayCancel();
                        return true;
                    }
                    case 2: {
                        this.clearWindows(255);
                        return true;
                    }
                }
                return false;
            }

            public void processCaptionEvent(Cea708CCParser.CaptionEvent event) {
                if (this.mIsDelayed) {
                    this.mPendingCaptionEvents.add(event);
                    return;
                }
                switch (event.type) {
                    case 1: {
                        this.sendBufferToCurrentWindow((String)event.obj);
                        break;
                    }
                    case 2: {
                        this.sendControlToCurrentWindow(((Character)event.obj).charValue());
                        break;
                    }
                    case 3: {
                        this.setCurrentWindowLayout((Integer)event.obj);
                        break;
                    }
                    case 4: {
                        this.clearWindows((Integer)event.obj);
                        break;
                    }
                    case 5: {
                        this.displayWindows((Integer)event.obj);
                        break;
                    }
                    case 6: {
                        this.hideWindows((Integer)event.obj);
                        break;
                    }
                    case 7: {
                        this.toggleWindows((Integer)event.obj);
                        break;
                    }
                    case 8: {
                        this.deleteWindows((Integer)event.obj);
                        break;
                    }
                    case 9: {
                        this.delay((Integer)event.obj);
                        break;
                    }
                    case 10: {
                        this.delayCancel();
                        break;
                    }
                    case 11: {
                        this.reset();
                        break;
                    }
                    case 12: {
                        this.setPenAttr((Cea708CCParser.CaptionPenAttr)event.obj);
                        break;
                    }
                    case 13: {
                        this.setPenColor((Cea708CCParser.CaptionPenColor)event.obj);
                        break;
                    }
                    case 14: {
                        this.setPenLocation((Cea708CCParser.CaptionPenLocation)event.obj);
                        break;
                    }
                    case 15: {
                        this.setWindowAttr((Cea708CCParser.CaptionWindowAttr)event.obj);
                        break;
                    }
                    case 16: {
                        this.defineWindow((Cea708CCParser.CaptionWindow)event.obj);
                    }
                }
            }

            private void setCurrentWindowLayout(int windowId) {
                if (windowId < 0 || windowId >= this.mCaptionWindowLayouts.length) {
                    return;
                }
                CCWindowLayout windowLayout = this.mCaptionWindowLayouts[windowId];
                if (windowLayout == null) {
                    return;
                }
                this.mCurrentWindowLayout = windowLayout;
            }

            private ArrayList<CCWindowLayout> getWindowsFromBitmap(int windowBitmap) {
                ArrayList<CCWindowLayout> windows = new ArrayList<CCWindowLayout>();
                for (int i = 0; i < 8; ++i) {
                    CCWindowLayout windowLayout;
                    if ((windowBitmap & 1 << i) == 0 || (windowLayout = this.mCaptionWindowLayouts[i]) == null) continue;
                    windows.add(windowLayout);
                }
                return windows;
            }

            private void clearWindows(int windowBitmap) {
                if (windowBitmap == 0) {
                    return;
                }
                for (CCWindowLayout windowLayout : this.getWindowsFromBitmap(windowBitmap)) {
                    windowLayout.clear();
                }
            }

            private void displayWindows(int windowBitmap) {
                if (windowBitmap == 0) {
                    return;
                }
                for (CCWindowLayout windowLayout : this.getWindowsFromBitmap(windowBitmap)) {
                    windowLayout.show();
                }
            }

            private void hideWindows(int windowBitmap) {
                if (windowBitmap == 0) {
                    return;
                }
                for (CCWindowLayout windowLayout : this.getWindowsFromBitmap(windowBitmap)) {
                    windowLayout.hide();
                }
            }

            private void toggleWindows(int windowBitmap) {
                if (windowBitmap == 0) {
                    return;
                }
                for (CCWindowLayout windowLayout : this.getWindowsFromBitmap(windowBitmap)) {
                    if (windowLayout.isShown()) {
                        windowLayout.hide();
                        continue;
                    }
                    windowLayout.show();
                }
            }

            private void deleteWindows(int windowBitmap) {
                if (windowBitmap == 0) {
                    return;
                }
                for (CCWindowLayout windowLayout : this.getWindowsFromBitmap(windowBitmap)) {
                    windowLayout.removeFromCaptionView();
                    this.mCaptionWindowLayouts[windowLayout.getCaptionWindowId()] = null;
                }
            }

            public void reset() {
                this.mCurrentWindowLayout = null;
                this.mIsDelayed = false;
                this.mPendingCaptionEvents.clear();
                for (int i = 0; i < 8; ++i) {
                    if (this.mCaptionWindowLayouts[i] != null) {
                        this.mCaptionWindowLayouts[i].removeFromCaptionView();
                    }
                    this.mCaptionWindowLayouts[i] = null;
                }
                this.mCCLayout.setVisibility(4);
                this.mHandler.removeMessages(2);
            }

            private void setWindowAttr(Cea708CCParser.CaptionWindowAttr windowAttr) {
                if (this.mCurrentWindowLayout != null) {
                    this.mCurrentWindowLayout.setWindowAttr(windowAttr);
                }
            }

            private void defineWindow(Cea708CCParser.CaptionWindow window) {
                if (window == null) {
                    return;
                }
                int windowId = window.id;
                if (windowId < 0 || windowId >= this.mCaptionWindowLayouts.length) {
                    return;
                }
                CCWindowLayout windowLayout = this.mCaptionWindowLayouts[windowId];
                if (windowLayout == null) {
                    windowLayout = new CCWindowLayout(this.mCCLayout.getContext());
                }
                windowLayout.initWindow(this.mCCLayout, window);
                this.mCurrentWindowLayout = this.mCaptionWindowLayouts[windowId] = windowLayout;
            }

            private void delay(int tenthsOfSeconds) {
                if (tenthsOfSeconds < 0 || tenthsOfSeconds > 255) {
                    return;
                }
                this.mIsDelayed = true;
                this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1), (long)(tenthsOfSeconds * 100));
            }

            private void delayCancel() {
                this.mIsDelayed = false;
                this.processPendingBuffer();
            }

            private void processPendingBuffer() {
                for (Cea708CCParser.CaptionEvent event : this.mPendingCaptionEvents) {
                    this.processCaptionEvent(event);
                }
                this.mPendingCaptionEvents.clear();
            }

            private void sendControlToCurrentWindow(char control) {
                if (this.mCurrentWindowLayout != null) {
                    this.mCurrentWindowLayout.sendControl(control);
                }
            }

            private void sendBufferToCurrentWindow(String buffer) {
                if (this.mCurrentWindowLayout != null) {
                    this.mCurrentWindowLayout.sendBuffer(buffer);
                    this.mHandler.removeMessages(2);
                    this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(2), 60000L);
                }
            }

            private void setPenAttr(Cea708CCParser.CaptionPenAttr attr) {
                if (this.mCurrentWindowLayout != null) {
                    this.mCurrentWindowLayout.setPenAttr(attr);
                }
            }

            private void setPenColor(Cea708CCParser.CaptionPenColor color2) {
                if (this.mCurrentWindowLayout != null) {
                    this.mCurrentWindowLayout.setPenColor(color2);
                }
            }

            private void setPenLocation(Cea708CCParser.CaptionPenLocation location) {
                if (this.mCurrentWindowLayout != null) {
                    this.mCurrentWindowLayout.setPenLocation(location.row, location.column);
                }
            }
        }

        class CCLayout
        extends ScaledLayout
        implements ClosedCaptionWidget.ClosedCaptionLayout {
            private static final float SAFE_TITLE_AREA_SCALE_START_X = 0.1f;
            private static final float SAFE_TITLE_AREA_SCALE_END_X = 0.9f;
            private static final float SAFE_TITLE_AREA_SCALE_START_Y = 0.1f;
            private static final float SAFE_TITLE_AREA_SCALE_END_Y = 0.9f;
            private final ScaledLayout mSafeTitleAreaLayout;

            CCLayout(Context context) {
                super(context);
                this.mSafeTitleAreaLayout = new ScaledLayout(context);
                this.addView((View)this.mSafeTitleAreaLayout, new ScaledLayout.ScaledLayoutParams(0.1f, 0.9f, 0.1f, 0.9f));
            }

            public void addOrUpdateViewToSafeTitleArea(CCWindowLayout captionWindowLayout, ScaledLayout.ScaledLayoutParams scaledLayoutParams) {
                int index = this.mSafeTitleAreaLayout.indexOfChild((View)captionWindowLayout);
                if (index < 0) {
                    this.mSafeTitleAreaLayout.addView((View)captionWindowLayout, scaledLayoutParams);
                    return;
                }
                this.mSafeTitleAreaLayout.updateViewLayout((View)captionWindowLayout, scaledLayoutParams);
            }

            public void removeViewFromSafeTitleArea(CCWindowLayout captionWindowLayout) {
                this.mSafeTitleAreaLayout.removeView((View)captionWindowLayout);
            }

            @Override
            public void setCaptionStyle(CaptioningManager.CaptionStyle style) {
                int count = this.mSafeTitleAreaLayout.getChildCount();
                for (int i = 0; i < count; ++i) {
                    CCWindowLayout windowLayout = (CCWindowLayout)this.mSafeTitleAreaLayout.getChildAt(i);
                    windowLayout.setCaptionStyle(style);
                }
            }

            @Override
            public void setFontScale(float fontScale) {
                int count = this.mSafeTitleAreaLayout.getChildCount();
                for (int i = 0; i < count; ++i) {
                    CCWindowLayout windowLayout = (CCWindowLayout)this.mSafeTitleAreaLayout.getChildAt(i);
                    windowLayout.setFontScale(fontScale);
                }
            }
        }

        class ScaledLayout
        extends ViewGroup {
            private static final String TAG = "ScaledLayout";
            private static final boolean DEBUG = false;
            private final Comparator<Rect> mRectTopLeftSorter;
            private Rect[] mRectArray;

            ScaledLayout(Context context) {
                super(context);
                this.mRectTopLeftSorter = new Comparator<Rect>(){

                    @Override
                    public int compare(Rect lhs, Rect rhs) {
                        if (lhs.top != rhs.top) {
                            return lhs.top - rhs.top;
                        }
                        return lhs.left - rhs.left;
                    }
                };
            }

            public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
                return new ScaledLayoutParams(this.getContext(), attrs);
            }

            protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
                return p instanceof ScaledLayoutParams;
            }

            protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                int i;
                int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
                int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
                int width = widthSpecSize - this.getPaddingLeft() - this.getPaddingRight();
                int height = heightSpecSize - this.getPaddingTop() - this.getPaddingBottom();
                int count = this.getChildCount();
                this.mRectArray = new Rect[count];
                for (int i2 = 0; i2 < count; ++i2) {
                    View child = this.getChildAt(i2);
                    ViewGroup.LayoutParams params = child.getLayoutParams();
                    if (!(params instanceof ScaledLayoutParams)) {
                        throw new RuntimeException("A child of ScaledLayout cannot have the UNSPECIFIED scale factors");
                    }
                    float scaleStartRow = ((ScaledLayoutParams)params).scaleStartRow;
                    float scaleEndRow = ((ScaledLayoutParams)params).scaleEndRow;
                    float scaleStartCol = ((ScaledLayoutParams)params).scaleStartCol;
                    float scaleEndCol = ((ScaledLayoutParams)params).scaleEndCol;
                    if (scaleStartRow < 0.0f || scaleStartRow > 1.0f) {
                        throw new RuntimeException("A child of ScaledLayout should have a range of scaleStartRow between 0 and 1");
                    }
                    if (scaleEndRow < scaleStartRow || scaleStartRow > 1.0f) {
                        throw new RuntimeException("A child of ScaledLayout should have a range of scaleEndRow between scaleStartRow and 1");
                    }
                    if (scaleEndCol < 0.0f || scaleEndCol > 1.0f) {
                        throw new RuntimeException("A child of ScaledLayout should have a range of scaleStartCol between 0 and 1");
                    }
                    if (scaleEndCol < scaleStartCol || scaleEndCol > 1.0f) {
                        throw new RuntimeException("A child of ScaledLayout should have a range of scaleEndCol between scaleStartCol and 1");
                    }
                    this.mRectArray[i2] = new Rect((int)(scaleStartCol * (float)width), (int)(scaleStartRow * (float)height), (int)(scaleEndCol * (float)width), (int)(scaleEndRow * (float)height));
                    int childWidthSpec = View.MeasureSpec.makeMeasureSpec((int)((int)((float)width * (scaleEndCol - scaleStartCol))), (int)0x40000000);
                    int childHeightSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                    child.measure(childWidthSpec, childHeightSpec);
                    if (child.getMeasuredHeight() > this.mRectArray[i2].height()) {
                        int overflowedHeight = child.getMeasuredHeight() - this.mRectArray[i2].height();
                        overflowedHeight = (overflowedHeight + 1) / 2;
                        this.mRectArray[i2].bottom += overflowedHeight;
                        this.mRectArray[i2].top -= overflowedHeight;
                        if (this.mRectArray[i2].top < 0) {
                            this.mRectArray[i2].bottom -= this.mRectArray[i2].top;
                            this.mRectArray[i2].top = 0;
                        }
                        if (this.mRectArray[i2].bottom > height) {
                            this.mRectArray[i2].top -= this.mRectArray[i2].bottom - height;
                            this.mRectArray[i2].bottom = height;
                        }
                    }
                    childHeightSpec = View.MeasureSpec.makeMeasureSpec((int)((int)((float)height * (scaleEndRow - scaleStartRow))), (int)0x40000000);
                    child.measure(childWidthSpec, childHeightSpec);
                }
                int visibleRectCount = 0;
                int[] visibleRectGroup = new int[count];
                Rect[] visibleRectArray = new Rect[count];
                for (i = 0; i < count; ++i) {
                    if (this.getChildAt(i).getVisibility() != 0) continue;
                    visibleRectGroup[visibleRectCount] = visibleRectCount;
                    visibleRectArray[visibleRectCount] = this.mRectArray[i];
                    ++visibleRectCount;
                }
                Arrays.sort(visibleRectArray, 0, visibleRectCount, this.mRectTopLeftSorter);
                for (i = 0; i < visibleRectCount - 1; ++i) {
                    for (int j = i + 1; j < visibleRectCount; ++j) {
                        if (!Rect.intersects((Rect)visibleRectArray[i], (Rect)visibleRectArray[j])) continue;
                        visibleRectGroup[j] = visibleRectGroup[i];
                        visibleRectArray[j].set(visibleRectArray[j].left, visibleRectArray[i].bottom, visibleRectArray[j].right, visibleRectArray[i].bottom + visibleRectArray[j].height());
                    }
                }
                for (i = visibleRectCount - 1; i >= 0; --i) {
                    if (visibleRectArray[i].bottom <= height) continue;
                    int overflowedHeight = visibleRectArray[i].bottom - height;
                    for (int j = 0; j <= i; ++j) {
                        if (visibleRectGroup[i] != visibleRectGroup[j]) continue;
                        visibleRectArray[j].set(visibleRectArray[j].left, visibleRectArray[j].top - overflowedHeight, visibleRectArray[j].right, visibleRectArray[j].bottom - overflowedHeight);
                    }
                }
                this.setMeasuredDimension(widthSpecSize, heightSpecSize);
            }

            protected void onLayout(boolean changed, int l, int t, int r, int b) {
                int paddingLeft = this.getPaddingLeft();
                int paddingTop = this.getPaddingTop();
                int count = this.getChildCount();
                for (int i = 0; i < count; ++i) {
                    View child = this.getChildAt(i);
                    if (child.getVisibility() == 8) continue;
                    int childLeft = paddingLeft + this.mRectArray[i].left;
                    int childTop = paddingTop + this.mRectArray[i].top;
                    int childBottom = paddingLeft + this.mRectArray[i].bottom;
                    int childRight = paddingTop + this.mRectArray[i].right;
                    child.layout(childLeft, childTop, childRight, childBottom);
                }
            }

            public void dispatchDraw(Canvas canvas) {
                int paddingLeft = this.getPaddingLeft();
                int paddingTop = this.getPaddingTop();
                int count = this.getChildCount();
                for (int i = 0; i < count; ++i) {
                    View child = this.getChildAt(i);
                    if (child.getVisibility() == 8) continue;
                    if (i >= this.mRectArray.length) break;
                    int childLeft = paddingLeft + this.mRectArray[i].left;
                    int childTop = paddingTop + this.mRectArray[i].top;
                    int saveCount = canvas.save();
                    canvas.translate((float)childLeft, (float)childTop);
                    child.draw(canvas);
                    canvas.restoreToCount(saveCount);
                }
            }

            class ScaledLayoutParams
            extends ViewGroup.LayoutParams {
                public static final float SCALE_UNSPECIFIED = -1.0f;
                public float scaleStartRow;
                public float scaleEndRow;
                public float scaleStartCol;
                public float scaleEndCol;

                ScaledLayoutParams(float scaleStartRow, float scaleEndRow, float scaleStartCol, float scaleEndCol) {
                    super(-1, -1);
                    this.scaleStartRow = scaleStartRow;
                    this.scaleEndRow = scaleEndRow;
                    this.scaleStartCol = scaleStartCol;
                    this.scaleEndCol = scaleEndCol;
                }

                ScaledLayoutParams(Context context, AttributeSet attrs) {
                    super(-1, -1);
                }
            }
        }
    }

    static class Cea708CaptionTrack
    extends SubtitleTrack {
        private final Cea708CCParser mCCParser;
        private final Cea708CCWidget mRenderingWidget;

        Cea708CaptionTrack(Cea708CCWidget renderingWidget, MediaFormat format) {
            super(format);
            this.mRenderingWidget = renderingWidget;
            this.mCCParser = new Cea708CCParser(this.mRenderingWidget);
        }

        @Override
        public void onData(byte[] data, boolean eos, long runID) {
            this.mCCParser.parse(data);
        }

        @Override
        public SubtitleTrack.RenderingWidget getRenderingWidget() {
            return this.mRenderingWidget;
        }

        @Override
        public void updateView(ArrayList<SubtitleTrack.Cue> activeCues) {
        }
    }
}

