/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media.subtitle;

import android.content.Context;
import android.support.annotation.RequiresApi;
import android.support.v4.media.subtitle.SubtitleTrack;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.CaptioningManager;

@RequiresApi(value=28)
abstract class ClosedCaptionWidget
extends ViewGroup
implements SubtitleTrack.RenderingWidget {
    private final CaptioningManager mManager;
    protected CaptioningManager.CaptionStyle mCaptionStyle;
    protected SubtitleTrack.RenderingWidget.OnChangedListener mListener;
    protected ClosedCaptionLayout mClosedCaptionLayout;
    private boolean mHasChangeListener;
    private final CaptioningManager.CaptioningChangeListener mCaptioningListener = new CaptioningManager.CaptioningChangeListener(){

        public void onUserStyleChanged(CaptioningManager.CaptionStyle userStyle) {
            ClosedCaptionWidget.this.mCaptionStyle = userStyle;
            ClosedCaptionWidget.this.mClosedCaptionLayout.setCaptionStyle(ClosedCaptionWidget.this.mCaptionStyle);
        }

        public void onFontScaleChanged(float fontScale) {
            ClosedCaptionWidget.this.mClosedCaptionLayout.setFontScale(fontScale);
        }
    };

    ClosedCaptionWidget(Context context) {
        this(context, null);
    }

    ClosedCaptionWidget(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    ClosedCaptionWidget(Context context, AttributeSet attrs, int defStyle) {
        this(context, attrs, defStyle, 0);
    }

    ClosedCaptionWidget(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setLayerType(1, null);
        this.mManager = (CaptioningManager)context.getSystemService("captioning");
        this.mCaptionStyle = this.mManager.getUserStyle();
        this.mClosedCaptionLayout = this.createCaptionLayout(context);
        this.mClosedCaptionLayout.setCaptionStyle(this.mCaptionStyle);
        this.mClosedCaptionLayout.setFontScale(this.mManager.getFontScale());
        this.addView((View)((ViewGroup)this.mClosedCaptionLayout), -1, -1);
        this.requestLayout();
    }

    public abstract ClosedCaptionLayout createCaptionLayout(Context var1);

    @Override
    public void setOnChangedListener(SubtitleTrack.RenderingWidget.OnChangedListener listener) {
        this.mListener = listener;
    }

    @Override
    public void setSize(int width, int height) {
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000);
        int heightSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
        this.measure(widthSpec, heightSpec);
        this.layout(0, 0, width, height);
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setVisibility(0);
        } else {
            this.setVisibility(8);
        }
        this.manageChangeListener();
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.manageChangeListener();
    }

    @Override
    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.manageChangeListener();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        ((ViewGroup)this.mClosedCaptionLayout).measure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        ((ViewGroup)this.mClosedCaptionLayout).layout(l, t, r, b);
    }

    private void manageChangeListener() {
        boolean needsListener;
        boolean bl = needsListener = this.isAttachedToWindow() && this.getVisibility() == 0;
        if (this.mHasChangeListener != needsListener) {
            this.mHasChangeListener = needsListener;
            if (needsListener) {
                this.mManager.addCaptioningChangeListener(this.mCaptioningListener);
            } else {
                this.mManager.removeCaptioningChangeListener(this.mCaptioningListener);
            }
        }
    }

    static interface ClosedCaptionLayout {
        public void setCaptionStyle(CaptioningManager.CaptionStyle var1);

        public void setFontScale(float var1);
    }
}

