/*
 * Decompiled with CFR 0.152.
 */
package android.support.v13.app;

import android.app.Activity;
import android.app.Fragment;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.v13.app.FragmentCompat23;
import android.support.v13.app.FragmentCompatICS;
import android.support.v13.app.FragmentCompatICSMR1;
import java.util.Arrays;

public class FragmentCompat {
    static final FragmentCompatImpl IMPL = Build.VERSION.SDK_INT >= 23 ? new MncFragmentCompatImpl() : (Build.VERSION.SDK_INT >= 15 ? new ICSMR1FragmentCompatImpl() : (Build.VERSION.SDK_INT >= 14 ? new ICSFragmentCompatImpl() : new BaseFragmentCompatImpl()));

    public static void setMenuVisibility(Fragment f, boolean visible) {
        IMPL.setMenuVisibility(f, visible);
    }

    public static void setUserVisibleHint(Fragment f, boolean deferStart) {
        IMPL.setUserVisibleHint(f, deferStart);
    }

    public static void requestPermissions(@NonNull Fragment fragment, @NonNull String[] permissions, int requestCode) {
        IMPL.requestPermissions(fragment, permissions, requestCode);
    }

    public static boolean shouldShowRequestPermissionRationale(@NonNull Fragment fragment, @NonNull String permission) {
        return IMPL.shouldShowRequestPermissionRationale(fragment, permission);
    }

    public static interface OnRequestPermissionsResultCallback {
        public void onRequestPermissionsResult(int var1, @NonNull String[] var2, @NonNull int[] var3);
    }

    static class MncFragmentCompatImpl
    extends ICSMR1FragmentCompatImpl {
        MncFragmentCompatImpl() {
        }

        @Override
        public void requestPermissions(Fragment fragment, String[] permissions, int requestCode) {
            FragmentCompat23.requestPermissions((Fragment)fragment, (String[])permissions, (int)requestCode);
        }

        @Override
        public boolean shouldShowRequestPermissionRationale(Fragment fragment, String permission) {
            return FragmentCompat23.shouldShowRequestPermissionRationale((Fragment)fragment, (String)permission);
        }
    }

    static class ICSMR1FragmentCompatImpl
    extends ICSFragmentCompatImpl {
        ICSMR1FragmentCompatImpl() {
        }

        @Override
        public void setUserVisibleHint(Fragment f, boolean deferStart) {
            FragmentCompatICSMR1.setUserVisibleHint((Fragment)f, (boolean)deferStart);
        }
    }

    static class ICSFragmentCompatImpl
    extends BaseFragmentCompatImpl {
        ICSFragmentCompatImpl() {
        }

        @Override
        public void setMenuVisibility(Fragment f, boolean visible) {
            FragmentCompatICS.setMenuVisibility((Fragment)f, (boolean)visible);
        }
    }

    static class BaseFragmentCompatImpl
    implements FragmentCompatImpl {
        BaseFragmentCompatImpl() {
        }

        @Override
        public void setMenuVisibility(Fragment f, boolean visible) {
        }

        @Override
        public void setUserVisibleHint(Fragment f, boolean deferStart) {
        }

        @Override
        public void requestPermissions(final Fragment fragment, final String[] permissions, final int requestCode) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    int[] grantResults = new int[permissions.length];
                    Activity context = fragment.getActivity();
                    if (context != null) {
                        PackageManager packageManager = context.getPackageManager();
                        String packageName = context.getPackageName();
                        int permissionCount = permissions.length;
                        for (int i = 0; i < permissionCount; ++i) {
                            grantResults[i] = packageManager.checkPermission(permissions[i], packageName);
                        }
                    } else {
                        Arrays.fill(grantResults, -1);
                    }
                    ((OnRequestPermissionsResultCallback)fragment).onRequestPermissionsResult(requestCode, permissions, grantResults);
                }
            });
        }

        @Override
        public boolean shouldShowRequestPermissionRationale(Fragment fragment, String permission) {
            return false;
        }
    }

    static interface FragmentCompatImpl {
        public void setMenuVisibility(Fragment var1, boolean var2);

        public void setUserVisibleHint(Fragment var1, boolean var2);

        public void requestPermissions(Fragment var1, String[] var2, int var3);

        public boolean shouldShowRequestPermissionRationale(Fragment var1, String var2);
    }
}

