/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.view.accessibility;

import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompatApi21;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompatApi22;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompatApi24;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompatIcs;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompatJellyBean;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompatJellybeanMr1;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompatJellybeanMr2;
import android.support.v4.view.accessibility.AccessibilityNodeInfoCompatKitKat;
import android.support.v4.view.accessibility.AccessibilityWindowInfoCompat;
import android.view.View;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AccessibilityNodeInfoCompat {
    private static final AccessibilityNodeInfoImpl IMPL = Build.VERSION.SDK_INT >= 24 ? new AccessibilityNodeInfoApi24Impl() : (Build.VERSION.SDK_INT >= 22 ? new AccessibilityNodeInfoApi22Impl() : (Build.VERSION.SDK_INT >= 21 ? new AccessibilityNodeInfoApi21Impl() : (Build.VERSION.SDK_INT >= 19 ? new AccessibilityNodeInfoKitKatImpl() : (Build.VERSION.SDK_INT >= 18 ? new AccessibilityNodeInfoJellybeanMr2Impl() : (Build.VERSION.SDK_INT >= 17 ? new AccessibilityNodeInfoJellybeanMr1Impl() : (Build.VERSION.SDK_INT >= 16 ? new AccessibilityNodeInfoJellybeanImpl() : (Build.VERSION.SDK_INT >= 14 ? new AccessibilityNodeInfoIcsImpl() : new AccessibilityNodeInfoStubImpl())))))));
    private final Object mInfo;
    public static final int ACTION_FOCUS = 1;
    public static final int ACTION_CLEAR_FOCUS = 2;
    public static final int ACTION_SELECT = 4;
    public static final int ACTION_CLEAR_SELECTION = 8;
    public static final int ACTION_CLICK = 16;
    public static final int ACTION_LONG_CLICK = 32;
    public static final int ACTION_ACCESSIBILITY_FOCUS = 64;
    public static final int ACTION_CLEAR_ACCESSIBILITY_FOCUS = 128;
    public static final int ACTION_NEXT_AT_MOVEMENT_GRANULARITY = 256;
    public static final int ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY = 512;
    public static final int ACTION_NEXT_HTML_ELEMENT = 1024;
    public static final int ACTION_PREVIOUS_HTML_ELEMENT = 2048;
    public static final int ACTION_SCROLL_FORWARD = 4096;
    public static final int ACTION_SCROLL_BACKWARD = 8192;
    public static final int ACTION_COPY = 16384;
    public static final int ACTION_PASTE = 32768;
    public static final int ACTION_CUT = 65536;
    public static final int ACTION_SET_SELECTION = 131072;
    public static final int ACTION_EXPAND = 262144;
    public static final int ACTION_COLLAPSE = 524288;
    public static final int ACTION_DISMISS = 0x100000;
    public static final int ACTION_SET_TEXT = 0x200000;
    public static final String ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT = "ACTION_ARGUMENT_MOVEMENT_GRANULARITY_INT";
    public static final String ACTION_ARGUMENT_HTML_ELEMENT_STRING = "ACTION_ARGUMENT_HTML_ELEMENT_STRING";
    public static final String ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN = "ACTION_ARGUMENT_EXTEND_SELECTION_BOOLEAN";
    public static final String ACTION_ARGUMENT_SELECTION_START_INT = "ACTION_ARGUMENT_SELECTION_START_INT";
    public static final String ACTION_ARGUMENT_SELECTION_END_INT = "ACTION_ARGUMENT_SELECTION_END_INT";
    public static final String ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE = "ACTION_ARGUMENT_SET_TEXT_CHARSEQUENCE";
    public static final int FOCUS_INPUT = 1;
    public static final int FOCUS_ACCESSIBILITY = 2;
    public static final int MOVEMENT_GRANULARITY_CHARACTER = 1;
    public static final int MOVEMENT_GRANULARITY_WORD = 2;
    public static final int MOVEMENT_GRANULARITY_LINE = 4;
    public static final int MOVEMENT_GRANULARITY_PARAGRAPH = 8;
    public static final int MOVEMENT_GRANULARITY_PAGE = 16;

    static AccessibilityNodeInfoCompat wrapNonNullInstance(Object object) {
        if (object != null) {
            return new AccessibilityNodeInfoCompat(object);
        }
        return null;
    }

    public AccessibilityNodeInfoCompat(Object info) {
        this.mInfo = info;
    }

    public Object getInfo() {
        return this.mInfo;
    }

    public static AccessibilityNodeInfoCompat obtain(View source) {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.obtain(source));
    }

    public static AccessibilityNodeInfoCompat obtain(View root, int virtualDescendantId) {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.obtain(root, virtualDescendantId));
    }

    public static AccessibilityNodeInfoCompat obtain() {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.obtain());
    }

    public static AccessibilityNodeInfoCompat obtain(AccessibilityNodeInfoCompat info) {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.obtain(info.mInfo));
    }

    public void setSource(View source) {
        IMPL.setSource(this.mInfo, source);
    }

    public void setSource(View root, int virtualDescendantId) {
        IMPL.setSource(this.mInfo, root, virtualDescendantId);
    }

    public AccessibilityNodeInfoCompat findFocus(int focus) {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.findFocus(this.mInfo, focus));
    }

    public AccessibilityNodeInfoCompat focusSearch(int direction) {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.focusSearch(this.mInfo, direction));
    }

    public int getWindowId() {
        return IMPL.getWindowId(this.mInfo);
    }

    public int getChildCount() {
        return IMPL.getChildCount(this.mInfo);
    }

    public AccessibilityNodeInfoCompat getChild(int index) {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.getChild(this.mInfo, index));
    }

    public void addChild(View child) {
        IMPL.addChild(this.mInfo, child);
    }

    public void addChild(View root, int virtualDescendantId) {
        IMPL.addChild(this.mInfo, root, virtualDescendantId);
    }

    public boolean removeChild(View child) {
        return IMPL.removeChild(this.mInfo, child);
    }

    public boolean removeChild(View root, int virtualDescendantId) {
        return IMPL.removeChild(this.mInfo, root, virtualDescendantId);
    }

    public int getActions() {
        return IMPL.getActions(this.mInfo);
    }

    public void addAction(int action) {
        IMPL.addAction(this.mInfo, action);
    }

    public void addAction(AccessibilityActionCompat action) {
        IMPL.addAction(this.mInfo, action.mAction);
    }

    public boolean removeAction(AccessibilityActionCompat action) {
        return IMPL.removeAction(this.mInfo, action.mAction);
    }

    public boolean performAction(int action) {
        return IMPL.performAction(this.mInfo, action);
    }

    public boolean performAction(int action, Bundle arguments) {
        return IMPL.performAction(this.mInfo, action, arguments);
    }

    public void setMovementGranularities(int granularities) {
        IMPL.setMovementGranularities(this.mInfo, granularities);
    }

    public int getMovementGranularities() {
        return IMPL.getMovementGranularities(this.mInfo);
    }

    public List<AccessibilityNodeInfoCompat> findAccessibilityNodeInfosByText(String text) {
        ArrayList<AccessibilityNodeInfoCompat> result = new ArrayList<AccessibilityNodeInfoCompat>();
        List<Object> infos = IMPL.findAccessibilityNodeInfosByText(this.mInfo, text);
        int infoCount = infos.size();
        for (int i = 0; i < infoCount; ++i) {
            Object info = infos.get(i);
            result.add(new AccessibilityNodeInfoCompat(info));
        }
        return result;
    }

    public AccessibilityNodeInfoCompat getParent() {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.getParent(this.mInfo));
    }

    public void setParent(View parent) {
        IMPL.setParent(this.mInfo, parent);
    }

    public void setParent(View root, int virtualDescendantId) {
        IMPL.setParent(this.mInfo, root, virtualDescendantId);
    }

    public void getBoundsInParent(Rect outBounds) {
        IMPL.getBoundsInParent(this.mInfo, outBounds);
    }

    public void setBoundsInParent(Rect bounds) {
        IMPL.setBoundsInParent(this.mInfo, bounds);
    }

    public void getBoundsInScreen(Rect outBounds) {
        IMPL.getBoundsInScreen(this.mInfo, outBounds);
    }

    public void setBoundsInScreen(Rect bounds) {
        IMPL.setBoundsInScreen(this.mInfo, bounds);
    }

    public boolean isCheckable() {
        return IMPL.isCheckable(this.mInfo);
    }

    public void setCheckable(boolean checkable) {
        IMPL.setCheckable(this.mInfo, checkable);
    }

    public boolean isChecked() {
        return IMPL.isChecked(this.mInfo);
    }

    public void setChecked(boolean checked) {
        IMPL.setChecked(this.mInfo, checked);
    }

    public boolean isFocusable() {
        return IMPL.isFocusable(this.mInfo);
    }

    public void setFocusable(boolean focusable) {
        IMPL.setFocusable(this.mInfo, focusable);
    }

    public boolean isFocused() {
        return IMPL.isFocused(this.mInfo);
    }

    public void setFocused(boolean focused) {
        IMPL.setFocused(this.mInfo, focused);
    }

    public boolean isVisibleToUser() {
        return IMPL.isVisibleToUser(this.mInfo);
    }

    public void setVisibleToUser(boolean visibleToUser) {
        IMPL.setVisibleToUser(this.mInfo, visibleToUser);
    }

    public boolean isAccessibilityFocused() {
        return IMPL.isAccessibilityFocused(this.mInfo);
    }

    public void setAccessibilityFocused(boolean focused) {
        IMPL.setAccessibilityFocused(this.mInfo, focused);
    }

    public boolean isSelected() {
        return IMPL.isSelected(this.mInfo);
    }

    public void setSelected(boolean selected) {
        IMPL.setSelected(this.mInfo, selected);
    }

    public boolean isClickable() {
        return IMPL.isClickable(this.mInfo);
    }

    public void setClickable(boolean clickable) {
        IMPL.setClickable(this.mInfo, clickable);
    }

    public boolean isLongClickable() {
        return IMPL.isLongClickable(this.mInfo);
    }

    public void setLongClickable(boolean longClickable) {
        IMPL.setLongClickable(this.mInfo, longClickable);
    }

    public boolean isEnabled() {
        return IMPL.isEnabled(this.mInfo);
    }

    public void setEnabled(boolean enabled) {
        IMPL.setEnabled(this.mInfo, enabled);
    }

    public boolean isPassword() {
        return IMPL.isPassword(this.mInfo);
    }

    public void setPassword(boolean password) {
        IMPL.setPassword(this.mInfo, password);
    }

    public boolean isScrollable() {
        return IMPL.isScrollable(this.mInfo);
    }

    public void setScrollable(boolean scrollable) {
        IMPL.setScrollable(this.mInfo, scrollable);
    }

    public boolean isImportantForAccessibility() {
        return IMPL.isImportantForAccessibility(this.mInfo);
    }

    public void setImportantForAccessibility(boolean important) {
        IMPL.setImportantForAccessibility(this.mInfo, important);
    }

    public CharSequence getPackageName() {
        return IMPL.getPackageName(this.mInfo);
    }

    public void setPackageName(CharSequence packageName) {
        IMPL.setPackageName(this.mInfo, packageName);
    }

    public CharSequence getClassName() {
        return IMPL.getClassName(this.mInfo);
    }

    public void setClassName(CharSequence className) {
        IMPL.setClassName(this.mInfo, className);
    }

    public CharSequence getText() {
        return IMPL.getText(this.mInfo);
    }

    public void setText(CharSequence text) {
        IMPL.setText(this.mInfo, text);
    }

    public CharSequence getContentDescription() {
        return IMPL.getContentDescription(this.mInfo);
    }

    public void setContentDescription(CharSequence contentDescription) {
        IMPL.setContentDescription(this.mInfo, contentDescription);
    }

    public void recycle() {
        IMPL.recycle(this.mInfo);
    }

    public void setViewIdResourceName(String viewId) {
        IMPL.setViewIdResourceName(this.mInfo, viewId);
    }

    public String getViewIdResourceName() {
        return IMPL.getViewIdResourceName(this.mInfo);
    }

    public int getLiveRegion() {
        return IMPL.getLiveRegion(this.mInfo);
    }

    public void setLiveRegion(int mode) {
        IMPL.setLiveRegion(this.mInfo, mode);
    }

    public int getDrawingOrder() {
        return IMPL.getDrawingOrder(this.mInfo);
    }

    public void setDrawingOrder(int drawingOrderInParent) {
        IMPL.setDrawingOrder(this.mInfo, drawingOrderInParent);
    }

    public CollectionInfoCompat getCollectionInfo() {
        Object info = IMPL.getCollectionInfo(this.mInfo);
        if (info == null) {
            return null;
        }
        return new CollectionInfoCompat(info);
    }

    public void setCollectionInfo(Object collectionInfo) {
        IMPL.setCollectionInfo(this.mInfo, ((CollectionInfoCompat)collectionInfo).mInfo);
    }

    public void setCollectionItemInfo(Object collectionItemInfo) {
        IMPL.setCollectionItemInfo(this.mInfo, ((CollectionItemInfoCompat)collectionItemInfo).mInfo);
    }

    public CollectionItemInfoCompat getCollectionItemInfo() {
        Object info = IMPL.getCollectionItemInfo(this.mInfo);
        if (info == null) {
            return null;
        }
        return new CollectionItemInfoCompat(info);
    }

    public RangeInfoCompat getRangeInfo() {
        Object info = IMPL.getRangeInfo(this.mInfo);
        if (info == null) {
            return null;
        }
        return new RangeInfoCompat(info);
    }

    public void setRangeInfo(RangeInfoCompat rangeInfo) {
        IMPL.setRangeInfo(this.mInfo, rangeInfo.mInfo);
    }

    public List<AccessibilityActionCompat> getActionList() {
        List<Object> actions = IMPL.getActionList(this.mInfo);
        if (actions != null) {
            ArrayList<AccessibilityActionCompat> result = new ArrayList<AccessibilityActionCompat>();
            int actionCount = actions.size();
            for (int i = 0; i < actionCount; ++i) {
                Object action = actions.get(i);
                result.add(new AccessibilityActionCompat(action));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public void setContentInvalid(boolean contentInvalid) {
        IMPL.setContentInvalid(this.mInfo, contentInvalid);
    }

    public boolean isContentInvalid() {
        return IMPL.isContentInvalid(this.mInfo);
    }

    public void setError(CharSequence error) {
        IMPL.setError(this.mInfo, error);
    }

    public CharSequence getError() {
        return IMPL.getError(this.mInfo);
    }

    public void setLabelFor(View labeled) {
        IMPL.setLabelFor(this.mInfo, labeled);
    }

    public void setLabelFor(View root, int virtualDescendantId) {
        IMPL.setLabelFor(this.mInfo, root, virtualDescendantId);
    }

    public AccessibilityNodeInfoCompat getLabelFor() {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.getLabelFor(this.mInfo));
    }

    public void setLabeledBy(View label) {
        IMPL.setLabeledBy(this.mInfo, label);
    }

    public void setLabeledBy(View root, int virtualDescendantId) {
        IMPL.setLabeledBy(this.mInfo, root, virtualDescendantId);
    }

    public AccessibilityNodeInfoCompat getLabeledBy() {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.getLabeledBy(this.mInfo));
    }

    public boolean canOpenPopup() {
        return IMPL.canOpenPopup(this.mInfo);
    }

    public void setCanOpenPopup(boolean opensPopup) {
        IMPL.setCanOpenPopup(this.mInfo, opensPopup);
    }

    public List<AccessibilityNodeInfoCompat> findAccessibilityNodeInfosByViewId(String viewId) {
        List<Object> nodes = IMPL.findAccessibilityNodeInfosByViewId(this.mInfo, viewId);
        if (nodes != null) {
            ArrayList<AccessibilityNodeInfoCompat> result = new ArrayList<AccessibilityNodeInfoCompat>();
            for (Object node : nodes) {
                result.add(new AccessibilityNodeInfoCompat(node));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public Bundle getExtras() {
        return IMPL.getExtras(this.mInfo);
    }

    public int getInputType() {
        return IMPL.getInputType(this.mInfo);
    }

    public void setInputType(int inputType) {
        IMPL.setInputType(this.mInfo, inputType);
    }

    public void setMaxTextLength(int max) {
        IMPL.setMaxTextLength(this.mInfo, max);
    }

    public int getMaxTextLength() {
        return IMPL.getMaxTextLength(this.mInfo);
    }

    public void setTextSelection(int start, int end) {
        IMPL.setTextSelection(this.mInfo, start, end);
    }

    public int getTextSelectionStart() {
        return IMPL.getTextSelectionStart(this.mInfo);
    }

    public int getTextSelectionEnd() {
        return IMPL.getTextSelectionEnd(this.mInfo);
    }

    public AccessibilityNodeInfoCompat getTraversalBefore() {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.getTraversalBefore(this.mInfo));
    }

    public void setTraversalBefore(View view) {
        IMPL.setTraversalBefore(this.mInfo, view);
    }

    public void setTraversalBefore(View root, int virtualDescendantId) {
        IMPL.setTraversalBefore(this.mInfo, root, virtualDescendantId);
    }

    public AccessibilityNodeInfoCompat getTraversalAfter() {
        return AccessibilityNodeInfoCompat.wrapNonNullInstance(IMPL.getTraversalAfter(this.mInfo));
    }

    public void setTraversalAfter(View view) {
        IMPL.setTraversalAfter(this.mInfo, view);
    }

    public void setTraversalAfter(View root, int virtualDescendantId) {
        IMPL.setTraversalAfter(this.mInfo, root, virtualDescendantId);
    }

    public AccessibilityWindowInfoCompat getWindow() {
        return AccessibilityWindowInfoCompat.wrapNonNullInstance(IMPL.getWindow(this.mInfo));
    }

    public boolean isDismissable() {
        return IMPL.isDismissable(this.mInfo);
    }

    public void setDismissable(boolean dismissable) {
        IMPL.setDismissable(this.mInfo, dismissable);
    }

    public boolean isEditable() {
        return IMPL.isEditable(this.mInfo);
    }

    public void setEditable(boolean editable) {
        IMPL.setEditable(this.mInfo, editable);
    }

    public boolean isMultiLine() {
        return IMPL.isMultiLine(this.mInfo);
    }

    public void setMultiLine(boolean multiLine) {
        IMPL.setMultiLine(this.mInfo, multiLine);
    }

    public boolean refresh() {
        return IMPL.refresh(this.mInfo);
    }

    @Nullable
    public CharSequence getRoleDescription() {
        return IMPL.getRoleDescription(this.mInfo);
    }

    public void setRoleDescription(@Nullable CharSequence roleDescription) {
        IMPL.setRoleDescription(this.mInfo, roleDescription);
    }

    public int hashCode() {
        return this.mInfo == null ? 0 : this.mInfo.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessibilityNodeInfoCompat other = (AccessibilityNodeInfoCompat)obj;
        return !(this.mInfo == null ? other.mInfo != null : !this.mInfo.equals(other.mInfo));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(super.toString());
        Rect bounds = new Rect();
        this.getBoundsInParent(bounds);
        builder.append("; boundsInParent: " + bounds);
        this.getBoundsInScreen(bounds);
        builder.append("; boundsInScreen: " + bounds);
        builder.append("; packageName: ").append(this.getPackageName());
        builder.append("; className: ").append(this.getClassName());
        builder.append("; text: ").append(this.getText());
        builder.append("; contentDescription: ").append(this.getContentDescription());
        builder.append("; viewId: ").append(this.getViewIdResourceName());
        builder.append("; checkable: ").append(this.isCheckable());
        builder.append("; checked: ").append(this.isChecked());
        builder.append("; focusable: ").append(this.isFocusable());
        builder.append("; focused: ").append(this.isFocused());
        builder.append("; selected: ").append(this.isSelected());
        builder.append("; clickable: ").append(this.isClickable());
        builder.append("; longClickable: ").append(this.isLongClickable());
        builder.append("; enabled: ").append(this.isEnabled());
        builder.append("; password: ").append(this.isPassword());
        builder.append("; scrollable: " + this.isScrollable());
        builder.append("; [");
        int actionBits = this.getActions();
        while (actionBits != 0) {
            int action = 1 << Integer.numberOfTrailingZeros(actionBits);
            builder.append(AccessibilityNodeInfoCompat.getActionSymbolicName(action));
            if ((actionBits &= ~action) == 0) continue;
            builder.append(", ");
        }
        builder.append("]");
        return builder.toString();
    }

    private static String getActionSymbolicName(int action) {
        switch (action) {
            case 1: {
                return "ACTION_FOCUS";
            }
            case 2: {
                return "ACTION_CLEAR_FOCUS";
            }
            case 4: {
                return "ACTION_SELECT";
            }
            case 8: {
                return "ACTION_CLEAR_SELECTION";
            }
            case 16: {
                return "ACTION_CLICK";
            }
            case 32: {
                return "ACTION_LONG_CLICK";
            }
            case 64: {
                return "ACTION_ACCESSIBILITY_FOCUS";
            }
            case 128: {
                return "ACTION_CLEAR_ACCESSIBILITY_FOCUS";
            }
            case 256: {
                return "ACTION_NEXT_AT_MOVEMENT_GRANULARITY";
            }
            case 512: {
                return "ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY";
            }
            case 1024: {
                return "ACTION_NEXT_HTML_ELEMENT";
            }
            case 2048: {
                return "ACTION_PREVIOUS_HTML_ELEMENT";
            }
            case 4096: {
                return "ACTION_SCROLL_FORWARD";
            }
            case 8192: {
                return "ACTION_SCROLL_BACKWARD";
            }
            case 65536: {
                return "ACTION_CUT";
            }
            case 16384: {
                return "ACTION_COPY";
            }
            case 32768: {
                return "ACTION_PASTE";
            }
            case 131072: {
                return "ACTION_SET_SELECTION";
            }
        }
        return "ACTION_UNKNOWN";
    }

    static class AccessibilityNodeInfoApi24Impl
    extends AccessibilityNodeInfoApi22Impl {
        AccessibilityNodeInfoApi24Impl() {
        }

        @Override
        public int getDrawingOrder(Object info) {
            return AccessibilityNodeInfoCompatApi24.getDrawingOrder((Object)info);
        }

        @Override
        public void setDrawingOrder(Object info, int drawingOrderInParent) {
            AccessibilityNodeInfoCompatApi24.setDrawingOrder((Object)info, (int)drawingOrderInParent);
        }

        @Override
        public boolean isImportantForAccessibility(Object info) {
            return AccessibilityNodeInfoCompatApi24.isImportantForAccessibility((Object)info);
        }

        @Override
        public void setImportantForAccessibility(Object info, boolean importantForAccessibility) {
            AccessibilityNodeInfoCompatApi24.setImportantForAccessibility((Object)info, (boolean)importantForAccessibility);
        }
    }

    static class AccessibilityNodeInfoApi22Impl
    extends AccessibilityNodeInfoApi21Impl {
        AccessibilityNodeInfoApi22Impl() {
        }

        @Override
        public Object getTraversalBefore(Object info) {
            return AccessibilityNodeInfoCompatApi22.getTraversalBefore((Object)info);
        }

        @Override
        public void setTraversalBefore(Object info, View view) {
            AccessibilityNodeInfoCompatApi22.setTraversalBefore((Object)info, (View)view);
        }

        @Override
        public void setTraversalBefore(Object info, View root, int virtualDescendantId) {
            AccessibilityNodeInfoCompatApi22.setTraversalBefore((Object)info, (View)root, (int)virtualDescendantId);
        }

        @Override
        public Object getTraversalAfter(Object info) {
            return AccessibilityNodeInfoCompatApi22.getTraversalAfter((Object)info);
        }

        @Override
        public void setTraversalAfter(Object info, View view) {
            AccessibilityNodeInfoCompatApi22.setTraversalAfter((Object)info, (View)view);
        }

        @Override
        public void setTraversalAfter(Object info, View root, int virtualDescendantId) {
            AccessibilityNodeInfoCompatApi22.setTraversalAfter((Object)info, (View)root, (int)virtualDescendantId);
        }
    }

    static class AccessibilityNodeInfoApi21Impl
    extends AccessibilityNodeInfoKitKatImpl {
        AccessibilityNodeInfoApi21Impl() {
        }

        @Override
        public Object newAccessibilityAction(int actionId, CharSequence label) {
            return AccessibilityNodeInfoCompatApi21.newAccessibilityAction((int)actionId, (CharSequence)label);
        }

        @Override
        public List<Object> getActionList(Object info) {
            return AccessibilityNodeInfoCompatApi21.getActionList((Object)info);
        }

        @Override
        public Object obtainCollectionInfo(int rowCount, int columnCount, boolean hierarchical, int selectionMode) {
            return AccessibilityNodeInfoCompatApi21.obtainCollectionInfo((int)rowCount, (int)columnCount, (boolean)hierarchical, (int)selectionMode);
        }

        @Override
        public void addAction(Object info, Object action) {
            AccessibilityNodeInfoCompatApi21.addAction((Object)info, (Object)action);
        }

        @Override
        public boolean removeAction(Object info, Object action) {
            return AccessibilityNodeInfoCompatApi21.removeAction((Object)info, (Object)action);
        }

        @Override
        public int getAccessibilityActionId(Object action) {
            return AccessibilityNodeInfoCompatApi21.getAccessibilityActionId((Object)action);
        }

        @Override
        public CharSequence getAccessibilityActionLabel(Object action) {
            return AccessibilityNodeInfoCompatApi21.getAccessibilityActionLabel((Object)action);
        }

        @Override
        public Object obtainCollectionItemInfo(int rowIndex, int rowSpan, int columnIndex, int columnSpan, boolean heading, boolean selected) {
            return AccessibilityNodeInfoCompatApi21.obtainCollectionItemInfo((int)rowIndex, (int)rowSpan, (int)columnIndex, (int)columnSpan, (boolean)heading, (boolean)selected);
        }

        @Override
        public boolean isCollectionItemSelected(Object info) {
            return AccessibilityNodeInfoCompatApi21.CollectionItemInfo.isSelected((Object)info);
        }

        @Override
        public CharSequence getError(Object info) {
            return AccessibilityNodeInfoCompatApi21.getError((Object)info);
        }

        @Override
        public void setError(Object info, CharSequence error) {
            AccessibilityNodeInfoCompatApi21.setError((Object)info, (CharSequence)error);
        }

        @Override
        public void setMaxTextLength(Object info, int max) {
            AccessibilityNodeInfoCompatApi21.setMaxTextLength((Object)info, (int)max);
        }

        @Override
        public int getMaxTextLength(Object info) {
            return AccessibilityNodeInfoCompatApi21.getMaxTextLength((Object)info);
        }

        @Override
        public Object getWindow(Object info) {
            return AccessibilityNodeInfoCompatApi21.getWindow((Object)info);
        }

        @Override
        public boolean removeChild(Object info, View child) {
            return AccessibilityNodeInfoCompatApi21.removeChild((Object)info, (View)child);
        }

        @Override
        public boolean removeChild(Object info, View root, int virtualDescendantId) {
            return AccessibilityNodeInfoCompatApi21.removeChild((Object)info, (View)root, (int)virtualDescendantId);
        }
    }

    static class AccessibilityNodeInfoKitKatImpl
    extends AccessibilityNodeInfoJellybeanMr2Impl {
        AccessibilityNodeInfoKitKatImpl() {
        }

        @Override
        public int getLiveRegion(Object info) {
            return AccessibilityNodeInfoCompatKitKat.getLiveRegion((Object)info);
        }

        @Override
        public void setLiveRegion(Object info, int mode) {
            AccessibilityNodeInfoCompatKitKat.setLiveRegion((Object)info, (int)mode);
        }

        @Override
        public Object getCollectionInfo(Object info) {
            return AccessibilityNodeInfoCompatKitKat.getCollectionInfo((Object)info);
        }

        @Override
        public void setCollectionInfo(Object info, Object collectionInfo) {
            AccessibilityNodeInfoCompatKitKat.setCollectionInfo((Object)info, (Object)collectionInfo);
        }

        @Override
        public Object obtainCollectionInfo(int rowCount, int columnCount, boolean hierarchical, int selectionMode) {
            return AccessibilityNodeInfoCompatKitKat.obtainCollectionInfo((int)rowCount, (int)columnCount, (boolean)hierarchical, (int)selectionMode);
        }

        @Override
        public Object obtainCollectionItemInfo(int rowIndex, int rowSpan, int columnIndex, int columnSpan, boolean heading, boolean selected) {
            return AccessibilityNodeInfoCompatKitKat.obtainCollectionItemInfo((int)rowIndex, (int)rowSpan, (int)columnIndex, (int)columnSpan, (boolean)heading);
        }

        @Override
        public int getCollectionInfoColumnCount(Object info) {
            return AccessibilityNodeInfoCompatKitKat.CollectionInfo.getColumnCount((Object)info);
        }

        @Override
        public int getCollectionInfoRowCount(Object info) {
            return AccessibilityNodeInfoCompatKitKat.CollectionInfo.getRowCount((Object)info);
        }

        @Override
        public boolean isCollectionInfoHierarchical(Object info) {
            return AccessibilityNodeInfoCompatKitKat.CollectionInfo.isHierarchical((Object)info);
        }

        @Override
        public Object getCollectionItemInfo(Object info) {
            return AccessibilityNodeInfoCompatKitKat.getCollectionItemInfo((Object)info);
        }

        @Override
        public Object getRangeInfo(Object info) {
            return AccessibilityNodeInfoCompatKitKat.getRangeInfo((Object)info);
        }

        @Override
        public void setRangeInfo(Object info, Object rangeInfo) {
            AccessibilityNodeInfoCompatKitKat.setRangeInfo((Object)info, (Object)rangeInfo);
        }

        @Override
        public int getCollectionItemColumnIndex(Object info) {
            return AccessibilityNodeInfoCompatKitKat.CollectionItemInfo.getColumnIndex((Object)info);
        }

        @Override
        public int getCollectionItemColumnSpan(Object info) {
            return AccessibilityNodeInfoCompatKitKat.CollectionItemInfo.getColumnSpan((Object)info);
        }

        @Override
        public int getCollectionItemRowIndex(Object info) {
            return AccessibilityNodeInfoCompatKitKat.CollectionItemInfo.getRowIndex((Object)info);
        }

        @Override
        public int getCollectionItemRowSpan(Object info) {
            return AccessibilityNodeInfoCompatKitKat.CollectionItemInfo.getRowSpan((Object)info);
        }

        @Override
        public boolean isCollectionItemHeading(Object info) {
            return AccessibilityNodeInfoCompatKitKat.CollectionItemInfo.isHeading((Object)info);
        }

        @Override
        public void setCollectionItemInfo(Object info, Object collectionItemInfo) {
            AccessibilityNodeInfoCompatKitKat.setCollectionItemInfo((Object)info, (Object)collectionItemInfo);
        }

        @Override
        public void setContentInvalid(Object info, boolean contentInvalid) {
            AccessibilityNodeInfoCompatKitKat.setContentInvalid((Object)info, (boolean)contentInvalid);
        }

        @Override
        public boolean isContentInvalid(Object info) {
            return AccessibilityNodeInfoCompatKitKat.isContentInvalid((Object)info);
        }

        @Override
        public boolean canOpenPopup(Object info) {
            return AccessibilityNodeInfoCompatKitKat.canOpenPopup((Object)info);
        }

        @Override
        public void setCanOpenPopup(Object info, boolean opensPopup) {
            AccessibilityNodeInfoCompatKitKat.setCanOpenPopup((Object)info, (boolean)opensPopup);
        }

        @Override
        public Bundle getExtras(Object info) {
            return AccessibilityNodeInfoCompatKitKat.getExtras((Object)info);
        }

        @Override
        public int getInputType(Object info) {
            return AccessibilityNodeInfoCompatKitKat.getInputType((Object)info);
        }

        @Override
        public void setInputType(Object info, int inputType) {
            AccessibilityNodeInfoCompatKitKat.setInputType((Object)info, (int)inputType);
        }

        @Override
        public boolean isDismissable(Object info) {
            return AccessibilityNodeInfoCompatKitKat.isDismissable((Object)info);
        }

        @Override
        public void setDismissable(Object info, boolean dismissable) {
            AccessibilityNodeInfoCompatKitKat.setDismissable((Object)info, (boolean)dismissable);
        }

        @Override
        public boolean isMultiLine(Object info) {
            return AccessibilityNodeInfoCompatKitKat.isMultiLine((Object)info);
        }

        @Override
        public void setMultiLine(Object info, boolean multiLine) {
            AccessibilityNodeInfoCompatKitKat.setMultiLine((Object)info, (boolean)multiLine);
        }

        @Override
        public CharSequence getRoleDescription(Object info) {
            return AccessibilityNodeInfoCompatKitKat.getRoleDescription((Object)info);
        }

        @Override
        public void setRoleDescription(Object info, CharSequence roleDescription) {
            AccessibilityNodeInfoCompatKitKat.setRoleDescription((Object)info, (CharSequence)roleDescription);
        }
    }

    static class AccessibilityNodeInfoJellybeanMr2Impl
    extends AccessibilityNodeInfoJellybeanMr1Impl {
        AccessibilityNodeInfoJellybeanMr2Impl() {
        }

        @Override
        public String getViewIdResourceName(Object info) {
            return AccessibilityNodeInfoCompatJellybeanMr2.getViewIdResourceName((Object)info);
        }

        @Override
        public void setViewIdResourceName(Object info, String viewId) {
            AccessibilityNodeInfoCompatJellybeanMr2.setViewIdResourceName((Object)info, (String)viewId);
        }

        @Override
        public List<Object> findAccessibilityNodeInfosByViewId(Object info, String viewId) {
            return AccessibilityNodeInfoCompatJellybeanMr2.findAccessibilityNodeInfosByViewId((Object)info, (String)viewId);
        }

        @Override
        public void setTextSelection(Object info, int start, int end) {
            AccessibilityNodeInfoCompatJellybeanMr2.setTextSelection((Object)info, (int)start, (int)end);
        }

        @Override
        public int getTextSelectionStart(Object info) {
            return AccessibilityNodeInfoCompatJellybeanMr2.getTextSelectionStart((Object)info);
        }

        @Override
        public int getTextSelectionEnd(Object info) {
            return AccessibilityNodeInfoCompatJellybeanMr2.getTextSelectionEnd((Object)info);
        }

        @Override
        public boolean isEditable(Object info) {
            return AccessibilityNodeInfoCompatJellybeanMr2.isEditable((Object)info);
        }

        @Override
        public void setEditable(Object info, boolean editable) {
            AccessibilityNodeInfoCompatJellybeanMr2.setEditable((Object)info, (boolean)editable);
        }

        @Override
        public boolean refresh(Object info) {
            return AccessibilityNodeInfoCompatJellybeanMr2.refresh((Object)info);
        }
    }

    static class AccessibilityNodeInfoJellybeanMr1Impl
    extends AccessibilityNodeInfoJellybeanImpl {
        AccessibilityNodeInfoJellybeanMr1Impl() {
        }

        @Override
        public void setLabelFor(Object info, View labeled) {
            AccessibilityNodeInfoCompatJellybeanMr1.setLabelFor((Object)info, (View)labeled);
        }

        @Override
        public void setLabelFor(Object info, View root, int virtualDescendantId) {
            AccessibilityNodeInfoCompatJellybeanMr1.setLabelFor((Object)info, (View)root, (int)virtualDescendantId);
        }

        @Override
        public Object getLabelFor(Object info) {
            return AccessibilityNodeInfoCompatJellybeanMr1.getLabelFor((Object)info);
        }

        @Override
        public void setLabeledBy(Object info, View labeled) {
            AccessibilityNodeInfoCompatJellybeanMr1.setLabeledBy((Object)info, (View)labeled);
        }

        @Override
        public void setLabeledBy(Object info, View root, int virtualDescendantId) {
            AccessibilityNodeInfoCompatJellybeanMr1.setLabeledBy((Object)info, (View)root, (int)virtualDescendantId);
        }

        @Override
        public Object getLabeledBy(Object info) {
            return AccessibilityNodeInfoCompatJellybeanMr1.getLabeledBy((Object)info);
        }
    }

    static class AccessibilityNodeInfoJellybeanImpl
    extends AccessibilityNodeInfoIcsImpl {
        AccessibilityNodeInfoJellybeanImpl() {
        }

        @Override
        public Object obtain(View root, int virtualDescendantId) {
            return AccessibilityNodeInfoCompatJellyBean.obtain((View)root, (int)virtualDescendantId);
        }

        @Override
        public Object findFocus(Object info, int focus) {
            return AccessibilityNodeInfoCompatJellyBean.findFocus((Object)info, (int)focus);
        }

        @Override
        public Object focusSearch(Object info, int direction) {
            return AccessibilityNodeInfoCompatJellyBean.focusSearch((Object)info, (int)direction);
        }

        @Override
        public void addChild(Object info, View child, int virtualDescendantId) {
            AccessibilityNodeInfoCompatJellyBean.addChild((Object)info, (View)child, (int)virtualDescendantId);
        }

        @Override
        public void setSource(Object info, View root, int virtualDescendantId) {
            AccessibilityNodeInfoCompatJellyBean.setSource((Object)info, (View)root, (int)virtualDescendantId);
        }

        @Override
        public boolean isVisibleToUser(Object info) {
            return AccessibilityNodeInfoCompatJellyBean.isVisibleToUser((Object)info);
        }

        @Override
        public void setVisibleToUser(Object info, boolean visibleToUser) {
            AccessibilityNodeInfoCompatJellyBean.setVisibleToUser((Object)info, (boolean)visibleToUser);
        }

        @Override
        public boolean isAccessibilityFocused(Object info) {
            return AccessibilityNodeInfoCompatJellyBean.isAccessibilityFocused((Object)info);
        }

        @Override
        public void setAccessibilityFocused(Object info, boolean focused) {
            AccessibilityNodeInfoCompatJellyBean.setAccesibilityFocused((Object)info, (boolean)focused);
        }

        @Override
        public boolean performAction(Object info, int action, Bundle arguments) {
            return AccessibilityNodeInfoCompatJellyBean.performAction((Object)info, (int)action, (Bundle)arguments);
        }

        @Override
        public void setMovementGranularities(Object info, int granularities) {
            AccessibilityNodeInfoCompatJellyBean.setMovementGranularities((Object)info, (int)granularities);
        }

        @Override
        public int getMovementGranularities(Object info) {
            return AccessibilityNodeInfoCompatJellyBean.getMovementGranularities((Object)info);
        }

        @Override
        public void setParent(Object info, View root, int virtualDescendantId) {
            AccessibilityNodeInfoCompatJellyBean.setParent((Object)info, (View)root, (int)virtualDescendantId);
        }
    }

    static class AccessibilityNodeInfoIcsImpl
    extends AccessibilityNodeInfoStubImpl {
        AccessibilityNodeInfoIcsImpl() {
        }

        @Override
        public Object obtain() {
            return AccessibilityNodeInfoCompatIcs.obtain();
        }

        @Override
        public Object obtain(View source) {
            return AccessibilityNodeInfoCompatIcs.obtain((View)source);
        }

        @Override
        public Object obtain(Object info) {
            return AccessibilityNodeInfoCompatIcs.obtain((Object)info);
        }

        @Override
        public void addAction(Object info, int action) {
            AccessibilityNodeInfoCompatIcs.addAction((Object)info, (int)action);
        }

        @Override
        public void addChild(Object info, View child) {
            AccessibilityNodeInfoCompatIcs.addChild((Object)info, (View)child);
        }

        @Override
        public List<Object> findAccessibilityNodeInfosByText(Object info, String text) {
            return AccessibilityNodeInfoCompatIcs.findAccessibilityNodeInfosByText((Object)info, (String)text);
        }

        @Override
        public int getActions(Object info) {
            return AccessibilityNodeInfoCompatIcs.getActions((Object)info);
        }

        @Override
        public void getBoundsInParent(Object info, Rect outBounds) {
            AccessibilityNodeInfoCompatIcs.getBoundsInParent((Object)info, (Rect)outBounds);
        }

        @Override
        public void getBoundsInScreen(Object info, Rect outBounds) {
            AccessibilityNodeInfoCompatIcs.getBoundsInScreen((Object)info, (Rect)outBounds);
        }

        @Override
        public Object getChild(Object info, int index) {
            return AccessibilityNodeInfoCompatIcs.getChild((Object)info, (int)index);
        }

        @Override
        public int getChildCount(Object info) {
            return AccessibilityNodeInfoCompatIcs.getChildCount((Object)info);
        }

        @Override
        public CharSequence getClassName(Object info) {
            return AccessibilityNodeInfoCompatIcs.getClassName((Object)info);
        }

        @Override
        public CharSequence getContentDescription(Object info) {
            return AccessibilityNodeInfoCompatIcs.getContentDescription((Object)info);
        }

        @Override
        public CharSequence getPackageName(Object info) {
            return AccessibilityNodeInfoCompatIcs.getPackageName((Object)info);
        }

        @Override
        public Object getParent(Object info) {
            return AccessibilityNodeInfoCompatIcs.getParent((Object)info);
        }

        @Override
        public CharSequence getText(Object info) {
            return AccessibilityNodeInfoCompatIcs.getText((Object)info);
        }

        @Override
        public int getWindowId(Object info) {
            return AccessibilityNodeInfoCompatIcs.getWindowId((Object)info);
        }

        @Override
        public boolean isCheckable(Object info) {
            return AccessibilityNodeInfoCompatIcs.isCheckable((Object)info);
        }

        @Override
        public boolean isChecked(Object info) {
            return AccessibilityNodeInfoCompatIcs.isChecked((Object)info);
        }

        @Override
        public boolean isClickable(Object info) {
            return AccessibilityNodeInfoCompatIcs.isClickable((Object)info);
        }

        @Override
        public boolean isEnabled(Object info) {
            return AccessibilityNodeInfoCompatIcs.isEnabled((Object)info);
        }

        @Override
        public boolean isFocusable(Object info) {
            return AccessibilityNodeInfoCompatIcs.isFocusable((Object)info);
        }

        @Override
        public boolean isFocused(Object info) {
            return AccessibilityNodeInfoCompatIcs.isFocused((Object)info);
        }

        @Override
        public boolean isLongClickable(Object info) {
            return AccessibilityNodeInfoCompatIcs.isLongClickable((Object)info);
        }

        @Override
        public boolean isPassword(Object info) {
            return AccessibilityNodeInfoCompatIcs.isPassword((Object)info);
        }

        @Override
        public boolean isScrollable(Object info) {
            return AccessibilityNodeInfoCompatIcs.isScrollable((Object)info);
        }

        @Override
        public boolean isSelected(Object info) {
            return AccessibilityNodeInfoCompatIcs.isSelected((Object)info);
        }

        @Override
        public boolean performAction(Object info, int action) {
            return AccessibilityNodeInfoCompatIcs.performAction((Object)info, (int)action);
        }

        @Override
        public void setBoundsInParent(Object info, Rect bounds) {
            AccessibilityNodeInfoCompatIcs.setBoundsInParent((Object)info, (Rect)bounds);
        }

        @Override
        public void setBoundsInScreen(Object info, Rect bounds) {
            AccessibilityNodeInfoCompatIcs.setBoundsInScreen((Object)info, (Rect)bounds);
        }

        @Override
        public void setCheckable(Object info, boolean checkable) {
            AccessibilityNodeInfoCompatIcs.setCheckable((Object)info, (boolean)checkable);
        }

        @Override
        public void setChecked(Object info, boolean checked) {
            AccessibilityNodeInfoCompatIcs.setChecked((Object)info, (boolean)checked);
        }

        @Override
        public void setClassName(Object info, CharSequence className) {
            AccessibilityNodeInfoCompatIcs.setClassName((Object)info, (CharSequence)className);
        }

        @Override
        public void setClickable(Object info, boolean clickable) {
            AccessibilityNodeInfoCompatIcs.setClickable((Object)info, (boolean)clickable);
        }

        @Override
        public void setContentDescription(Object info, CharSequence contentDescription) {
            AccessibilityNodeInfoCompatIcs.setContentDescription((Object)info, (CharSequence)contentDescription);
        }

        @Override
        public void setEnabled(Object info, boolean enabled) {
            AccessibilityNodeInfoCompatIcs.setEnabled((Object)info, (boolean)enabled);
        }

        @Override
        public void setFocusable(Object info, boolean focusable) {
            AccessibilityNodeInfoCompatIcs.setFocusable((Object)info, (boolean)focusable);
        }

        @Override
        public void setFocused(Object info, boolean focused) {
            AccessibilityNodeInfoCompatIcs.setFocused((Object)info, (boolean)focused);
        }

        @Override
        public void setLongClickable(Object info, boolean longClickable) {
            AccessibilityNodeInfoCompatIcs.setLongClickable((Object)info, (boolean)longClickable);
        }

        @Override
        public void setPackageName(Object info, CharSequence packageName) {
            AccessibilityNodeInfoCompatIcs.setPackageName((Object)info, (CharSequence)packageName);
        }

        @Override
        public void setParent(Object info, View parent) {
            AccessibilityNodeInfoCompatIcs.setParent((Object)info, (View)parent);
        }

        @Override
        public void setPassword(Object info, boolean password) {
            AccessibilityNodeInfoCompatIcs.setPassword((Object)info, (boolean)password);
        }

        @Override
        public void setScrollable(Object info, boolean scrollable) {
            AccessibilityNodeInfoCompatIcs.setScrollable((Object)info, (boolean)scrollable);
        }

        @Override
        public void setSelected(Object info, boolean selected) {
            AccessibilityNodeInfoCompatIcs.setSelected((Object)info, (boolean)selected);
        }

        @Override
        public void setSource(Object info, View source) {
            AccessibilityNodeInfoCompatIcs.setSource((Object)info, (View)source);
        }

        @Override
        public void setText(Object info, CharSequence text) {
            AccessibilityNodeInfoCompatIcs.setText((Object)info, (CharSequence)text);
        }

        @Override
        public void recycle(Object info) {
            AccessibilityNodeInfoCompatIcs.recycle((Object)info);
        }
    }

    static class AccessibilityNodeInfoStubImpl
    implements AccessibilityNodeInfoImpl {
        AccessibilityNodeInfoStubImpl() {
        }

        @Override
        public Object newAccessibilityAction(int actionId, CharSequence label) {
            return null;
        }

        @Override
        public Object obtain() {
            return null;
        }

        @Override
        public Object obtain(View source) {
            return null;
        }

        @Override
        public Object obtain(View root, int virtualDescendantId) {
            return null;
        }

        @Override
        public Object obtain(Object info) {
            return null;
        }

        @Override
        public void addAction(Object info, int action) {
        }

        @Override
        public void addAction(Object info, Object action) {
        }

        @Override
        public boolean removeAction(Object info, Object action) {
            return false;
        }

        @Override
        public int getAccessibilityActionId(Object action) {
            return 0;
        }

        @Override
        public CharSequence getAccessibilityActionLabel(Object action) {
            return null;
        }

        @Override
        public void addChild(Object info, View child) {
        }

        @Override
        public void addChild(Object info, View child, int virtualDescendantId) {
        }

        @Override
        public boolean removeChild(Object info, View child) {
            return false;
        }

        @Override
        public boolean removeChild(Object info, View root, int virtualDescendantId) {
            return false;
        }

        @Override
        public List<Object> findAccessibilityNodeInfosByText(Object info, String text) {
            return Collections.emptyList();
        }

        @Override
        public int getActions(Object info) {
            return 0;
        }

        @Override
        public void getBoundsInParent(Object info, Rect outBounds) {
        }

        @Override
        public void getBoundsInScreen(Object info, Rect outBounds) {
        }

        @Override
        public Object getChild(Object info, int index) {
            return null;
        }

        @Override
        public int getChildCount(Object info) {
            return 0;
        }

        @Override
        public CharSequence getClassName(Object info) {
            return null;
        }

        @Override
        public CharSequence getContentDescription(Object info) {
            return null;
        }

        @Override
        public CharSequence getPackageName(Object info) {
            return null;
        }

        @Override
        public Object getParent(Object info) {
            return null;
        }

        @Override
        public CharSequence getText(Object info) {
            return null;
        }

        @Override
        public int getWindowId(Object info) {
            return 0;
        }

        @Override
        public boolean isCheckable(Object info) {
            return false;
        }

        @Override
        public boolean isChecked(Object info) {
            return false;
        }

        @Override
        public boolean isClickable(Object info) {
            return false;
        }

        @Override
        public boolean isEnabled(Object info) {
            return false;
        }

        @Override
        public boolean isFocusable(Object info) {
            return false;
        }

        @Override
        public boolean isFocused(Object info) {
            return false;
        }

        @Override
        public boolean isVisibleToUser(Object info) {
            return false;
        }

        @Override
        public boolean isAccessibilityFocused(Object info) {
            return false;
        }

        @Override
        public boolean isLongClickable(Object info) {
            return false;
        }

        @Override
        public boolean isPassword(Object info) {
            return false;
        }

        @Override
        public boolean isScrollable(Object info) {
            return false;
        }

        @Override
        public boolean isSelected(Object info) {
            return false;
        }

        @Override
        public boolean performAction(Object info, int action) {
            return false;
        }

        @Override
        public boolean performAction(Object info, int action, Bundle arguments) {
            return false;
        }

        @Override
        public void setMovementGranularities(Object info, int granularities) {
        }

        @Override
        public int getMovementGranularities(Object info) {
            return 0;
        }

        @Override
        public void setBoundsInParent(Object info, Rect bounds) {
        }

        @Override
        public void setBoundsInScreen(Object info, Rect bounds) {
        }

        @Override
        public void setCheckable(Object info, boolean checkable) {
        }

        @Override
        public void setChecked(Object info, boolean checked) {
        }

        @Override
        public void setClassName(Object info, CharSequence className) {
        }

        @Override
        public void setClickable(Object info, boolean clickable) {
        }

        @Override
        public void setContentDescription(Object info, CharSequence contentDescription) {
        }

        @Override
        public void setEnabled(Object info, boolean enabled) {
        }

        @Override
        public void setFocusable(Object info, boolean focusable) {
        }

        @Override
        public void setFocused(Object info, boolean focused) {
        }

        @Override
        public void setVisibleToUser(Object info, boolean visibleToUser) {
        }

        @Override
        public void setAccessibilityFocused(Object info, boolean focused) {
        }

        @Override
        public void setLongClickable(Object info, boolean longClickable) {
        }

        @Override
        public void setPackageName(Object info, CharSequence packageName) {
        }

        @Override
        public void setParent(Object info, View parent) {
        }

        @Override
        public void setPassword(Object info, boolean password) {
        }

        @Override
        public void setScrollable(Object info, boolean scrollable) {
        }

        @Override
        public void setSelected(Object info, boolean selected) {
        }

        @Override
        public void setSource(Object info, View source) {
        }

        @Override
        public void setSource(Object info, View root, int virtualDescendantId) {
        }

        @Override
        public Object findFocus(Object info, int focus) {
            return null;
        }

        @Override
        public Object focusSearch(Object info, int direction) {
            return null;
        }

        @Override
        public void setText(Object info, CharSequence text) {
        }

        @Override
        public void recycle(Object info) {
        }

        @Override
        public void setParent(Object info, View root, int virtualDescendantId) {
        }

        @Override
        public String getViewIdResourceName(Object info) {
            return null;
        }

        @Override
        public void setViewIdResourceName(Object info, String viewId) {
        }

        @Override
        public int getLiveRegion(Object info) {
            return 0;
        }

        @Override
        public void setLiveRegion(Object info, int mode) {
        }

        @Override
        public Object getCollectionInfo(Object info) {
            return null;
        }

        @Override
        public void setCollectionInfo(Object info, Object collectionInfo) {
        }

        @Override
        public Object getCollectionItemInfo(Object info) {
            return null;
        }

        @Override
        public void setCollectionItemInfo(Object info, Object collectionItemInfo) {
        }

        @Override
        public Object getRangeInfo(Object info) {
            return null;
        }

        @Override
        public void setRangeInfo(Object info, Object rangeInfo) {
        }

        @Override
        public List<Object> getActionList(Object info) {
            return null;
        }

        @Override
        public Object obtainCollectionInfo(int rowCount, int columnCount, boolean hierarchical, int selectionMode) {
            return null;
        }

        @Override
        public int getCollectionInfoColumnCount(Object info) {
            return 0;
        }

        @Override
        public int getCollectionInfoRowCount(Object info) {
            return 0;
        }

        @Override
        public boolean isCollectionInfoHierarchical(Object info) {
            return false;
        }

        @Override
        public Object obtainCollectionItemInfo(int rowIndex, int rowSpan, int columnIndex, int columnSpan, boolean heading, boolean selected) {
            return null;
        }

        @Override
        public int getCollectionItemColumnIndex(Object info) {
            return 0;
        }

        @Override
        public int getCollectionItemColumnSpan(Object info) {
            return 0;
        }

        @Override
        public int getCollectionItemRowIndex(Object info) {
            return 0;
        }

        @Override
        public int getCollectionItemRowSpan(Object info) {
            return 0;
        }

        @Override
        public boolean isCollectionItemHeading(Object info) {
            return false;
        }

        @Override
        public boolean isCollectionItemSelected(Object info) {
            return false;
        }

        @Override
        public Object getTraversalBefore(Object info) {
            return null;
        }

        @Override
        public void setTraversalBefore(Object info, View view) {
        }

        @Override
        public void setTraversalBefore(Object info, View root, int virtualDescendantId) {
        }

        @Override
        public Object getTraversalAfter(Object info) {
            return null;
        }

        @Override
        public void setTraversalAfter(Object info, View view) {
        }

        @Override
        public void setTraversalAfter(Object info, View root, int virtualDescendantId) {
        }

        @Override
        public void setContentInvalid(Object info, boolean contentInvalid) {
        }

        @Override
        public boolean isContentInvalid(Object info) {
            return false;
        }

        @Override
        public void setError(Object info, CharSequence error) {
        }

        @Override
        public CharSequence getError(Object info) {
            return null;
        }

        @Override
        public void setLabelFor(Object info, View labeled) {
        }

        @Override
        public void setLabelFor(Object info, View root, int virtualDescendantId) {
        }

        @Override
        public Object getLabelFor(Object info) {
            return null;
        }

        @Override
        public void setLabeledBy(Object info, View labeled) {
        }

        @Override
        public void setLabeledBy(Object info, View root, int virtualDescendantId) {
        }

        @Override
        public Object getLabeledBy(Object info) {
            return null;
        }

        @Override
        public boolean canOpenPopup(Object info) {
            return false;
        }

        @Override
        public void setCanOpenPopup(Object info, boolean opensPopup) {
        }

        @Override
        public List<Object> findAccessibilityNodeInfosByViewId(Object info, String viewId) {
            return Collections.emptyList();
        }

        @Override
        public Bundle getExtras(Object info) {
            return new Bundle();
        }

        @Override
        public int getInputType(Object info) {
            return 0;
        }

        @Override
        public void setInputType(Object info, int inputType) {
        }

        @Override
        public void setMaxTextLength(Object info, int max) {
        }

        @Override
        public int getMaxTextLength(Object info) {
            return -1;
        }

        @Override
        public void setTextSelection(Object info, int start, int end) {
        }

        @Override
        public int getTextSelectionStart(Object info) {
            return -1;
        }

        @Override
        public int getTextSelectionEnd(Object info) {
            return -1;
        }

        @Override
        public Object getWindow(Object info) {
            return null;
        }

        @Override
        public boolean isDismissable(Object info) {
            return false;
        }

        @Override
        public void setDismissable(Object info, boolean dismissable) {
        }

        @Override
        public boolean isEditable(Object info) {
            return false;
        }

        @Override
        public void setEditable(Object info, boolean editable) {
        }

        @Override
        public boolean isMultiLine(Object info) {
            return false;
        }

        @Override
        public void setMultiLine(Object info, boolean multiLine) {
        }

        @Override
        public boolean refresh(Object info) {
            return false;
        }

        @Override
        public CharSequence getRoleDescription(Object info) {
            return null;
        }

        @Override
        public void setRoleDescription(Object info, CharSequence roleDescription) {
        }

        @Override
        public int getDrawingOrder(Object info) {
            return 0;
        }

        @Override
        public void setDrawingOrder(Object info, int drawingOrderInParent) {
        }

        @Override
        public boolean isImportantForAccessibility(Object info) {
            return true;
        }

        @Override
        public void setImportantForAccessibility(Object info, boolean importantForAccessibility) {
        }
    }

    static interface AccessibilityNodeInfoImpl {
        public Object newAccessibilityAction(int var1, CharSequence var2);

        public Object obtain();

        public Object obtain(View var1);

        public Object obtain(Object var1);

        public Object obtain(View var1, int var2);

        public void setSource(Object var1, View var2);

        public void setSource(Object var1, View var2, int var3);

        public Object findFocus(Object var1, int var2);

        public Object focusSearch(Object var1, int var2);

        public int getWindowId(Object var1);

        public int getChildCount(Object var1);

        public Object getChild(Object var1, int var2);

        public void addChild(Object var1, View var2);

        public void addChild(Object var1, View var2, int var3);

        public boolean removeChild(Object var1, View var2);

        public boolean removeChild(Object var1, View var2, int var3);

        public int getActions(Object var1);

        public void addAction(Object var1, int var2);

        public void addAction(Object var1, Object var2);

        public boolean removeAction(Object var1, Object var2);

        public int getAccessibilityActionId(Object var1);

        public CharSequence getAccessibilityActionLabel(Object var1);

        public boolean performAction(Object var1, int var2);

        public boolean performAction(Object var1, int var2, Bundle var3);

        public void setMovementGranularities(Object var1, int var2);

        public int getMovementGranularities(Object var1);

        public List<Object> findAccessibilityNodeInfosByText(Object var1, String var2);

        public Object getParent(Object var1);

        public void setParent(Object var1, View var2, int var3);

        public void setParent(Object var1, View var2);

        public void getBoundsInParent(Object var1, Rect var2);

        public void setBoundsInParent(Object var1, Rect var2);

        public void getBoundsInScreen(Object var1, Rect var2);

        public void setBoundsInScreen(Object var1, Rect var2);

        public boolean isCheckable(Object var1);

        public void setCheckable(Object var1, boolean var2);

        public boolean isChecked(Object var1);

        public void setChecked(Object var1, boolean var2);

        public boolean isFocusable(Object var1);

        public void setFocusable(Object var1, boolean var2);

        public boolean isFocused(Object var1);

        public void setFocused(Object var1, boolean var2);

        public boolean isVisibleToUser(Object var1);

        public void setVisibleToUser(Object var1, boolean var2);

        public boolean isAccessibilityFocused(Object var1);

        public void setAccessibilityFocused(Object var1, boolean var2);

        public boolean isSelected(Object var1);

        public void setSelected(Object var1, boolean var2);

        public boolean isClickable(Object var1);

        public void setClickable(Object var1, boolean var2);

        public boolean isLongClickable(Object var1);

        public void setLongClickable(Object var1, boolean var2);

        public boolean isEnabled(Object var1);

        public void setEnabled(Object var1, boolean var2);

        public boolean isPassword(Object var1);

        public void setPassword(Object var1, boolean var2);

        public boolean isScrollable(Object var1);

        public void setScrollable(Object var1, boolean var2);

        public CharSequence getPackageName(Object var1);

        public void setPackageName(Object var1, CharSequence var2);

        public CharSequence getClassName(Object var1);

        public void setClassName(Object var1, CharSequence var2);

        public CharSequence getText(Object var1);

        public void setText(Object var1, CharSequence var2);

        public CharSequence getContentDescription(Object var1);

        public void setContentDescription(Object var1, CharSequence var2);

        public void recycle(Object var1);

        public String getViewIdResourceName(Object var1);

        public void setViewIdResourceName(Object var1, String var2);

        public int getLiveRegion(Object var1);

        public void setLiveRegion(Object var1, int var2);

        public Object getCollectionInfo(Object var1);

        public void setCollectionInfo(Object var1, Object var2);

        public Object getCollectionItemInfo(Object var1);

        public void setCollectionItemInfo(Object var1, Object var2);

        public Object getRangeInfo(Object var1);

        public void setRangeInfo(Object var1, Object var2);

        public List<Object> getActionList(Object var1);

        public Object obtainCollectionInfo(int var1, int var2, boolean var3, int var4);

        public int getCollectionInfoColumnCount(Object var1);

        public int getCollectionInfoRowCount(Object var1);

        public boolean isCollectionInfoHierarchical(Object var1);

        public Object obtainCollectionItemInfo(int var1, int var2, int var3, int var4, boolean var5, boolean var6);

        public int getCollectionItemColumnIndex(Object var1);

        public int getCollectionItemColumnSpan(Object var1);

        public int getCollectionItemRowIndex(Object var1);

        public int getCollectionItemRowSpan(Object var1);

        public boolean isCollectionItemHeading(Object var1);

        public boolean isCollectionItemSelected(Object var1);

        public Object getTraversalBefore(Object var1);

        public void setTraversalBefore(Object var1, View var2);

        public void setTraversalBefore(Object var1, View var2, int var3);

        public Object getTraversalAfter(Object var1);

        public void setTraversalAfter(Object var1, View var2);

        public void setTraversalAfter(Object var1, View var2, int var3);

        public void setContentInvalid(Object var1, boolean var2);

        public boolean isContentInvalid(Object var1);

        public void setError(Object var1, CharSequence var2);

        public CharSequence getError(Object var1);

        public void setLabelFor(Object var1, View var2);

        public void setLabelFor(Object var1, View var2, int var3);

        public Object getLabelFor(Object var1);

        public void setLabeledBy(Object var1, View var2);

        public void setLabeledBy(Object var1, View var2, int var3);

        public Object getLabeledBy(Object var1);

        public boolean canOpenPopup(Object var1);

        public void setCanOpenPopup(Object var1, boolean var2);

        public List<Object> findAccessibilityNodeInfosByViewId(Object var1, String var2);

        public Bundle getExtras(Object var1);

        public int getInputType(Object var1);

        public void setInputType(Object var1, int var2);

        public void setMaxTextLength(Object var1, int var2);

        public int getMaxTextLength(Object var1);

        public void setTextSelection(Object var1, int var2, int var3);

        public int getTextSelectionStart(Object var1);

        public int getTextSelectionEnd(Object var1);

        public Object getWindow(Object var1);

        public boolean isDismissable(Object var1);

        public void setDismissable(Object var1, boolean var2);

        public boolean isEditable(Object var1);

        public void setEditable(Object var1, boolean var2);

        public int getDrawingOrder(Object var1);

        public void setDrawingOrder(Object var1, int var2);

        public boolean isImportantForAccessibility(Object var1);

        public void setImportantForAccessibility(Object var1, boolean var2);

        public boolean isMultiLine(Object var1);

        public void setMultiLine(Object var1, boolean var2);

        public boolean refresh(Object var1);

        public CharSequence getRoleDescription(Object var1);

        public void setRoleDescription(Object var1, CharSequence var2);
    }

    public static class RangeInfoCompat {
        public static final int RANGE_TYPE_INT = 0;
        public static final int RANGE_TYPE_FLOAT = 1;
        public static final int RANGE_TYPE_PERCENT = 2;
        private final Object mInfo;

        private RangeInfoCompat(Object info) {
            this.mInfo = info;
        }

        public float getCurrent() {
            return AccessibilityNodeInfoCompatKitKat.RangeInfo.getCurrent((Object)this.mInfo);
        }

        public float getMax() {
            return AccessibilityNodeInfoCompatKitKat.RangeInfo.getMax((Object)this.mInfo);
        }

        public float getMin() {
            return AccessibilityNodeInfoCompatKitKat.RangeInfo.getMin((Object)this.mInfo);
        }

        public int getType() {
            return AccessibilityNodeInfoCompatKitKat.RangeInfo.getType((Object)this.mInfo);
        }
    }

    public static class CollectionItemInfoCompat {
        private final Object mInfo;

        public static CollectionItemInfoCompat obtain(int rowIndex, int rowSpan, int columnIndex, int columnSpan, boolean heading, boolean selected) {
            return new CollectionItemInfoCompat(IMPL.obtainCollectionItemInfo(rowIndex, rowSpan, columnIndex, columnSpan, heading, selected));
        }

        private CollectionItemInfoCompat(Object info) {
            this.mInfo = info;
        }

        public int getColumnIndex() {
            return IMPL.getCollectionItemColumnIndex(this.mInfo);
        }

        public int getColumnSpan() {
            return IMPL.getCollectionItemColumnSpan(this.mInfo);
        }

        public int getRowIndex() {
            return IMPL.getCollectionItemRowIndex(this.mInfo);
        }

        public int getRowSpan() {
            return IMPL.getCollectionItemRowSpan(this.mInfo);
        }

        public boolean isHeading() {
            return IMPL.isCollectionItemHeading(this.mInfo);
        }

        public boolean isSelected() {
            return IMPL.isCollectionItemSelected(this.mInfo);
        }
    }

    public static class CollectionInfoCompat {
        public static final int SELECTION_MODE_NONE = 0;
        public static final int SELECTION_MODE_SINGLE = 1;
        public static final int SELECTION_MODE_MULTIPLE = 2;
        final Object mInfo;

        public static CollectionInfoCompat obtain(int rowCount, int columnCount, boolean hierarchical, int selectionMode) {
            return new CollectionInfoCompat(IMPL.obtainCollectionInfo(rowCount, columnCount, hierarchical, selectionMode));
        }

        private CollectionInfoCompat(Object info) {
            this.mInfo = info;
        }

        public int getColumnCount() {
            return IMPL.getCollectionInfoColumnCount(this.mInfo);
        }

        public int getRowCount() {
            return IMPL.getCollectionInfoRowCount(this.mInfo);
        }

        public boolean isHierarchical() {
            return IMPL.isCollectionInfoHierarchical(this.mInfo);
        }
    }

    public static class AccessibilityActionCompat {
        public static final AccessibilityActionCompat ACTION_FOCUS = new AccessibilityActionCompat(1, null);
        public static final AccessibilityActionCompat ACTION_CLEAR_FOCUS = new AccessibilityActionCompat(2, null);
        public static final AccessibilityActionCompat ACTION_SELECT = new AccessibilityActionCompat(4, null);
        public static final AccessibilityActionCompat ACTION_CLEAR_SELECTION = new AccessibilityActionCompat(8, null);
        public static final AccessibilityActionCompat ACTION_CLICK = new AccessibilityActionCompat(16, null);
        public static final AccessibilityActionCompat ACTION_LONG_CLICK = new AccessibilityActionCompat(32, null);
        public static final AccessibilityActionCompat ACTION_ACCESSIBILITY_FOCUS = new AccessibilityActionCompat(64, null);
        public static final AccessibilityActionCompat ACTION_CLEAR_ACCESSIBILITY_FOCUS = new AccessibilityActionCompat(128, null);
        public static final AccessibilityActionCompat ACTION_NEXT_AT_MOVEMENT_GRANULARITY = new AccessibilityActionCompat(256, null);
        public static final AccessibilityActionCompat ACTION_PREVIOUS_AT_MOVEMENT_GRANULARITY = new AccessibilityActionCompat(512, null);
        public static final AccessibilityActionCompat ACTION_NEXT_HTML_ELEMENT = new AccessibilityActionCompat(1024, null);
        public static final AccessibilityActionCompat ACTION_PREVIOUS_HTML_ELEMENT = new AccessibilityActionCompat(2048, null);
        public static final AccessibilityActionCompat ACTION_SCROLL_FORWARD = new AccessibilityActionCompat(4096, null);
        public static final AccessibilityActionCompat ACTION_SCROLL_BACKWARD = new AccessibilityActionCompat(8192, null);
        public static final AccessibilityActionCompat ACTION_COPY = new AccessibilityActionCompat(16384, null);
        public static final AccessibilityActionCompat ACTION_PASTE = new AccessibilityActionCompat(32768, null);
        public static final AccessibilityActionCompat ACTION_CUT = new AccessibilityActionCompat(65536, null);
        public static final AccessibilityActionCompat ACTION_SET_SELECTION = new AccessibilityActionCompat(131072, null);
        public static final AccessibilityActionCompat ACTION_EXPAND = new AccessibilityActionCompat(262144, null);
        public static final AccessibilityActionCompat ACTION_COLLAPSE = new AccessibilityActionCompat(524288, null);
        public static final AccessibilityActionCompat ACTION_DISMISS = new AccessibilityActionCompat(0x100000, null);
        public static final AccessibilityActionCompat ACTION_SET_TEXT = new AccessibilityActionCompat(0x200000, null);
        private final Object mAction;

        public AccessibilityActionCompat(int actionId, CharSequence label) {
            this(IMPL.newAccessibilityAction(actionId, label));
        }

        private AccessibilityActionCompat(Object action) {
            this.mAction = action;
        }

        public int getId() {
            return IMPL.getAccessibilityActionId(this.mAction);
        }

        public CharSequence getLabel() {
            return IMPL.getAccessibilityActionLabel(this.mAction);
        }
    }
}

