/*
 * Decompiled with CFR 0.152.
 */
package android.support.test.espresso.contrib;

import android.content.res.Resources;
import android.support.design.widget.NavigationView;
import android.support.test.espresso.PerformException;
import android.support.test.espresso.UiController;
import android.support.test.espresso.ViewAction;
import android.support.test.espresso.matcher.ViewMatchers;
import android.support.test.espresso.util.HumanReadables;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public final class NavigationViewActions {
    private NavigationViewActions() {
    }

    public static ViewAction navigateTo(final int menuItemId) {
        return new ViewAction(){

            public void perform(UiController uiController, View view) {
                NavigationView navigationView = (NavigationView)view;
                Menu menu = navigationView.getMenu();
                if (null == menu.findItem(menuItemId)) {
                    throw new PerformException.Builder().withActionDescription(this.getDescription()).withViewDescription(HumanReadables.describe((View)view)).withCause((Throwable)new RuntimeException(this.getErrorMessage(menu, view))).build();
                }
                menu.performIdentifierAction(menuItemId, 0);
            }

            private String getErrorMessage(Menu menu, View view) {
                String newLine = System.getProperty("line.separator");
                StringBuilder errorMessage = new StringBuilder("Menu item was not found, available menu items:").append(newLine);
                for (int position = 0; position < menu.size(); ++position) {
                    errorMessage.append("[MenuItem] position=").append(position);
                    MenuItem menuItem = menu.getItem(position);
                    if (menuItem == null) continue;
                    CharSequence itemTitle = menuItem.getTitle();
                    if (itemTitle != null) {
                        errorMessage.append(", title=").append(itemTitle);
                    }
                    if (view.getResources() != null) {
                        int itemId = menuItem.getItemId();
                        try {
                            errorMessage.append(", id=");
                            String menuItemResourceName = view.getResources().getResourceName(itemId);
                            errorMessage.append(menuItemResourceName);
                        }
                        catch (Resources.NotFoundException nfe) {
                            errorMessage.append("not found");
                        }
                    }
                    errorMessage.append(newLine);
                }
                return errorMessage.toString();
            }

            public String getDescription() {
                return "click on menu item with id";
            }

            public Matcher<View> getConstraints() {
                return Matchers.allOf((Matcher)ViewMatchers.isAssignableFrom(NavigationView.class), (Matcher)ViewMatchers.withEffectiveVisibility((ViewMatchers.Visibility)ViewMatchers.Visibility.VISIBLE), (Matcher)ViewMatchers.isDisplayingAtLeast((int)90));
            }
        };
    }
}

